/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;

public abstract class ClearableLazyValue<T> {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard("ClearableLazyValue");
    private T myValue;

    @NotNull
    protected abstract T compute();

    @NotNull
    public T getValue() {
        T result2 = this.myValue;
        if (result2 == null) {
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            result2 = this.compute();
            if (stamp.mayCacheNow()) {
                this.myValue = result2;
            }
        }
        T t = result2;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/ClearableLazyValue", "getValue"));
        }
        return t;
    }

    public void drop() {
        this.myValue = null;
    }
}

