/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.vfs;

import java.util.EventObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;

public class VirtualFileEvent
extends EventObject {
    private final VirtualFile myFile;
    private final VirtualFile myParent;
    private final Object myRequestor;
    private final String myFileName;
    private final long myOldModificationStamp;
    private final long myNewModificationStamp;

    public VirtualFileEvent(@Nullable Object requestor, @NotNull VirtualFile file, @NotNull String fileName, @Nullable VirtualFile parent2) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFileEvent", "<init>"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFileEvent", "<init>"));
        }
        this(requestor, file, fileName, parent2, 0L, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public VirtualFileEvent(@Nullable Object requestor, @NotNull VirtualFile file, @Nullable VirtualFile parent2, long oldModificationStamp, long l) {
        void newModificationStamp;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFileEvent", "<init>"));
        }
        this(requestor, file, file.getName(), parent2, oldModificationStamp, (long)newModificationStamp);
    }

    /*
     * WARNING - void declaration
     */
    private VirtualFileEvent(@Nullable Object requestor, @NotNull VirtualFile file, @NotNull String fileName, @Nullable VirtualFile parent2, long oldModificationStamp, long l) {
        void newModificationStamp;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFileEvent", "<init>"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFileEvent", "<init>"));
        }
        super(file);
        this.myFile = file;
        this.myFileName = fileName;
        this.myParent = parent2;
        this.myRequestor = requestor == null ? file.getUserData(VirtualFile.REQUESTOR_MARKER) : requestor;
        this.myOldModificationStamp = oldModificationStamp;
        this.myNewModificationStamp = newModificationStamp;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile2 = this.myFile;
        if (virtualFile2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFileEvent", "getFile"));
        }
        return virtualFile2;
    }

    @Nullable
    public VirtualFile getParent() {
        return this.myParent;
    }

    @Nullable
    public Object getRequestor() {
        return this.myRequestor;
    }
}

