/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.LanguageParserDefinitions;
import org.jetbrains.kotlin.com.intellij.lang.ParserDefinition;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilderFactory;
import org.jetbrains.kotlin.com.intellij.lexer.Lexer;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileTypeRegistry;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.LanguageFileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProviderFactory;
import org.jetbrains.kotlin.com.intellij.psi.LanguageFileViewProviders;
import org.jetbrains.kotlin.com.intellij.psi.LanguageSubstitutors;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.SingleRootFileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.GeneratedMarkerVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.DummyHolder;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.DummyHolderFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiPlainTextFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.kotlin.com.intellij.util.LocalTimeCounter;
import org.jetbrains.kotlin.com.intellij.util.text.CharSequenceSubSequence;

public class PsiFileFactoryImpl
extends PsiFileFactory {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.PsiFileFactoryImpl");
    private final PsiManager myManager;

    public PsiFileFactoryImpl(PsiManager manager) {
        this.myManager = manager;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PsiFile createFileFromText(@NotNull String name, @NotNull FileType fileType, @NotNull CharSequence text2, long modificationStamp, boolean bl) {
        void eventSystemEnabled;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        PsiFile psiFile = this.createFileFromText(name, fileType, text2, modificationStamp, (boolean)eventSystemEnabled, true);
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        return psiFile;
    }

    @Override
    public PsiFile createFileFromText(@NotNull String name, @NotNull Language language, @NotNull CharSequence text2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        return this.createFileFromText(name, language, text2, true, true);
    }

    @Override
    public PsiFile createFileFromText(@NotNull String name, @NotNull Language language, @NotNull CharSequence text2, boolean eventSystemEnabled, boolean markAsCopy) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        return this.createFileFromText(name, language, text2, eventSystemEnabled, markAsCopy, false);
    }

    @Override
    public PsiFile createFileFromText(@NotNull String name, @NotNull Language language, @NotNull CharSequence text2, boolean eventSystemEnabled, boolean markAsCopy, boolean noSizeLimit) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        return this.createFileFromText(name, language, text2, eventSystemEnabled, markAsCopy, noSizeLimit, null);
    }

    @Override
    public PsiFile createFileFromText(@NotNull String name, @NotNull Language language, @NotNull CharSequence text2, boolean eventSystemEnabled, boolean markAsCopy, boolean noSizeLimit, @Nullable VirtualFile original) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        LightVirtualFile virtualFile2 = new LightVirtualFile(name, language, text2);
        if (original != null) {
            virtualFile2.setOriginalFile(original);
        }
        if (noSizeLimit) {
            SingleRootFileViewProvider.doNotCheckFileSizeLimit(virtualFile2);
        }
        return this.trySetupPsiForFile(virtualFile2, language, eventSystemEnabled, markAsCopy);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PsiFile createFileFromText(@NotNull String name, @NotNull FileType fileType, @NotNull CharSequence text2, long modificationStamp, boolean eventSystemEnabled, boolean bl) {
        void markAsCopy;
        Language language;
        PsiFile file;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        LightVirtualFile virtualFile2 = new LightVirtualFile(name, fileType, text2, modificationStamp);
        if (fileType instanceof LanguageFileType && (file = this.trySetupPsiForFile(virtualFile2, language = LanguageSubstitutors.INSTANCE.substituteLanguage(((LanguageFileType)fileType).getLanguage(), virtualFile2, this.myManager.getProject()), eventSystemEnabled, (boolean)markAsCopy)) != null) {
            PsiFile psiFile = file;
            if (psiFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
            }
            return psiFile;
        }
        SingleRootFileViewProvider singleRootFileViewProvider = new SingleRootFileViewProvider(this.myManager, virtualFile2, eventSystemEnabled);
        PsiPlainTextFileImpl plainTextFile = new PsiPlainTextFileImpl(singleRootFileViewProvider);
        if (markAsCopy != false) {
            CodeEditUtil.setNodeGenerated(plainTextFile.getNode(), true);
        }
        PsiPlainTextFileImpl psiPlainTextFileImpl = plainTextFile;
        if (psiPlainTextFileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        return psiPlainTextFileImpl;
    }

    @Nullable
    public PsiFile trySetupPsiForFile(@NotNull LightVirtualFile virtualFile2, @NotNull Language language, boolean physical, boolean markAsCopy) {
        PsiFile psiFile;
        ParserDefinition parserDefinition;
        FileViewProvider viewProvider;
        if (virtualFile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "trySetupPsiForFile"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "trySetupPsiForFile"));
        }
        FileViewProviderFactory factory2 = (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language);
        FileViewProvider fileViewProvider = viewProvider = factory2 != null ? factory2.createFileViewProvider(virtualFile2, language, this.myManager, physical) : null;
        if (viewProvider == null) {
            viewProvider = new SingleRootFileViewProvider(this.myManager, virtualFile2, physical);
        }
        if ((parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language = viewProvider.getBaseLanguage())) != null && (psiFile = viewProvider.getPsi(language)) != null) {
            if (markAsCopy) {
                if (psiFile.getNode() == null) {
                    throw new AssertionError((Object)("No node for file " + psiFile + "; language=" + language));
                }
                PsiFileFactoryImpl.markGenerated(psiFile);
            }
            return psiFile;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PsiFile createFileFromText(@NotNull String name, @NotNull FileType fileType, Language language, @NotNull Language targetLanguage, @NotNull CharSequence text2, long modificationStamp, boolean physical, boolean bl) {
        void markAsCopy;
        PsiFile psiFile;
        FileViewProvider viewProvider;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (targetLanguage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetLanguage", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        LightVirtualFile virtualFile2 = new LightVirtualFile(name, fileType, text2, modificationStamp);
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        FileViewProviderFactory factory2 = (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language);
        FileViewProvider fileViewProvider = viewProvider = factory2 != null ? factory2.createFileViewProvider(virtualFile2, language, this.myManager, physical) : null;
        if (viewProvider == null) {
            viewProvider = new SingleRootFileViewProvider(this.myManager, virtualFile2, physical);
        }
        if (parserDefinition != null && (psiFile = viewProvider.getPsi(targetLanguage)) != null) {
            if (markAsCopy != false) {
                PsiFileFactoryImpl.markGenerated(psiFile);
            }
            PsiFile psiFile2 = psiFile;
            if (psiFile2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
            }
            return psiFile2;
        }
        SingleRootFileViewProvider singleRootFileViewProvider = new SingleRootFileViewProvider(this.myManager, virtualFile2, physical);
        PsiPlainTextFileImpl plainTextFile = new PsiPlainTextFileImpl(singleRootFileViewProvider);
        if (markAsCopy != false) {
            CodeEditUtil.setNodeGenerated(plainTextFile.getNode(), true);
        }
        PsiPlainTextFileImpl psiPlainTextFileImpl = plainTextFile;
        if (psiPlainTextFileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        return psiPlainTextFileImpl;
    }

    @Override
    @NotNull
    public PsiFile createFileFromText(@NotNull String name, @NotNull FileType fileType, @NotNull CharSequence text2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        PsiFile psiFile = this.createFileFromText(name, fileType, text2, LocalTimeCounter.currentTime(), false);
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        return psiFile;
    }

    @Override
    @NotNull
    public PsiFile createFileFromText(@NotNull String name, @NotNull String text2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        FileType type2 = FileTypeRegistry.getInstance().getFileTypeByFileName(name);
        if (type2.isBinary()) {
            throw new RuntimeException("Cannot create binary files from text: name " + name + ", file type " + type2);
        }
        PsiFile psiFile = this.createFileFromText(name, type2, (CharSequence)text2);
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        return psiFile;
    }

    @Override
    public PsiFile createFileFromText(FileType fileType, String fileName, CharSequence chars, int startOffset, int endOffset) {
        LOG.assertTrue(!fileType.isBinary());
        CharSequence text2 = startOffset == 0 && endOffset == chars.length() ? chars : new CharSequenceSubSequence(chars, startOffset, endOffset);
        return this.createFileFromText(fileName, fileType, text2);
    }

    @Override
    @Nullable
    public PsiFile createFileFromText(@NotNull CharSequence chars, @NotNull PsiFile original) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        PsiFile file = this.createFileFromText(original.getName(), original.getLanguage(), chars, false, true);
        if (file != null) {
            file.putUserData(ORIGINAL_FILE, original);
        }
        return file;
    }

    @Nullable
    public PsiElement createElementFromText(@Nullable String text2, @NotNull Language language, @NotNull IElementType type2, @Nullable PsiElement context) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createElementFromText"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl", "createElementFromText"));
        }
        if (text2 == null) {
            return null;
        }
        DummyHolder result2 = DummyHolderFactory.createHolder(this.myManager, language, context);
        FileElement holder = result2.getTreeElement();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        if (parserDefinition == null) {
            throw new AssertionError((Object)("No parser definition for " + language));
        }
        Project project = this.myManager.getProject();
        Lexer lexer = parserDefinition.createLexer(project);
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project, holder, lexer, language, (CharSequence)text2);
        ASTNode node = parserDefinition.createParser(project).parse(type2, builder);
        holder.rawAddChildren((TreeElement)node);
        PsiFileFactoryImpl.markGenerated(result2);
        return node.getPsi();
    }

    public static void markGenerated(PsiElement element) {
        TreeElement node = (TreeElement)element.getNode();
        assert (node != null);
        node.acceptTree(new GeneratedMarkerVisitor());
    }
}

