/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.javadoc;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.kotlin.com.intellij.codeInsight.daemon.JavaErrorMessages;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.JavadocTagInfo;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocTagValue;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;

class ExceptionTagInfo
implements JavadocTagInfo {
    private final String myName;

    public ExceptionTagInfo(@NonNls String name) {
        this.myName = name;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public boolean isInline() {
        return false;
    }

    @Override
    public boolean isValidInContext(PsiElement element) {
        return element instanceof PsiMethod;
    }

    @Override
    public String checkTagValue(PsiDocTagValue value) {
        PsiClassType[] references;
        if (value == null) {
            return JavaErrorMessages.message("javadoc.exception.tag.exception.class.expected", new Object[0]);
        }
        PsiElement firstChild = value.getFirstChild();
        if (firstChild == null) {
            return JavaErrorMessages.message("javadoc.exception.tag.exception.class.expected", new Object[0]);
        }
        PsiElement psiElement = firstChild.getFirstChild();
        if (!(psiElement instanceof PsiJavaCodeReferenceElement)) {
            return JavaErrorMessages.message("javadoc.exception.tag.wrong.tag.value", new Object[0]);
        }
        PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)psiElement;
        PsiElement element = ref.resolve();
        if (!(element instanceof PsiClass)) {
            return null;
        }
        PsiClass exceptionClass = (PsiClass)element;
        PsiClass throwable = JavaPsiFacade.getInstance(value.getProject()).findClass("java.lang.Throwable", value.getResolveScope());
        if (throwable != null && !exceptionClass.equals(throwable) && !exceptionClass.isInheritor(throwable, true)) {
            return JavaErrorMessages.message("javadoc.exception.tag.class.is.not.throwable", exceptionClass.getQualifiedName());
        }
        PsiClass runtimeException = JavaPsiFacade.getInstance(value.getProject()).findClass("java.lang.RuntimeException", value.getResolveScope());
        if (runtimeException != null && (exceptionClass.isInheritor(runtimeException, true) || exceptionClass.equals(runtimeException))) {
            return null;
        }
        PsiClass errorException = JavaPsiFacade.getInstance(value.getProject()).findClass("java.lang.Error", value.getResolveScope());
        if (errorException != null && (exceptionClass.isInheritor(errorException, true) || exceptionClass.equals(errorException))) {
            return null;
        }
        PsiMethod method = PsiTreeUtil.getParentOfType((PsiElement)value, PsiMethod.class);
        if (method == null) {
            return null;
        }
        for (PsiClassType reference : references = method.getThrowsList().getReferencedTypes()) {
            PsiClass psiClass = reference.resolve();
            if (psiClass == null || !exceptionClass.isInheritor(psiClass, true) && !exceptionClass.equals(psiClass)) continue;
            return null;
        }
        return JavaErrorMessages.message("javadoc.exception.tag.exception.is.not.thrown", exceptionClass.getName(), method.getName());
    }

    @Override
    public PsiReference getReference(PsiDocTagValue value) {
        return null;
    }
}

