/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiCall;
import org.jetbrains.kotlin.com.intellij.psi.PsiCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiConditionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiDiamondType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiResolveHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiReturnStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.CompoundInitialState;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InitialInferenceState;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import org.jetbrains.kotlin.com.intellij.psi.infos.MethodCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;

public class InferenceSessionContainer {
    private static final Logger LOG = Logger.getInstance(InferenceSessionContainer.class);
    private final Map<PsiElement, InferenceSession> myNestedSessions = new HashMap<PsiElement, InferenceSession>();

    public void registerNestedSession(InferenceSession session) {
        this.myNestedSessions.put(session.getContext(), session);
        this.myNestedSessions.putAll(session.getInferenceSessionContainer().myNestedSessions);
    }

    @Contract(value="_, !null -> !null")
    public PsiSubstitutor findNestedSubstitutor(PsiElement arg, @Nullable PsiSubstitutor defaultSession) {
        InferenceSession session = this.myNestedSessions.get(PsiTreeUtil.getParentOfType(arg, PsiCall.class));
        return session == null ? defaultSession : session.getInferenceSubstitution();
    }

    void registerNestedSession(InferenceSession session, PsiType returnType, PsiExpression returnExpression) {
        InferenceSession inferenceSession;
        PsiSubstitutor callSession = this.findNestedSubstitutor(((PsiCallExpression)returnExpression).getArgumentList(), null);
        if (callSession == null && (inferenceSession = ExpressionCompatibilityConstraint.reduceExpressionCompatibilityConstraint(session, returnExpression, returnType, false)) != null && inferenceSession != session) {
            this.registerNestedSession(inferenceSession);
            session.propagateVariables(inferenceSession.getInferenceVariables(), inferenceSession.getRestoreNameSubstitution());
        }
    }

    static PsiSubstitutor infer(@NotNull PsiTypeParameter[] typeParameters2, @NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments2, @NotNull PsiSubstitutor partialSubstitutor, @NotNull PsiElement parent2, @NotNull ParameterTypeInferencePolicy policy) {
        PsiCall topLevelCall;
        PsiExpressionList argumentList2;
        MethodCandidateInfo.CurrentCandidateProperties properties2;
        if (typeParameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "infer"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "infer"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "infer"));
        }
        if (partialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partialSubstitutor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "infer"));
        }
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "infer"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "infer"));
        }
        if (parent2 instanceof PsiCall && (properties2 = MethodCandidateInfo.getCurrentMethod(argumentList2 = ((PsiCall)parent2).getArgumentList())) != null && !properties2.isApplicabilityCheck() && !MethodCandidateInfo.ourOverloadGuard.currentStack().contains(argumentList2) && (topLevelCall = PsiResolveHelper.ourGraphGuard.doPreventingRecursion(parent2, false, () -> {
            if (parent2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "lambda$infer$0"));
            }
            if (parent2 instanceof PsiExpression && !PsiPolyExpressionUtil.isPolyExpression((PsiExpression)parent2)) {
                return null;
            }
            return LambdaUtil.treeWalkUp(parent2);
        })) != null) {
            InferenceSession session;
            if (MethodCandidateInfo.isOverloadCheck() || !PsiDiamondType.ourDiamondGuard.currentStack().isEmpty() || LambdaUtil.isLambdaParameterCheck()) {
                session = InferenceSessionContainer.startTopLevelInference(topLevelCall, policy);
            } else {
                Map<PsiElement, InferenceSession> sessions;
                InferenceSession childSession;
                session = (InferenceSession)CachedValuesManager.getCachedValue(topLevelCall, () -> {
                    if (policy == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "lambda$infer$1"));
                    }
                    return new CachedValueProvider.Result<InferenceSession>(InferenceSessionContainer.startTopLevelInference(topLevelCall, policy), PsiModificationTracker.MODIFICATION_COUNT);
                });
                if (session != null && (childSession = (sessions = session.getInferenceSessionContainer().myNestedSessions).get(parent2)) != null) {
                    for (PsiTypeParameter parameter : typeParameters2) {
                        if (childSession.getInferenceSubstitution().getSubstitutionMap().containsKey(parameter)) continue;
                        session = InferenceSessionContainer.startTopLevelInference(topLevelCall, policy);
                        break;
                    }
                }
            }
            if (session != null) {
                PsiSubstitutor childSubstitutor = InferenceSessionContainer.inferNested(parameters2, arguments2, (PsiCall)parent2, properties2, session);
                if (childSubstitutor != null) {
                    return childSubstitutor;
                }
            } else if (topLevelCall instanceof PsiMethodCallExpression) {
                return new InferenceSession(typeParameters2, partialSubstitutor, parent2.getManager(), parent2, policy).prepareSubstitution();
            }
        }
        InferenceSession inferenceSession = new InferenceSession(typeParameters2, partialSubstitutor, parent2.getManager(), parent2, policy);
        inferenceSession.initExpressionConstraints(parameters2, arguments2, parent2);
        return inferenceSession.infer(parameters2, arguments2, parent2);
    }

    private static PsiSubstitutor inferNested(@NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments2, @NotNull PsiCall parent2, @NotNull MethodCandidateInfo.CurrentCandidateProperties properties2, @NotNull InferenceSession parentSession) {
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "inferNested"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "inferNested"));
        }
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "inferNested"));
        }
        if (properties2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "inferNested"));
        }
        if (parentSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentSession", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "inferNested"));
        }
        CompoundInitialState compoundInitialState = InferenceSessionContainer.createState(parentSession);
        InitialInferenceState initialInferenceState = compoundInitialState.getInitialState(parent2);
        if (initialInferenceState != null) {
            InferenceSession childSession = new InferenceSession(initialInferenceState);
            List<String> errorMessages = parentSession.getIncompatibleErrorMessages();
            if (errorMessages != null) {
                PsiMethod outerCallerMethod;
                PsiElement context = parentSession.getContext();
                if (context instanceof PsiCallExpression && (outerCallerMethod = ((PsiCallExpression)context).resolveMethod()) != null && outerCallerMethod.hasTypeParameters()) {
                    return properties2.getInfo().getSubstitutor(false);
                }
                return childSession.prepareSubstitution();
            }
            return childSession.collectAdditionalAndInfer(parameters2, arguments2, properties2, compoundInitialState.getInitialSubstitutor());
        }
        PsiElement gParent = PsiUtil.skipParenthesizedExprUp(parent2.getParent());
        while (true) {
            PsiCall call2;
            PsiElement returnContainer;
            if (gParent instanceof PsiReturnStatement && (returnContainer = gParent.getParent()) instanceof PsiCodeBlock) {
                gParent = returnContainer.getParent();
            }
            if (gParent instanceof PsiConditionalExpression) {
                gParent = PsiUtil.skipParenthesizedExprUp(gParent.getParent());
            }
            if (!(gParent instanceof PsiLambdaExpression) || (call2 = PsiTreeUtil.getParentOfType(gParent, PsiCall.class)) == null) break;
            initialInferenceState = compoundInitialState.getInitialState(call2);
            if (initialInferenceState != null) {
                PsiExpressionList argumentList2 = call2.getArgumentList();
                int idx = LambdaUtil.getLambdaIdx(argumentList2, gParent);
                JavaResolveResult result2 = PsiDiamondType.getDiamondsAwareResolveResult(call2);
                PsiElement method = result2.getElement();
                if (!(method instanceof PsiMethod) || idx <= -1) break;
                LOG.assertTrue(argumentList2 != null);
                PsiParameter[] methodParameters = ((PsiMethod)method).getParameterList().getParameters();
                if (methodParameters.length == 0) break;
                InferenceSession sessionInsideLambda = new InferenceSession(initialInferenceState);
                sessionInsideLambda.collectAdditionalAndInfer(methodParameters, argumentList2.getExpressions(), ((MethodCandidateInfo)result2).createProperties(), compoundInitialState.getInitialSubstitutor());
                return InferenceSessionContainer.inferNested(parameters2, arguments2, parent2, properties2, sessionInsideLambda);
            }
            gParent = PsiUtil.skipParenthesizedExprUp(call2.getParent());
        }
        return null;
    }

    private static CompoundInitialState createState(InferenceSession topLevelSession) {
        PsiSubstitutor topInferenceSubstitutor = InferenceSessionContainer.replaceVariables(topLevelSession.getInferenceVariables());
        final LinkedHashMap<PsiElement, InitialInferenceState> nestedStates = new LinkedHashMap<PsiElement, InitialInferenceState>();
        InferenceSessionContainer copy = new InferenceSessionContainer(){

            @Override
            public PsiSubstitutor findNestedSubstitutor(PsiElement arg, @Nullable PsiSubstitutor defaultSession) {
                PsiSubstitutor substitutor2 = super.findNestedSubstitutor(arg, null);
                if (substitutor2 != null) {
                    return substitutor2;
                }
                InitialInferenceState state2 = (InitialInferenceState)nestedStates.get(PsiTreeUtil.getParentOfType(arg, PsiCall.class));
                if (state2 != null) {
                    return state2.getInferenceSubstitutor();
                }
                return super.findNestedSubstitutor(arg, defaultSession);
            }
        };
        Map<PsiElement, InferenceSession> nestedSessions = topLevelSession.getInferenceSessionContainer().myNestedSessions;
        for (Map.Entry<PsiElement, InferenceSession> entry : nestedSessions.entrySet()) {
            nestedStates.put(entry.getKey(), entry.getValue().createInitialState(copy, topLevelSession.getInferenceVariables(), topInferenceSubstitutor));
        }
        PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable2 : topLevelSession.getInferenceVariables()) {
            PsiClass psiClass;
            PsiType instantiation = variable2.getInstantiation();
            if (instantiation == PsiType.NULL || !((psiClass = PsiUtil.resolveClassInClassTypeOnly(topInferenceSubstitutor.substitute(variable2))) instanceof InferenceVariable)) continue;
            substitutor2 = substitutor2.put((PsiTypeParameter)psiClass, instantiation);
        }
        return new CompoundInitialState(substitutor2, nestedStates);
    }

    @Nullable
    private static InferenceSession startTopLevelInference(PsiCall topLevelCall, ParameterTypeInferencePolicy policy) {
        JavaResolveResult result2 = PsiDiamondType.getDiamondsAwareResolveResult(topLevelCall);
        if (result2 instanceof MethodCandidateInfo) {
            PsiMethod method = ((MethodCandidateInfo)result2).getElement();
            PsiParameter[] topLevelParameters = method.getParameterList().getParameters();
            PsiExpressionList topLevelCallArgumentList = topLevelCall.getArgumentList();
            LOG.assertTrue(topLevelCallArgumentList != null, topLevelCall);
            PsiExpression[] topLevelArguments = topLevelCallArgumentList.getExpressions();
            return PsiResolveHelper.ourGraphGuard.doPreventingRecursion(topLevelCall, true, () -> {
                InferenceSession topLevelSession = new InferenceSession(method.getTypeParameters(), ((MethodCandidateInfo)result2).getSiteSubstitutor(), topLevelCall.getManager(), topLevelCall, policy);
                topLevelSession.initExpressionConstraints(topLevelParameters, topLevelArguments, topLevelCall, method, ((MethodCandidateInfo)result2).isVarargs());
                topLevelSession.infer(topLevelParameters, topLevelArguments, topLevelCall, ((MethodCandidateInfo)result2).createProperties());
                return topLevelSession;
            });
        }
        return null;
    }

    @NotNull
    private static PsiSubstitutor replaceVariables(Collection<InferenceVariable> inferenceVariables) {
        InferenceVariable[] oldVars;
        ArrayList<InferenceVariable> targetVars = new ArrayList<InferenceVariable>();
        PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable2 : oldVars = inferenceVariables.toArray(new InferenceVariable[inferenceVariables.size()])) {
            InferenceVariable newVariable = new InferenceVariable(variable2.getCallContext(), variable2.getParameter(), variable2.getName());
            substitutor2 = substitutor2.put(variable2, JavaPsiFacade.getElementFactory(variable2.getProject()).createType(newVariable));
            targetVars.add(newVariable);
            if (!variable2.isThrownBound()) continue;
            newVariable.setThrownBound();
        }
        for (int i = 0; i < targetVars.size(); ++i) {
            InferenceVariable var = (InferenceVariable)targetVars.get(i);
            for (InferenceBound boundType : InferenceBound.values()) {
                for (PsiType bound : oldVars[i].getBounds(boundType)) {
                    var.addBound(substitutor2.substitute(bound), boundType, null);
                }
            }
        }
        PsiSubstitutor psiSubstitutor = substitutor2;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "replaceVariables"));
        }
        return psiSubstitutor;
    }
}

