/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.CommonProcessors;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.Processors;
import org.jetbrains.kotlin.com.intellij.util.Query;
import org.jetbrains.kotlin.com.intellij.util.UnmodifiableIterator;

public abstract class AbstractQuery<Result>
implements Query<Result> {
    private boolean myIsProcessing;

    @Override
    @NotNull
    public Collection<Result> findAll() {
        this.assertNotProcessing();
        ArrayList result2 = new ArrayList();
        Processor processor = Processors.cancelableCollectProcessor(result2);
        this.forEach(processor);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/AbstractQuery", "findAll"));
        }
        return arrayList;
    }

    @Override
    public Iterator<Result> iterator() {
        this.assertNotProcessing();
        return new UnmodifiableIterator<Result>(this.findAll().iterator());
    }

    @Override
    @Nullable
    public Result findFirst() {
        this.assertNotProcessing();
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        this.forEach(processor);
        return (Result)processor.getFoundValue();
    }

    private void assertNotProcessing() {
        assert (!this.myIsProcessing) : "Operation is not allowed while query is being processed";
    }

    @Override
    public boolean forEach(@NotNull Processor<Result> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/kotlin/com/intellij/util/AbstractQuery", "forEach"));
        }
        this.assertNotProcessing();
        this.myIsProcessing = true;
        try {
            boolean bl = this.processResults(consumer);
            return bl;
        }
        finally {
            this.myIsProcessing = false;
        }
    }

    protected abstract boolean processResults(@NotNull Processor<Result> var1);
}

