/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.Query;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class CollectionQuery<T>
implements Query<T> {
    private final Collection<T> myCollection;

    public CollectionQuery(@NotNull Collection<T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "org/jetbrains/kotlin/com/intellij/util/CollectionQuery", "<init>"));
        }
        this.myCollection = collection;
    }

    @Override
    @NotNull
    public Collection<T> findAll() {
        Collection<T> collection = this.myCollection;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/CollectionQuery", "findAll"));
        }
        return collection;
    }

    @Override
    public T findFirst() {
        Iterator<T> i = this.iterator();
        return i.hasNext() ? (T)i.next() : null;
    }

    @Override
    public boolean forEach(@NotNull Processor<T> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/kotlin/com/intellij/util/CollectionQuery", "forEach"));
        }
        return ContainerUtil.process(this.myCollection, consumer);
    }

    @Override
    public Iterator<T> iterator() {
        return this.myCollection.iterator();
    }
}

