/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.kotlin.com.intellij.util.CommonProcessors;
import org.jetbrains.kotlin.com.intellij.util.Processor;

public class Processors {
    @NotNull
    public static <T> Processor<T> cancelableCollectProcessor(@NotNull Collection<T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "org/jetbrains/kotlin/com/intellij/util/Processors", "cancelableCollectProcessor"));
        }
        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor<T>((Collection)collection){

            @Override
            public boolean process(T t) {
                ProgressManager.checkCanceled();
                return super.process(t);
            }
        };
        if (collectProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/Processors", "cancelableCollectProcessor"));
        }
        return collectProcessor;
    }
}

