/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.diff;

import java.util.Arrays;
import java.util.BitSet;
import org.jetbrains.kotlin.com.intellij.util.diff.FilesTooBigForDiffException;
import org.jetbrains.kotlin.com.intellij.util.diff.LinkedDiffPaths;

class IntLCS {
    private final int[] myFirst;
    private final int[] mySecond;
    private final int myStart1;
    private final int myStart2;
    private final LinkedDiffPaths myPathsMatrix;
    private final int[] myPrevPathKey;
    private int[] myPrevEnds;
    private int[] myCurrentEnds;
    private final int myMaxX;
    private final int myMaxY;
    private final BitSet myChanges1;
    private final BitSet myChanges2;

    public IntLCS(int[] first, int[] second) {
        this(first, second, 0, first.length, 0, second.length, new BitSet(first.length), new BitSet(second.length));
    }

    public IntLCS(int[] first, int[] second, int start1, int count1, int start2, int count2, BitSet changes1, BitSet changes2) {
        this.myFirst = first;
        this.mySecond = second;
        this.myStart1 = start1;
        this.myStart2 = start2;
        this.myMaxX = count1;
        this.myMaxY = count2;
        this.myChanges1 = changes1;
        this.myChanges2 = changes2;
        this.myPathsMatrix = new LinkedDiffPaths(this.myMaxX, this.myMaxY);
        this.myPrevPathKey = new int[this.myMaxX + this.myMaxY + 1];
        Arrays.fill(this.myPrevPathKey, -1);
        this.myPrevEnds = new int[this.myMaxX + this.myMaxY + 1];
        this.myCurrentEnds = new int[this.myMaxX + this.myMaxY + 1];
    }

    public int execute() throws FilesTooBigForDiffException {
        for (int d = 0; d <= this.myMaxX + this.myMaxY; ++d) {
            int minDiag = -this.calcBound(this.myMaxY, d);
            int maxDiag = this.calcBound(this.myMaxX, d);
            if (d == 0) {
                int end = this.skipEquals(0, 0);
                if (end > 0) {
                    int xy = end - 1;
                    this.myPrevPathKey[this.myMaxY] = this.myPathsMatrix.encodeStep(xy, xy, end, false, -1);
                }
                if (this.myMaxX == this.myMaxY && end == this.myMaxX) {
                    return 0;
                }
                this.myPrevEnds[this.myMaxY] = end;
                continue;
            }
            System.arraycopy(this.myPrevEnds, minDiag + this.myMaxY, this.myCurrentEnds, minDiag + this.myMaxY, maxDiag - minDiag);
            for (int k = minDiag; k <= maxDiag; k += 2) {
                int prevEndH;
                int end;
                if (k == -d) {
                    int prevEndV = this.myPrevEnds[k + 1 + this.myMaxY];
                    int vertical = this.findDiagonalEnd(k + 1, prevEndV, true);
                    end = this.encodeStep(prevEndV, vertical, k, true);
                } else if (k == d) {
                    prevEndH = this.myPrevEnds[k - 1 + this.myMaxY];
                    int horisontal = this.findDiagonalEnd(k - 1, prevEndH, false);
                    end = this.encodeStep(prevEndH, horisontal, k, false);
                } else {
                    prevEndH = this.myPrevEnds[k - 1 + this.myMaxY];
                    int prevEndV = this.myPrevEnds[k + 1 + this.myMaxY];
                    if (prevEndH + 1 > prevEndV) {
                        int horisontal = this.findDiagonalEnd(k - 1, prevEndH, false);
                        end = this.encodeStep(prevEndH, horisontal, k, false);
                    } else {
                        int vertical = this.findDiagonalEnd(k + 1, prevEndV, true);
                        end = this.encodeStep(prevEndV, vertical, k, true);
                    }
                }
                this.myCurrentEnds[k + this.myMaxY] = end;
                if (k != this.myMaxX - this.myMaxY || end != this.myMaxX) continue;
                this.myPathsMatrix.applyChanges(this.myStart1, this.myStart2, this.myChanges1, this.myChanges2);
                return d;
            }
            int[] temps = this.myCurrentEnds;
            this.myCurrentEnds = this.myPrevEnds;
            this.myPrevEnds = temps;
        }
        throw new RuntimeException();
    }

    public BitSet[] getChanges() {
        return new BitSet[]{this.myChanges1, this.myChanges2};
    }

    private int findDiagonalEnd(int prevDiagonal, int prevEnd, boolean isVertical) {
        int x = prevEnd;
        int y = x - prevDiagonal;
        if (isVertical) {
            ++y;
        } else {
            ++x;
        }
        return this.skipEquals(x, y);
    }

    private int encodeStep(int prevEnd, int diagLength, int tDiagonal, boolean afterVertical) throws FilesTooBigForDiffException {
        int end = prevEnd + diagLength;
        int prevDiagonal = tDiagonal + this.myMaxY;
        if (!afterVertical) {
            ++end;
        }
        prevDiagonal = afterVertical ? ++prevDiagonal : --prevDiagonal;
        int x = end - 1;
        int y = x - tDiagonal;
        if (x == -1 || y == -1 || x >= this.myMaxX || y >= this.myMaxY) {
            return end;
        }
        this.myPrevPathKey[tDiagonal + this.myMaxY] = this.myPathsMatrix.encodeStep(x, y, diagLength, afterVertical, this.myPrevPathKey[prevDiagonal]);
        return end;
    }

    private int calcBound(int bound, int d) {
        return d <= bound ? d : 2 * bound - d;
    }

    private int skipEquals(int x, int y) {
        int skipped = 0;
        while (x < this.myMaxX && y < this.myMaxY && this.myFirst[this.myStart1 + x] == this.mySecond[this.myStart2 + y]) {
            ++skipped;
            ++x;
            ++y;
        }
        return skipped;
    }
}

