/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.model.functors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.model.ConditionalEffect;
import org.jetbrains.kotlin.contracts.model.ESEffect;
import org.jetbrains.kotlin.contracts.model.ESExpression;
import org.jetbrains.kotlin.contracts.model.structure.ESOr;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000*\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aO\u0010\u0000\u001a\u0004\u0018\u0001H\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0003\"\u0004\b\u0002\u0010\u00012\b\u0010\u0004\u001a\u0004\u0018\u0001H\u00022\b\u0010\u0005\u001a\u0004\u0018\u0001H\u00032\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00010\u0007H\u0000\u00a2\u0006\u0002\u0010\b\u001aW\u0010\t\u001a\u0004\u0018\u0001H\u0001\"\b\b\u0000\u0010\u0002*\u0002H\u0001\"\b\b\u0001\u0010\u0003*\u0002H\u0001\"\u0004\b\u0002\u0010\u00012\b\u0010\u0004\u001a\u0004\u0018\u0001H\u00022\b\u0010\u0005\u001a\u0004\u0018\u0001H\u00032\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00010\u0007H\u0000\u00a2\u0006\u0002\u0010\b\u001a\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0000\u001a:\u0010\u000f\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u0010*\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0000\u00a8\u0006\u0014"}, d2={"applyIfBothNotNull", "R", "F", "S", "first", "second", "operation", "Lkotlin/Function2;", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "applyWithDefault", "foldConditionsWithOr", "Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "list", "", "Lorg/jetbrains/kotlin/contracts/model/ConditionalEffect;", "strictPartition", "Lkotlin/Pair;", "firstModel", "Lorg/jetbrains/kotlin/contracts/model/ESEffect;", "secondModel", "resolution"})
public final class FunctorsUtilsKt {
    @Nullable
    public static final <F, S, R> R applyIfBothNotNull(@Nullable F first, @Nullable S second, @NotNull Function2<? super F, ? super S, ? extends R> operation) {
        Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
        return (R)(first == null || second == null ? null : operation.invoke(first, second));
    }

    @Nullable
    public static final <F extends R, S extends R, R> R applyWithDefault(@Nullable F first, @Nullable S second, @NotNull Function2<? super F, ? super S, ? extends R> operation) {
        Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
        return (R)(first == null && second == null ? null : (first == null ? (Object)second : (second == null ? (Object)first : operation.invoke(first, second))));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final ESExpression foldConditionsWithOr(@NotNull List<ConditionalEffect> list2) {
        ESExpression eSExpression;
        Intrinsics.checkParameterIsNotNull(list2, (String)"list");
        if (list2.isEmpty()) {
            eSExpression = null;
        } else {
            void var3_3;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)list2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                ConditionalEffect conditionalEffect = (ConditionalEffect)item$iv$iv;
                Collection collection = destination$iv$iv;
                ESExpression eSExpression2 = it.getCondition();
                collection.add(eSExpression2);
            }
            $receiver$iv = (List)destination$iv$iv;
            Iterator iterator$iv = $receiver$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void condition;
                ESExpression eSExpression3 = (ESExpression)iterator$iv.next();
                ESExpression acc = (ESExpression)accumulator$iv;
                accumulator$iv = new ESOr(acc, (ESExpression)condition);
            }
            eSExpression = (ESExpression)var3_3;
        }
        return eSExpression;
    }

    @NotNull
    public static final Pair<List<ConditionalEffect>, List<ConditionalEffect>> strictPartition(@NotNull List<ConditionalEffect> $receiver, @NotNull ESEffect firstModel, @NotNull ESEffect secondModel) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)firstModel, (String)"firstModel");
        Intrinsics.checkParameterIsNotNull((Object)secondModel, (String)"secondModel");
        List first = new ArrayList();
        List second = new ArrayList();
        Iterable $receiver$iv = $receiver;
        for (Object element$iv : $receiver$iv) {
            Collection collection;
            ConditionalEffect it = (ConditionalEffect)element$iv;
            if (Intrinsics.areEqual((Object)it.getSimpleEffect(), (Object)firstModel)) {
                collection = first;
                collection.add(it);
            }
            if (!Intrinsics.areEqual((Object)it.getSimpleEffect(), (Object)secondModel)) continue;
            collection = second;
            collection.add(it);
        }
        return TuplesKt.to((Object)first, (Object)second);
    }
}

