/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.google.common.collect.Maps;
import org.jetbrains.kotlin.com.google.common.collect.Sets;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.hash.LinkedHashMap;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsDynamicScope;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsImportedModule;
import org.jetbrains.kotlin.js.backend.ast.JsImportedModuleKey;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameBinding;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsProgramFragment;
import org.jetbrains.kotlin.js.backend.ast.JsRootScope;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.backend.ast.metadata.SpecialFunction;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.naming.NameSuggestionKt;
import org.jetbrains.kotlin.js.naming.SuggestedName;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsBuiltinNameClashChecker;
import org.jetbrains.kotlin.js.sourceMap.SourceFilePathResolver;
import org.jetbrains.kotlin.js.translate.context.DeclarationExporter;
import org.jetbrains.kotlin.js.translate.context.DeferredCallSite;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.context.generator.Generator;
import org.jetbrains.kotlin.js.translate.context.generator.Rule;
import org.jetbrains.kotlin.js.translate.declaration.ClassModelGenerator;
import org.jetbrains.kotlin.js.translate.intrinsic.Intrinsics;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.SignatureUtilsKt;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public final class StaticContext {
    @NotNull
    private final JsProgram program;
    @NotNull
    private final JsProgramFragment fragment;
    @NotNull
    private final BindingTrace bindingTrace;
    @NotNull
    private final Namer namer;
    @NotNull
    private final Intrinsics intrinsics;
    @NotNull
    private final JsScope rootScope;
    @NotNull
    private final Generator<JsName> innerNames = new InnerNameGenerator();
    @NotNull
    private final Generator<JsScope> scopes = new ScopeGenerator();
    @NotNull
    private final Generator<JsName> objectInstanceNames = new ObjectInstanceNameGenerator();
    @NotNull
    private final Map<JsScope, JsFunction> scopeToFunction = Maps.newHashMap();
    @NotNull
    private final Map<MemberDescriptor, List<DeclarationDescriptor>> classOrConstructorClosure = Maps.newHashMap();
    @NotNull
    private final Map<ClassDescriptor, List<DeferredCallSite>> deferredCallSites = new HashMap<ClassDescriptor, List<DeferredCallSite>>();
    @NotNull
    private final JsConfig config;
    @NotNull
    private final ModuleDescriptor currentModule;
    @NotNull
    private final NameSuggestion nameSuggestion = new NameSuggestion();
    @NotNull
    private final Map<DeclarationDescriptor, JsName> nameCache = new HashMap<DeclarationDescriptor, JsName>();
    @NotNull
    private final Map<VariableDescriptorWithAccessors, JsName> backingFieldNameCache = new HashMap<VariableDescriptorWithAccessors, JsName>();
    @NotNull
    private final Map<DeclarationDescriptor, JsExpression> fqnCache = new HashMap<DeclarationDescriptor, JsExpression>();
    private final Map<DeclarationDescriptor, String> tagCache = new HashMap<DeclarationDescriptor, String>();
    @NotNull
    private final Map<JsImportedModuleKey, JsImportedModule> importedModules = new LinkedHashMap<JsImportedModuleKey, JsImportedModule>();
    @NotNull
    private final DeclarationExporter exporter = new DeclarationExporter(this);
    @NotNull
    private final Map<FqName, JsScope> packageScopes = new HashMap<FqName, JsScope>();
    @NotNull
    private final ClassModelGenerator classModelGenerator;
    @Nullable
    private JsName nameForImportsForInline;
    private final Map<String, JsExpression> modulesImportedForInline = new HashMap<String, JsExpression>();
    private final Map<SpecialFunction, JsName> specialFunctions = new EnumMap<SpecialFunction, JsName>(SpecialFunction.class);
    private final Map<String, JsName> intrinsicNames = new HashMap<String, JsName>();
    @NotNull
    private final SourceFilePathResolver sourceFilePathResolver;
    private final boolean isStdlib;
    private static final Set<String> BUILTIN_JS_PROPERTIES = Sets.union(JsBuiltinNameClashChecker.PROHIBITED_MEMBER_NAMES, JsBuiltinNameClashChecker.PROHIBITED_STATIC_NAMES);

    public StaticContext(@NotNull BindingTrace bindingTrace, @NotNull JsConfig config, @NotNull ModuleDescriptor moduleDescriptor, @NotNull SourceFilePathResolver sourceFilePathResolver) {
        this.program = new JsProgram();
        JsFunction rootFunction = JsAstUtils.createFunctionWithEmptyBody(this.program.getScope());
        this.fragment = new JsProgramFragment(rootFunction.getScope());
        this.bindingTrace = bindingTrace;
        this.namer = Namer.newInstance(this.program.getRootScope());
        this.intrinsics = new Intrinsics();
        this.rootScope = this.fragment.getScope();
        this.config = config;
        this.currentModule = moduleDescriptor;
        JsName kotlinName = this.rootScope.declareName("Kotlin");
        this.createImportedModule(new JsImportedModuleKey(Namer.KOTLIN_LOWER_NAME, null), Namer.KOTLIN_LOWER_NAME, kotlinName, null);
        this.classModelGenerator = new ClassModelGenerator(TranslationContext.rootContext(this));
        this.sourceFilePathResolver = sourceFilePathResolver;
        ClassDescriptor exceptionClass = FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, ClassId.topLevel(new FqName("kotlin.Exception")));
        this.isStdlib = exceptionClass != null && DescriptorUtils.getContainingModule(exceptionClass) == moduleDescriptor;
    }

    @NotNull
    public JsProgram getProgram() {
        return this.program;
    }

    @NotNull
    public JsProgramFragment getFragment() {
        return this.fragment;
    }

    @NotNull
    public BindingTrace getBindingTrace() {
        return this.bindingTrace;
    }

    @NotNull
    public BindingContext getBindingContext() {
        return this.bindingTrace.getBindingContext();
    }

    @NotNull
    public Intrinsics getIntrinsics() {
        return this.intrinsics;
    }

    @NotNull
    public Namer getNamer() {
        return this.namer;
    }

    @NotNull
    public SourceFilePathResolver getSourceFilePathResolver() {
        return this.sourceFilePathResolver;
    }

    @NotNull
    public JsScope getScopeForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof ModuleDescriptor) {
            return this.rootScope;
        }
        JsScope scope = this.scopes.get(descriptor2.getOriginal());
        assert (scope != null) : "Must have a scope for descriptor";
        return scope;
    }

    @NotNull
    public JsFunction getFunctionWithScope(@NotNull CallableDescriptor descriptor2) {
        JsScope scope = this.getScopeForDescriptor(descriptor2);
        JsFunction function2 = this.scopeToFunction.get(scope);
        assert (scope.equals(function2.getScope())) : "Inconsistency.";
        return function2;
    }

    @NotNull
    public JsNameRef getQualifiedReference(@NotNull DeclarationDescriptor descriptor2) {
        return (JsNameRef)this.getQualifiedExpression(descriptor2);
    }

    @Nullable
    public String getTag(@NotNull DeclarationDescriptor descriptor2) {
        String tag;
        if (!this.tagCache.containsKey(descriptor2)) {
            tag = SignatureUtilsKt.generateSignature(descriptor2);
            this.tagCache.put(descriptor2, tag);
        } else {
            tag = this.tagCache.get(descriptor2);
        }
        return tag;
    }

    @NotNull
    private JsExpression getQualifiedExpression(@NotNull DeclarationDescriptor descriptor2) {
        JsExpression fqn = this.fqnCache.get(descriptor2);
        if (fqn == null) {
            fqn = this.buildQualifiedExpression(descriptor2);
            this.fqnCache.put(descriptor2, fqn);
        }
        return fqn.deepCopy();
    }

    @Nullable
    public SuggestedName suggestName(@NotNull DeclarationDescriptor descriptor2) {
        return this.nameSuggestion.suggest(descriptor2);
    }

    @NotNull
    private JsExpression buildQualifiedExpression(@NotNull DeclarationDescriptor descriptor2) {
        String moduleName;
        SuggestedName suggested;
        if (descriptor2 instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)descriptor2;
            SimpleType type2 = classDescriptor.getDefaultType();
            if (KotlinBuiltIns.isAny(classDescriptor)) {
                return JsAstUtils.pureFqn("Object", null);
            }
            if (KotlinBuiltIns.isInt(type2) || KotlinBuiltIns.isShort(type2) || KotlinBuiltIns.isByte(type2) || KotlinBuiltIns.isFloat(type2) || KotlinBuiltIns.isDouble(type2)) {
                return JsAstUtils.pureFqn("Number", null);
            }
            if (KotlinBuiltIns.isLong(type2)) {
                return JsAstUtils.pureFqn("Long", (JsExpression)Namer.kotlinObject());
            }
            if (KotlinBuiltIns.isChar(type2)) {
                return JsAstUtils.pureFqn("BoxedChar", (JsExpression)Namer.kotlinObject());
            }
            if (KotlinBuiltIns.isString(type2)) {
                return JsAstUtils.pureFqn("String", null);
            }
            if (KotlinBuiltIns.isBoolean(type2)) {
                return JsAstUtils.pureFqn("Boolean", null);
            }
            if (KotlinBuiltIns.isArrayOrPrimitiveArray(classDescriptor)) {
                return JsAstUtils.pureFqn("Array", null);
            }
            if (FunctionTypesKt.isBuiltinFunctionalType(type2)) {
                return JsAstUtils.pureFqn("Function", null);
            }
            if (TypeUtilsKt.isNotNullThrowable(classDescriptor.getDefaultType())) {
                return JsAstUtils.pureFqn("Error", null);
            }
        }
        if ((suggested = this.suggestName(descriptor2)) == null) {
            ModuleDescriptor module2 = DescriptorUtils.getContainingModule(descriptor2);
            JsExpression result2 = this.getModuleExpressionFor(module2);
            return result2 != null ? result2 : JsAstUtils.pureFqn(Namer.getRootPackageName(), null);
        }
        if (this.config.getModuleKind() != ModuleKind.PLAIN && (moduleName = AnnotationsUtils.getModuleName(suggested.getDescriptor())) != null) {
            return JsAstUtils.pureFqn(this.getImportedModule(moduleName, suggested.getDescriptor()).getInternalName(), null);
        }
        List<JsName> partNames = this.getActualNameFromSuggested(suggested);
        Object expression2 = AnnotationsUtils.isLibraryObject(suggested.getDescriptor()) ? Namer.kotlinObject() : (AnnotationsUtils.isNativeObject(suggested.getDescriptor()) && !AnnotationsUtils.isNativeObject(suggested.getScope()) || suggested.getDescriptor() instanceof CallableDescriptor && suggested.getScope() instanceof FunctionDescriptor ? null : this.getQualifiedExpression(suggested.getScope()));
        if (AnnotationsUtils.isNativeObject(suggested.getDescriptor()) && DescriptorUtils.isTopLevelDeclaration(suggested.getDescriptor())) {
            String qualifier;
            String fileModuleName = AnnotationsUtils.getFileModuleName(this.getBindingContext(), suggested.getDescriptor());
            if (fileModuleName != null) {
                JsName moduleJsName = this.getImportedModule(fileModuleName, null).getInternalName();
                expression2 = JsAstUtils.pureFqn(moduleJsName, (JsExpression)expression2);
            }
            if ((qualifier = AnnotationsUtils.getFileQualifier(this.getBindingContext(), suggested.getDescriptor())) != null) {
                for (String qualifierPart : StringUtil.split(qualifier, ".")) {
                    expression2 = JsAstUtils.pureFqn(qualifierPart, (JsExpression)expression2);
                }
            }
        }
        for (JsName partName : partNames) {
            expression2 = new JsNameRef(partName, (JsExpression)expression2);
            StaticContext.applySideEffects((JsExpression)expression2, suggested.getDescriptor());
        }
        assert (expression2 != null) : "Since partNames is not empty, expression must be non-null";
        return expression2;
    }

    @NotNull
    public JsName getNameForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isAny((ClassDescriptor)descriptor2)) {
            JsName result2 = this.rootScope.declareName("Object");
            MetadataProperties.setDescriptor(result2, descriptor2);
            return result2;
        }
        SuggestedName suggested = this.nameSuggestion.suggest(descriptor2);
        if (suggested == null) {
            throw new IllegalArgumentException("Can't generate name for root declarations: " + descriptor2);
        }
        return this.getActualNameFromSuggested(suggested).get(0);
    }

    @NotNull
    public JsName getNameForBackingField(@NotNull VariableDescriptorWithAccessors property) {
        JsName name = this.backingFieldNameCache.get(property);
        if (name == null) {
            SuggestedName fqn = this.nameSuggestion.suggest(property);
            assert (fqn != null) : "Properties are non-root declarations: " + property;
            assert (fqn.getNames().size() == 1) : "Private names must always consist of exactly one name";
            JsScope scope = this.getScopeForDescriptor(fqn.getScope());
            String baseName = NameSuggestion.getPrivateMangledName(fqn.getNames().get(0), property) + "_0";
            name = scope.declareFreshName(baseName);
            this.backingFieldNameCache.put(property, name);
        }
        return name;
    }

    @NotNull
    public JsName getInnerNameForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        JsName name = this.innerNames.get(descriptor2.getOriginal());
        assert (name != null) : "Must have inner name for descriptor";
        return name;
    }

    @NotNull
    public JsName getNameForObjectInstance(@NotNull ClassDescriptor descriptor2) {
        JsName name = this.objectInstanceNames.get(descriptor2.getOriginal());
        assert (name != null) : "Must have inner name for object instance";
        return name;
    }

    @NotNull
    private List<JsName> getActualNameFromSuggested(@NotNull SuggestedName suggested) {
        JsScope scope = this.getScopeForDescriptor(suggested.getScope());
        if (DynamicCallsKt.isDynamic(suggested.getDescriptor())) {
            scope = JsDynamicScope.INSTANCE;
        } else if (AnnotationsUtils.isPredefinedObject(suggested.getDescriptor()) && DescriptorUtils.isTopLevelDeclaration(suggested.getDescriptor())) {
            scope = this.rootScope;
        }
        ArrayList<JsName> names2 = new ArrayList<JsName>();
        if (suggested.getStable()) {
            String tag = this.getTag(suggested.getDescriptor());
            int index2 = 0;
            for (String namePart : suggested.getNames()) {
                JsName name = scope.declareName(namePart);
                MetadataProperties.setDescriptor(name, suggested.getDescriptor());
                if (tag != null && !AnnotationsUtils.isNativeObject(suggested.getDescriptor()) && !AnnotationsUtils.isLibraryObject(suggested.getDescriptor())) {
                    this.fragment.getNameBindings().add(new JsNameBinding(index2++ + ":" + tag, name));
                }
                names2.add(name);
            }
        } else {
            assert (suggested.getNames().size() == 1) : "Private names must always consist of exactly one name";
            JsName name = this.nameCache.get(suggested.getDescriptor());
            if (name == null) {
                String baseName = NameSuggestion.sanitizeName(suggested.getNames().get(0));
                if (suggested.getDescriptor() instanceof LocalVariableDescriptor || suggested.getDescriptor() instanceof ValueParameterDescriptor) {
                    name = JsScope.declareTemporaryName(baseName);
                } else {
                    if (!DescriptorUtils.isDescriptorWithLocalVisibility(suggested.getDescriptor())) {
                        baseName = baseName + "_0";
                    }
                    name = scope.declareFreshName(baseName);
                }
            }
            this.nameCache.put(suggested.getDescriptor(), name);
            MetadataProperties.setDescriptor(name, suggested.getDescriptor());
            String tag = this.getTag(suggested.getDescriptor());
            if (tag != null) {
                this.fragment.getNameBindings().add(new JsNameBinding(tag, name));
            }
            names2.add(name);
        }
        return names2;
    }

    @NotNull
    public JsConfig getConfig() {
        return this.config;
    }

    @NotNull
    private JsName importDeclaration(@NotNull String suggestedName, @NotNull String tag, @NotNull JsExpression declaration) {
        JsName result2 = this.importDeclarationImpl(suggestedName, tag, declaration);
        this.fragment.getNameBindings().add(new JsNameBinding(tag, result2));
        return result2;
    }

    @NotNull
    private JsName importDeclarationImpl(@NotNull String suggestedName, @NotNull String tag, @NotNull JsExpression declaration) {
        JsName result2 = JsScope.declareTemporaryName(suggestedName);
        MetadataProperties.setImported(result2, true);
        this.fragment.getImports().put(tag, declaration);
        return result2;
    }

    @NotNull
    private JsName localOrImportedName(@NotNull DeclarationDescriptor descriptor2, @NotNull String suggestedName) {
        JsName name;
        boolean isNative;
        ModuleDescriptor module2 = DescriptorUtilsKt.getModule(descriptor2);
        String tag = this.getTag(descriptor2);
        boolean bl = isNative = AnnotationsUtils.isNativeObject(descriptor2) || AnnotationsUtils.isLibraryObject(descriptor2);
        if (module2 != this.currentModule && !this.isLocallyRedeclaredBuiltin(descriptor2) || isNative) {
            assert (tag != null) : "Can't import declaration without tag: " + descriptor2;
            JsNameRef result2 = this.getQualifiedReference(descriptor2);
            if (isNative && result2.getQualifier() == null && result2.getName() != null) {
                name = result2.getName();
                tag = null;
            } else {
                name = this.importDeclarationImpl(suggestedName, tag, result2);
            }
        } else {
            name = JsScope.declareTemporaryName(suggestedName);
        }
        if (tag != null) {
            this.fragment.getNameBindings().add(new JsNameBinding(tag, name));
        }
        MetadataProperties.setDescriptor(name, descriptor2);
        return name;
    }

    private boolean isLocallyRedeclaredBuiltin(@NotNull DeclarationDescriptor descriptor2) {
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return false;
        }
        FqName fqName2 = DescriptorUtils.getFqNameSafe(descriptor2);
        ClassId classId = ClassId.topLevel(fqName2);
        ClassDescriptor localDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(this.currentModule, classId);
        return localDescriptor != null && DescriptorUtils.getContainingModule(localDescriptor) == this.currentModule;
    }

    @NotNull
    public static String getSuggestedName(@NotNull DeclarationDescriptor descriptor2) {
        String suggestedName;
        if (descriptor2 instanceof PropertyGetterDescriptor) {
            PropertyGetterDescriptor getter2 = (PropertyGetterDescriptor)descriptor2;
            suggestedName = "get_" + StaticContext.getSuggestedName(getter2.getCorrespondingProperty());
        } else if (descriptor2 instanceof PropertySetterDescriptor) {
            PropertySetterDescriptor setter2 = (PropertySetterDescriptor)descriptor2;
            suggestedName = "set_" + StaticContext.getSuggestedName(setter2.getCorrespondingProperty());
        } else if (descriptor2 instanceof ConstructorDescriptor) {
            ConstructorDescriptor constructor = (ConstructorDescriptor)descriptor2;
            suggestedName = StaticContext.getSuggestedName(constructor.getContainingDeclaration()) + "_init";
            descriptor2 = descriptor2.getContainingDeclaration();
            assert (descriptor2 != null) : "ConstructorDescriptor should have containing declaration: " + constructor;
        } else {
            suggestedName = descriptor2.getName().isSpecial() ? (descriptor2 instanceof ClassDescriptor ? (DescriptorUtils.isAnonymousObject(descriptor2) ? "ObjectLiteral" : "Anonymous") : (descriptor2 instanceof FunctionDescriptor ? "lambda" : "anonymous")) : NameSuggestion.sanitizeName(descriptor2.getName().asString());
        }
        if (!(descriptor2 instanceof PackageFragmentDescriptor) && !DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
            DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
            assert (container2 != null) : "We just figured out that descriptor is not for a top-level declaration: " + descriptor2;
            suggestedName = StaticContext.getSuggestedName(container2) + "$" + NameSuggestion.sanitizeName(suggestedName);
        }
        return suggestedName;
    }

    private JsScope getScopeForPackage(FqName fqName2) {
        JsScope scope = this.packageScopes.get(fqName2);
        if (scope == null) {
            if (fqName2.isRoot()) {
                scope = new JsRootScope(this.program);
            } else {
                JsScope parentScope = this.getScopeForPackage(fqName2.parent());
                scope = parentScope.innerObjectScope(fqName2.shortName().asString());
            }
            this.packageScopes.put(fqName2, scope);
        }
        return scope;
    }

    @Nullable
    private JsExpression getModuleExpressionFor(@NotNull DeclarationDescriptor descriptor2) {
        JsName name = this.getModuleInnerName(descriptor2);
        return name != null ? JsAstUtils.pureFqn(name, null) : null;
    }

    @Nullable
    private JsName getModuleInnerName(@NotNull DeclarationDescriptor descriptor2) {
        ModuleDescriptor module2 = DescriptorUtils.getContainingModule(descriptor2);
        if (this.currentModule == module2) {
            return this.rootScope.declareName(Namer.getRootPackageName());
        }
        String moduleName = StaticContext.suggestModuleName(module2);
        if ("<unknown>".equals(moduleName)) {
            return null;
        }
        return this.getImportedModule(moduleName, null).getInternalName();
    }

    @NotNull
    private static String suggestModuleName(@NotNull ModuleDescriptor module2) {
        if (module2 == module2.getBuiltIns().getBuiltInsModule()) {
            return Namer.KOTLIN_LOWER_NAME;
        }
        String moduleName = module2.getName().asString();
        return moduleName.substring(1, moduleName.length() - 1);
    }

    @NotNull
    public JsImportedModule getImportedModule(@NotNull String baseName, @Nullable DeclarationDescriptor descriptor2) {
        String plainName = descriptor2 != null && this.config.getModuleKind() == ModuleKind.UMD ? this.getPlainId(descriptor2) : null;
        JsImportedModuleKey key = new JsImportedModuleKey(baseName, plainName);
        JsImportedModule module2 = this.importedModules.get(key);
        if (module2 == null) {
            JsName internalName = JsScope.declareTemporaryName("$module$" + Namer.suggestedModuleName(baseName));
            module2 = this.createImportedModule(key, baseName, internalName, plainName != null ? JsAstUtils.pureFqn(plainName, null) : null);
        }
        return module2;
    }

    private JsImportedModule createImportedModule(JsImportedModuleKey key, String baseName, JsName internalName, JsExpression plainName) {
        JsImportedModule module2 = new JsImportedModule(baseName, internalName, plainName);
        this.importedModules.put(key, module2);
        this.fragment.getImportedModules().add(module2);
        return module2;
    }

    @NotNull
    private String getPlainId(@NotNull DeclarationDescriptor declaration) {
        SuggestedName suggestedName = this.nameSuggestion.suggest(declaration);
        assert (suggestedName != null) : "Declaration should not be ModuleDescriptor, therefore suggestedName should be non-null";
        return suggestedName.getNames().get(0);
    }

    private static void applySideEffects(JsExpression expression2, DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof FunctionDescriptor || descriptor2 instanceof PackageFragmentDescriptor || descriptor2 instanceof ClassDescriptor) {
            MetadataProperties.setSideEffects(expression2, SideEffectKind.PURE);
        }
    }

    public void putClassOrConstructorClosure(@NotNull MemberDescriptor localClass, @NotNull List<DeclarationDescriptor> closure) {
        this.classOrConstructorClosure.put(localClass, Lists.newArrayList(closure));
    }

    @Nullable
    public List<DeclarationDescriptor> getClassOrConstructorClosure(@NotNull MemberDescriptor descriptor2) {
        List<DeclarationDescriptor> result2 = this.classOrConstructorClosure.get(descriptor2);
        return result2 != null ? Lists.newArrayList(result2) : null;
    }

    @NotNull
    public Map<ClassDescriptor, List<DeferredCallSite>> getDeferredCallSites() {
        return this.deferredCallSites;
    }

    @NotNull
    public List<JsStatement> getTopLevelStatements() {
        return this.fragment.getInitializerBlock().getStatements();
    }

    @NotNull
    public List<JsStatement> getDeclarationStatements() {
        return this.fragment.getDeclarationBlock().getStatements();
    }

    public void addClass(@NotNull ClassDescriptor classDescriptor) {
        if (!AnnotationsUtils.isNativeObject(classDescriptor) && !AnnotationsUtils.isLibraryObject(classDescriptor)) {
            this.fragment.getClasses().put(this.getInnerNameForDescriptor(classDescriptor), this.classModelGenerator.generateClassModel(classDescriptor));
        }
    }

    public void export(@NotNull MemberDescriptor descriptor2, boolean force) {
        this.exporter.export(descriptor2, force);
    }

    @NotNull
    public NameSuggestion getNameSuggestion() {
        return this.nameSuggestion;
    }

    @NotNull
    public ModuleDescriptor getCurrentModule() {
        return this.currentModule;
    }

    public void addInlineCall(@NotNull CallableDescriptor descriptor2) {
        descriptor2 = (CallableDescriptor)JsDescriptorUtils.findRealInlineDeclaration(descriptor2);
        String tag = Namer.getFunctionTag(descriptor2, this.config);
        JsExpression moduleExpression = this.exportModuleForInline(DescriptorUtils.getContainingModule(descriptor2));
        if (moduleExpression == null) {
            moduleExpression = this.getModuleExpressionFor(descriptor2);
        }
        this.fragment.getInlineModuleMap().put(tag, moduleExpression);
    }

    @NotNull
    private JsName getNameForImportsForInline() {
        if (this.nameForImportsForInline == null) {
            JsName name = JsScope.declareTemporaryName("$$importsForInline$$");
            this.fragment.getNameBindings().add(new JsNameBinding("$$importsForInline$$", name));
            this.nameForImportsForInline = name;
            return name;
        }
        return this.nameForImportsForInline;
    }

    @Nullable
    public JsExpression exportModuleForInline(@NotNull ModuleDescriptor declaration) {
        if (this.getCurrentModule().getBuiltIns().getBuiltInsModule() == declaration) {
            return null;
        }
        String moduleName = StaticContext.suggestModuleName(declaration);
        if (moduleName.equals(Namer.KOTLIN_LOWER_NAME)) {
            return null;
        }
        return this.exportModuleForInline(moduleName, this.getInnerNameForDescriptor(declaration));
    }

    @NotNull
    public JsExpression exportModuleForInline(@NotNull String moduleId, @NotNull JsName moduleName) {
        JsExpression moduleRef = this.modulesImportedForInline.get(moduleId);
        if (moduleRef == null) {
            JsExpression lhsModuleRef;
            JsNameRef currentModuleRef = JsAstUtils.pureFqn(this.getInnerNameForDescriptor(this.getCurrentModule()), null);
            JsNameRef importsRef = JsAstUtils.pureFqn("$$importsForInline$$", (JsExpression)currentModuleRef);
            JsNameRef currentImports = JsAstUtils.pureFqn(this.getNameForImportsForInline(), null);
            if (NameSuggestionKt.isValidES5Identifier(moduleId)) {
                moduleRef = JsAstUtils.pureFqn(moduleId, (JsExpression)importsRef);
                lhsModuleRef = JsAstUtils.pureFqn(moduleId, (JsExpression)currentImports);
            } else {
                moduleRef = new JsArrayAccess(importsRef, new JsStringLiteral(moduleId));
                MetadataProperties.setSideEffects(moduleRef, SideEffectKind.PURE);
                lhsModuleRef = new JsArrayAccess(currentImports, new JsStringLiteral(moduleId));
            }
            MetadataProperties.setLocalAlias(moduleRef, moduleName);
            JsExpressionStatement importStmt = new JsExpressionStatement(JsAstUtils.assignment(lhsModuleRef, moduleName.makeRef()));
            MetadataProperties.setExportedTag(importStmt, "imports:" + moduleId);
            this.getFragment().getExportBlock().getStatements().add(importStmt);
            this.modulesImportedForInline.put(moduleId, moduleRef);
        }
        return moduleRef.deepCopy();
    }

    @NotNull
    public JsName getNameForSpecialFunction(@NotNull SpecialFunction specialFunction) {
        return this.specialFunctions.computeIfAbsent(specialFunction, f -> {
            JsExpression expression2 = Namer.createSpecialFunction(specialFunction);
            JsName name = this.importDeclaration(f.getSuggestedName(), TranslationUtils.getTagForSpecialFunction(f), expression2);
            MetadataProperties.setSpecialFunction(name, f);
            return name;
        });
    }

    @NotNull
    public JsExpression getReferenceToIntrinsic(@NotNull String name) {
        JsName resultName = this.intrinsicNames.computeIfAbsent(name, k -> {
            DeclarationDescriptor descriptor2;
            if (this.isStdlib && (descriptor2 = this.findDescriptorForIntrinsic(name)) != null) {
                return this.getInnerNameForDescriptor(descriptor2);
            }
            return this.importDeclaration(NameSuggestion.sanitizeName(name), "intrinsic:" + name, TranslationUtils.getIntrinsicFqn(name));
        });
        return JsAstUtils.pureFqn(resultName, null);
    }

    @Nullable
    private DeclarationDescriptor findDescriptorForIntrinsic(@NotNull String name) {
        PackageViewDescriptor rootPackage = this.currentModule.getPackage(FqName.ROOT);
        FunctionDescriptor functionDescriptor = DescriptorUtils.getFunctionByNameOrNull(rootPackage.getMemberScope(), Name.identifier(name));
        if (functionDescriptor != null) {
            return functionDescriptor;
        }
        ClassifierDescriptor cls = rootPackage.getMemberScope().getContributedClassifier(Name.identifier(name), NoLookupLocation.FROM_BACKEND);
        if (cls != null) {
            return cls;
        }
        return null;
    }

    private final class ScopeGenerator
    extends Generator<JsScope> {
        public ScopeGenerator() {
            Rule<JsScope> generateNewScopesForClassesWithNoAncestors = descriptor2 -> {
                if (!(descriptor2 instanceof ClassDescriptor)) {
                    return null;
                }
                if (JsDescriptorUtils.getSuperclass((ClassDescriptor)descriptor2) == null) {
                    JsFunction function2 = new JsFunction((JsScope)new JsRootScope(StaticContext.this.program), new JsBlock(), descriptor2.toString());
                    for (String builtinName : BUILTIN_JS_PROPERTIES) {
                        function2.getScope().declareName(builtinName);
                    }
                    StaticContext.this.scopeToFunction.put(function2.getScope(), function2);
                    return function2.getScope();
                }
                return null;
            };
            Rule<JsScope> generateInnerScopesForDerivedClasses = descriptor2 -> {
                if (!(descriptor2 instanceof ClassDescriptor)) {
                    return null;
                }
                ClassDescriptor superclass = JsDescriptorUtils.getSuperclass((ClassDescriptor)descriptor2);
                if (superclass == null) {
                    return null;
                }
                return StaticContext.this.getScopeForDescriptor(superclass).innerObjectScope("Scope for class " + descriptor2.getName());
            };
            Rule<JsScope> generateNewScopesForPackageDescriptors = descriptor2 -> StaticContext.this.fragment.getScope();
            Rule<JsScope> generateInnerScopesForMembers = descriptor2 -> StaticContext.this.fragment.getScope().innerObjectScope("Scope for member " + descriptor2.getName());
            Rule<JsScope> createFunctionObjectsForCallableDescriptors = descriptor2 -> {
                if (!(descriptor2 instanceof CallableDescriptor)) {
                    return null;
                }
                JsFunction correspondingFunction = JsAstUtils.createFunctionWithEmptyBody(StaticContext.this.fragment.getScope());
                assert (!StaticContext.this.scopeToFunction.containsKey(correspondingFunction.getScope())) : "Scope to function value overridden for " + descriptor2;
                StaticContext.this.scopeToFunction.put(correspondingFunction.getScope(), correspondingFunction);
                correspondingFunction.setSource(KotlinSourceElementKt.getPsi(((CallableDescriptor)descriptor2).getSource()));
                return correspondingFunction.getScope();
            };
            Rule<JsScope> scopeForPackage = descriptor2 -> {
                if (!(descriptor2 instanceof PackageFragmentDescriptor)) {
                    return null;
                }
                PackageFragmentDescriptor packageDescriptor = (PackageFragmentDescriptor)descriptor2;
                return StaticContext.this.getScopeForPackage(packageDescriptor.getFqName());
            };
            this.addRule(scopeForPackage);
            this.addRule(createFunctionObjectsForCallableDescriptors);
            this.addRule(generateNewScopesForClassesWithNoAncestors);
            this.addRule(generateInnerScopesForDerivedClasses);
            this.addRule(generateNewScopesForPackageDescriptors);
            this.addRule(generateInnerScopesForMembers);
        }
    }

    private final class ObjectInstanceNameGenerator
    extends Generator<JsName> {
        public ObjectInstanceNameGenerator() {
            this.addRule(descriptor2 -> {
                String suggested = StaticContext.getSuggestedName(descriptor2) + "_getInstance";
                JsName result2 = JsScope.declareTemporaryName(suggested);
                String tag = SignatureUtilsKt.generateSignature(descriptor2);
                if (tag != null) {
                    StaticContext.this.fragment.getNameBindings().add(new JsNameBinding("object:" + tag, result2));
                }
                return result2;
            });
        }
    }

    private final class InnerNameGenerator
    extends Generator<JsName> {
        public InnerNameGenerator() {
            this.addRule(descriptor2 -> {
                FunctionDescriptor initialDescriptor;
                if (descriptor2 instanceof PackageFragmentDescriptor && DescriptorUtils.getContainingModule(descriptor2) == StaticContext.this.currentModule) {
                    return StaticContext.this.exporter.getLocalPackageName(((PackageFragmentDescriptor)descriptor2).getFqName());
                }
                if (descriptor2 instanceof FunctionDescriptor && (initialDescriptor = ((FunctionDescriptor)descriptor2).getInitialSignatureDescriptor()) != null) {
                    return StaticContext.this.getInnerNameForDescriptor(initialDescriptor);
                }
                if (descriptor2 instanceof ModuleDescriptor) {
                    return StaticContext.this.getModuleInnerName(descriptor2);
                }
                if (descriptor2 instanceof LocalVariableDescriptor || descriptor2 instanceof ParameterDescriptor) {
                    return StaticContext.this.getNameForDescriptor(descriptor2);
                }
                if (descriptor2 instanceof ConstructorDescriptor && ((ConstructorDescriptor)descriptor2).isPrimary()) {
                    return StaticContext.this.getInnerNameForDescriptor(((ConstructorDescriptor)descriptor2).getConstructedClass());
                }
                return StaticContext.this.localOrImportedName(descriptor2, StaticContext.getSuggestedName(descriptor2));
            });
        }
    }
}

