/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J$\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J,\u0010\u0011\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J$\u0010\u0014\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\f\u0010\u0015\u001a\u00020\u0016*\u00020\rH\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/AssigningNamedArgumentToVarargChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkAssignmentOfSingleElementInAnnotation", "argument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "argumentExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "checkAssignmentOfSingleElementInFunction", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "checkAssignmentOfSingleElementToVararg", "hasSpread", "", "frontend"})
public final class AssigningNamedArgumentToVarargChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = resolvedCall2.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"resolvedCall.valueArguments");
        Map<ValueParameterDescriptor, ResolvedValueArgument> map3 = map2;
        Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = map3.entrySet().iterator();
        while (iterator2.hasNext()) {
            ResolvedValueArgument resolvedArgument;
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry;
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry2 = entry = iterator2.next();
            ValueParameterDescriptor parameterDescriptor = entry2.getKey();
            entry2 = entry;
            ResolvedValueArgument resolvedValueArgument = resolvedArgument = entry2.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedValueArgument, (String)"resolvedArgument");
            Iterator<ValueArgument> iterator3 = resolvedValueArgument.getArguments().iterator();
            while (iterator3.hasNext()) {
                ValueArgument argument;
                ValueArgument valueArgument = argument = iterator3.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)valueArgument, (String)"argument");
                ValueParameterDescriptor valueParameterDescriptor = parameterDescriptor;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"parameterDescriptor");
                this.checkAssignmentOfSingleElementToVararg(valueArgument, valueParameterDescriptor, context.getResolutionContext());
            }
        }
    }

    private final void checkAssignmentOfSingleElementToVararg(ValueArgument argument, ValueParameterDescriptor parameterDescriptor, ResolutionContext<?> context) {
        if (!context.languageVersionSettings.supportsFeature(LanguageFeature.AssigningArraysToVarargsInNamedFormInAnnotations)) {
            return;
        }
        if (!argument.isNamed()) {
            return;
        }
        if (!ArgumentsUtilsKt.isVararg(parameterDescriptor)) {
            return;
        }
        KtExpression ktExpression = argument.getArgumentExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression argumentExpression = ktExpression;
        if (CallResolverUtilKt.isParameterOfAnnotation(parameterDescriptor)) {
            this.checkAssignmentOfSingleElementInAnnotation(argument, argumentExpression, context);
        } else {
            this.checkAssignmentOfSingleElementInFunction(argument, argumentExpression, context, parameterDescriptor);
        }
    }

    private final void checkAssignmentOfSingleElementInAnnotation(ValueArgument argument, KtExpression argumentExpression, ResolutionContext<?> context) {
        if (CallResolverUtilKt.isArrayOrArrayLiteral(argument, context)) {
            if (this.hasSpread(argument)) {
                context.trace.report(Errors.ASSIGNING_SINGLE_ELEMENT_TO_VARARG_IN_NAMED_FORM_ANNOTATION.on((KtExpression)((PsiElement)argumentExpression)));
            }
        } else {
            context.trace.report(Errors.ASSIGNING_SINGLE_ELEMENT_TO_VARARG_IN_NAMED_FORM_ANNOTATION.on((KtExpression)((PsiElement)argumentExpression)));
        }
    }

    private final void checkAssignmentOfSingleElementInFunction(ValueArgument argument, KtExpression argumentExpression, ResolutionContext<?> context, ValueParameterDescriptor parameterDescriptor) {
        if (!this.hasSpread(argument)) {
            context.trace.report(Errors.ASSIGNING_SINGLE_ELEMENT_TO_VARARG_IN_NAMED_FORM_FUNCTION.on((KtExpression)((PsiElement)argumentExpression), parameterDescriptor.getType()));
        }
    }

    private final boolean hasSpread(@NotNull ValueArgument $receiver) {
        return $receiver.getSpreadElement() != null;
    }
}

