/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.org.objectweb.asm.tree;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.org.objectweb.asm.ModuleVisitor;
import org.jetbrains.org.objectweb.asm.tree.ModuleExportNode;
import org.jetbrains.org.objectweb.asm.tree.ModuleOpenNode;
import org.jetbrains.org.objectweb.asm.tree.ModuleProvideNode;
import org.jetbrains.org.objectweb.asm.tree.ModuleRequireNode;

public class ModuleNode
extends ModuleVisitor {
    public String name;
    public int access;
    public String version;
    public String mainClass;
    public String osName;
    public String osArch;
    public String osVersion;
    public List<String> packages;
    public List<ModuleRequireNode> requires;
    public List<ModuleExportNode> exports;
    public List<ModuleOpenNode> opens;
    public List<String> uses;
    public List<ModuleProvideNode> provides;

    public ModuleNode(String name, int access, String version) {
        super(393216);
        this.name = name;
        this.access = access;
        this.version = version;
    }

    public void visitMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void visitTarget(String osName, String osArch, String osVersion) {
        this.osName = osName;
        this.osArch = osArch;
        this.osVersion = osVersion;
    }

    public void visitPackage(String packaze) {
        if (this.packages == null) {
            this.packages = new ArrayList<String>(5);
        }
        this.packages.add(packaze);
    }

    public void visitRequire(String module2, int access, String version) {
        if (this.requires == null) {
            this.requires = new ArrayList<ModuleRequireNode>(5);
        }
        this.requires.add(new ModuleRequireNode(module2, access, version));
    }

    public void visitExport(String packaze, int access, String ... modules) {
        if (this.exports == null) {
            this.exports = new ArrayList<ModuleExportNode>(5);
        }
        ArrayList<String> moduleList = null;
        if (modules != null) {
            moduleList = new ArrayList<String>(modules.length);
            for (int i = 0; i < modules.length; ++i) {
                moduleList.add(modules[i]);
            }
        }
        this.exports.add(new ModuleExportNode(packaze, access, moduleList));
    }

    public void visitOpen(String packaze, int access, String ... modules) {
        if (this.opens == null) {
            this.opens = new ArrayList<ModuleOpenNode>(5);
        }
        ArrayList<String> moduleList = null;
        if (modules != null) {
            moduleList = new ArrayList<String>(modules.length);
            for (int i = 0; i < modules.length; ++i) {
                moduleList.add(modules[i]);
            }
        }
        this.opens.add(new ModuleOpenNode(packaze, access, moduleList));
    }

    public void visitUse(String service) {
        if (this.uses == null) {
            this.uses = new ArrayList<String>(5);
        }
        this.uses.add(service);
    }

    public void visitProvide(String service, String ... providers) {
        if (this.provides == null) {
            this.provides = new ArrayList<ModuleProvideNode>(5);
        }
        ArrayList<String> providerList = new ArrayList<String>(providers.length);
        for (int i = 0; i < providers.length; ++i) {
            providerList.add(providers[i]);
        }
        this.provides.add(new ModuleProvideNode(service, providerList));
    }

    public void visitEnd() {
    }
}

