/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import java.io.File;
import java.util.Date;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.artifacts.dsl.ArtifactFile;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskDependency;

public class LazyPublishArtifact
implements PublishArtifact {
    private final Provider<?> provider;
    private final String version;

    public LazyPublishArtifact(Provider<?> provider, String version) {
        this.provider = provider;
        this.version = version;
    }

    public String getName() {
        return this.getValue().getName();
    }

    public String getExtension() {
        return this.getValue().getExtension();
    }

    public String getType() {
        return "";
    }

    public String getClassifier() {
        return this.getValue().getClassifier();
    }

    public File getFile() {
        Object value = this.provider.get();
        if (value instanceof FileSystemLocation) {
            FileSystemLocation location = (FileSystemLocation)value;
            return location.getAsFile();
        }
        if (value instanceof File) {
            return (File)value;
        }
        throw new InvalidUserDataException(String.format("Cannot convert provided value (%s) to a file.", value));
    }

    public Date getDate() {
        return new Date();
    }

    private ArtifactFile getValue() {
        return new ArtifactFile(this.getFile(), this.version);
    }

    public TaskDependency getBuildDependencies() {
        return new AbstractTaskDependency(){

            public void visitDependencies(TaskDependencyResolveContext context) {
                if (LazyPublishArtifact.this.provider instanceof TaskDependencyContainer) {
                    context.add((Object)LazyPublishArtifact.this.provider);
                }
            }
        };
    }
}

