/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories;

import java.io.File;
import java.net.URI;
import java.util.Map;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.AuthenticationContainer;
import org.gradle.api.artifacts.repositories.FlatDirectoryArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.internal.ExperimentalFeatures;
import org.gradle.api.internal.InstantiatorFactory;
import org.gradle.api.internal.artifacts.BaseRepositoryFactory;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.IvyContextManager;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.ModuleMetadataParser;
import org.gradle.api.internal.artifacts.mvnsettings.LocalMavenRepositoryLocator;
import org.gradle.api.internal.artifacts.repositories.DefaultFlatDirArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.DefaultIvyArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.DefaultMavenArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.DefaultMavenLocalArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.metadata.IvyMutableModuleMetadataFactory;
import org.gradle.api.internal.artifacts.repositories.metadata.MavenMutableModuleMetadataFactory;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransportFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.authentication.AuthenticationSchemeRegistry;
import org.gradle.internal.authentication.DefaultAuthenticationContainer;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.MutableMavenModuleResolveMetadata;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resource.local.FileResourceRepository;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableResourceFinder;

public class DefaultBaseRepositoryFactory
implements BaseRepositoryFactory {
    private final LocalMavenRepositoryLocator localMavenRepositoryLocator;
    private final FileResolver fileResolver;
    private final Instantiator instantiator;
    private final RepositoryTransportFactory transportFactory;
    private final LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder;
    private final FileStore<ModuleComponentArtifactIdentifier> artifactFileStore;
    private final FileStore<String> externalResourcesFileStore;
    private final MetaDataParser<MutableMavenModuleResolveMetadata> pomParser;
    private final ModuleMetadataParser metadataParser;
    private final AuthenticationSchemeRegistry authenticationSchemeRegistry;
    private final IvyContextManager ivyContextManager;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final InstantiatorFactory instantiatorFactory;
    private final FileResourceRepository fileResourceRepository;
    private final ExperimentalFeatures experimentalFeatures;
    private final MavenMutableModuleMetadataFactory mavenMetadataFactory;
    private final IvyMutableModuleMetadataFactory ivyMetadataFactory;

    public DefaultBaseRepositoryFactory(LocalMavenRepositoryLocator localMavenRepositoryLocator, FileResolver fileResolver, RepositoryTransportFactory transportFactory, LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder, FileStore<ModuleComponentArtifactIdentifier> artifactFileStore, FileStore<String> externalResourcesFileStore, MetaDataParser<MutableMavenModuleResolveMetadata> pomParser, ModuleMetadataParser metadataParser, AuthenticationSchemeRegistry authenticationSchemeRegistry, IvyContextManager ivyContextManager, ImmutableModuleIdentifierFactory moduleIdentifierFactory, InstantiatorFactory instantiatorFactory, FileResourceRepository fileResourceRepository, ExperimentalFeatures experimentalFeatures, MavenMutableModuleMetadataFactory mavenMetadataFactory, IvyMutableModuleMetadataFactory ivyMetadataFactory) {
        this.localMavenRepositoryLocator = localMavenRepositoryLocator;
        this.fileResolver = fileResolver;
        this.metadataParser = metadataParser;
        this.instantiator = instantiatorFactory.decorate();
        this.transportFactory = transportFactory;
        this.locallyAvailableResourceFinder = locallyAvailableResourceFinder;
        this.artifactFileStore = artifactFileStore;
        this.externalResourcesFileStore = externalResourcesFileStore;
        this.pomParser = pomParser;
        this.authenticationSchemeRegistry = authenticationSchemeRegistry;
        this.ivyContextManager = ivyContextManager;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.instantiatorFactory = instantiatorFactory;
        this.fileResourceRepository = fileResourceRepository;
        this.experimentalFeatures = experimentalFeatures;
        this.mavenMetadataFactory = mavenMetadataFactory;
        this.ivyMetadataFactory = ivyMetadataFactory;
    }

    @Override
    public FlatDirectoryArtifactRepository createFlatDirRepository() {
        return (FlatDirectoryArtifactRepository)this.instantiator.newInstance(DefaultFlatDirArtifactRepository.class, new Object[]{this.fileResolver, this.transportFactory, this.locallyAvailableResourceFinder, this.artifactFileStore, this.moduleIdentifierFactory, this.ivyMetadataFactory});
    }

    @Override
    public ArtifactRepository createGradlePluginPortal() {
        MavenArtifactRepository mavenRepository = this.createMavenRepository(new NamedMavenRepositoryDescriber("https://plugins.gradle.org/m2"));
        mavenRepository.setUrl((Object)System.getProperty("org.gradle.internal.plugins.portal.url.override", "https://plugins.gradle.org/m2"));
        return mavenRepository;
    }

    @Override
    public MavenArtifactRepository createMavenLocalRepository() {
        MavenArtifactRepository mavenRepository = (MavenArtifactRepository)this.instantiator.newInstance(DefaultMavenLocalArtifactRepository.class, new Object[]{this.fileResolver, this.transportFactory, this.locallyAvailableResourceFinder, this.instantiatorFactory, this.artifactFileStore, this.pomParser, this.metadataParser, this.createAuthenticationContainer(), this.moduleIdentifierFactory, this.fileResourceRepository, this.experimentalFeatures, this.mavenMetadataFactory});
        File localMavenRepository = this.localMavenRepositoryLocator.getLocalMavenRepository();
        mavenRepository.setUrl((Object)localMavenRepository);
        return mavenRepository;
    }

    @Override
    public MavenArtifactRepository createJCenterRepository() {
        MavenArtifactRepository mavenRepository = this.createMavenRepository(new NamedMavenRepositoryDescriber("https://jcenter.bintray.com/"));
        mavenRepository.setUrl((Object)"https://jcenter.bintray.com/");
        return mavenRepository;
    }

    @Override
    public MavenArtifactRepository createMavenCentralRepository() {
        MavenArtifactRepository mavenRepository = this.createMavenRepository(new NamedMavenRepositoryDescriber("https://repo.maven.apache.org/maven2/"));
        mavenRepository.setUrl((Object)"https://repo.maven.apache.org/maven2/");
        return mavenRepository;
    }

    @Override
    public MavenArtifactRepository createGoogleRepository() {
        MavenArtifactRepository mavenRepository = this.createMavenRepository(new NamedMavenRepositoryDescriber("https://dl.google.com/dl/android/maven2/"));
        mavenRepository.setUrl((Object)"https://dl.google.com/dl/android/maven2/");
        return mavenRepository;
    }

    @Override
    public IvyArtifactRepository createIvyRepository() {
        return (IvyArtifactRepository)this.instantiator.newInstance(DefaultIvyArtifactRepository.class, new Object[]{this.fileResolver, this.transportFactory, this.locallyAvailableResourceFinder, this.artifactFileStore, this.externalResourcesFileStore, this.createAuthenticationContainer(), this.ivyContextManager, this.moduleIdentifierFactory, this.instantiatorFactory, this.fileResourceRepository, this.metadataParser, this.experimentalFeatures, this.ivyMetadataFactory});
    }

    @Override
    public MavenArtifactRepository createMavenRepository() {
        return (MavenArtifactRepository)this.instantiator.newInstance(DefaultMavenArtifactRepository.class, new Object[]{this.fileResolver, this.transportFactory, this.locallyAvailableResourceFinder, this.instantiatorFactory, this.artifactFileStore, this.pomParser, this.metadataParser, this.createAuthenticationContainer(), this.moduleIdentifierFactory, this.externalResourcesFileStore, this.fileResourceRepository, this.experimentalFeatures, this.mavenMetadataFactory});
    }

    public MavenArtifactRepository createMavenRepository(Transformer<String, MavenArtifactRepository> describer) {
        return (MavenArtifactRepository)this.instantiator.newInstance(DefaultMavenArtifactRepository.class, new Object[]{describer, this.fileResolver, this.transportFactory, this.locallyAvailableResourceFinder, this.instantiatorFactory, this.artifactFileStore, this.pomParser, this.metadataParser, this.createAuthenticationContainer(), this.moduleIdentifierFactory, this.externalResourcesFileStore, this.fileResourceRepository, this.experimentalFeatures, this.mavenMetadataFactory});
    }

    protected AuthenticationContainer createAuthenticationContainer() {
        DefaultAuthenticationContainer container = (DefaultAuthenticationContainer)this.instantiator.newInstance(DefaultAuthenticationContainer.class, new Object[]{this.instantiator});
        for (Map.Entry e : this.authenticationSchemeRegistry.getRegisteredSchemes().entrySet()) {
            container.registerBinding((Class)e.getKey(), (Class)e.getValue());
        }
        return container;
    }

    private static class NamedMavenRepositoryDescriber
    implements Transformer<String, MavenArtifactRepository> {
        private final String defaultUrl;

        private NamedMavenRepositoryDescriber(String defaultUrl) {
            this.defaultUrl = defaultUrl;
        }

        public String transform(MavenArtifactRepository repository) {
            URI url = repository.getUrl();
            if (url == null || this.defaultUrl.equals(url.toString())) {
                return repository.getName();
            }
            return repository.getName() + '(' + url + ')';
        }
    }
}

