/*
 * Decompiled with CFR 0.152.
 */
package org.grails.compiler.injection;

import grails.compiler.ast.ClassInjector;
import grails.persistence.Entity;
import groovy.transform.CompilationUnitAware;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.grails.compiler.injection.ArtefactTypeAstTransformation;
import org.grails.compiler.injection.DefaultGrailsDomainClassInjector;
import org.grails.compiler.injection.GrailsASTUtils;
import org.grails.compiler.injection.GrailsAwareInjectionOperation;
import org.grails.compiler.injection.TraitInjectionUtils;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class EntityASTTransformation
implements ASTTransformation,
CompilationUnitAware {
    private static final ClassNode MY_TYPE = new ClassNode(Entity.class);
    private static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();
    protected CompilationUnit compilationUnit;

    public void visit(ASTNode[] astNodes, SourceUnit sourceUnit) {
        if (!(astNodes[0] instanceof AnnotationNode) || !(astNodes[1] instanceof AnnotatedNode)) {
            throw new RuntimeException("Internal error: wrong types: $node.class / $parent.class");
        }
        AnnotatedNode parent = (AnnotatedNode)astNodes[1];
        AnnotationNode node = (AnnotationNode)astNodes[0];
        if (!MY_TYPE.equals((Object)node.getClassNode()) || !(parent instanceof ClassNode)) {
            return;
        }
        ClassNode cNode = (ClassNode)parent;
        String cName = cNode.getName();
        if (cNode.isInterface()) {
            throw new RuntimeException("Error processing interface '" + cName + "'. " + MY_TYPE_NAME + " not allowed for interfaces.");
        }
        this.applyTransformation(sourceUnit, cNode);
    }

    public void applyTransformation(SourceUnit sourceUnit, ClassNode classNode) {
        if (GrailsASTUtils.isApplied((ASTNode)classNode, EntityASTTransformation.class)) {
            return;
        }
        GrailsASTUtils.markApplied((ASTNode)classNode, EntityASTTransformation.class);
        DefaultGrailsDomainClassInjector domainInjector = new DefaultGrailsDomainClassInjector();
        domainInjector.performInjectionOnAnnotatedEntity(classNode);
        ClassInjector[] classInjectors = GrailsAwareInjectionOperation.getClassInjectors();
        List<ClassInjector> domainInjectors = ArtefactTypeAstTransformation.findInjectors("Domain", classInjectors);
        for (ClassInjector injector : domainInjectors) {
            try {
                injector.performInjection(sourceUnit, classNode);
            }
            catch (RuntimeException e) {
                try {
                    System.err.println("Error occurred calling AST injector [" + injector.getClass().getName() + "]: " + e.getMessage());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw e;
            }
        }
        if (this.compilationUnit != null) {
            TraitInjectionUtils.processTraitsForNode(sourceUnit, classNode, "Domain", this.compilationUnit);
        }
    }

    public void setCompilationUnit(CompilationUnit unit) {
        this.compilationUnit = unit;
    }
}

