/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.StringTokenizer;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.DF;
import javajs.util.Lst;
import javajs.util.PT;
import jspecview.common.Annotation;
import jspecview.common.Coordinate;
import jspecview.common.Integral;
import jspecview.common.IntegralComparator;
import jspecview.common.Measurement;
import jspecview.common.MeasurementData;
import jspecview.common.Parameters;
import jspecview.common.ScriptToken;
import jspecview.common.Spectrum;

public class IntegralData
extends MeasurementData {
    private static final long serialVersionUID = 1L;
    public static final double DEFAULT_OFFSET = 30.0;
    public static final double DEFAULT_RANGE = 50.0;
    public static final double DEFAULT_MINY = 0.1;
    private double percentMinY;
    private double percentOffset;
    private double intRange;
    private double normalizationFactor = 1.0;
    private double percentRange;
    private double offset;
    private double integralTotal;
    boolean haveRegions;
    private Coordinate[] xyCoords;
    private static Comparator<Measurement> c = new IntegralComparator();
    private static final String[] HEADER = new String[]{"peak", "start/ppm", "end/ppm", "value"};

    public double getPercentMinimumY() {
        return this.percentMinY;
    }

    public double getPercentOffset() {
        return this.percentOffset;
    }

    public double getIntegralFactor() {
        return this.intRange;
    }

    public IntegralData(double d, double d2, double d3, Spectrum spectrum) {
        super(Annotation.AType.Integration, spectrum);
        this.percentMinY = d;
        this.percentOffset = d2;
        this.percentRange = d3;
        this.calculateIntegral();
    }

    public IntegralData(Spectrum spectrum, Parameters parameters) {
        super(Annotation.AType.Integration, spectrum);
        if (parameters == null) {
            this.autoIntegrate();
            return;
        }
        this.percentOffset = parameters.integralOffset;
        this.percentRange = parameters.integralRange;
        this.calculateIntegral();
    }

    public void update(Parameters parameters) {
        this.update(parameters.integralMinY, parameters.integralOffset, parameters.integralRange);
    }

    public void update(double d, double d2, double d3) {
        int n;
        double d4 = this.percentRange;
        if (d3 <= 0.0 || d3 == this.percentRange && d2 == this.percentOffset) {
            return;
        }
        this.percentOffset = d2;
        this.percentRange = d3;
        this.checkRange();
        double d5 = d3 / 100.0 / this.integralTotal;
        double d6 = d2 / 100.0;
        for (n = 0; n < this.xyCoords.length; ++n) {
            double d7 = this.xyCoords[n].getYVal();
            d7 = (d7 - this.offset) / this.intRange;
            this.xyCoords[n].setYVal(d7 * d5 + d6);
        }
        if (this.normalizationFactor != 1.0) {
            this.normalizationFactor *= d4 / d3;
        }
        if (this.haveRegions) {
            n = this.size();
            while (--n >= 0) {
                Measurement measurement = (Measurement)this.get(n);
                double d8 = this.getYValueAt(measurement.getXVal());
                double d9 = this.getYValueAt(measurement.getXVal2());
                measurement.setYVal(d8);
                measurement.setYVal2(d9);
                measurement.setValue(Math.abs(d9 - d8) * 100.0 * this.normalizationFactor);
            }
        }
        this.intRange = d5;
        this.offset = d6;
    }

    double getYValueAt(double d) {
        return Coordinate.getYValueAt(this.xyCoords, d);
    }

    public Integral addIntegralRegion(double d, double d2) {
        if (Double.isNaN(d)) {
            this.haveRegions = false;
            this.clear();
            return null;
        }
        if (Double.isNaN(d2)) {
            return this.splitIntegral(d);
        }
        if (d == d2) {
            return null;
        }
        if (d < d2) {
            this.clear(d, d2);
            return null;
        }
        double d3 = this.getYValueAt(d);
        double d4 = this.getYValueAt(d2);
        this.haveRegions = true;
        Integral integral = new Integral().setInt(d, d3, this.spec, Math.abs(d4 - d3) * 100.0 * this.normalizationFactor, d2, d4);
        this.clear(d, d2);
        this.addLast(integral);
        Collections.sort(this, c);
        return integral;
    }

    private Integral splitIntegral(double d) {
        int n = this.find(d);
        if (n < 0) {
            return null;
        }
        Integral integral = (Integral)this.removeItemAt(n);
        double d2 = integral.getXVal();
        double d3 = integral.getXVal2();
        this.addIntegralRegion(d2, d);
        return this.addIntegralRegion(d, d3);
    }

    @Override
    public void setSpecShift(double d) {
        Coordinate.shiftX(this.xyCoords, d);
        int n = this.size();
        while (--n >= 1) {
            ((Measurement)this.get(n)).addSpecShift(d);
        }
    }

    public void addMarks(String string) {
        string = PT.rep(" " + string, ",", " ");
        string = PT.rep(string, " -", " #");
        string = PT.rep(string, "--", "-#");
        string = string.replace('-', '^');
        string = string.replace('#', '-');
        Lst<String> lst = ScriptToken.getTokens(string);
        for (int i = 0; i < lst.size(); ++i) {
            try {
                Integral integral;
                String string2 = (String)lst.get(i);
                double d = 0.0;
                int n = string2.indexOf(94);
                if (n < 0) continue;
                int n2 = string2.indexOf(58);
                if (n2 > n) {
                    d = Double.valueOf(string2.substring(n2 + 1).trim());
                    string2 = string2.substring(0, n2).trim();
                }
                double d2 = Double.valueOf(string2.substring(0, n).trim());
                double d3 = Double.valueOf(string2.substring(n + 1).trim());
                if (d3 == 0.0 && d2 == 0.0) {
                    this.clear();
                }
                if (d3 == d2 || (integral = this.addIntegralRegion(Math.max(d3, d2), Math.min(d3, d2))) == null || !(d > 0.0)) continue;
                this.setSelectedIntegral(integral, d);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Coordinate[] calculateIntegral() {
        Coordinate[] coordinateArray = this.spec.getXYCoords();
        this.xyCoords = new Coordinate[coordinateArray.length];
        this.integralTotal = 0.0;
        this.checkRange();
        double d = 1.0E100;
        for (int i = 0; i < coordinateArray.length; ++i) {
            double d2 = coordinateArray[i].getYVal();
            if (!(d2 < d) || !(d2 >= 0.0)) continue;
            d = d2;
        }
        double d3 = 1.0E100;
        double d4 = -1.0E100;
        for (int i = 0; i < coordinateArray.length; ++i) {
            double d5 = coordinateArray[i].getYVal();
            this.integralTotal += d5 - d;
            if (this.integralTotal < d3) {
                d3 = this.integralTotal;
            }
            if (!(this.integralTotal > d4)) continue;
            d4 = this.integralTotal;
        }
        this.integralTotal = d4 - d3;
        this.intRange = this.percentRange / 100.0 / this.integralTotal;
        this.offset = this.percentOffset / 100.0;
        double d6 = 0.0;
        int n = coordinateArray.length;
        while (--n >= 0) {
            double d7 = coordinateArray[n].getYVal();
            this.xyCoords[n] = new Coordinate().set(coordinateArray[n].getXVal(), (d6 += d7 - d) * this.intRange + this.offset);
        }
        return this.xyCoords;
    }

    private void checkRange() {
        this.percentOffset = Math.max(5.0, this.percentOffset);
        this.percentRange = Math.max(10.0, this.percentRange);
    }

    public static Lst<Annotation> getIntegrationRatiosFromString(Spectrum spectrum, String string) {
        Lst<Annotation> lst = new Lst<Annotation>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ":");
            Annotation annotation = new Annotation().setA(Double.parseDouble(stringTokenizer2.nextToken()), 0.0, spectrum, stringTokenizer2.nextToken(), true, false, 0, 0);
            lst.addLast(annotation);
        }
        return lst;
    }

    public Coordinate[] getXYCoords() {
        return this.xyCoords;
    }

    public double getPercentYValueAt(double d) {
        return this.getYValueAt(d) * 100.0;
    }

    public void dispose() {
        this.spec = null;
        this.xyCoords = null;
    }

    public void setSelectedIntegral(Measurement measurement, double d) {
        double d2 = measurement.getValue();
        double d3 = d <= 0.0 ? 1.0 / this.normalizationFactor : d / d2;
        this.factorAllIntegrals(d3, d <= 0.0);
    }

    private void factorAllIntegrals(double d, boolean bl) {
        for (int i = 0; i < this.size(); ++i) {
            Measurement measurement = (Measurement)this.get(i);
            measurement.setValue(d * measurement.getValue());
        }
        this.normalizationFactor = bl ? 1.0 : this.normalizationFactor * d;
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public Measurement remove(int n) {
        return (Measurement)this.removeItemAt(n);
    }

    public BS getBitSet() {
        BS bS = BS.newN(this.xyCoords.length);
        if (this.size() == 0) {
            bS.setBits(0, this.xyCoords.length);
            return bS;
        }
        int n = this.size();
        while (--n >= 0) {
            Measurement measurement = (Measurement)this.get(n);
            int n2 = Coordinate.getNearestIndexForX(this.xyCoords, measurement.getXVal());
            int n3 = Coordinate.getNearestIndexForX(this.xyCoords, measurement.getXVal2());
            bS.setBits(Math.min(n2, n3), Math.max(n2, n3));
        }
        return bS;
    }

    @Override
    public String[][] getMeasurementListArray(String string) {
        String[][] stringArray = new String[this.size()][];
        int n = 0;
        int n2 = this.size();
        while (--n2 >= 0) {
            stringArray[n++] = new String[]{"" + n, DF.formatDecimalDbl(((Measurement)this.get(n2)).getXVal(), 2), DF.formatDecimalDbl(((Measurement)this.get(n2)).getXVal2(), 2), ((Measurement)this.get((int)n2)).text};
        }
        return stringArray;
    }

    @Override
    public double[][] getMeasurementListArrayReal(String string) {
        double[][] dArray = AU.newDouble2(this.size());
        int n = 0;
        int n2 = this.size();
        while (--n2 >= 0) {
            dArray[n] = new double[]{((Measurement)this.get(n2)).getXVal(), ((Measurement)this.get(n2)).getXVal2(), ((Measurement)this.get(n2)).getValue()};
            ++n;
        }
        return dArray;
    }

    @Override
    public String[] getDataHeader() {
        return HEADER;
    }

    public void shiftY(int n, int n2, int n3, int n4) {
        double d = (int)(100.0 * (double)(n3 + n4 - n2) / (double)n4);
        if (n < 0) {
            d -= this.percentOffset;
        }
        if (n < 0) {
            this.update(0.0, this.percentOffset, d);
        } else {
            this.update(0.0, d, this.percentRange);
        }
    }

    public void autoIntegrate() {
        if (this.xyCoords == null) {
            this.calculateIntegral();
        }
        if (this.xyCoords.length == 0) {
            return;
        }
        this.clear();
        int n = -1;
        double d = 1.0E-4;
        int n2 = 0;
        int n3 = 20;
        double d2 = this.xyCoords[this.xyCoords.length - 1].getYVal();
        int n4 = this.xyCoords.length - 1;
        while (--n4 >= 0) {
            double d3 = this.xyCoords[n4].getYVal();
            ++n2;
            if (d3 - d2 < d && n < 0) {
                if (!(d3 < d2)) continue;
                d2 = d3;
                n2 = 0;
                continue;
            }
            if (n < 0) {
                n = n4 + Math.min(n2, n3);
                d2 = d3;
                n2 = 0;
                continue;
            }
            if (d3 - d2 < d) {
                if (n2 == 1) {
                    d2 = d3;
                }
                if (n2 < n3) continue;
                this.addIntegralRegion(this.xyCoords[n].getXVal(), this.xyCoords[n4].getXVal());
                n = -1;
                d2 = d3;
                n2 = 0;
                continue;
            }
            n2 = 0;
            d2 = d3;
        }
        if (this.spec.nH > 0) {
            this.factorAllIntegrals((double)this.spec.nH / this.percentRange, false);
        }
    }

    @Override
    public void getInfo(Map<String, Object> map) {
        map.put("offset", this.myParams.integralOffset);
        map.put("range", this.myParams.integralRange);
        map.put("normalizationFactor", this.normalizationFactor);
        map.put("integralTotal", this.integralTotal);
        super.getInfo(map);
    }

    public void setMinimumIntegral(double d) {
        int n = this.size();
        while (--n >= 0) {
            if (!(((Measurement)this.get(n)).getValue() < d)) continue;
            this.removeItemAt(n);
        }
    }

    public static enum IntMode {
        OFF,
        ON,
        TOGGLE,
        AUTO,
        LIST,
        MARK,
        MIN,
        UPDATE,
        CLEAR,
        NA;


        static IntMode getMode(String string) {
            for (IntMode intMode : IntMode.values()) {
                if (!string.startsWith(intMode.name())) continue;
                return intMode;
            }
            return NA;
        }
    }
}

