/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.MessagePackReader;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.adapter.readers.cif.MMCifReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.Structure;
import org.jmol.java.BS;
import org.jmol.script.SV;
import org.jmol.util.Logger;

public class MMTFReader
extends MMCifReader {
    private boolean haveStructure;
    private String pdbID;
    private Map<String, Object> map;
    private int fileAtomCount;
    private int opCount = 0;
    private int[] groupModels;
    private int[] groupMap;
    private int[] groupDSSP;
    private int[] atomGroup;
    private String[] labelAsymList;
    private Atom[] atomMap;
    private Object[] entities;
    private int groupCount;
    private int ac0;
    private BS[] bsStructures;
    private int lastGroup;

    @Override
    protected void addHeader() {
    }

    @Override
    protected void setup(String fullPath, Map<String, Object> htParams, Object reader) {
        this.isBinary = true;
        this.isMMCIF = true;
        this.iHaveFractionalCoordinates = false;
        this.setupASCR(fullPath, htParams, reader);
    }

    @Override
    protected void processBinaryDocument() throws Exception {
        boolean doDoubleBonds = !this.isCourseGrained && !this.checkFilterKey("NODOUBLE");
        this.isDSSP1 = !this.checkFilterKey("DSSP2");
        boolean mmtfImplementsDSSP2 = false;
        this.applySymmetryToBonds = true;
        this.map = new MessagePackReader(this.binaryDoc, true).readMap();
        this.entities = (Object[])this.map.get("entityList");
        if (Logger.debugging) {
            for (String s : this.map.keySet()) {
                Logger.info(s);
            }
        }
        this.asc.setInfo("noAutoBond", Boolean.TRUE);
        Logger.info("MMTF version " + this.map.get("mmtfVersion"));
        Logger.info("MMTF Producer " + this.map.get("mmtfProducer"));
        String title = (String)this.map.get("title");
        if (title != null) {
            this.appendLoadNote(title);
        }
        this.pdbID = (String)this.map.get("structureId");
        if (this.pdbID == null) {
            this.pdbID = (String)this.map.get("pdbId");
        }
        this.fileAtomCount = (Integer)this.map.get("numAtoms");
        int nBonds = (Integer)this.map.get("numBonds");
        this.groupCount = (Integer)this.map.get("numGroups");
        this.groupModels = new int[this.groupCount];
        this.groupDSSP = new int[this.groupCount];
        this.groupMap = new int[this.groupCount];
        int modelCount = (Integer)this.map.get("numModels");
        this.appendLoadNote("id=" + this.pdbID + " numAtoms=" + this.fileAtomCount + " numBonds=" + nBonds + " numGroups=" + this.groupCount + " numModels=" + modelCount);
        this.getMMTFAtoms(doDoubleBonds);
        if (!this.isCourseGrained) {
            int[] bo = (int[])this.decode("bondOrderList");
            int[] bi = (int[])this.decode("bondAtomList");
            this.addMMTFBonds(bo, bi, 0, doDoubleBonds, true);
            if (this.isDSSP1 || mmtfImplementsDSSP2) {
                this.getStructure();
            }
        }
        this.setMMTFSymmetry();
        this.getMMTFBioAssembly();
        this.setModelPDB(true);
        if (Logger.debuggingHigh) {
            Logger.info(SV.getVariable(this.map).asString());
        }
    }

    @Override
    public void applySymmetryAndSetTrajectory() throws Exception {
        this.ac0 = this.ac;
        super.applySymmetryAndSetTrajectory();
        if (this.haveStructure) {
            this.addStructureSymmetry();
        }
    }

    private void getMMTFAtoms(boolean doMulti) throws Exception {
        int[] chainsPerModel = (int[])this.map.get("chainsPerModel");
        int[] groupsPerChain = (int[])this.map.get("groupsPerChain");
        this.labelAsymList = (String[])this.decode("chainIdList");
        String[] authAsymList = (String[])this.decode("chainNameList");
        int[] groupTypeList = (int[])this.decode("groupTypeList");
        int[] groupIdList = (int[])this.decode("groupIdList");
        Object[] groupList = (Object[])this.map.get("groupList");
        char[] insCodes = (char[])this.decode("insCodeList");
        int[] atomId = (int[])this.decode("atomIdList");
        boolean haveSerial = atomId != null;
        char[] altloc = (char[])this.decode("altLocList");
        float[] occ = (float[])this.decode("occupancyList");
        float[] x = (float[])this.decode("xCoordList");
        float[] y = (float[])this.decode("yCoordList");
        float[] z = (float[])this.decode("zCoordList");
        float[] bf = (float[])this.decode("bFactorList");
        String[] nameList = this.useAuthorChainID ? authAsymList : this.labelAsymList;
        int iModel = -1;
        int iChain = 0;
        int nChain = 0;
        int iGroup = 0;
        int nGroup = 0;
        int chainpt = 0;
        int seqNo = 0;
        int iatom = 0;
        String chainID = "";
        String authAsym = "";
        String labelAsym = "";
        char insCode = '\u0000';
        this.atomMap = new Atom[this.fileAtomCount];
        this.atomGroup = new int[this.fileAtomCount];
        int thisGroup = -1;
        for (int j = 0; j < this.groupCount; ++j) {
            if (++iGroup >= nGroup) {
                chainID = nameList[chainpt];
                authAsym = authAsymList[chainpt];
                labelAsym = this.labelAsymList[chainpt];
                nGroup = groupsPerChain[chainpt++];
                iGroup = 0;
                if (++iChain >= nChain) {
                    this.groupModels[j] = ++iModel;
                    nChain = chainsPerModel[iModel];
                    iChain = 0;
                    this.setModelPDB(true);
                    this.incrementModel(iModel + 1);
                    this.asc.setCurrentModelInfo("pdbID", this.pdbID);
                    this.nAtoms0 = this.asc.ac;
                    if (this.done) {
                        return;
                    }
                }
            }
            Map g = (Map)groupList[groupTypeList[j]];
            String[] atomNameList = (String[])g.get("atomNameList");
            int len = atomNameList.length;
            if (this.skipping) {
                iatom += len;
                continue;
            }
            int a0 = iatom;
            if (insCodes != null) {
                insCode = insCodes[j];
            }
            seqNo = groupIdList[j];
            String group3 = (String)g.get("groupName");
            boolean isHetero = this.vwr.getJBR().isHetero(group3);
            if (isHetero) {
                String hetName = "" + g.get("chemCompType");
                if (this.htHetero == null || !this.htHetero.containsKey(group3)) {
                    if (this.entities != null && hetName.equals("NON-POLYMER")) {
                        int i = this.entities.length;
                        block1: while (--i >= 0) {
                            Map entity = (Map)this.entities[i];
                            int[] chainList = (int[])entity.get("chainIndexList");
                            int k = chainList.length;
                            while (--k >= 0) {
                                if (chainList[k] != iChain) continue;
                                hetName = "a component of the entity \"" + entity.get("description") + "\"";
                                break block1;
                            }
                        }
                    }
                    this.addHetero(group3, hetName, false, true);
                }
            }
            String[] elementList = (String[])g.get("elementList");
            boolean haveAtom = false;
            int ia = 0;
            int pt = 0;
            while (ia < len) {
                Atom a = new Atom();
                a.isHetero = isHetero;
                if (insCode != '\u0000') {
                    a.insertionCode = insCode;
                }
                this.setAtomCoordXYZ(a, x[iatom], y[iatom], z[iatom]);
                a.elementSymbol = elementList[pt];
                a.atomName = atomNameList[pt++];
                if (seqNo >= 0) {
                    a.sequenceNumber = seqNo;
                    this.maxSerial = Math.max(this.maxSerial, a.sequenceNumber);
                }
                a.group3 = group3;
                this.setChainID(a, chainID);
                if (bf != null) {
                    a.bfactor = bf[iatom];
                }
                if (altloc != null) {
                    a.altLoc = altloc[iatom];
                }
                if (occ != null) {
                    a.foccupancy = occ[iatom];
                }
                if (haveSerial) {
                    a.atomSerial = atomId[iatom];
                }
                if (this.filterAtom(a, -1) && this.processSubclassAtom(a, labelAsym, authAsym)) {
                    if (!haveAtom) {
                        ++thisGroup;
                        haveAtom = true;
                    }
                    if (haveSerial) {
                        this.asc.addAtomWithMappedSerialNumber(a);
                    } else {
                        this.asc.addAtom(a);
                    }
                    this.atomMap[iatom] = a;
                    this.atomGroup[this.ac] = j;
                    this.groupMap[j] = this.lastGroup = thisGroup;
                    ++this.ac;
                }
                ++ia;
                ++iatom;
            }
            if (this.isCourseGrained) continue;
            int[] bo = (int[])g.get("bondOrderList");
            int[] bi = (int[])g.get("bondAtomList");
            this.addMMTFBonds(bo, bi, a0, doMulti, false);
        }
        this.asc.setCurrentModelInfo("pdbID", this.pdbID);
    }

    private void addMMTFBonds(int[] bo, int[] bi, int a0, boolean doMulti, boolean isInter) {
        if (bi == null) {
            return;
        }
        doMulti &= bo != null;
        int pt = 0;
        int nj = bi.length / 2;
        for (int bj = 0; bj < nj; ++bj) {
            Atom a1 = this.atomMap[bi[pt++] + a0];
            Atom a2 = this.atomMap[bi[pt++] + a0];
            if (a1 == null || a2 == null) continue;
            Bond bond = new Bond(a1.index, a2.index, doMulti ? bo[bj] : 1);
            this.asc.addBond(bond);
            if (!Logger.debugging || !isInter) continue;
            Logger.info("inter-group (" + (a1.atomSetIndex + 1) + "." + a1.index + "/" + (a2.atomSetIndex + 1) + "." + a2.index + ") bond " + a1.group3 + a1.sequenceNumber + "." + a1.atomName + " - " + a2.group3 + a2.sequenceNumber + "." + a2.atomName + " " + bond.order);
        }
    }

    private void setMMTFSymmetry() {
        this.setSpaceGroupName((String)this.map.get("spaceGroup"));
        float[] o = (float[])this.map.get("unitCell");
        if (o != null) {
            for (int i = 0; i < 6; ++i) {
                this.setUnitCellItem(i, o[i]);
            }
        }
    }

    private void getMMTFBioAssembly() {
        Object[] o = (Object[])this.map.get("bioAssemblyList");
        if (o == null) {
            return;
        }
        if (this.vBiomolecules == null) {
            this.vBiomolecules = new Lst();
        }
        int i = o.length;
        while (--i >= 0) {
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            this.vBiomolecules.addLast(info);
            int iMolecule = i + 1;
            this.checkFilterAssembly("" + iMolecule, info);
            info.put("name", "biomolecule " + iMolecule);
            info.put("molecule", iMolecule);
            Lst<String> assemb = new Lst<String>();
            Lst<String> ops = new Lst<String>();
            info.put("biomts", new Lst());
            info.put("chains", new Lst());
            info.put("assemblies", assemb);
            info.put("operators", ops);
            Map m = (Map)o[i];
            Object[] tlist = (Object[])m.get("transformList");
            SB chlist = new SB();
            int n = tlist.length;
            for (int j = 0; j < n; ++j) {
                Map t = (Map)tlist[j];
                chlist.setLength(0);
                int[] chainList = (int[])t.get("chainIndexList");
                int kn = chainList.length;
                for (int k = 0; k < kn; ++k) {
                    chlist.append("$").append(this.labelAsymList[chainList[k]]);
                }
                assemb.addLast(chlist.append("$").toString());
                String id = "" + ++this.opCount;
                this.addMatrix(id, M4.newA16((float[])t.get("matrix")), false);
                ops.addLast(id);
            }
        }
    }

    private void getStructure() {
        int n;
        int[] a = (int[])this.decode("secStructList");
        if (Logger.debugging) {
            Logger.info(PT.toJSON("secStructList", a));
        }
        this.bsStructures = new BS[]{new BS(), null, new BS(), new BS(), new BS(), null, new BS()};
        int lastGroup = -1;
        for (int j = 0; j < a.length; ++j) {
            int type = a[j];
            switch (type) {
                case 0: 
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    int igroup = this.groupMap[j];
                    this.bsStructures[type].set(igroup);
                    this.groupDSSP[igroup] = type + 1;
                    lastGroup = j;
                }
            }
        }
        int n2 = n = this.isDSSP1 ? this.asc.iSet : this.groupModels[lastGroup];
        if (lastGroup >= 0) {
            this.haveStructure = true;
            this.asc.addStructure(new Structure(n, null, null, null, 0, 0, this.bsStructures));
        }
    }

    private void addStructureSymmetry() {
        if (this.asc.ac == 0) {
            return;
        }
        Atom[] atoms = this.asc.atoms;
        BS bsAtoms = this.asc.bsAtoms;
        int ptGroup = this.lastGroup;
        int mygroup = -1;
        int n = this.asc.ac;
        for (int i = this.ac0; i < n; ++i) {
            int dssp;
            if (bsAtoms != null && !bsAtoms.get(i)) continue;
            Atom a = atoms[i];
            int igroup = this.atomGroup[a.atomSite];
            if (igroup != mygroup) {
                mygroup = igroup;
                ++ptGroup;
            }
            if ((dssp = this.groupDSSP[igroup]) <= 0) continue;
            this.bsStructures[dssp - 1].set(ptGroup);
        }
    }

    private Object decode(String key) {
        return MessagePackReader.decode((byte[])this.map.get(key));
    }
}

