/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javajs.J2SIgnoreImport;
import javajs.api.GenericZipInputStream;
import javajs.api.GenericZipTools;
import javajs.api.Interface;
import javajs.api.ZInputStream;
import javajs.util.BArray;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.Rdr;
import javajs.util.SB;
import org.apache.tools.bzip2.CBZip2InputStreamFactory;

@J2SIgnoreImport(value={ZipOutputStream.class})
public class ZipTools
implements GenericZipTools {
    @Override
    public ZInputStream newZipInputStream(InputStream is) {
        return ZipTools.newZIS(is);
    }

    private static ZInputStream newZIS(InputStream is) {
        return is instanceof ZInputStream ? (ZInputStream)((Object)is) : (is instanceof BufferedInputStream ? new GenericZipInputStream(is) : new GenericZipInputStream(new BufferedInputStream(is)));
    }

    @Override
    public void getAllZipData(InputStream is, String[] subfileList, String name0, String binaryFileList, String exclude, Map<String, String> fileData) {
        ZipInputStream zis = (ZipInputStream)((Object)ZipTools.newZIS(is));
        SB listing = new SB();
        binaryFileList = "|" + binaryFileList + "|";
        String prefix = PT.join(subfileList, '/', 1);
        String prefixd = null;
        if (prefix != null && (prefixd = prefix.substring(0, prefix.indexOf("/") + 1)).length() == 0) {
            prefixd = null;
        }
        try {
            ZipEntry ze;
            while ((ze = zis.getNextEntry()) != null) {
                String str;
                String name = ze.getName();
                if (prefix != null && prefixd != null && !name.equals(prefix) && !name.startsWith(prefixd) || exclude != null && name.contains(exclude)) continue;
                listing.append(name).appendC('\n');
                String sname = "|" + name.substring(name.lastIndexOf("/") + 1) + "|";
                boolean asBinaryString = binaryFileList.indexOf(sname) >= 0;
                byte[] bytes = Rdr.getLimitedStreamBytes(zis, ze.getSize());
                if (asBinaryString) {
                    str = this.getBinaryStringForBytes(bytes);
                    name = name + ":asBinaryString";
                } else {
                    str = Rdr.fixUTF(bytes);
                }
                str = "BEGIN Directory Entry " + name + "\n" + str + "\nEND Directory Entry " + name + "\n";
                String key = name0 + "|" + name;
                fileData.put(key, str);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        fileData.put("#Directory_Listing", listing.toString());
    }

    private String getBinaryStringForBytes(byte[] bytes) {
        SB ret = new SB();
        for (int i = 0; i < bytes.length; ++i) {
            ret.append(Integer.toHexString(bytes[i] & 0xFF)).appendC(' ');
        }
        return ret.toString();
    }

    @Override
    public Object getZipFileDirectory(BufferedInputStream bis, String[] list, int listPtr, boolean asBufferedInputStream) {
        if (list == null || listPtr >= list.length) {
            return this.getZipDirectoryAsStringAndClose(bis);
        }
        bis = Rdr.getPngZipStream(bis, true);
        String fileName = list[listPtr];
        ZipInputStream zis = new ZipInputStream(bis);
        try {
            ZipEntry ze;
            boolean asBinaryString;
            boolean isAll = fileName.equals(".");
            if (isAll || fileName.lastIndexOf("/") == fileName.length() - 1) {
                ZipEntry ze2;
                SB ret = new SB();
                while ((ze2 = zis.getNextEntry()) != null) {
                    String name = ze2.getName();
                    if (!isAll && !name.startsWith(fileName)) continue;
                    ret.append(name).appendC('\n');
                }
                String str = ret.toString();
                return asBufferedInputStream ? Rdr.getBIS(str.getBytes()) : str;
            }
            int pt = fileName.indexOf(":asBinaryString");
            boolean bl = asBinaryString = pt > 0;
            if (asBinaryString) {
                fileName = fileName.substring(0, pt);
            }
            fileName = fileName.replace('\\', '/');
            while ((ze = zis.getNextEntry()) != null && !fileName.equals(ze.getName())) {
            }
            byte[] bytes = ze == null ? null : Rdr.getLimitedStreamBytes(zis, ze.getSize());
            ze = null;
            zis.close();
            if (bytes == null) {
                return "";
            }
            if (Rdr.isZipB(bytes) || Rdr.isPngZipB(bytes)) {
                return this.getZipFileDirectory(Rdr.getBIS(bytes), list, ++listPtr, asBufferedInputStream);
            }
            if (asBufferedInputStream) {
                return Rdr.getBIS(bytes);
            }
            if (asBinaryString) {
                SB ret = new SB();
                for (int i = 0; i < bytes.length; ++i) {
                    ret.append(Integer.toHexString(bytes[i] & 0xFF)).appendC(' ');
                }
                return ret.toString();
            }
            if (Rdr.isGzipB(bytes)) {
                bytes = Rdr.getLimitedStreamBytes(this.getUnGzippedInputStream(bytes), -1L);
            }
            return Rdr.fixUTF(bytes);
        }
        catch (Exception e) {
            return "";
        }
    }

    public byte[] getZipFileContentsAsBytes(BufferedInputStream bis, String[] list, int listPtr) {
        byte[] ret = new byte[]{};
        String fileName = list[listPtr];
        if (fileName.lastIndexOf("/") == fileName.length() - 1) {
            return ret;
        }
        try {
            ZipEntry ze;
            bis = Rdr.getPngZipStream(bis, true);
            ZipInputStream zis = new ZipInputStream(bis);
            while ((ze = zis.getNextEntry()) != null) {
                if (!fileName.equals(ze.getName())) continue;
                byte[] bytes = Rdr.getLimitedStreamBytes(zis, ze.getSize());
                return (Rdr.isZipB(bytes) || Rdr.isPngZipB(bytes)) && ++listPtr < list.length ? this.getZipFileContentsAsBytes(Rdr.getBIS(bytes), list, listPtr) : bytes;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public String getZipDirectoryAsStringAndClose(BufferedInputStream bis) {
        SB sb = new SB();
        String[] s = new String[]{};
        try {
            s = this.getZipDirectoryOrErrorAndClose(bis, null);
            bis.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        for (int i = 0; i < s.length; ++i) {
            sb.append(s[i]).appendC('\n');
        }
        return sb.toString();
    }

    @Override
    public String[] getZipDirectoryAndClose(BufferedInputStream bis, String manifestID) {
        String[] s = new String[]{};
        try {
            s = this.getZipDirectoryOrErrorAndClose(bis, manifestID);
            bis.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        return s;
    }

    private String[] getZipDirectoryOrErrorAndClose(BufferedInputStream bis, String manifestID) throws IOException {
        ZipEntry ze;
        bis = Rdr.getPngZipStream(bis, true);
        Lst<String> v = new Lst<String>();
        ZipInputStream zis = new ZipInputStream(bis);
        String manifest = null;
        while ((ze = zis.getNextEntry()) != null) {
            String fileName = ze.getName();
            if (manifestID != null && fileName.startsWith(manifestID)) {
                manifest = ZipTools.getStreamAsString(zis);
                continue;
            }
            if (fileName.startsWith("__MACOS")) continue;
            v.addLast(fileName);
        }
        zis.close();
        if (manifestID != null) {
            v.add(0, manifest == null ? "" : manifest + "\n############\n");
        }
        return v.toArray(new String[v.size()]);
    }

    public static String getStreamAsString(InputStream is) throws IOException {
        return Rdr.fixUTF(Rdr.getLimitedStreamBytes(is, -1L));
    }

    @Override
    public InputStream newGZIPInputStream(InputStream is) throws IOException {
        return new BufferedInputStream(new GZIPInputStream(is, 512));
    }

    @Override
    public InputStream newBZip2InputStream(InputStream is) throws IOException {
        return new BufferedInputStream(((CBZip2InputStreamFactory)Interface.getInterface("org.apache.tools.bzip2.CBZip2InputStreamFactory")).getStream(is));
    }

    @Override
    public BufferedInputStream getUnGzippedInputStream(byte[] bytes) {
        try {
            return Rdr.getUnzippedInputStream(this, Rdr.getBIS(bytes));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void addZipEntry(Object zos, String fileName) throws IOException {
        ((ZipOutputStream)zos).putNextEntry(new ZipEntry(fileName));
    }

    @Override
    public void closeZipEntry(Object zos) throws IOException {
        ((ZipOutputStream)zos).closeEntry();
    }

    @Override
    public Object getZipOutputStream(Object bos) {
        return new ZipOutputStream((OutputStream)bos);
    }

    @Override
    public int getCrcValue(byte[] bytes) {
        CRC32 crc = new CRC32();
        crc.update(bytes, 0, bytes.length);
        return (int)crc.getValue();
    }

    @Override
    public void readFileAsMap(BufferedInputStream bis, Map<String, Object> bdata, String name) {
        int pt = name == null ? -1 : name.indexOf("|");
        name = pt >= 0 ? name.substring(pt + 1) : null;
        byte[] bytes = null;
        try {
            if (Rdr.isPngZipStream(bis)) {
                boolean isImage = "_IMAGE_".equals(name);
                if (name == null || isImage) {
                    bytes = ZipTools.getPngImageBytes(bis);
                    bdata.put(isImage ? "_DATA_" : "_IMAGE_", new BArray(bytes));
                }
                if (!isImage) {
                    this.cacheZipContents(bis, name, bdata, true);
                }
            } else if (Rdr.isZipS(bis)) {
                this.cacheZipContents(bis, name, bdata, true);
            } else if (name == null) {
                bytes = Rdr.getLimitedStreamBytes(Rdr.getUnzippedInputStream(this, bis), -1L);
                bdata.put("_DATA_", new BArray(bytes));
            } else {
                throw new IOException("ZIP file " + name + " not found");
            }
            if (bytes != null) {
                bdata.put("_LEN_", bytes.length);
            }
            bdata.put("$_BINARY_$", Boolean.TRUE);
        }
        catch (IOException e) {
            bdata.clear();
            bdata.put("_ERROR_", e.getMessage());
        }
    }

    @Override
    public String cacheZipContents(BufferedInputStream bis, String fileName, Map<String, Object> cache, boolean asByteArray) {
        String file0;
        ZipInputStream zis = (ZipInputStream)((Object)ZipTools.newZIS(bis));
        SB listing = new SB();
        long n = 0L;
        boolean oneFile = asByteArray && fileName != null;
        int pt = oneFile ? fileName.indexOf("|") : -1;
        String string = file0 = pt >= 0 ? fileName : null;
        if (pt >= 0) {
            fileName = fileName.substring(0, pt);
        }
        try {
            ZipEntry ze;
            while ((ze = zis.getNextEntry()) != null) {
                Object o;
                Object object;
                String name = ze.getName();
                if (fileName != null) {
                    if (oneFile) {
                        if (!name.equalsIgnoreCase(fileName)) {
                            continue;
                        }
                    } else {
                        listing.append(name).appendC('\n');
                    }
                }
                long nBytes = ze.getSize();
                byte[] bytes = Rdr.getLimitedStreamBytes(zis, nBytes);
                if (file0 != null) {
                    this.readFileAsMap(Rdr.getBIS(bytes), cache, file0);
                    return null;
                }
                n += (long)bytes.length;
                if (asByteArray) {
                    BArray bArray;
                    object = bArray;
                    bArray = new BArray(bytes);
                } else {
                    object = o = bytes;
                }
                cache.put(oneFile ? "_DATA_" : (fileName == null ? "" : fileName + "|") + name, o);
                if (!oneFile) continue;
                break;
            }
            zis.close();
        }
        catch (Exception e) {
            try {
                zis.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
            return null;
        }
        if (n == 0L || fileName == null) {
            return null;
        }
        System.out.println("ZipTools cached " + n + " bytes from " + fileName);
        return listing.toString();
    }

    private static byte[] getPngImageBytes(BufferedInputStream bis) {
        try {
            if (Rdr.isPngZipStream(bis)) {
                int[] pt_count = new int[2];
                Rdr.getPngZipPointAndCount(bis, pt_count);
                if (pt_count[1] != 0) {
                    return ZipTools.deActivatePngZipB(Rdr.getLimitedStreamBytes(bis, pt_count[0]));
                }
            }
            return Rdr.getLimitedStreamBytes(bis, -1L);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static byte[] deActivatePngZipB(byte[] bytes) {
        if (Rdr.isPngZipB(bytes)) {
            bytes[51] = 32;
        }
        return bytes;
    }
}

