/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericBinaryDocumentReader;
import javajs.util.BC;
import javajs.util.SB;

public class MessagePackReader {
    private GenericBinaryDocumentReader doc;
    private boolean isHomo;
    private static final int POSITIVEFIXINT_x80 = 128;
    private static final int FIXMAP_xF0 = 128;
    private static final int FIXSTR_xE0 = 160;
    private static final int NEGATIVEFIXINT_xE0 = 224;
    private static final int DEFINITE_xE0 = 192;
    private static final int NIL = 192;
    private static final int FALSE = 194;
    private static final int TRUE = 195;
    private static final int BIN8 = 196;
    private static final int BIN16 = 197;
    private static final int BIN32 = 198;
    private static final int EXT8 = 199;
    private static final int EXT16 = 200;
    private static final int EXT32 = 201;
    private static final int FLOAT32 = 202;
    private static final int FLOAT64 = 203;
    private static final int UINT8 = 204;
    private static final int UINT16 = 205;
    private static final int UINT32 = 206;
    private static final int UINT64 = 207;
    private static final int INT8 = 208;
    private static final int INT16 = 209;
    private static final int INT32 = 210;
    private static final int INT64 = 211;
    private static final int FIXEXT1 = 212;
    private static final int FIXEXT2 = 213;
    private static final int FIXEXT4 = 214;
    private static final int FIXEXT8 = 215;
    private static final int FIXEXT16 = 216;
    private static final int STR8 = 217;
    private static final int STR16 = 218;
    private static final int STR32 = 219;
    private static final int ARRAY16 = 220;
    private static final int ARRAY32 = 221;
    private static final int MAP16 = 222;
    private static final int MAP32 = 223;

    public MessagePackReader(GenericBinaryDocumentReader genericBinaryDocumentReader, boolean bl) {
        this.isHomo = bl;
        this.doc = genericBinaryDocumentReader;
    }

    public Map<String, Object> readMap() throws Exception {
        return (Map)this.getNext(null, 0);
    }

    public Object getNext(Object object, int n) throws Exception {
        int n2 = this.doc.readByte() & 0xFF;
        int n3 = n2 & 0xE0;
        if ((n2 & 0x80) == 0) {
            if (object != null) {
                ((int[])object)[n] = n2;
                return null;
            }
            return n2;
        }
        block0 : switch (n3) {
            case 224: {
                n2 = BC.intToSignedInt(n2 | 0xFFFFFF00);
                if (object != null) {
                    ((int[])object)[n] = n2;
                    return null;
                }
                return n2;
            }
            case 160: {
                String string = this.doc.readString(n2 & 0x1F);
                if (object != null) {
                    ((String[])object)[n] = string;
                    return null;
                }
                return string;
            }
            case 128: {
                return (n2 & 0xF0) == 128 ? this.getMap(n2 & 0xF) : this.getArray(n2 & 0xF);
            }
            case 192: {
                switch (n2) {
                    case 192: {
                        return null;
                    }
                    case 194: {
                        return Boolean.FALSE;
                    }
                    case 195: {
                        return Boolean.TRUE;
                    }
                    case 199: {
                        return this.getObject(this.doc.readUInt8());
                    }
                    case 200: {
                        return this.getObject(this.doc.readUnsignedShort());
                    }
                    case 201: {
                        return this.getObject(this.doc.readInt());
                    }
                    case 212: {
                        return this.getObject(1);
                    }
                    case 213: {
                        return this.getObject(2);
                    }
                    case 214: {
                        return this.getObject(4);
                    }
                    case 215: {
                        return this.getObject(8);
                    }
                    case 216: {
                        return this.getObject(16);
                    }
                    case 220: {
                        return this.getArray(this.doc.readUnsignedShort());
                    }
                    case 221: {
                        return this.getArray(this.doc.readInt());
                    }
                    case 222: {
                        return this.getMap(this.doc.readUnsignedShort());
                    }
                    case 223: {
                        return this.getMap(this.doc.readInt());
                    }
                    case 196: {
                        return this.doc.readBytes(this.doc.readUInt8());
                    }
                    case 197: {
                        return this.doc.readBytes(this.doc.readUnsignedShort());
                    }
                    case 198: {
                        return this.doc.readBytes(this.doc.readInt());
                    }
                }
                if (object == null) {
                    switch (n2) {
                        case 202: {
                            return Float.valueOf(this.doc.readFloat());
                        }
                        case 203: {
                            return Float.valueOf((float)this.doc.readDouble());
                        }
                        case 204: {
                            return this.doc.readUInt8();
                        }
                        case 205: {
                            return this.doc.readUnsignedShort();
                        }
                        case 206: {
                            return this.doc.readInt();
                        }
                        case 207: {
                            return this.doc.readLong();
                        }
                        case 208: {
                            return (int)this.doc.readByte();
                        }
                        case 209: {
                            return (int)this.doc.readShort();
                        }
                        case 210: {
                            return this.doc.readInt();
                        }
                        case 211: {
                            return this.doc.readLong();
                        }
                        case 217: {
                            return this.doc.readString(this.doc.readUInt8());
                        }
                        case 218: {
                            return this.doc.readString(this.doc.readShort());
                        }
                        case 219: {
                            return this.doc.readString(this.doc.readInt());
                        }
                    }
                    break;
                }
                switch (n2) {
                    case 202: {
                        ((float[])object)[n] = this.doc.readFloat();
                        break block0;
                    }
                    case 203: {
                        ((float[])object)[n] = (float)this.doc.readDouble();
                        break block0;
                    }
                    case 204: {
                        ((int[])object)[n] = this.doc.readUInt8();
                        break block0;
                    }
                    case 205: {
                        ((int[])object)[n] = this.doc.readUnsignedShort();
                        break block0;
                    }
                    case 206: {
                        ((int[])object)[n] = this.doc.readInt();
                        break block0;
                    }
                    case 207: {
                        ((int[])object)[n] = (int)this.doc.readLong();
                        break block0;
                    }
                    case 208: {
                        ((int[])object)[n] = this.doc.readByte();
                        break block0;
                    }
                    case 209: {
                        ((int[])object)[n] = this.doc.readShort();
                        break block0;
                    }
                    case 210: {
                        ((int[])object)[n] = this.doc.readInt();
                        break block0;
                    }
                    case 211: {
                        ((int[])object)[n] = (int)this.doc.readLong();
                        break block0;
                    }
                    case 217: {
                        ((String[])object)[n] = this.doc.readString(this.doc.readUInt8());
                        break block0;
                    }
                    case 218: {
                        ((String[])object)[n] = this.doc.readString(this.doc.readShort());
                        break block0;
                    }
                    case 219: {
                        ((String[])object)[n] = this.doc.readString(this.doc.readInt());
                    }
                }
            }
        }
        return null;
    }

    private Object getObject(int n) throws Exception {
        return new Object[]{this.doc.readUInt8(), this.doc.readBytes(n)};
    }

    private Object getArray(int n) throws Exception {
        if (this.isHomo) {
            Object[] objectArray;
            if (n == 0) {
                return null;
            }
            Object object = this.getNext(null, 0);
            if (object instanceof Integer) {
                objectArray = new int[n];
                objectArray[0] = (Integer)object;
                object = objectArray;
            } else if (object instanceof Float) {
                objectArray = new float[n];
                objectArray[0] = (int)((Float)object).floatValue();
                object = objectArray;
            } else if (object instanceof String) {
                objectArray = new String[n];
                objectArray[0] = (int)((String)object);
                object = objectArray;
            } else {
                Object[] objectArray2 = new Object[n];
                objectArray2[0] = object;
                for (int i = 1; i < n; ++i) {
                    objectArray2[i] = this.getNext(null, 0);
                }
                return objectArray2;
            }
            for (int i = 1; i < n; ++i) {
                this.getNext(object, i);
            }
            return object;
        }
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.getNext(null, 0);
        }
        return objectArray;
    }

    private Object getMap(int n) throws Exception {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        for (int i = 0; i < n; ++i) {
            String string = this.getNext(null, 0).toString();
            Object object = this.getNext(null, 0);
            if (object == null) continue;
            hashtable.put(string, object);
        }
        return hashtable;
    }

    public static Object decode(byte[] byArray) {
        int n = BC.bytesToInt(byArray, 0, true);
        int n2 = BC.bytesToInt(byArray, 4, true);
        int n3 = BC.bytesToInt(byArray, 8, true);
        switch (n) {
            case 1: {
                return MessagePackReader.getFloats(byArray, n2, 1.0f);
            }
            case 2: 
            case 3: 
            case 4: {
                return MessagePackReader.getInts(byArray, n2);
            }
            case 5: {
                return MessagePackReader.rldecode32ToStr(byArray);
            }
            case 6: {
                return MessagePackReader.rldecode32ToChar(byArray, n2);
            }
            case 7: {
                return MessagePackReader.rldecode32(byArray, n2);
            }
            case 8: {
                return MessagePackReader.rldecode32Delta(byArray, n2);
            }
            case 9: {
                return MessagePackReader.rldecodef(byArray, n2, n3);
            }
            case 10: {
                return MessagePackReader.unpack16Deltaf(byArray, n2, n3);
            }
            case 11: {
                return MessagePackReader.getFloats(byArray, n2, n3);
            }
            case 12: 
            case 13: {
                return MessagePackReader.unpackf(byArray, 14 - n, n2, n3);
            }
            case 14: 
            case 15: {
                return MessagePackReader.unpack(byArray, 16 - n, n2);
            }
        }
        System.out.println("MMTF type " + n + " not found!");
        return null;
    }

    public static float[] getFloats(byte[] byArray, int n, float f) {
        if (byArray == null) {
            return null;
        }
        float[] fArray = new float[n];
        try {
            switch ((byArray.length - 12) / n) {
                case 2: {
                    int n2 = 0;
                    int n3 = 12;
                    while (n2 < n) {
                        fArray[n2] = (float)BC.bytesToShort(byArray, n3, false) / f;
                        ++n2;
                        n3 += 2;
                    }
                    break;
                }
                case 4: {
                    int n4 = 0;
                    int n5 = 12;
                    while (n4 < n) {
                        fArray[n4] = BC.bytesToFloat(byArray, n5, false);
                        ++n4;
                        n5 += 4;
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fArray;
    }

    public static int[] getInts(byte[] byArray, int n) {
        if (byArray == null) {
            return null;
        }
        int[] nArray = new int[n];
        switch ((byArray.length - 12) / n) {
            case 1: {
                int n2 = 0;
                int n3 = 12;
                while (n2 < n) {
                    nArray[n2] = byArray[n3];
                    ++n2;
                    ++n3;
                }
                break;
            }
            case 2: {
                int n4 = 0;
                int n5 = 12;
                while (n4 < n) {
                    nArray[n4] = BC.bytesToShort(byArray, n5, true);
                    ++n4;
                    n5 += 2;
                }
                break;
            }
            case 4: {
                int n6 = 0;
                int n7 = 12;
                while (n6 < n) {
                    nArray[n6] = BC.bytesToInt(byArray, n7, true);
                    ++n6;
                    n7 += 4;
                }
                break;
            }
        }
        return nArray;
    }

    public static String[] rldecode32ToStr(byte[] byArray) {
        String[] stringArray = new String[(byArray.length - 12) / 4];
        int n = stringArray.length;
        int n2 = 12;
        block3: for (int i = 0; i < n; ++i) {
            SB sB = new SB();
            block4: for (int j = 0; j < 4; ++j) {
                switch (byArray[n2]) {
                    case 0: {
                        stringArray[i] = sB.toString();
                        n2 += 4 - j;
                        continue block3;
                    }
                    default: {
                        sB.appendC((char)byArray[n2++]);
                        if (j != 3) continue block4;
                        stringArray[i] = sB.toString();
                        continue block4;
                    }
                }
            }
        }
        return stringArray;
    }

    public static char[] rldecode32ToChar(byte[] byArray, int n) {
        if (byArray == null) {
            return null;
        }
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 3;
        while (n2 < n) {
            char c = (char)byArray[(n3++ << 2) + 3];
            int n4 = BC.bytesToInt(byArray, n3++ << 2, true);
            while (--n4 >= 0) {
                cArray[n2++] = c;
            }
        }
        return cArray;
    }

    public static int[] rldecode32(byte[] byArray, int n) {
        if (byArray == null) {
            return null;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 3;
        while (n2 < n) {
            int n4 = BC.bytesToInt(byArray, n3++ << 2, true);
            int n5 = BC.bytesToInt(byArray, n3++ << 2, true);
            while (--n5 >= 0) {
                nArray[n2++] = n4;
            }
        }
        return nArray;
    }

    public static int[] rldecode32Delta(byte[] byArray, int n) {
        if (byArray == null) {
            return null;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 3;
        int n4 = 0;
        while (n2 < n) {
            int n5 = BC.bytesToInt(byArray, n3++ << 2, true);
            int n6 = BC.bytesToInt(byArray, n3++ << 2, true);
            while (--n6 >= 0) {
                nArray[n2++] = n4 += n5;
            }
        }
        return nArray;
    }

    public static float[] rldecodef(byte[] byArray, int n, float f) {
        if (byArray == null) {
            return null;
        }
        float[] fArray = new float[n];
        int n2 = 0;
        int n3 = 3;
        while (n2 < n) {
            int n4 = BC.bytesToInt(byArray, n3++ << 2, true);
            int n5 = BC.bytesToInt(byArray, n3++ << 2, true);
            while (--n5 >= 0) {
                fArray[n2++] = (float)n4 / f;
            }
        }
        return fArray;
    }

    public static float[] unpack16Deltaf(byte[] byArray, int n, float f) {
        if (byArray == null) {
            return null;
        }
        float[] fArray = new float[n];
        int n2 = 0;
        int n3 = 6;
        int n4 = 0;
        int n5 = 0;
        while (n2 < n) {
            int n6;
            if ((n6 = BC.bytesToShort(byArray, n3++ << 1, true)) == Short.MAX_VALUE || n6 == Short.MIN_VALUE) {
                n5 += n6;
                continue;
            }
            int n7 = n2++;
            n4 = n4 + n6 + n5;
            fArray[n7] = (float)n4 / f;
            n5 = 0;
        }
        return fArray;
    }

    public static float[] unpackf(byte[] byArray, int n, int n2, float f) {
        if (byArray == null) {
            return null;
        }
        float[] fArray = new float[n2];
        switch (n) {
            case 1: {
                int n3 = 0;
                int n4 = 12;
                int n5 = 0;
                while (n3 < n2) {
                    byte by;
                    if ((by = byArray[n4++]) == 127 || by == -128) {
                        n5 += by;
                        continue;
                    }
                    fArray[n3++] = (float)(by + n5) / f;
                    n5 = 0;
                }
                break;
            }
            case 2: {
                int n6 = 0;
                int n7 = 6;
                int n8 = 0;
                while (n6 < n2) {
                    int n9;
                    if ((n9 = BC.bytesToShort(byArray, n7++ << 1, true)) == Short.MAX_VALUE || n9 == Short.MIN_VALUE) {
                        n8 += n9;
                        continue;
                    }
                    fArray[n6++] = (float)(n9 + n8) / f;
                    n8 = 0;
                }
                break;
            }
        }
        return fArray;
    }

    public static int[] unpack(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return null;
        }
        int[] nArray = new int[n2];
        switch (n) {
            case 1: {
                int n3 = 0;
                int n4 = 12;
                int n5 = 0;
                while (n3 < n2) {
                    byte by;
                    if ((by = byArray[n4++]) == 127 || by == -128) {
                        n5 += by;
                        continue;
                    }
                    nArray[n3++] = by + n5;
                    n5 = 0;
                }
                break;
            }
            case 2: {
                int n6 = 0;
                int n7 = 6;
                int n8 = 0;
                while (n6 < n2) {
                    int n9;
                    if ((n9 = BC.bytesToShort(byArray, n7++ << 1, true)) == Short.MAX_VALUE || n9 == Short.MIN_VALUE) {
                        n8 += n9;
                        continue;
                    }
                    nArray[n6++] = n9 + n8;
                    n8 = 0;
                }
                break;
            }
        }
        return nArray;
    }
}

