/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javajs.util.M4;
import javajs.util.P4;
import javajs.util.T3;
import javajs.util.T4;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.viewer.TransformManager;

public class TransformManager4D
extends TransformManager {
    private static final int MODE_3D = 0;
    private static final int MODE_4D_WX = 1;
    private static final int MODE_4D_WY = 2;
    private static final int MODE_4D_WZ = 3;
    private boolean is4D = false;
    private int mouseMode = 3;
    private M4 m2_rotate;
    private final M4 m3_toScreen = new M4();
    private float zOffset;
    private final T3 v1 = new V3();
    private final M4 m4 = new M4();
    private T4 p4 = new P4();
    private final V3 zero = new V3();

    @Override
    public void resetRotation() {
        if (this.m2_rotate != null) {
            this.m2_rotate.setIdentity();
        }
        this.matrixRotate.setScale(1.0f);
    }

    @Override
    protected void rotateXYBy(float xDelta, float yDelta, BS bsAtoms) {
        this.rotate3DBall(xDelta, yDelta, bsAtoms);
        switch (this.is4D && bsAtoms == null ? this.mouseMode : 0) {
            case 0: {
                this.m2_rotate = null;
                break;
            }
            case 1: {
                this.checkM2();
                this.rotate4DBall(0.0f, xDelta, yDelta);
                break;
            }
            case 2: {
                this.checkM2();
                this.rotate4DBall(xDelta, 0.0f, yDelta);
                break;
            }
            case 3: {
                this.checkM2();
                this.rotate4DBall(xDelta, yDelta, 0.0f);
            }
        }
    }

    protected void rotate4DBall(float xDelta, float yDelta, float zDelta) {
        float scale = 50.0f;
        this.setAsBallRotation(this.m4, scale, xDelta, yDelta, zDelta);
        this.m2_rotate.mul2(this.m4, this.m2_rotate);
    }

    public void setAsBallRotation(M4 m, float scale, float dx, float dy, float dz) {
        float dxyz2 = dx * dx + dy * dy + dz * dz;
        float sxyz = (float)Math.sqrt(dxyz2);
        float th = sxyz / scale;
        float c = (float)Math.cos(th);
        float s = (float)Math.sin(th);
        float nx = dx / sxyz;
        float ny = dy / sxyz;
        float nz = dz / sxyz;
        float c1 = c - 1.0f;
        m.m00 = 1.0f + c1 * nx * nx;
        m.m11 = 1.0f + c1 * ny * ny;
        m.m22 = 1.0f + c1 * nz * nz;
        m.m33 = c;
        m.m01 = m.m10 = c1 * nx * ny;
        m.m02 = m.m20 = c1 * nx * nz;
        m.m12 = m.m21 = c1 * ny * nz;
        m.m03 = s * nx;
        m.m30 = -m.m03;
        m.m13 = s * ny;
        m.m31 = -m.m13;
        m.m23 = s * nz;
        m.m32 = -m.m23;
    }

    private void checkM2() {
        if (this.m2_rotate == null) {
            this.m2_rotate = M4.newMV(this.matrixRotate, this.zero);
        }
    }

    @Override
    public synchronized void calcTransformMatrix() {
        super.calcTransformMatrix();
        boolean bl = this.doTransform4D = this.is4D && !this.stereoFrame && this.mode != 1;
        if (!this.doTransform4D) {
            return;
        }
        this.v1.sub2(this.frameOffset, this.fixedRotationCenter);
        this.checkM2();
        this.m3_toScreen.setIdentity();
        this.m3_toScreen.m11 = this.m3_toScreen.m22 = this.scalePixelsPerAngstrom;
        this.m3_toScreen.m00 = this.m3_toScreen.m22;
        this.m3_toScreen.m11 = this.m3_toScreen.m22 = -this.scalePixelsPerAngstrom;
        System.out.println(this.m2_rotate);
        this.zOffset = this.modelCenterOffset;
    }

    @Override
    protected void getScreenTemp(T3 ptXYZ) {
        if (this.doTransform4D && ptXYZ instanceof T4) {
            this.p4.add2(ptXYZ, this.v1);
            this.m2_rotate.rotate(this.p4);
            this.fScrPt.setT(this.p4);
            this.m3_toScreen.rotTrans(this.fScrPt);
            this.fScrPt.z += this.zOffset;
        } else {
            this.matrixTransform.rotTrans2(ptXYZ, this.fScrPt);
        }
    }
}

