/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import org.jmol.java.BS;
import org.jmol.util.SimpleNode;
import org.jmol.viewer.Viewer;

public class CIPData {
    Viewer vwr;
    boolean setAuxiliary;
    BS bsAtropisomeric = new BS();
    BS bsAtoms;
    BS bsHelixM;
    BS bsHelixP;
    BS bsAromatic;
    SimpleNode[] atoms;
    BS bsXAromatic = new BS();
    BS bsCMinus = new BS();
    private BS bsMolecule;
    BS[] lstSmallRings;
    BS bsKekuleAmbiguous = new BS();

    public CIPData set(Viewer vwr, BS bsAtoms) {
        this.vwr = vwr;
        this.atoms = vwr.ms.at;
        this.bsAtoms = bsAtoms;
        this.bsMolecule = vwr.ms.getMoleculeBitSet(bsAtoms);
        this.setAuxiliary = vwr.getBoolean(603979960);
        try {
            BS lstRing = this.match("[r]");
            this.lstSmallRings = lstRing.isEmpty() ? new BS[0] : this.getList("*1**1||*1***1||*1****1||*1*****1||*1******1");
            this.bsAromatic = this.match("a");
            if (!this.bsAromatic.isEmpty()) {
                this.bsAtropisomeric = this.match("[!H](.t1:-20,20)a{a(.t2:-20,20)-a}a[!H]");
                this.bsHelixM = this.match("A{a}(.t:-10,-40)a(.t:-10,-40)aaa");
                this.bsHelixP = this.match("A{a}(.t:10,40)a(.t:10,40)aaa");
                this.bsXAromatic = this.match("[r5v3n+0,r5v2o+0]");
                this.bsCMinus = this.match("[a-]");
                if (!this.match("[n+1,o+1]").isEmpty() && !this.bsXAromatic.isEmpty()) {
                    this.bsKekuleAmbiguous.or(this.match("a1[n+,o+]a[n,o]a1"));
                    this.bsKekuleAmbiguous.or(this.match("a1[n+,o+][n,o]aa1"));
                }
                if (!this.bsCMinus.isEmpty()) {
                    this.bsKekuleAmbiguous.or(this.match("a1=a[a-]a=a1"));
                }
                BS[] lstR6a = this.getList("a1aaaaa1");
                int i = lstR6a.length;
                while (--i >= 0) {
                    this.bsKekuleAmbiguous.or(lstR6a[i]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    private BS[] getList(String smarts) throws Exception {
        return this.vwr.getSubstructureSetArray(smarts, this.bsMolecule, 2);
    }

    private BS match(String smarts) throws Exception {
        return this.vwr.getSmartsMatch(smarts, this.bsMolecule);
    }
}

