/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.number.modifiers;

import com.ibm.icu.impl.number.Format;
import com.ibm.icu.impl.number.FormatQuantity;
import com.ibm.icu.impl.number.Modifier;
import com.ibm.icu.impl.number.ModifierHolder;
import com.ibm.icu.impl.number.Properties;

public class PositiveNegativeAffixModifier
extends Format.BeforeFormat
implements Modifier.PositiveNegativeModifier {
    private final Modifier.AffixModifier positive;
    private final Modifier.AffixModifier negative;

    public PositiveNegativeAffixModifier(Modifier.AffixModifier positive, Modifier.AffixModifier negative) {
        this.positive = positive;
        this.negative = negative;
    }

    @Override
    public Modifier getModifier(boolean isNegative) {
        return isNegative ? this.negative : this.positive;
    }

    @Override
    public void before(FormatQuantity input, ModifierHolder mods) {
        Modifier mod = this.getModifier(input.isNegative());
        mods.add(mod);
    }

    @Override
    public void export(Properties properties) {
        PositiveNegativeAffixModifier.exportPositiveNegative(properties, this.positive, this.negative);
    }

    static void exportPositiveNegative(Properties properties, Modifier positive, Modifier negative) {
        properties.setPositivePrefix(positive.getPrefix().isEmpty() ? null : positive.getPrefix());
        properties.setPositiveSuffix(positive.getSuffix().isEmpty() ? null : positive.getSuffix());
        properties.setNegativePrefix(negative.getPrefix().isEmpty() ? null : negative.getPrefix());
        properties.setNegativeSuffix(negative.getSuffix().isEmpty() ? null : negative.getSuffix());
    }
}

