/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CoreFileTypeRegistry
extends FileTypeRegistry {
    private final Map<String, FileType> myExtensionsMap = new THashMap<String, FileType>(FileUtil.PATH_HASHING_STRATEGY);
    private final List<FileType> myAllFileTypes = new ArrayList<FileType>();

    public CoreFileTypeRegistry() {
        this.myAllFileTypes.add(UnknownFileType.INSTANCE);
    }

    @Override
    public boolean isFileIgnored(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/core/CoreFileTypeRegistry", "isFileIgnored"));
        }
        return false;
    }

    @Override
    @NotNull
    public FileType[] getRegisteredFileTypes() {
        FileType[] fileTypeArray = this.myAllFileTypes.toArray(new FileType[this.myAllFileTypes.size()]);
        if (fileTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreFileTypeRegistry", "getRegisteredFileTypes"));
        }
        return fileTypeArray;
    }

    @Override
    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file2) {
        FileType fileType;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/core/CoreFileTypeRegistry", "getFileTypeByFile"));
        }
        if (file2 instanceof LightVirtualFile && (fileType = ((LightVirtualFile)file2).getAssignedFileType()) != null) {
            FileType fileType2 = fileType;
            if (fileType2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreFileTypeRegistry", "getFileTypeByFile"));
            }
            return fileType2;
        }
        FileType fileType3 = this.getFileTypeByFileName(file2.getName());
        if (fileType3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreFileTypeRegistry", "getFileTypeByFile"));
        }
        return fileType3;
    }

    @Override
    @NotNull
    public FileType getFileTypeByFileName(@NotNull @NonNls String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/core/CoreFileTypeRegistry", "getFileTypeByFileName"));
        }
        String extension = FileUtilRt.getExtension(fileName);
        FileType fileType = this.getFileTypeByExtension(extension);
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreFileTypeRegistry", "getFileTypeByFileName"));
        }
        return fileType;
    }

    @NotNull
    public FileType getFileTypeByExtension(@NonNls @NotNull String extension) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/core/CoreFileTypeRegistry", "getFileTypeByExtension"));
        }
        FileType result2 = this.myExtensionsMap.get(extension);
        FileType fileType = result2 == null ? UnknownFileType.INSTANCE : result2;
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreFileTypeRegistry", "getFileTypeByExtension"));
        }
        return fileType;
    }

    public void registerFileType(@NotNull FileType fileType, @NotNull @NonNls String extension) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/core/CoreFileTypeRegistry", "registerFileType"));
        }
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/core/CoreFileTypeRegistry", "registerFileType"));
        }
        this.myAllFileTypes.add(fileType);
        for (String ext : extension.split(";")) {
            this.myExtensionsMap.put(ext, fileType);
        }
    }
}

