/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.Language;
import com.intellij.lang.MetaLanguage;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageExtension<T>
extends KeyedExtensionCollector<T, Language> {
    private final T myDefaultImplementation;
    private final Key<T> IN_LANGUAGE_CACHE;

    public LanguageExtension(@NonNls String epName) {
        this(epName, null);
    }

    public LanguageExtension(@NonNls String epName, @Nullable T defaultImplementation) {
        super(epName);
        this.myDefaultImplementation = defaultImplementation;
        this.IN_LANGUAGE_CACHE = Key.create("EXTENSIONS_IN_LANGUAGE_" + epName);
    }

    @Override
    @NotNull
    protected String keyToString(@NotNull Language key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/lang/LanguageExtension", "keyToString"));
        }
        String string = key.getID();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/LanguageExtension", "keyToString"));
        }
        return string;
    }

    public T forLanguage(@NotNull Language l) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/lang/LanguageExtension", "forLanguage"));
        }
        T cached = l.getUserData(this.IN_LANGUAGE_CACHE);
        if (cached != null) {
            return cached;
        }
        T result2 = this.findForLanguage(l);
        if (result2 == null) {
            return null;
        }
        result2 = l.putUserDataIfAbsent(this.IN_LANGUAGE_CACHE, result2);
        return result2;
    }

    protected T findForLanguage(@NotNull Language l) {
        T result2;
        MetaLanguage metaLanguage;
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/lang/LanguageExtension", "findForLanguage"));
        }
        List extensions = this.forKey(l);
        if (!extensions.isEmpty()) {
            return extensions.get(0);
        }
        Language base = l.getBaseLanguage();
        if (base != null) {
            return this.forLanguage(base);
        }
        MetaLanguage[] metaLanguageArray = MetaLanguage.all();
        int n = metaLanguageArray.length;
        for (int i = 0; !(i >= n || (metaLanguage = metaLanguageArray[i]).matchesLanguage(l) && (result2 = this.forLanguage(metaLanguage)) != null); ++i) {
        }
        return this.myDefaultImplementation;
    }

    @NotNull
    public List<T> allForLanguage(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/lang/LanguageExtension", "allForLanguage"));
        }
        boolean copyList = true;
        List result2 = null;
        for (Language l = language; l != null; l = l.getBaseLanguage()) {
            List list2 = this.forKey(l);
            if (result2 == null) {
                result2 = list2;
                continue;
            }
            if (list2.isEmpty()) continue;
            if (copyList) {
                result2 = ContainerUtil.newArrayList(ContainerUtil.concat(result2, list2));
                copyList = false;
                continue;
            }
            result2.addAll(list2);
        }
        List list3 = result2;
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/LanguageExtension", "allForLanguage"));
        }
        return list3;
    }

    @NotNull
    public List<T> allForLanguageOrAny(@NotNull Language l) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/lang/LanguageExtension", "allForLanguageOrAny"));
        }
        ArrayList<T> providers = new ArrayList<T>(this.allForLanguage(l));
        if (l != Language.ANY) {
            providers.addAll(this.allForLanguage(Language.ANY));
        }
        if (!(l instanceof MetaLanguage)) {
            for (MetaLanguage metaLanguage : MetaLanguage.all()) {
                providers.addAll(this.allForLanguage(metaLanguage));
            }
        }
        ArrayList<T> arrayList = providers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/LanguageExtension", "allForLanguageOrAny"));
        }
        return arrayList;
    }

    protected T getDefaultImplementation() {
        return this.myDefaultImplementation;
    }

    @NotNull
    protected Key<T> getLanguageCache() {
        Key<T> key = this.IN_LANGUAGE_CACHE;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/LanguageExtension", "getLanguageCache"));
        }
        return key;
    }

    @NotNull
    protected Set<String> getAllBaseLanguageIdsWithAny(@NotNull Language key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/lang/LanguageExtension", "getAllBaseLanguageIdsWithAny"));
        }
        THashSet<String> allowed = new THashSet<String>();
        while (key != null) {
            allowed.add(this.keyToString(key));
            key = key.getBaseLanguage();
        }
        allowed.add("any");
        for (MetaLanguage metaLanguage : MetaLanguage.all()) {
            allowed.add(metaLanguage.getID());
        }
        THashSet<String> tHashSet = allowed;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/LanguageExtension", "getAllBaseLanguageIdsWithAny"));
        }
        return tHashSet;
    }
}

