/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Locale;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ApplicationNamesInfo {
    private String myProductName;
    private String myFullProductName;
    private String myLowercaseProductName;
    private String myScriptName;
    private String myDefaultLauncherName;

    @NotNull
    public static ApplicationNamesInfo getInstance() {
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfoHolder.ourInstance;
        if (applicationNamesInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/ApplicationNamesInfo", "getInstance"));
        }
        return applicationNamesInfo;
    }

    private ApplicationNamesInfo() {
        String resource = "/idea/" + ApplicationNamesInfo.getComponentName() + ".xml";
        try {
            Document doc = JDOMUtil.loadDocument(ApplicationNamesInfo.class, resource);
            this.readInfo(doc.getRootElement());
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load resource: " + resource, e);
        }
    }

    private void readInfo(Element rootElement) {
        Element names2 = rootElement.getChild("names", rootElement.getNamespace());
        this.myProductName = names2.getAttributeValue("product");
        this.myFullProductName = names2.getAttributeValue("fullname");
        this.myLowercaseProductName = StringUtil.capitalize(this.myProductName.toLowerCase(Locale.US));
        this.myScriptName = names2.getAttributeValue("script");
        this.myDefaultLauncherName = names2.getAttributeValue("default-launcher-name", this.myScriptName);
    }

    public String getProductName() {
        return this.myProductName;
    }

    public static String getComponentName() {
        String prefix = System.getProperty("idea.platform.prefix");
        return prefix != null ? prefix + "ApplicationInfo" : "ApplicationInfo";
    }

    private static class ApplicationNamesInfoHolder {
        private static final ApplicationNamesInfo ourInstance = new ApplicationNamesInfo();
    }
}

