/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LoggerRt {
    private static Factory ourFactory;

    private static synchronized Factory getFactory() {
        if (ourFactory == null) {
            try {
                ourFactory = new IdeaFactory();
            }
            catch (Throwable t) {
                ourFactory = new JavaFactory();
            }
        }
        return ourFactory;
    }

    @NotNull
    public static LoggerRt getInstance(@NotNull String category) {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/openapi/diagnostic/LoggerRt", "getInstance"));
        }
        LoggerRt loggerRt = LoggerRt.getFactory().getInstance(category);
        if (loggerRt == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diagnostic/LoggerRt", "getInstance"));
        }
        return loggerRt;
    }

    @NotNull
    public static LoggerRt getInstance(@NotNull Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/openapi/diagnostic/LoggerRt", "getInstance"));
        }
        LoggerRt loggerRt = LoggerRt.getInstance('#' + clazz.getName());
        if (loggerRt == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diagnostic/LoggerRt", "getInstance"));
        }
        return loggerRt;
    }

    public void info(@Nullable String message) {
        this.info(message, null);
    }

    public void info(@NotNull Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/openapi/diagnostic/LoggerRt", "info"));
        }
        this.info(t.getMessage(), t);
    }

    public void warn(@Nullable String message) {
        this.warn(message, null);
    }

    public abstract void info(@Nullable String var1, @Nullable Throwable var2);

    public abstract void warn(@Nullable String var1, @Nullable Throwable var2);

    private static class IdeaFactory
    implements Factory {
        private final Method myGetInstance;
        private final Method myInfo;
        private final Method myWarn;
        private final Method myError;

        private IdeaFactory() throws Exception {
            Class<?> loggerClass = Class.forName("com.intellij.openapi.diagnostic.Logger");
            this.myGetInstance = loggerClass.getMethod("getInstance", String.class);
            this.myGetInstance.setAccessible(true);
            this.myInfo = loggerClass.getMethod("info", String.class, Throwable.class);
            this.myInfo.setAccessible(true);
            this.myWarn = loggerClass.getMethod("warn", String.class, Throwable.class);
            this.myInfo.setAccessible(true);
            this.myError = loggerClass.getMethod("error", String.class, Throwable.class);
            this.myError.setAccessible(true);
        }

        public LoggerRt getInstance(@NotNull String category) {
            if (category == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/openapi/diagnostic/LoggerRt$IdeaFactory", "getInstance"));
            }
            try {
                final Object logger = this.myGetInstance.invoke(null, category);
                return new LoggerRt(){

                    public void info(@Nullable String message, @Nullable Throwable t) {
                        try {
                            IdeaFactory.this.myInfo.invoke(logger, message, t);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }

                    public void warn(@Nullable String message, @Nullable Throwable t) {
                        try {
                            IdeaFactory.this.myWarn.invoke(logger, message, t);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class JavaFactory
    implements Factory {
        private JavaFactory() {
        }

        public LoggerRt getInstance(@NotNull String category) {
            if (category == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/openapi/diagnostic/LoggerRt$JavaFactory", "getInstance"));
            }
            final Logger logger = Logger.getLogger(category);
            return new LoggerRt(){

                public void info(@Nullable String message, @Nullable Throwable t) {
                    logger.log(Level.INFO, message, t);
                }

                public void warn(@Nullable String message, @Nullable Throwable t) {
                    logger.log(Level.WARNING, message, t);
                }
            };
        }
    }

    private static interface Factory {
        public LoggerRt getInstance(@NotNull String var1);
    }
}

