/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.containers.ThreadLocalRandom;
import gnu.trove.TObjectHashingStrategy;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.LockSupport;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

public final class ConcurrentHashMap<K, V>
extends AbstractMap<K, V>
implements TObjectHashingStrategy<K>,
ConcurrentMap<K, V> {
    private static final int NCPU = Runtime.getRuntime().availableProcessors();
    private volatile transient Node<K, V>[] table;
    private volatile transient Node<K, V>[] nextTable;
    private volatile transient long baseCount;
    private volatile transient int sizeCtl;
    private volatile transient int transferIndex;
    private volatile transient int cellsBusy;
    private volatile transient CounterCell[] counterCells;
    private transient KeySetView<K, V> keySet;
    private transient ValuesView<K, V> values;
    private transient EntrySetView<K, V> entrySet;
    @NotNull
    private final TObjectHashingStrategy<K> myHashingStrategy;
    private static final TObjectHashingStrategy THIS = new TObjectHashingStrategy(){

        public int computeHashCode(Object object) {
            throw new IncorrectOperationException();
        }

        @Override
        public boolean equals(Object o1, Object o2) {
            throw new IncorrectOperationException();
        }
    };
    private static final Unsafe U;
    private static final long SIZECTL;
    private static final long TRANSFERINDEX;
    private static final long BASECOUNT;
    private static final long CELLSBUSY;
    private static final long CELLVALUE;
    private static final long ABASE;
    private static final int ASHIFT;

    private static int spread(int h) {
        return (h ^ h >>> 16) & Integer.MAX_VALUE;
    }

    private static int tableSizeFor(int c) {
        int n = c - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    private static Class<?> comparableClassFor(Object x) {
        if (x instanceof Comparable) {
            Class<?> c = x.getClass();
            if (c == String.class) {
                return c;
            }
            Type[] ts = c.getGenericInterfaces();
            if (ts != null) {
                for (int i = 0; i < ts.length; ++i) {
                    Type[] as;
                    ParameterizedType p;
                    Type t = ts[i];
                    if (!(t instanceof ParameterizedType) || (p = (ParameterizedType)t).getRawType() != Comparable.class || (as = p.getActualTypeArguments()) == null || as.length != 1 || as[0] != c) continue;
                    return c;
                }
            }
        }
        return null;
    }

    private static int compareComparables(Class<?> kc, Object k, Object x) {
        return x == null || x.getClass() != kc ? 0 : ((Comparable)k).compareTo(x);
    }

    private static <K, V> Node<K, V> tabAt(Node<K, V>[] tab, int i) {
        return (Node)U.getObjectVolatile(tab, ((long)i << ASHIFT) + ABASE);
    }

    private static <K, V> boolean casTabAt(Node<K, V>[] tab, int i, Node<K, V> c, Node<K, V> v) {
        return U.compareAndSwapObject(tab, ((long)i << ASHIFT) + ABASE, c, v);
    }

    private static <K, V> void setTabAt(Node<K, V>[] tab, int i, Node<K, V> v) {
        U.putObjectVolatile(tab, ((long)i << ASHIFT) + ABASE, v);
    }

    public ConcurrentHashMap() {
        this(16);
    }

    public ConcurrentHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ConcurrentHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 1);
    }

    public ConcurrentHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this(initialCapacity, loadFactor, concurrencyLevel, THIS);
    }

    public ConcurrentHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        long size;
        int cap;
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/containers/ConcurrentHashMap", "<init>"));
        }
        if (!(loadFactor > 0.0f) || initialCapacity < 0 || concurrencyLevel <= 0) {
            throw new IllegalArgumentException();
        }
        if (initialCapacity < concurrencyLevel) {
            initialCapacity = concurrencyLevel;
        }
        this.sizeCtl = cap = (size = (long)(1.0 + (double)((float)initialCapacity / loadFactor))) >= 0x40000000L ? 0x40000000 : ConcurrentHashMap.tableSizeFor((int)size);
        this.myHashingStrategy = hashingStrategy == THIS ? this : hashingStrategy;
    }

    @Override
    public int size() {
        long n = this.sumCount();
        return n < 0L ? 0 : (n > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)n);
    }

    @Override
    public boolean isEmpty() {
        return this.sumCount() <= 0L;
    }

    @Override
    public V get(@NotNull Object key) {
        Node<K, V> e;
        int n;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentHashMap", "get"));
        }
        int h = this.hash(key);
        Node<K, V>[] tab = this.table;
        if (this.table != null && (n = tab.length) > 0 && (e = ConcurrentHashMap.tabAt(tab, n - 1 & h)) != null) {
            int eh = e.hash;
            if (eh == h) {
                if (this.isEqual(key, e.key)) {
                    return e.val;
                }
            } else if (eh < 0) {
                Node<K, V> p = e.find(h, key);
                return p != null ? (V)p.val : null;
            }
            while ((e = e.next) != null) {
                if (e.hash != h || !this.isEqual(key, e.key)) continue;
                return e.val;
            }
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(@NotNull Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentHashMap", "containsValue"));
        }
        Node[] t = this.table;
        if (this.table != null) {
            Node p;
            Traverser it = new Traverser(t, t.length, 0, t.length);
            while ((p = it.advance()) != null) {
                Object v = p.val;
                if (v != value && (v == null || !value.equals(v))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V put(@NotNull K key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentHashMap", "put"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentHashMap", "put"));
        }
        return this.putVal(key, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V putVal(@NotNull K key, @NotNull V value, boolean onlyIfAbsent) {
        int binCount;
        block20: {
            V oldVal;
            int i;
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentHashMap", "putVal"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentHashMap", "putVal"));
            }
            int hash = this.hash(key);
            binCount = 0;
            Node<K, V>[] tab = this.table;
            while (true) {
                int n;
                if (tab == null || (n = tab.length) == 0) {
                    tab = this.initTable();
                    continue;
                }
                i = n - 1 & hash;
                Node<K, V> f = ConcurrentHashMap.tabAt(tab, i);
                if (f == null) {
                    if (!ConcurrentHashMap.casTabAt(tab, i, null, new Node<K, V>(hash, key, value, null, this.myHashingStrategy))) continue;
                    break block20;
                }
                int fh = f.hash;
                if (fh == -1) {
                    tab = this.helpTransfer(tab, f);
                    continue;
                }
                oldVal = null;
                Node<K, V> node = f;
                synchronized (node) {
                    block21: {
                        if (ConcurrentHashMap.tabAt(tab, i) == f) {
                            if (fh >= 0) {
                                binCount = 1;
                                Node<K, V> e = f;
                                while (true) {
                                    if (e.hash == hash && this.isEqual(key, e.key)) {
                                        oldVal = e.val;
                                        if (!onlyIfAbsent) {
                                            e.val = value;
                                        }
                                        break block21;
                                    }
                                    Node<K, V> pred = e;
                                    e = e.next;
                                    if (e == null) {
                                        pred.next = new Node<K, V>(hash, key, value, null, this.myHashingStrategy);
                                        break block21;
                                    }
                                    ++binCount;
                                }
                            }
                            if (f instanceof TreeBin) {
                                binCount = 2;
                                TreeNode p = ((TreeBin)f).putTreeVal(hash, key, value);
                                if (p != null) {
                                    oldVal = p.val;
                                    if (!onlyIfAbsent) {
                                        p.val = value;
                                    }
                                }
                            }
                        }
                    }
                }
                if (binCount != 0) break;
            }
            if (binCount >= 8) {
                this.treeifyBin(tab, i);
            }
            if (oldVal != null) {
                return oldVal;
            }
        }
        this.addCount(1L, binCount);
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.tryPresize(m.size());
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.putVal(e.getKey(), e.getValue(), false);
        }
    }

    @Override
    public V remove(Object key) {
        return this.replaceNode(key, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V replaceNode(Object key, V value, Object cv) {
        int i;
        Node<K, V> f;
        int n;
        int hash = this.hash(key);
        Node<K, V>[] tab = this.table;
        while (tab != null && (n = tab.length) != 0 && (f = ConcurrentHashMap.tabAt(tab, i = n - 1 & hash)) != null) {
            int fh = f.hash;
            if (fh == -1) {
                tab = this.helpTransfer(tab, f);
                continue;
            }
            Object oldVal = null;
            boolean validated = false;
            Node<K, V> node = f;
            synchronized (node) {
                if (ConcurrentHashMap.tabAt(tab, i) == f) {
                    if (fh >= 0) {
                        validated = true;
                        Node<K, V> e = f;
                        Node<K, V> pred = null;
                        do {
                            if (e.hash == hash && this.isEqual(key, e.key)) {
                                Object ev = e.val;
                                if (cv == null || cv == ev || ev != null && cv.equals(ev)) {
                                    oldVal = ev;
                                    if (value != null) {
                                        e.val = value;
                                    } else if (pred != null) {
                                        pred.next = e.next;
                                    } else {
                                        ConcurrentHashMap.setTabAt(tab, i, e.next);
                                    }
                                }
                                break;
                            }
                            pred = e;
                        } while ((e = e.next) != null);
                    } else if (f instanceof TreeBin) {
                        TreeNode p;
                        validated = true;
                        TreeBin t = (TreeBin)f;
                        TreeNode r = t.root;
                        if (r != null && (p = r.findTreeNode(hash, key, null)) != null) {
                            Object pv = p.val;
                            if (cv == null || cv == pv || pv != null && cv.equals(pv)) {
                                oldVal = pv;
                                if (value != null) {
                                    p.val = value;
                                } else if (t.removeTreeNode(p)) {
                                    ConcurrentHashMap.setTabAt(tab, i, ConcurrentHashMap.untreeify(t.first));
                                }
                            }
                        }
                    }
                }
            }
            if (!validated) continue;
            if (oldVal == null) break;
            if (value == null) {
                this.addCount(-1L, -1);
            }
            return (V)oldVal;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        long delta = 0L;
        int i = 0;
        Node<K, V>[] tab = this.table;
        while (tab != null && i < tab.length) {
            TreeNode f = ConcurrentHashMap.tabAt(tab, i);
            if (f == null) {
                ++i;
                continue;
            }
            int fh = f.hash;
            if (fh == -1) {
                tab = this.helpTransfer(tab, f);
                i = 0;
                continue;
            }
            TreeNode treeNode = f;
            synchronized (treeNode) {
                if (ConcurrentHashMap.tabAt(tab, i) == f) {
                    Node p;
                    TreeNode treeNode2 = fh >= 0 ? f : (p = f instanceof TreeBin ? ((TreeBin)((Object)f)).first : null);
                    while (p != null) {
                        --delta;
                        p = p.next;
                    }
                    ConcurrentHashMap.setTabAt(tab, i++, null);
                }
            }
        }
        if (delta != 0L) {
            this.addCount(delta, -1);
        }
    }

    public KeySetView<K, V> keySet() {
        KeySetView<K, V> ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySetView(this, null));
    }

    @Override
    public Collection<V> values() {
        ValuesView<K, V> vs = this.values;
        return vs != null ? vs : (this.values = new ValuesView(this));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySetView<K, V> es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySetView(this));
    }

    @Override
    public int hashCode() {
        int h = 0;
        Node[] t = this.table;
        if (this.table != null) {
            Node p;
            Traverser it = new Traverser(t, t.length, 0, t.length);
            while ((p = it.advance()) != null) {
                h += this.hash(p.key) ^ p.val.hashCode();
            }
        }
        return h;
    }

    @Override
    public String toString() {
        Node[] t = this.table;
        int f = this.table == null ? 0 : t.length;
        Traverser it = new Traverser(t, f, 0, f);
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        Node p = it.advance();
        if (p != null) {
            while (true) {
                Object k = p.key;
                Object v = p.val;
                sb.append((Object)(k == this ? "(this Map)" : k));
                sb.append('=');
                sb.append((Object)(v == this ? "(this Map)" : v));
                p = it.advance();
                if (p == null) break;
                sb.append(',').append(' ');
            }
        }
        return sb.append('}').toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o != this) {
            Node p;
            if (!(o instanceof Map)) {
                return false;
            }
            Map m = (Map)o;
            Node[] t = this.table;
            int f = this.table == null ? 0 : t.length;
            Traverser it = new Traverser(t, f, 0, f);
            while ((p = it.advance()) != null) {
                Object val = p.val;
                Object v = m.get(p.key);
                if (v != null && (v == val || v.equals(val))) continue;
                return false;
            }
            for (Map.Entry e : m.entrySet()) {
                V v;
                Object mv;
                Object mk = e.getKey();
                if (mk != null && (mv = e.getValue()) != null && (v = this.get(mk)) != null && (mv == v || mv.equals(v))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public V putIfAbsent(@NotNull K key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentHashMap", "putIfAbsent"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentHashMap", "putIfAbsent"));
        }
        return this.putVal(key, value, true);
    }

    @Override
    public boolean remove(@NotNull Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentHashMap", "remove"));
        }
        return value != null && this.replaceNode(key, null, value) != null;
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentHashMap", "replace"));
        }
        if (oldValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldValue", "com/intellij/util/containers/ConcurrentHashMap", "replace"));
        }
        if (newValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "com/intellij/util/containers/ConcurrentHashMap", "replace"));
        }
        return this.replaceNode(key, newValue, oldValue) != null;
    }

    @Override
    public V replace(@NotNull K key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentHashMap", "replace"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentHashMap", "replace"));
        }
        return this.replaceNode(key, value, null);
    }

    @Override
    public V getOrDefault(@NotNull Object key, V defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentHashMap", "getOrDefault"));
        }
        V v = this.get(key);
        return v == null ? defaultValue : v;
    }

    private long mappingCount() {
        long n = this.sumCount();
        return n < 0L ? 0L : n;
    }

    private static int resizeStamp(int n) {
        return Integer.numberOfLeadingZeros(n) | 0x8000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node<K, V>[] initTable() {
        Node<K, V>[] tab;
        block6: {
            int sc;
            while (true) {
                tab = this.table;
                if (this.table != null && tab.length != 0) break block6;
                sc = this.sizeCtl;
                if (sc < 0) {
                    Thread.yield();
                    continue;
                }
                if (U.compareAndSwapInt(this, SIZECTL, sc, -1)) break;
            }
            try {
                tab = this.table;
                if (this.table == null || tab.length == 0) {
                    int n = sc > 0 ? sc : 16;
                    Node[] nt = new Node[n];
                    tab = nt;
                    this.table = nt;
                    sc = n - (n >>> 2);
                }
            }
            finally {
                this.sizeCtl = sc;
            }
        }
        return tab;
    }

    private void addCount(long x, int check2) {
        long s;
        long b;
        CounterCell[] as = this.counterCells;
        if (this.counterCells != null || !U.compareAndSwapLong(this, BASECOUNT, b = this.baseCount, s = b + x)) {
            long v;
            CounterCell a;
            int m;
            boolean uncontended = true;
            if (as == null || (m = as.length - 1) < 0 || (a = as[ThreadLocalRandom.getProbe() & m]) == null || !(uncontended = U.compareAndSwapLong(a, CELLVALUE, v = a.value, v + x))) {
                this.fullAddCount(x, uncontended);
                return;
            }
            if (check2 <= 1) {
                return;
            }
            s = this.sumCount();
        }
        if (check2 >= 0) {
            int sc;
            while (s >= (long)(sc = this.sizeCtl)) {
                int n;
                Node<K, V>[] tab = this.table;
                if (this.table == null || (n = tab.length) >= 0x40000000) break;
                int rs = ConcurrentHashMap.resizeStamp(n);
                if (sc < 0) {
                    if (sc >>> 16 != rs || sc == rs + 1 || sc == rs + 65535) break;
                    Node<K, V>[] nt = this.nextTable;
                    if (this.nextTable == null || this.transferIndex <= 0) break;
                    if (U.compareAndSwapInt(this, SIZECTL, sc, sc + 1)) {
                        this.transfer(tab, nt);
                    }
                } else if (U.compareAndSwapInt(this, SIZECTL, sc, (rs << 16) + 2)) {
                    this.transfer(tab, null);
                }
                s = this.sumCount();
            }
        }
    }

    private Node<K, V>[] helpTransfer(Node<K, V>[] tab, Node<K, V> f) {
        Node[] nextTab;
        if (tab != null && f instanceof ForwardingNode && (nextTab = ((ForwardingNode)f).nextTable) != null) {
            int sc;
            int rs = ConcurrentHashMap.resizeStamp(tab.length);
            while (nextTab == this.nextTable && this.table == tab && (sc = this.sizeCtl) < 0 && sc >>> 16 == rs && sc != rs + 1 && sc != rs + 65535 && this.transferIndex > 0) {
                if (!U.compareAndSwapInt(this, SIZECTL, sc, sc + 1)) continue;
                this.transfer(tab, nextTab);
                break;
            }
            return nextTab;
        }
        return this.table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryPresize(int size) {
        int sc;
        int c;
        int n = c = size >= 0x20000000 ? 0x40000000 : ConcurrentHashMap.tableSizeFor(size + (size >>> 1) + 1);
        while ((sc = this.sizeCtl) >= 0) {
            int n2;
            Node<K, V>[] tab = this.table;
            if (tab == null || (n2 = tab.length) == 0) {
                int n3 = n2 = sc > c ? sc : c;
                if (!U.compareAndSwapInt(this, SIZECTL, sc, -1)) continue;
                try {
                    if (this.table != tab) continue;
                    Node[] nt = new Node[n2];
                    this.table = nt;
                    sc = n2 - (n2 >>> 2);
                    continue;
                }
                finally {
                    this.sizeCtl = sc;
                    continue;
                }
            }
            if (c <= sc || n2 >= 0x40000000) break;
            if (tab != this.table) continue;
            int rs = ConcurrentHashMap.resizeStamp(n2);
            if (sc < 0) {
                if (sc >>> 16 != rs || sc == rs + 1 || sc == rs + 65535) break;
                Node<K, V>[] nt = this.nextTable;
                if (this.nextTable == null || this.transferIndex <= 0) break;
                if (!U.compareAndSwapInt(this, SIZECTL, sc, sc + 1)) continue;
                this.transfer(tab, nt);
                continue;
            }
            if (!U.compareAndSwapInt(this, SIZECTL, sc, (rs << 16) + 2)) continue;
            this.transfer(tab, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transfer(Node<K, V>[] tab, Node<K, V>[] nextTab) {
        int n = tab.length;
        int stride = NCPU > 1 ? (n >>> 3) / NCPU : n;
        if (stride < 16) {
            stride = 16;
        }
        if (nextTab == null) {
            try {
                Node[] nt = new Node[n << 1];
                nextTab = nt;
            }
            catch (Throwable ex) {
                this.sizeCtl = Integer.MAX_VALUE;
                return;
            }
            this.nextTable = nextTab;
            this.transferIndex = n;
        }
        int nextn = nextTab.length;
        ForwardingNode fwd = new ForwardingNode(nextTab, this.myHashingStrategy);
        boolean advance = true;
        boolean finishing = false;
        int i = 0;
        int bound = 0;
        while (true) {
            if (advance) {
                if (--i >= bound || finishing) {
                    advance = false;
                    continue;
                }
                int nextIndex = this.transferIndex;
                if (nextIndex <= 0) {
                    i = -1;
                    advance = false;
                    continue;
                }
                int nextBound = nextIndex > stride ? nextIndex - stride : 0;
                if (!U.compareAndSwapInt(this, TRANSFERINDEX, nextIndex, nextBound)) continue;
                bound = nextBound;
                i = nextIndex - 1;
                advance = false;
                continue;
            }
            if (i < 0 || i >= n || i + n >= nextn) {
                if (finishing) {
                    this.nextTable = null;
                    this.table = nextTab;
                    this.sizeCtl = (n << 1) - (n >>> 1);
                    return;
                }
                int sc = this.sizeCtl;
                if (!U.compareAndSwapInt(this, SIZECTL, sc, sc - 1)) continue;
                if (sc - 2 != ConcurrentHashMap.resizeStamp(n) << 16) {
                    return;
                }
                advance = true;
                finishing = true;
                i = n;
                continue;
            }
            TreeBin f = ConcurrentHashMap.tabAt(tab, i);
            if (f == null) {
                advance = ConcurrentHashMap.casTabAt(tab, i, null, fwd);
                continue;
            }
            int fh = f.hash;
            if (fh == -1) {
                advance = true;
                continue;
            }
            TreeBin treeBin = f;
            synchronized (treeBin) {
                if (ConcurrentHashMap.tabAt(tab, i) == f) {
                    Node hn;
                    if (fh >= 0) {
                        Node ln;
                        int runBit = fh & n;
                        TreeBin lastRun = f;
                        Node p = f.next;
                        while (p != null) {
                            int b = p.hash & n;
                            if (b != runBit) {
                                runBit = b;
                                lastRun = p;
                            }
                            p = p.next;
                        }
                        if (runBit == 0) {
                            ln = lastRun;
                            hn = null;
                        } else {
                            hn = lastRun;
                            ln = null;
                        }
                        p = f;
                        while (p != lastRun) {
                            int ph = p.hash;
                            Object pk = p.key;
                            Object pv = p.val;
                            if ((ph & n) == 0) {
                                ln = new Node(ph, pk, pv, ln, this.myHashingStrategy);
                            } else {
                                hn = new Node(ph, pk, pv, hn, this.myHashingStrategy);
                            }
                            p = p.next;
                        }
                        ConcurrentHashMap.setTabAt(nextTab, i, ln);
                        ConcurrentHashMap.setTabAt(nextTab, i + n, hn);
                        ConcurrentHashMap.setTabAt(tab, i, fwd);
                        advance = true;
                    } else if (f instanceof TreeBin) {
                        TreeBin ln;
                        TreeBin t = f;
                        TreeNode lo = null;
                        TreeNode loTail = null;
                        TreeNode hi = null;
                        TreeNode hiTail = null;
                        int lc = 0;
                        int hc = 0;
                        Node e = t.first;
                        while (e != null) {
                            int h = e.hash;
                            TreeNode p = new TreeNode(h, e.key, e.val, null, null, this.myHashingStrategy);
                            if ((h & n) == 0) {
                                if ((p.prev = loTail) == null) {
                                    lo = p;
                                } else {
                                    loTail.next = p;
                                }
                                loTail = p;
                                ++lc;
                            } else {
                                if ((p.prev = hiTail) == null) {
                                    hi = p;
                                } else {
                                    hiTail.next = p;
                                }
                                hiTail = p;
                                ++hc;
                            }
                            e = e.next;
                        }
                        TreeBin treeBin2 = lc <= 6 ? ConcurrentHashMap.untreeify(lo) : (ln = hc != 0 ? new TreeBin(lo, this.myHashingStrategy) : t);
                        hn = hc <= 6 ? ConcurrentHashMap.untreeify(hi) : (lc != 0 ? new TreeBin(hi, this.myHashingStrategy) : t);
                        ConcurrentHashMap.setTabAt(nextTab, i, ln);
                        ConcurrentHashMap.setTabAt(nextTab, i + n, hn);
                        ConcurrentHashMap.setTabAt(tab, i, fwd);
                        advance = true;
                    }
                }
            }
        }
    }

    private long sumCount() {
        CounterCell[] as = this.counterCells;
        long sum = this.baseCount;
        if (as != null) {
            for (int i = 0; i < as.length; ++i) {
                CounterCell a = as[i];
                if (a == null) continue;
                sum += a.value;
            }
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void fullAddCount(long x, boolean wasUncontended) {
        int h = ThreadLocalRandom.getProbe();
        if (h == 0) {
            ThreadLocalRandom.localInit();
            h = ThreadLocalRandom.getProbe();
            wasUncontended = true;
        }
        boolean collide = false;
        while (true) {
            long v;
            int n;
            CounterCell[] as = this.counterCells;
            if (this.counterCells != null && (n = as.length) > 0) {
                CounterCell a = as[n - 1 & h];
                if (a == null) {
                    if (this.cellsBusy == 0) {
                        CounterCell r = new CounterCell(x);
                        if (this.cellsBusy == 0 && U.compareAndSwapInt(this, CELLSBUSY, 0, 1)) {
                            boolean created = false;
                            try {
                                int j;
                                int m;
                                CounterCell[] rs = this.counterCells;
                                if (this.counterCells != null && (m = rs.length) > 0 && rs[j = m - 1 & h] == null) {
                                    rs[j] = r;
                                    created = true;
                                }
                            }
                            finally {
                                this.cellsBusy = 0;
                            }
                            if (!created) continue;
                            return;
                        }
                    }
                    collide = false;
                } else if (!wasUncontended) {
                    wasUncontended = true;
                } else {
                    v = a.value;
                    if (U.compareAndSwapLong(a, CELLVALUE, v, v + x)) return;
                    if (this.counterCells != as || n >= NCPU) {
                        collide = false;
                    } else if (!collide) {
                        collide = true;
                    } else if (this.cellsBusy == 0 && U.compareAndSwapInt(this, CELLSBUSY, 0, 1)) {
                        try {
                            if (this.counterCells == as) {
                                CounterCell[] rs = new CounterCell[n << 1];
                                for (int i = 0; i < n; ++i) {
                                    rs[i] = as[i];
                                }
                                this.counterCells = rs;
                            }
                        }
                        finally {
                            this.cellsBusy = 0;
                        }
                        collide = false;
                        continue;
                    }
                }
                h = ThreadLocalRandom.advanceProbe(h);
                continue;
            }
            if (this.cellsBusy == 0 && this.counterCells == as && U.compareAndSwapInt(this, CELLSBUSY, 0, 1)) {
                boolean init = false;
                try {
                    if (this.counterCells == as) {
                        CounterCell[] rs = new CounterCell[2];
                        rs[h & 1] = new CounterCell(x);
                        this.counterCells = rs;
                        init = true;
                    }
                }
                finally {
                    this.cellsBusy = 0;
                }
                if (!init) continue;
                return;
            }
            v = this.baseCount;
            if (U.compareAndSwapLong(this, BASECOUNT, v, v + x)) return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void treeifyBin(Node<K, V>[] tab, int index2) {
        if (tab != null) {
            int n = tab.length;
            if (n < 64) {
                this.tryPresize(n << 1);
            } else {
                Node<K, V> b = ConcurrentHashMap.tabAt(tab, index2);
                if (b != null && b.hash >= 0) {
                    Node<K, V> node = b;
                    synchronized (node) {
                        if (ConcurrentHashMap.tabAt(tab, index2) == b) {
                            TreeNode hd = null;
                            TreeNode tl = null;
                            Node<K, V> e = b;
                            while (e != null) {
                                TreeNode p = new TreeNode(e.hash, e.key, e.val, null, null, this.myHashingStrategy);
                                if ((p.prev = tl) == null) {
                                    hd = p;
                                } else {
                                    tl.next = p;
                                }
                                tl = p;
                                e = e.next;
                            }
                            ConcurrentHashMap.setTabAt(tab, index2, new TreeBin(hd, this.myHashingStrategy));
                        }
                    }
                }
            }
        }
    }

    private static <K, V> Node<K, V> untreeify(Node<K, V> b) {
        Node hd = null;
        Node tl = null;
        Node<K, V> q = b;
        while (q != null) {
            Node p = new Node(q.hash, q.key, q.val, null, q.myHashingStrategy);
            if (tl == null) {
                hd = p;
            } else {
                tl.next = p;
            }
            tl = p;
            q = q.next;
        }
        return hd;
    }

    @Override
    public int computeHashCode(K object) {
        return object == null ? 0 : object.hashCode();
    }

    @Override
    public boolean equals(K o1, K o2) {
        return o1.equals(o2);
    }

    private int hash(K key) {
        return ConcurrentHashMap.spread(this.myHashingStrategy.computeHashCode(key));
    }

    private boolean isEqual(@NotNull K key1, K key2) {
        if (key1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key1", "com/intellij/util/containers/ConcurrentHashMap", "isEqual"));
        }
        return ConcurrentHashMap.isEqual(key1, key2, this.myHashingStrategy);
    }

    private static <K> boolean isEqual(@NotNull K key1, K key2, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (key1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key1", "com/intellij/util/containers/ConcurrentHashMap", "isEqual"));
        }
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/containers/ConcurrentHashMap", "isEqual"));
        }
        return key1 == key2 || key2 != null && hashingStrategy.equals(key1, key2);
    }

    static {
        try {
            U = AtomicFieldUpdater.getUnsafe();
            Class<ConcurrentHashMap> k = ConcurrentHashMap.class;
            SIZECTL = U.objectFieldOffset(k.getDeclaredField("sizeCtl"));
            TRANSFERINDEX = U.objectFieldOffset(k.getDeclaredField("transferIndex"));
            BASECOUNT = U.objectFieldOffset(k.getDeclaredField("baseCount"));
            CELLSBUSY = U.objectFieldOffset(k.getDeclaredField("cellsBusy"));
            Class<CounterCell> ck = CounterCell.class;
            CELLVALUE = U.objectFieldOffset(ck.getDeclaredField("value"));
            Class<Node[]> ak = Node[].class;
            ABASE = U.arrayBaseOffset(ak);
            int scale = U.arrayIndexScale(ak);
            if ((scale & scale - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            ASHIFT = 31 - Integer.numberOfLeadingZeros(scale);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private static final class EntrySetView<K, V>
    extends CollectionView<K, V, Map.Entry<K, V>>
    implements Set<Map.Entry<K, V>> {
        private EntrySetView(ConcurrentHashMap<K, V> map2) {
            super(map2);
        }

        @Override
        public boolean contains(Object o) {
            Object v;
            Object r;
            Map.Entry e;
            Object k;
            return o instanceof Map.Entry && (k = (e = (Map.Entry)o).getKey()) != null && (r = this.map.get(k)) != null && (v = e.getValue()) != null && (v == r || v.equals(r));
        }

        @Override
        public boolean remove(Object o) {
            Object v;
            Map.Entry e;
            Object k;
            return o instanceof Map.Entry && (k = (e = (Map.Entry)o).getKey()) != null && (v = e.getValue()) != null && this.map.remove(k, v);
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<K, V>> iterator() {
            ConcurrentHashMap m = this.map;
            Node[] t = m.table;
            int f = t == null ? 0 : t.length;
            EntryIterator entryIterator = new EntryIterator(t, f, 0, f, m);
            if (entryIterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentHashMap$EntrySetView", "iterator"));
            }
            return entryIterator;
        }

        @Override
        public boolean add(Map.Entry<K, V> e) {
            return this.map.putVal(e.getKey(), e.getValue(), false) == null;
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends Map.Entry<K, V>> c) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/ConcurrentHashMap$EntrySetView", "addAll"));
            }
            boolean added = false;
            for (Map.Entry<K, V> e : c) {
                if (!this.add(e)) continue;
                added = true;
            }
            return added;
        }

        @Override
        public final int hashCode() {
            int h = 0;
            Node[] t = this.map.table;
            if (t != null) {
                Node p;
                Traverser it = new Traverser(t, t.length, 0, t.length);
                while ((p = it.advance()) != null) {
                    h += p.hashCode();
                }
            }
            return h;
        }

        @Override
        public final boolean equals(Object o) {
            Set c;
            return o instanceof Set && ((c = (Set)o) == this || this.containsAll(c) && c.containsAll(this));
        }
    }

    private static final class ValuesView<K, V>
    extends CollectionView<K, V, V>
    implements Collection<V> {
        ValuesView(ConcurrentHashMap<K, V> map2) {
            super(map2);
        }

        @Override
        public final boolean contains(Object o) {
            return this.map.containsValue(o);
        }

        @Override
        public final boolean remove(Object o) {
            if (o != null) {
                Iterator<V> it = this.iterator();
                while (it.hasNext()) {
                    if (!o.equals(it.next())) continue;
                    it.remove();
                    return true;
                }
            }
            return false;
        }

        @Override
        @NotNull
        public final Iterator<V> iterator() {
            ConcurrentHashMap m = this.map;
            Node[] t = m.table;
            int f = t == null ? 0 : t.length;
            ValueIterator valueIterator = new ValueIterator(t, f, 0, f, m);
            if (valueIterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentHashMap$ValuesView", "iterator"));
            }
            return valueIterator;
        }

        @Override
        public final boolean add(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(@NotNull Collection<? extends V> c) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/ConcurrentHashMap$ValuesView", "addAll"));
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class KeySetView<K, V>
    extends CollectionView<K, V, K>
    implements Set<K> {
        private final V value;

        KeySetView(ConcurrentHashMap<K, V> map2, V value) {
            super(map2);
            this.value = value;
        }

        @Override
        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.map.remove(o) != null;
        }

        @Override
        @NotNull
        public Iterator<K> iterator() {
            ConcurrentHashMap m = this.map;
            Node[] t = m.table;
            int f = t == null ? 0 : t.length;
            KeyIterator keyIterator = new KeyIterator(t, f, 0, f, m);
            if (keyIterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentHashMap$KeySetView", "iterator"));
            }
            return keyIterator;
        }

        @Override
        public boolean add(@NotNull K e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/containers/ConcurrentHashMap$KeySetView", "add"));
            }
            V v = this.value;
            if (v == null) {
                throw new UnsupportedOperationException();
            }
            return this.map.putVal(e, v, true) == null;
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends K> c) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/ConcurrentHashMap$KeySetView", "addAll"));
            }
            boolean added = false;
            V v = this.value;
            if (v == null) {
                throw new UnsupportedOperationException();
            }
            for (K e : c) {
                if (this.map.putVal(e, v, true) != null) continue;
                added = true;
            }
            return added;
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (K e : this) {
                h += this.map.hash(e);
            }
            return h;
        }

        @Override
        public boolean equals(Object o) {
            Set c;
            return o instanceof Set && ((c = (Set)o) == this || this.containsAll(c) && c.containsAll(this));
        }
    }

    private static abstract class CollectionView<K, V, E>
    implements Collection<E> {
        final ConcurrentHashMap<K, V> map;

        CollectionView(@NotNull ConcurrentHashMap<K, V> map2) {
            if (map2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/util/containers/ConcurrentHashMap$CollectionView", "<init>"));
            }
            this.map = map2;
        }

        @Override
        public final void clear() {
            this.map.clear();
        }

        @Override
        public final int size() {
            return this.map.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public abstract Iterator<E> iterator();

        @Override
        public abstract boolean contains(Object var1);

        @Override
        @NotNull
        public final Object[] toArray() {
            long sz = ((ConcurrentHashMap)this.map).mappingCount();
            if (sz > 0x7FFFFFF7L) {
                throw new OutOfMemoryError("Required array size too large");
            }
            int n = (int)sz;
            Object[] r = new Object[n];
            int i = 0;
            for (E e : this) {
                if (i == n) {
                    if (n >= 0x7FFFFFF7) {
                        throw new OutOfMemoryError("Required array size too large");
                    }
                    n = n >= 0x3FFFFFFB ? 0x7FFFFFF7 : (n += (n >>> 1) + 1);
                    r = Arrays.copyOf(r, n);
                }
                r[i++] = e;
            }
            Object[] objectArray = i == n ? r : Arrays.copyOf(r, i);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentHashMap$CollectionView", "toArray"));
            }
            return objectArray;
        }

        @Override
        @NotNull
        public final <T> T[] toArray(@NotNull T[] a) {
            if (a == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/util/containers/ConcurrentHashMap$CollectionView", "toArray"));
            }
            long sz = ((ConcurrentHashMap)this.map).mappingCount();
            if (sz > 0x7FFFFFF7L) {
                throw new OutOfMemoryError("Required array size too large");
            }
            int m = (int)sz;
            T[] r = a.length >= m ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), m);
            int n = r.length;
            int i = 0;
            for (E e : this) {
                if (i == n) {
                    if (n >= 0x7FFFFFF7) {
                        throw new OutOfMemoryError("Required array size too large");
                    }
                    n = n >= 0x3FFFFFFB ? 0x7FFFFFF7 : (n += (n >>> 1) + 1);
                    r = Arrays.copyOf(r, n);
                }
                r[i++] = e;
            }
            if (a == r && i < n) {
                r[i] = null;
                if (r == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentHashMap$CollectionView", "toArray"));
                }
                return r;
            }
            T[] TArray = i == n ? r : Arrays.copyOf(r, i);
            if (TArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentHashMap$CollectionView", "toArray"));
            }
            return TArray;
        }

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            Iterator<E> it = this.iterator();
            if (it.hasNext()) {
                while (true) {
                    E e;
                    sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
                    if (!it.hasNext()) break;
                    sb.append(',').append(' ');
                }
            }
            return sb.append(']').toString();
        }

        @Override
        public final boolean containsAll(@NotNull Collection<?> c) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/ConcurrentHashMap$CollectionView", "containsAll"));
            }
            if (c != this) {
                for (Object e : c) {
                    if (e != null && this.contains(e)) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public final boolean removeAll(@NotNull Collection<?> c) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/ConcurrentHashMap$CollectionView", "removeAll"));
            }
            boolean modified = false;
            Iterator<E> it = this.iterator();
            while (it.hasNext()) {
                if (!c.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public final boolean retainAll(@NotNull Collection<?> c) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/ConcurrentHashMap$CollectionView", "retainAll"));
            }
            boolean modified = false;
            Iterator<E> it = this.iterator();
            while (it.hasNext()) {
                if (c.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }
    }

    private static final class MapEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V val;
        private final ConcurrentHashMap<K, V> map;

        MapEntry(K key, V val, ConcurrentHashMap<K, V> map2) {
            this.key = key;
            this.val = val;
            this.map = map2;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.val;
        }

        @Override
        public int hashCode() {
            return ((ConcurrentHashMap)this.map).hash(this.key) ^ this.val.hashCode();
        }

        public String toString() {
            return this.key + "=" + this.val;
        }

        @Override
        public boolean equals(Object o) {
            Object v;
            Map.Entry e;
            Object k;
            return o instanceof Map.Entry && (k = (e = (Map.Entry)o).getKey()) != null && (v = e.getValue()) != null && ((ConcurrentHashMap)this.map).isEqual(k, this.key) && (v == this.val || v.equals(this.val));
        }

        @Override
        public V setValue(@NotNull V value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentHashMap$MapEntry", "setValue"));
            }
            V v = this.val;
            this.val = value;
            this.map.put(this.key, value);
            return v;
        }
    }

    private static final class EntryIterator<K, V>
    extends BaseIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator(Node<K, V>[] tab, int index2, int size, int limit, ConcurrentHashMap<K, V> map2) {
            super(tab, index2, size, limit, map2);
        }

        @Override
        public final Map.Entry<K, V> next() {
            Node p = this.next;
            if (p == null) {
                throw new NoSuchElementException();
            }
            Object k = p.key;
            Object v = p.val;
            this.lastReturned = p;
            this.advance();
            return new MapEntry(k, v, this.map);
        }
    }

    private static final class ValueIterator<K, V>
    extends BaseIterator<K, V>
    implements Enumeration<V>,
    Iterator<V> {
        ValueIterator(Node<K, V>[] tab, int index2, int size, int limit, ConcurrentHashMap<K, V> map2) {
            super(tab, index2, size, limit, map2);
        }

        @Override
        public final V next() {
            Node p = this.next;
            if (p == null) {
                throw new NoSuchElementException();
            }
            Object v = p.val;
            this.lastReturned = p;
            this.advance();
            return v;
        }

        @Override
        public final V nextElement() {
            return this.next();
        }
    }

    private static final class KeyIterator<K, V>
    extends BaseIterator<K, V>
    implements Enumeration<K>,
    Iterator<K> {
        KeyIterator(Node<K, V>[] tab, int index2, int size, int limit, ConcurrentHashMap<K, V> map2) {
            super(tab, index2, size, limit, map2);
        }

        @Override
        public final K next() {
            Node p = this.next;
            if (p == null) {
                throw new NoSuchElementException();
            }
            Object k = p.key;
            this.lastReturned = p;
            this.advance();
            return k;
        }

        @Override
        public final K nextElement() {
            return this.next();
        }
    }

    private static class BaseIterator<K, V>
    extends Traverser<K, V> {
        final ConcurrentHashMap<K, V> map;
        Node<K, V> lastReturned;

        private BaseIterator(Node<K, V>[] tab, int size, int index2, int limit, ConcurrentHashMap<K, V> map2) {
            super(tab, size, index2, limit);
            this.map = map2;
            this.advance();
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        public final boolean hasMoreElements() {
            return this.next != null;
        }

        public final void remove() {
            Node<K, V> p = this.lastReturned;
            if (p == null) {
                throw new IllegalStateException();
            }
            this.lastReturned = null;
            ((ConcurrentHashMap)this.map).replaceNode(p.key, null, null);
        }
    }

    private static class Traverser<K, V> {
        private Node<K, V>[] tab;
        Node<K, V> next;
        private TableStack<K, V> stack;
        private TableStack<K, V> spare;
        private int index;
        private int baseIndex;
        private final int baseLimit;
        private final int baseSize;

        private Traverser(Node<K, V>[] tab, int size, int index2, int limit) {
            this.tab = tab;
            this.baseSize = size;
            this.baseIndex = this.index = index2;
            this.baseLimit = limit;
            this.next = null;
        }

        final Node<K, V> advance() {
            TreeNode e = this.next;
            if (e != null) {
                e = e.next;
            }
            while (true) {
                int i;
                int n;
                Node[] t;
                block10: {
                    block9: {
                        if (e != null) {
                            this.next = e;
                            return this.next;
                        }
                        if (this.baseIndex >= this.baseLimit) break block9;
                        t = this.tab;
                        if (this.tab != null && (n = t.length) > (i = this.index) && i >= 0) break block10;
                    }
                    this.next = null;
                    return null;
                }
                e = ConcurrentHashMap.tabAt(t, i);
                if (e != null && e.hash < 0) {
                    if (e instanceof ForwardingNode) {
                        this.tab = ((ForwardingNode)((Object)e)).nextTable;
                        e = null;
                        this.pushState(t, i, n);
                        continue;
                    }
                    e = e instanceof TreeBin ? ((TreeBin)((Object)e)).first : null;
                }
                if (this.stack != null) {
                    this.recoverState(n);
                    continue;
                }
                this.index = i + this.baseSize;
                if (this.index < n) continue;
                this.index = ++this.baseIndex;
            }
        }

        private void pushState(Node<K, V>[] t, int i, int n) {
            TableStack<K, V> s = this.spare;
            if (s != null) {
                this.spare = ((TableStack)s).next;
            } else {
                s = new TableStack();
            }
            TableStack.access$2102(s, t);
            ((TableStack)s).length = n;
            ((TableStack)s).index = i;
            ((TableStack)s).next = (TableStack)this.stack;
            this.stack = s;
        }

        private void recoverState(int n) {
            int len;
            TableStack<K, V> s;
            while ((s = this.stack) != null && (this.index += (len = ((TableStack)s).length)) >= n) {
                n = len;
                this.index = ((TableStack)s).index;
                this.tab = ((TableStack)s).tab;
                TableStack.access$2102(s, null);
                TableStack next = ((TableStack)s).next;
                ((TableStack)s).next = (TableStack)this.spare;
                this.stack = next;
                this.spare = s;
            }
            if (s == null && (this.index += this.baseSize) >= n) {
                this.index = ++this.baseIndex;
            }
        }
    }

    private static final class TableStack<K, V> {
        private int length;
        private int index;
        private Node<K, V>[] tab;
        private TableStack<K, V> next;

        private TableStack() {
        }

        static /* synthetic */ Node[] access$2102(TableStack x0, Node[] x1) {
            x0.tab = x1;
            return x1;
        }
    }

    private static final class TreeBin<K, V>
    extends Node<K, V> {
        private TreeNode<K, V> root;
        private volatile TreeNode<K, V> first;
        private volatile Thread waiter;
        private volatile int lockState;
        private static final Unsafe U;
        private static final long LOCKSTATE;

        private static int tieBreakOrder(Object a, Object b) {
            int d;
            if (a == null || b == null || (d = a.getClass().getName().compareTo(b.getClass().getName())) == 0) {
                d = System.identityHashCode(a) <= System.identityHashCode(b) ? -1 : 1;
            }
            return d;
        }

        private TreeBin(TreeNode<K, V> b, TObjectHashingStrategy<K> hashingStrategy) {
            super(-2, null, null, null, hashingStrategy);
            this.first = b;
            TreeNode<K, V> r = null;
            TreeNode<K, V> x = b;
            while (x != null) {
                TreeNode<K, V> next = (TreeNode<K, V>)x.next;
                ((TreeNode)x).left = (((TreeNode)x).right = null);
                if (r == null) {
                    ((TreeNode)x).parent = null;
                    ((TreeNode)x).red = false;
                    r = x;
                } else {
                    TreeNode<K, V> xp;
                    int dir;
                    Object k = x.key;
                    int h = x.hash;
                    Class kc = null;
                    TreeNode<K, V> p = r;
                    do {
                        Object pk = p.key;
                        int ph = p.hash;
                        if (ph > h) {
                            dir = -1;
                        } else if (ph < h) {
                            dir = 1;
                        } else if (kc == null && (kc = ConcurrentHashMap.comparableClassFor(k)) == null || (dir = ConcurrentHashMap.compareComparables(kc, k, pk)) == 0) {
                            dir = TreeBin.tieBreakOrder(k, pk);
                        }
                        xp = p;
                    } while ((p = dir <= 0 ? ((TreeNode)p).left : ((TreeNode)p).right) != null);
                    ((TreeNode)x).parent = (TreeNode)xp;
                    if (dir <= 0) {
                        ((TreeNode)xp).left = (TreeNode)x;
                    } else {
                        ((TreeNode)xp).right = (TreeNode)x;
                    }
                    r = TreeBin.balanceInsertion(r, x);
                }
                x = next;
            }
            this.root = r;
            assert (TreeBin.checkInvariants(this.root));
        }

        private void lockRoot() {
            if (!U.compareAndSwapInt(this, LOCKSTATE, 0, 1)) {
                this.contendedLock();
            }
        }

        private void unlockRoot() {
            this.lockState = 0;
        }

        private void contendedLock() {
            boolean waiting = false;
            while (true) {
                int s;
                if (((s = this.lockState) & 0xFFFFFFFD) == 0) {
                    if (!U.compareAndSwapInt(this, LOCKSTATE, s, 1)) continue;
                    if (waiting) {
                        this.waiter = null;
                    }
                    return;
                }
                if ((s & 2) == 0) {
                    if (!U.compareAndSwapInt(this, LOCKSTATE, s, s | 2)) continue;
                    waiting = true;
                    this.waiter = Thread.currentThread();
                    continue;
                }
                if (!waiting) continue;
                LockSupport.park(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final Node<K, V> find(int h, Object k) {
            if (k != null) {
                Node e = this.first;
                while (e != null) {
                    TreeNode p;
                    int s = this.lockState;
                    if ((s & 3) != 0) {
                        if (e.hash == h && ConcurrentHashMap.isEqual(k, e.key, this.myHashingStrategy)) {
                            return e;
                        }
                        e = e.next;
                        continue;
                    }
                    if (!U.compareAndSwapInt(this, LOCKSTATE, s, s + 4)) continue;
                    try {
                        TreeNode<K, V> r = this.root;
                        p = r == null ? null : ((TreeNode)r).findTreeNode(h, k, null);
                    }
                    finally {
                        Thread w;
                        int ls;
                        while (!U.compareAndSwapInt(this, LOCKSTATE, ls = this.lockState, ls - 4)) {
                        }
                        if (ls == 6 && (w = this.waiter) != null) {
                            LockSupport.unpark(w);
                        }
                    }
                    return p;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TreeNode<K, V> putTreeVal(int h, K k, V v) {
            block19: {
                TreeNode xp;
                int dir;
                Class kc = null;
                boolean searched = false;
                TreeNode p = this.root;
                do {
                    if (p == null) {
                        this.root = new TreeNode<K, V>(h, k, v, null, null, this.myHashingStrategy);
                        this.first = this.root;
                        break block19;
                    }
                    Object pk = p.key;
                    int ph = p.hash;
                    if (ph > h) {
                        dir = -1;
                    } else if (ph < h) {
                        dir = 1;
                    } else {
                        if (ConcurrentHashMap.isEqual(k, pk, this.myHashingStrategy)) {
                            return p;
                        }
                        if (kc == null && (kc = ConcurrentHashMap.comparableClassFor(k)) == null || (dir = ConcurrentHashMap.compareComparables(kc, k, pk)) == 0) {
                            if (!searched) {
                                TreeNode q;
                                searched = true;
                                TreeNode ch = p.left;
                                if (ch != null && (q = ch.findTreeNode(h, k, kc)) != null || (ch = p.right) != null && (q = ch.findTreeNode(h, k, kc)) != null) {
                                    return q;
                                }
                            }
                            dir = TreeBin.tieBreakOrder(k, pk);
                        }
                    }
                    xp = p;
                } while ((p = dir <= 0 ? p.left : p.right) != null);
                TreeNode<K, V> f = this.first;
                TreeNode<K, V> x = new TreeNode<K, V>(h, k, v, f, xp, this.myHashingStrategy);
                this.first = x;
                if (f != null) {
                    ((TreeNode)f).prev = (TreeNode)x;
                }
                if (dir <= 0) {
                    xp.left = (TreeNode)x;
                } else {
                    xp.right = (TreeNode)x;
                }
                if (!xp.red) {
                    ((TreeNode)x).red = true;
                } else {
                    this.lockRoot();
                    try {
                        this.root = TreeBin.balanceInsertion(this.root, x);
                    }
                    finally {
                        this.unlockRoot();
                    }
                }
            }
            assert (TreeBin.checkInvariants(this.root));
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean removeTreeNode(TreeNode<K, V> p) {
            TreeNode rl;
            TreeNode next = (TreeNode)p.next;
            TreeNode pred = p.prev;
            if (pred == null) {
                this.first = next;
            } else {
                pred.next = next;
            }
            if (next != null) {
                next.prev = pred;
            }
            if (this.first == null) {
                this.root = null;
                return true;
            }
            TreeNode r = this.root;
            if (r == null || r.right == null || (rl = r.left) == null || rl.left == null) {
                return true;
            }
            this.lockRoot();
            try {
                TreeNode pp;
                TreeNode replacement;
                TreeNode pl = p.left;
                TreeNode pr = p.right;
                if (pl != null && pr != null) {
                    TreeNode sl;
                    TreeNode s = pr;
                    while ((sl = s.left) != null) {
                        s = sl;
                    }
                    boolean c = s.red;
                    s.red = p.red;
                    p.red = c;
                    TreeNode sr = s.right;
                    TreeNode pp2 = p.parent;
                    if (s == pr) {
                        p.parent = s;
                        s.right = p;
                    } else {
                        TreeNode sp = s.parent;
                        if ((p.parent = sp) != null) {
                            if (s == sp.left) {
                                sp.left = p;
                            } else {
                                sp.right = p;
                            }
                        }
                        if ((s.right = pr) != null) {
                            pr.parent = s;
                        }
                    }
                    p.left = null;
                    if ((p.right = sr) != null) {
                        sr.parent = p;
                    }
                    if ((s.left = pl) != null) {
                        pl.parent = s;
                    }
                    if ((s.parent = pp2) == null) {
                        r = s;
                    } else if (p == pp2.left) {
                        pp2.left = s;
                    } else {
                        pp2.right = s;
                    }
                    replacement = sr != null ? sr : p;
                } else {
                    replacement = pl != null ? pl : (pr != null ? pr : p);
                }
                if (replacement != p) {
                    pp = replacement.parent = p.parent;
                    if (pp == null) {
                        r = replacement;
                    } else if (p == pp.left) {
                        pp.left = replacement;
                    } else {
                        pp.right = replacement;
                    }
                    p.left = (p.right = (p.parent = null));
                }
                TreeNode treeNode = this.root = p.red ? r : TreeBin.balanceDeletion(r, replacement);
                if (p == replacement && (pp = p.parent) != null) {
                    if (p == pp.left) {
                        pp.left = null;
                    } else if (p == pp.right) {
                        pp.right = null;
                    }
                    p.parent = null;
                }
            }
            finally {
                this.unlockRoot();
            }
            assert (TreeBin.checkInvariants(this.root));
            return false;
        }

        private static <K, V> TreeNode<K, V> rotateLeft(TreeNode<K, V> root2, TreeNode<K, V> p) {
            TreeNode r;
            if (p != null && (r = ((TreeNode)p).right) != null) {
                TreeNode pp;
                TreeNode rl = ((TreeNode)p).right = r.left;
                if (rl != null) {
                    rl.parent = (TreeNode)p;
                }
                if ((pp = (r.parent = ((TreeNode)p).parent)) == null) {
                    root2 = r;
                    root2.red = false;
                } else if (pp.left == p) {
                    pp.left = r;
                } else {
                    pp.right = r;
                }
                r.left = (TreeNode)p;
                ((TreeNode)p).parent = r;
            }
            return root2;
        }

        private static <K, V> TreeNode<K, V> rotateRight(TreeNode<K, V> root2, TreeNode<K, V> p) {
            TreeNode l;
            if (p != null && (l = ((TreeNode)p).left) != null) {
                TreeNode pp;
                TreeNode lr = ((TreeNode)p).left = l.right;
                if (lr != null) {
                    lr.parent = (TreeNode)p;
                }
                if ((pp = (l.parent = ((TreeNode)p).parent)) == null) {
                    root2 = l;
                    root2.red = false;
                } else if (pp.right == p) {
                    pp.right = l;
                } else {
                    pp.left = l;
                }
                l.right = (TreeNode)p;
                ((TreeNode)p).parent = l;
            }
            return root2;
        }

        private static <K, V> TreeNode<K, V> balanceInsertion(TreeNode<K, V> root2, TreeNode<K, V> x) {
            x.red = true;
            while (true) {
                TreeNode xpp;
                TreeNode xp;
                if ((xp = x.parent) == null) {
                    x.red = false;
                    return x;
                }
                if (!xp.red || (xpp = xp.parent) == null) {
                    return root2;
                }
                TreeNode xppl = xpp.left;
                if (xp == xppl) {
                    TreeNode xppr = xpp.right;
                    if (xppr != null && xppr.red) {
                        xppr.red = false;
                        xp.red = false;
                        xpp.red = true;
                        x = xpp;
                        continue;
                    }
                    if (x == xp.right) {
                        x = xp;
                        root2 = TreeBin.rotateLeft(root2, x);
                        xp = x.parent;
                        TreeNode treeNode = xpp = xp == null ? null : xp.parent;
                    }
                    if (xp == null) continue;
                    xp.red = false;
                    if (xpp == null) continue;
                    xpp.red = true;
                    root2 = TreeBin.rotateRight(root2, xpp);
                    continue;
                }
                if (xppl != null && xppl.red) {
                    xppl.red = false;
                    xp.red = false;
                    xpp.red = true;
                    x = xpp;
                    continue;
                }
                if (x == xp.left) {
                    x = xp;
                    root2 = TreeBin.rotateRight(root2, x);
                    xp = x.parent;
                    TreeNode treeNode = xpp = xp == null ? null : xp.parent;
                }
                if (xp == null) continue;
                xp.red = false;
                if (xpp == null) continue;
                xpp.red = true;
                root2 = TreeBin.rotateLeft(root2, xpp);
            }
        }

        private static <K, V> TreeNode<K, V> balanceDeletion(TreeNode<K, V> root2, TreeNode<K, V> x) {
            while (x != null && x != root2) {
                TreeNode sr;
                TreeNode sl;
                TreeNode<K, V> xp = ((TreeNode)x).parent;
                if (xp == null) {
                    ((TreeNode)x).red = false;
                    return x;
                }
                if (((TreeNode)x).red) {
                    ((TreeNode)x).red = false;
                    return root2;
                }
                TreeNode xpl = ((TreeNode)xp).left;
                if (xpl == x) {
                    TreeNode xpr = ((TreeNode)xp).right;
                    if (xpr != null && xpr.red) {
                        xpr.red = false;
                        ((TreeNode)xp).red = true;
                        root2 = TreeBin.rotateLeft(root2, xp);
                        xp = ((TreeNode)x).parent;
                        TreeNode treeNode = xpr = xp == null ? null : ((TreeNode)xp).right;
                    }
                    if (xpr == null) {
                        x = xp;
                        continue;
                    }
                    sl = xpr.left;
                    sr = xpr.right;
                    if (!(sr != null && sr.red || sl != null && sl.red)) {
                        xpr.red = true;
                        x = xp;
                        continue;
                    }
                    if (sr == null || !sr.red) {
                        if (sl != null) {
                            sl.red = false;
                        }
                        xpr.red = true;
                        root2 = TreeBin.rotateRight(root2, xpr);
                        xp = ((TreeNode)x).parent;
                        TreeNode treeNode = xpr = xp == null ? null : ((TreeNode)xp).right;
                    }
                    if (xpr != null) {
                        xpr.red = xp == null ? false : ((TreeNode)xp).red;
                        sr = xpr.right;
                        if (sr != null) {
                            sr.red = false;
                        }
                    }
                    if (xp != null) {
                        ((TreeNode)xp).red = false;
                        root2 = TreeBin.rotateLeft(root2, xp);
                    }
                    x = root2;
                    continue;
                }
                if (xpl != null && xpl.red) {
                    xpl.red = false;
                    ((TreeNode)xp).red = true;
                    root2 = TreeBin.rotateRight(root2, xp);
                    xp = ((TreeNode)x).parent;
                    TreeNode treeNode = xpl = xp == null ? null : ((TreeNode)xp).left;
                }
                if (xpl == null) {
                    x = xp;
                    continue;
                }
                sl = xpl.left;
                sr = xpl.right;
                if (!(sl != null && sl.red || sr != null && sr.red)) {
                    xpl.red = true;
                    x = xp;
                    continue;
                }
                if (sl == null || !sl.red) {
                    if (sr != null) {
                        sr.red = false;
                    }
                    xpl.red = true;
                    root2 = TreeBin.rotateLeft(root2, xpl);
                    xp = ((TreeNode)x).parent;
                    TreeNode treeNode = xpl = xp == null ? null : ((TreeNode)xp).left;
                }
                if (xpl != null) {
                    xpl.red = xp == null ? false : ((TreeNode)xp).red;
                    sl = xpl.left;
                    if (sl != null) {
                        sl.red = false;
                    }
                }
                if (xp != null) {
                    ((TreeNode)xp).red = false;
                    root2 = TreeBin.rotateRight(root2, xp);
                }
                x = root2;
            }
            return root2;
        }

        private static <K, V> boolean checkInvariants(TreeNode<K, V> t) {
            TreeNode tp = ((TreeNode)t).parent;
            TreeNode tl = ((TreeNode)t).left;
            TreeNode tr = ((TreeNode)t).right;
            TreeNode tb = ((TreeNode)t).prev;
            TreeNode tn = (TreeNode)t.next;
            if (tb != null && tb.next != t) {
                return false;
            }
            if (tn != null && tn.prev != t) {
                return false;
            }
            if (tp != null && t != tp.left && t != tp.right) {
                return false;
            }
            if (tl != null && (tl.parent != t || tl.hash > t.hash)) {
                return false;
            }
            if (tr != null && (tr.parent != t || tr.hash < t.hash)) {
                return false;
            }
            if (((TreeNode)t).red && tl != null && tl.red && tr != null && tr.red) {
                return false;
            }
            if (tl != null && !TreeBin.checkInvariants(tl)) {
                return false;
            }
            return tr == null || TreeBin.checkInvariants(tr);
        }

        static {
            try {
                U = AtomicFieldUpdater.getUnsafe();
                Class<TreeBin> k = TreeBin.class;
                LOCKSTATE = U.objectFieldOffset(k.getDeclaredField("lockState"));
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
    }

    private static final class TreeNode<K, V>
    extends Node<K, V> {
        private TreeNode<K, V> parent;
        private TreeNode<K, V> left;
        private TreeNode<K, V> right;
        private TreeNode<K, V> prev;
        private boolean red;

        TreeNode(int hash, K key, V val, Node<K, V> next, TreeNode<K, V> parent2, TObjectHashingStrategy<K> hashingStrategy) {
            super(hash, key, val, next, hashingStrategy);
            this.parent = parent2;
        }

        @Override
        Node<K, V> find(int h, Object k) {
            return this.findTreeNode(h, k, null);
        }

        private TreeNode<K, V> findTreeNode(int h, Object k, Class<?> kc) {
            if (k != null) {
                TreeNode<K, V> p = this;
                do {
                    int dir;
                    Object pk = p.key;
                    TreeNode<K, V> pl = p.left;
                    TreeNode<K, V> pr = p.right;
                    int ph = p.hash;
                    if (ph > h) {
                        p = pl;
                        continue;
                    }
                    if (ph < h) {
                        p = pr;
                        continue;
                    }
                    if (ConcurrentHashMap.isEqual(k, pk, this.myHashingStrategy)) {
                        return p;
                    }
                    if (pl == null) {
                        p = pr;
                        continue;
                    }
                    if (pr == null) {
                        p = pl;
                        continue;
                    }
                    if ((kc != null || (kc = ConcurrentHashMap.comparableClassFor(k)) != null) && (dir = ConcurrentHashMap.compareComparables(kc, k, pk)) != 0) {
                        p = dir < 0 ? pl : pr;
                        continue;
                    }
                    TreeNode<K, V> q = super.findTreeNode(h, k, kc);
                    if (q != null) {
                        return q;
                    }
                    p = pl;
                } while (p != null);
            }
            return null;
        }
    }

    static final class CounterCell {
        volatile long value;

        CounterCell(long x) {
            this.value = x;
        }
    }

    private static final class ForwardingNode<K, V>
    extends Node<K, V> {
        private final Node<K, V>[] nextTable;

        private ForwardingNode(Node<K, V>[] tab, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
            if (hashingStrategy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/containers/ConcurrentHashMap$ForwardingNode", "<init>"));
            }
            super(-1, null, null, null, hashingStrategy);
            this.nextTable = tab;
        }

        @Override
        Node<K, V> find(int h, Object k) {
            Node[] tab = this.nextTable;
            block0: while (true) {
                Node e;
                int n;
                if (k == null || tab == null || (n = tab.length) == 0 || (e = ConcurrentHashMap.tabAt(tab, n - 1 & h)) == null) {
                    return null;
                }
                do {
                    int eh;
                    if ((eh = e.hash) == h && ConcurrentHashMap.isEqual(k, e.key, this.myHashingStrategy)) {
                        return e;
                    }
                    if (eh >= 0) continue;
                    if (e instanceof ForwardingNode) {
                        tab = ((ForwardingNode)e).nextTable;
                        continue block0;
                    }
                    return e.find(h, k);
                } while ((e = e.next) != null);
                break;
            }
            return null;
        }
    }

    private static class Node<K, V>
    implements Map.Entry<K, V> {
        final int hash;
        final K key;
        volatile V val;
        volatile Node<K, V> next;
        @NotNull
        final TObjectHashingStrategy<K> myHashingStrategy;

        Node(int hash, K key, V val, Node<K, V> next, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
            if (hashingStrategy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/containers/ConcurrentHashMap$Node", "<init>"));
            }
            this.hash = hash;
            this.key = key;
            this.val = val;
            this.next = next;
            this.myHashingStrategy = hashingStrategy;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.val;
        }

        @Override
        public final int hashCode() {
            return this.key.hashCode() ^ this.val.hashCode();
        }

        public final String toString() {
            return this.key + "=" + this.val;
        }

        @Override
        public final V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean equals(Object o) {
            V u;
            Object v;
            Map.Entry e;
            Object k;
            return !(!(o instanceof Map.Entry) || (k = (e = (Map.Entry)o).getKey()) == null || (v = e.getValue()) == null || k != this.key && !this.myHashingStrategy.equals(k, this.key) || v != (u = this.val) && !v.equals(u));
        }

        Node<K, V> find(int h, Object k) {
            Node<K, V> e = this;
            if (k != null) {
                do {
                    K ek;
                    if (e.hash != h || (ek = e.key) != k && (ek == null || !this.myHashingStrategy.equals(k, ek))) continue;
                    return e;
                } while ((e = e.next) != null);
            }
            return null;
        }
    }
}

