/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.w2lcommon.filter;

import com.sun.star.awt.XDialogEventHandler;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertyAccess;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.document.XDocumentPropertiesSupplier;
import com.sun.star.frame.XDesktop;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XServiceName;
import com.sun.star.lang.XTypeProvider;
import com.sun.star.ui.dialogs.XExecutableDialog;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.XChangesBatch;
import java.util.HashSet;
import org.openoffice.da.comp.w2lcommon.helper.DialogBase;
import org.openoffice.da.comp.w2lcommon.helper.MacroExpander;
import org.openoffice.da.comp.w2lcommon.helper.PropertyHelper;
import org.openoffice.da.comp.w2lcommon.helper.XPropertySetHelper;

public abstract class OptionsDialogBase
extends DialogBase
implements XPropertyAccess {
    protected XMultiServiceFactory xMSF = null;
    private PropertyValue[] mediaProps = null;
    private String[] sConfigNames = null;
    private HashSet<String> lockedOptions = new HashSet();

    protected abstract void loadSettings(XPropertySet var1);

    protected abstract void saveSettings(XPropertySet var1, PropertyHelper var2);

    @Override
    public abstract String getDialogLibraryName();

    @Override
    public abstract String getDialogName();

    public abstract String getRegistryPath();

    public OptionsDialogBase(XComponentContext xContext) {
        super(xContext);
    }

    @Override
    public void initialize() {
        try {
            Object view = this.getRegistryView(false);
            XPropertySet xProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)view);
            this.loadSettings(xProps);
            this.disposeRegistryView(view);
        }
        catch (com.sun.star.uno.Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void endDialog() {
        try {
            Object rwview = this.getRegistryView(true);
            XPropertySet xProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)rwview);
            PropertyHelper filterData = new PropertyHelper();
            this.saveSettings(xProps, filterData);
            XChangesBatch xUpdateContext = (XChangesBatch)UnoRuntime.queryInterface(XChangesBatch.class, (Object)rwview);
            try {
                xUpdateContext.commitChanges();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.disposeRegistryView(rwview);
            PropertyHelper helper = new PropertyHelper(this.mediaProps);
            helper.put("FilterData", filterData.toArray());
            this.mediaProps = helper.toArray();
        }
        catch (com.sun.star.uno.Exception exception) {
            // empty catch block
        }
    }

    private String getTemplateName() {
        try {
            Object desktop = this.xContext.getServiceManager().createInstanceWithContext("com.sun.star.frame.Desktop", this.xContext);
            XDesktop xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)desktop);
            XComponent xComponent = xDesktop.getCurrentComponent();
            XDocumentPropertiesSupplier xDocPropsSuppl = (XDocumentPropertiesSupplier)UnoRuntime.queryInterface(XDocumentPropertiesSupplier.class, (Object)xComponent);
            return xDocPropsSuppl.getDocumentProperties().getTemplateName();
        }
        catch (Exception e) {
            return "";
        }
    }

    private Object getRegistryView(boolean bUpdate) throws com.sun.star.uno.Exception {
        Object provider = this.xMSF.createInstance("com.sun.star.configuration.ConfigurationProvider");
        XMultiServiceFactory xProvider = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)provider);
        Object[] args = new PropertyValue[]{new PropertyValue()};
        args[0].Name = "nodepath";
        args[0].Value = this.getRegistryPath();
        String sServiceName = bUpdate ? "com.sun.star.configuration.ConfigurationUpdateAccess" : "com.sun.star.configuration.ConfigurationAccess";
        Object view = xProvider.createInstanceWithArguments(sServiceName, args);
        return view;
    }

    private void disposeRegistryView(Object view) {
        XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)view);
        xComponent.dispose();
    }

    @Override
    public Type[] getTypes() {
        Type[] typeReturn = new Type[]{};
        try {
            typeReturn = new Type[]{new Type(XServiceName.class), new Type(XServiceInfo.class), new Type(XTypeProvider.class), new Type(XExecutableDialog.class), new Type(XPropertyAccess.class), new Type(XDialogEventHandler.class)};
        }
        catch (Exception exception) {
            // empty catch block
        }
        return typeReturn;
    }

    public PropertyValue[] getPropertyValues() {
        return this.mediaProps;
    }

    public void setPropertyValues(PropertyValue[] props) {
        this.mediaProps = props;
    }

    protected void updateLockedOptions() {
        this.lockedOptions.clear();
        short nItem = this.getListBoxSelectedItem("Config");
        int nStdConfigs = this.getListBoxStringItemList("Config").length - this.sConfigNames.length;
        if (nItem >= nStdConfigs) {
            String sName = this.sConfigNames[nItem - nStdConfigs];
            try {
                Object view = this.getRegistryView(false);
                XPropertySet xProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)view);
                Object configurations = XPropertySetHelper.getPropertyValue(xProps, "Configurations");
                XNameAccess xConfigurations = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)configurations);
                String sLockedOptions = "";
                Object config = xConfigurations.getByName(sName);
                XPropertySet xCfgProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)config);
                sLockedOptions = XPropertySetHelper.getPropertyValueAsString(xCfgProps, "LockedOptions");
                this.disposeRegistryView(view);
                int nStart = 0;
                for (int i = 0; i < sLockedOptions.length(); ++i) {
                    if (sLockedOptions.charAt(i) != ',') continue;
                    this.lockedOptions.add(sLockedOptions.substring(nStart, i).trim());
                    nStart = i + 1;
                }
                if (nStart < sLockedOptions.length()) {
                    this.lockedOptions.add(sLockedOptions.substring(nStart).trim());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected boolean isLocked(String sOptionName) {
        return this.lockedOptions.contains(sOptionName);
    }

    protected void loadConfig(XPropertySet xProps) {
        int i;
        String[] sStdConfigs = this.getListBoxStringItemList("Config");
        int nStdConfigs = sStdConfigs.length;
        Object configurations = XPropertySetHelper.getPropertyValue(xProps, "Configurations");
        XNameAccess xConfigurations = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)configurations);
        this.sConfigNames = xConfigurations.getElementNames();
        int nRegConfigs = this.sConfigNames.length;
        String[] sAllConfigs = new String[nStdConfigs + nRegConfigs];
        for (i = 0; i < nStdConfigs; i = (int)((short)(i + 1))) {
            sAllConfigs[i] = sStdConfigs[i];
        }
        for (i = 0; i < nRegConfigs; i = (int)((short)(i + 1))) {
            try {
                Object config = xConfigurations.getByName(this.sConfigNames[i]);
                XPropertySet xCfgProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)config);
                sAllConfigs[nStdConfigs + i] = XPropertySetHelper.getPropertyValueAsString(xCfgProps, "DisplayName");
                continue;
            }
            catch (Exception e) {
                sAllConfigs[nStdConfigs + i] = "";
            }
        }
        this.setListBoxStringItemList("Config", sAllConfigs);
        if (nStdConfigs + nRegConfigs <= 12) {
            this.setListBoxLineCount("Config", (short)(nStdConfigs + nRegConfigs));
        } else {
            this.setListBoxLineCount("Config", (short)12);
        }
        String sTheTemplateName = this.getTemplateName();
        Object templates = XPropertySetHelper.getPropertyValue(xProps, "Templates");
        XNameAccess xTemplates = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)templates);
        String[] sTemplateNames = xTemplates.getElementNames();
        for (int i2 = 0; i2 < sTemplateNames.length; ++i2) {
            try {
                Object template = xTemplates.getByName(sTemplateNames[i2]);
                XPropertySet xTplProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)template);
                String sTemplateName = XPropertySetHelper.getPropertyValueAsString(xTplProps, "TemplateName");
                if (!sTemplateName.equals(sTheTemplateName)) continue;
                String sConfigName = XPropertySetHelper.getPropertyValueAsString(xTplProps, "ConfigName");
                for (int j = 0; j < nRegConfigs; j = (int)((short)(j + 1))) {
                    if (!this.sConfigNames[j].equals(sConfigName)) continue;
                    this.setListBoxSelectedItem("Config", (short)(nStdConfigs + j));
                    return;
                }
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        short nConfig = XPropertySetHelper.getPropertyValueAsShort(xProps, "Config");
        if (nConfig < nStdConfigs) {
            this.setListBoxSelectedItem("Config", nConfig);
        } else {
            String sConfigName = XPropertySetHelper.getPropertyValueAsString(xProps, "ConfigName");
            for (int i3 = 0; i3 < nRegConfigs; i3 = (int)((short)(i3 + 1))) {
                if (!this.sConfigNames[i3].equals(sConfigName)) continue;
                this.setListBoxSelectedItem("Config", (short)(nStdConfigs + i3));
            }
        }
    }

    protected short saveConfig(XPropertySet xProps, PropertyHelper filterData) {
        int nStdConfigs;
        Object configurations = XPropertySetHelper.getPropertyValue(xProps, "Configurations");
        XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)configurations);
        short nConfig = this.getListBoxSelectedItem("Config");
        if (nConfig >= (nStdConfigs = this.getListBoxStringItemList("Config").length - this.sConfigNames.length)) {
            int i = nConfig - nStdConfigs;
            XPropertySetHelper.setPropertyValue(xProps, "ConfigName", this.sConfigNames[i]);
            try {
                Object config = xNameAccess.getByName(this.sConfigNames[i]);
                XPropertySet xCfgProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)config);
                MacroExpander expander = new MacroExpander(this.xContext);
                filterData.put("ConfigURL", expander.expandMacros(XPropertySetHelper.getPropertyValueAsString(xCfgProps, "ConfigURL")));
                filterData.put("TemplateURL", expander.expandMacros(XPropertySetHelper.getPropertyValueAsString(xCfgProps, "TargetTemplateURL")));
                filterData.put("StyleSheetURL", expander.expandMacros(XPropertySetHelper.getPropertyValueAsString(xCfgProps, "StyleSheetURL")));
                Object resources = XPropertySetHelper.getPropertyValue(xCfgProps, "Resources");
                XNameAccess xResourceNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)resources);
                if (xResourceNameAccess != null) {
                    String[] sResourceNames;
                    StringBuilder buf = new StringBuilder();
                    for (String sName : sResourceNames = xResourceNameAccess.getElementNames()) {
                        Object resource = xResourceNameAccess.getByName(sName);
                        XPropertySet xResourceProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)resource);
                        String sURL = expander.expandMacros(XPropertySetHelper.getPropertyValueAsString(xResourceProps, "URL"));
                        String sFileName = expander.expandMacros(XPropertySetHelper.getPropertyValueAsString(xResourceProps, "FileName"));
                        String sMediaType = expander.expandMacros(XPropertySetHelper.getPropertyValueAsString(xResourceProps, "MediaType"));
                        if (buf.length() > 0) {
                            buf.append(';');
                        }
                        buf.append(sURL).append("::").append(sFileName).append("::").append(sMediaType);
                    }
                    filterData.put("Resources", buf.toString());
                }
            }
            catch (Exception e) {}
        } else {
            XPropertySetHelper.setPropertyValue(xProps, "ConfigName", "");
        }
        XPropertySetHelper.setPropertyValue(xProps, "Config", nConfig);
        return nConfig;
    }

    protected boolean loadCheckBoxOption(XPropertySet xProps, String sName) {
        boolean bValue = XPropertySetHelper.getPropertyValueAsBoolean(xProps, sName);
        this.setCheckBoxStateAsBoolean(sName, bValue);
        return bValue;
    }

    protected boolean saveCheckBoxOption(XPropertySet xProps, String sName) {
        boolean bValue = this.getCheckBoxStateAsBoolean(sName);
        XPropertySetHelper.setPropertyValue(xProps, sName, bValue);
        return bValue;
    }

    protected boolean saveCheckBoxOption(XPropertySet xProps, PropertyHelper filterData, String sName, String sOptionName) {
        boolean bValue = this.saveCheckBoxOption(xProps, sName);
        if (!this.isLocked(sOptionName)) {
            filterData.put(sOptionName, Boolean.toString(bValue));
        }
        return bValue;
    }

    protected short loadListBoxOption(XPropertySet xProps, String sName) {
        short nValue = XPropertySetHelper.getPropertyValueAsShort(xProps, sName);
        this.setListBoxSelectedItem(sName, nValue);
        return nValue;
    }

    protected short saveListBoxOption(XPropertySet xProps, String sName) {
        short nValue = this.getListBoxSelectedItem(sName);
        XPropertySetHelper.setPropertyValue(xProps, sName, nValue);
        return nValue;
    }

    protected short saveListBoxOption(XPropertySet xProps, PropertyHelper filterData, String sName, String sOptionName, String[] sValues) {
        short nValue = this.saveListBoxOption(xProps, sName);
        if (!this.isLocked(sOptionName) && nValue >= 0 && nValue < sValues.length) {
            filterData.put(sOptionName, sValues[nValue]);
        }
        return nValue;
    }

    protected String loadComboBoxOption(XPropertySet xProps, String sName) {
        String sValue = XPropertySetHelper.getPropertyValueAsString(xProps, sName);
        this.setComboBoxText(sName, sValue);
        return sValue;
    }

    protected String saveComboBoxOption(XPropertySet xProps, String sName) {
        String sValue = this.getComboBoxText(sName);
        XPropertySetHelper.setPropertyValue(xProps, sName, sValue);
        return sValue;
    }

    protected String saveComboBoxOption(XPropertySet xProps, PropertyHelper filterData, String sName, String sOptionName) {
        String sValue = this.saveComboBoxOption(xProps, sName);
        if (!this.isLocked(sOptionName)) {
            filterData.put(sOptionName, sValue);
        }
        return sValue;
    }

    protected String loadTextFieldOption(XPropertySet xProps, String sName) {
        String sValue = XPropertySetHelper.getPropertyValueAsString(xProps, sName);
        this.setTextFieldText(sName, sValue);
        return sValue;
    }

    protected String saveTextFieldOption(XPropertySet xProps, String sName) {
        String sValue = this.getTextFieldText(sName);
        XPropertySetHelper.setPropertyValue(xProps, sName, sValue);
        return sValue;
    }

    protected String saveTextFieldOption(XPropertySet xProps, PropertyHelper filterData, String sName, String sOptionName) {
        String sValue = this.saveTextFieldOption(xProps, sName);
        if (!this.isLocked(sOptionName)) {
            filterData.put(sOptionName, sValue);
        }
        return sValue;
    }

    protected int loadNumericOption(XPropertySet xProps, String sName) {
        int nValue = XPropertySetHelper.getPropertyValueAsInteger(xProps, sName);
        this.setNumericFieldValue(sName, nValue);
        return nValue;
    }

    protected int saveNumericOption(XPropertySet xProps, String sName) {
        int nValue = this.getNumericFieldValue(sName);
        XPropertySetHelper.setPropertyValue(xProps, sName, nValue);
        return nValue;
    }

    protected int saveNumericOptionAsPercentage(XPropertySet xProps, PropertyHelper filterData, String sName, String sOptionName) {
        int nValue = this.saveNumericOption(xProps, sName);
        if (!this.isLocked(sOptionName)) {
            filterData.put(sOptionName, Integer.toString(nValue) + "%");
        }
        return nValue;
    }
}

