// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IGESSolid_Shell_HeaderFile
#define _IGESSolid_Shell_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_IGESSolid_Shell.hxx>

#include <Handle_IGESSolid_HArray1OfFace.hxx>
#include <Handle_TColStd_HArray1OfInteger.hxx>
#include <IGESData_IGESEntity.hxx>
#include <Standard_Boolean.hxx>
#include <Standard_Integer.hxx>
#include <Handle_IGESSolid_Face.hxx>
class IGESSolid_HArray1OfFace;
class TColStd_HArray1OfInteger;
class Standard_DimensionMismatch;
class Standard_OutOfRange;
class IGESSolid_Face;


//! defines Shell, Type <514> Form Number <1>
//! in package IGESSolid
//! Shell entity is a connected entity of dimensionality 2
//! which divides R3 into two arcwise connected open subsets,
//! one of which is finite. Inside of the shell is defined to
//! be the finite region.
//! From IGES-5.3, Form can be <1> for Closed or <2> for Open
class IGESSolid_Shell : public IGESData_IGESEntity
{

public:

  
  Standard_EXPORT IGESSolid_Shell();
  
  //! This method is used to set the fields of the class Shell
  //! - allFaces  : the faces comprising the shell
  //! - allOrient : the orientation flags of the shell
  //! raises exception if length of allFaces & allOrient do not match
  Standard_EXPORT   void Init (const Handle(IGESSolid_HArray1OfFace)& allFaces, const Handle(TColStd_HArray1OfInteger)& allOrient) ;
  
  //! Tells if a Shell is Closed, i.e. if its FormNumber is 1
  //! (this is the default)
  Standard_EXPORT   Standard_Boolean IsClosed()  const;
  
  //! Sets or Unsets the Closed status (FormNumber = 1 else 2)
  Standard_EXPORT   void SetClosed (const Standard_Boolean closed) ;
  
  //! returns the number of the face entities in the shell
  Standard_EXPORT   Standard_Integer NbFaces()  const;
  
  //! returns the Index'th face entity of the shell
  //! raises exception if Index <= 0 or Index > NbFaces()
  Standard_EXPORT   Handle(IGESSolid_Face) Face (const Standard_Integer Index)  const;
  
  //! returns the orientation of Index'th face w.r.t the direction of
  //! the underlying surface
  //! raises exception if Index <= 0 or Index > NbFaces()
  Standard_EXPORT   Standard_Boolean Orientation (const Standard_Integer Index)  const;




  DEFINE_STANDARD_RTTI(IGESSolid_Shell)

protected:




private: 


  Handle(IGESSolid_HArray1OfFace) theFaces;
  Handle(TColStd_HArray1OfInteger) theOrientation;


};







#endif // _IGESSolid_Shell_HeaderFile
