/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.ParsingException;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.imap.protocol.Item;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.mail.internet.MailDateFormat;

public class INTERNALDATE
implements Item {
    static final char[] name = new char[]{'I', 'N', 'T', 'E', 'R', 'N', 'A', 'L', 'D', 'A', 'T', 'E'};
    public int msgno;
    protected Date date;
    private static MailDateFormat mailDateFormat = new MailDateFormat();
    private static SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss ", Locale.US);

    public INTERNALDATE(FetchResponse fetchResponse) throws ParsingException {
        this.msgno = fetchResponse.getNumber();
        fetchResponse.skipSpaces();
        String string = fetchResponse.readString();
        if (string == null) {
            throw new ParsingException("INTERNALDATE is NIL");
        }
        try {
            this.date = mailDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            throw new ParsingException("INTERNALDATE parse error");
        }
    }

    public Date getDate() {
        return this.date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(Date date) {
        StringBuffer stringBuffer = new StringBuffer();
        SimpleDateFormat simpleDateFormat = df;
        synchronized (simpleDateFormat) {
            df.format(date, stringBuffer, new FieldPosition(0));
        }
        int n = -date.getTimezoneOffset();
        if (n < 0) {
            stringBuffer.append('-');
            n = -n;
        } else {
            stringBuffer.append('+');
        }
        int n2 = n / 60;
        int n3 = n % 60;
        stringBuffer.append(Character.forDigit(n2 / 10, 10));
        stringBuffer.append(Character.forDigit(n2 % 10, 10));
        stringBuffer.append(Character.forDigit(n3 / 10, 10));
        stringBuffer.append(Character.forDigit(n3 % 10, 10));
        return stringBuffer.toString();
    }
}

