/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import org.directwebremoting.ConversionException;
import org.directwebremoting.extend.NestedProperty;
import org.directwebremoting.extend.Property;
import org.directwebremoting.util.LocalUtil;

public class ConstructorProperty
implements Property {
    private final Constructor<?> constructor;
    private final String parameterName;
    private final int parameterNumber;

    public ConstructorProperty(Constructor<?> constructor, String parameterName, int parameterNumber) {
        this.constructor = constructor;
        this.parameterName = parameterName;
        this.parameterNumber = parameterNumber;
    }

    @Override
    public String getName() {
        return this.parameterName;
    }

    @Override
    public Class<?> getPropertyType() {
        Type[] types = this.constructor.getGenericParameterTypes();
        if (this.parameterNumber >= types.length) {
            throw new IllegalArgumentException("parameterNumber=" + this.parameterNumber + " is too big when method=" + this.constructor.getName() + " returns genericParameterTypes.length=" + types.length);
        }
        Type parameterType = types[this.parameterNumber];
        return LocalUtil.toClass(parameterType, this.toString());
    }

    @Override
    public Property createChild(int nextNewParameterNumber) {
        Type[] types = this.constructor.getGenericParameterTypes();
        if (this.parameterNumber >= types.length) {
            throw new IllegalArgumentException("parameterNumber=" + this.parameterNumber + " is too big when method=" + this.constructor.getName() + " returns genericParameterTypes.length=" + types.length);
        }
        Type parameterType = types[this.parameterNumber];
        return new NestedProperty(this, this.constructor, parameterType, this.parameterNumber, nextNewParameterNumber);
    }

    @Override
    public Object getValue(Object bean) throws ConversionException {
        throw new UnsupportedOperationException("Can't get value from constructor parameter");
    }

    @Override
    public void setValue(Object bean, Object value) throws ConversionException {
        throw new UnsupportedOperationException("Can't set value to constructor parameter");
    }

    public int hashCode() {
        return this.constructor.hashCode() + this.parameterNumber;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConstructorProperty that = (ConstructorProperty)obj;
        if (!this.constructor.equals(that.constructor)) {
            return false;
        }
        return this.parameterNumber == that.parameterNumber;
    }

    public String toString() {
        return "ConstructorProperty[ctor=" + this.constructor.getName() + ",p#=" + this.parameterNumber + "]";
    }
}

