/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.KeyedFactoryEPBean;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ExceptionUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.PicoContainer;

public abstract class KeyedExtensionFactory<T, KeyT> {
    private final Class<T> myInterfaceClass;
    private final ExtensionPointName<KeyedFactoryEPBean> myEpName;
    private final PicoContainer myPicoContainer;

    public KeyedExtensionFactory(@NotNull Class<T> interfaceClass, @NonNls @NotNull ExtensionPointName<KeyedFactoryEPBean> epName, @NotNull PicoContainer picoContainer) {
        if (interfaceClass == null) {
            KeyedExtensionFactory.$$$reportNull$$$0(0);
        }
        if (epName == null) {
            KeyedExtensionFactory.$$$reportNull$$$0(1);
        }
        if (picoContainer == null) {
            KeyedExtensionFactory.$$$reportNull$$$0(2);
        }
        this.myInterfaceClass = interfaceClass;
        this.myEpName = epName;
        this.myPicoContainer = picoContainer;
    }

    @NotNull
    public T get() {
        final KeyedFactoryEPBean[] epBeans = Extensions.getExtensions(this.myEpName);
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object keyArg = args[0];
                String key = KeyedExtensionFactory.this.getKey(keyArg);
                Object result = KeyedExtensionFactory.this.getByKey(epBeans, key, method, args);
                if (result == null) {
                    result = KeyedExtensionFactory.this.getByKey(epBeans, null, method, args);
                }
                return result;
            }
        };
        Object object = Proxy.newProxyInstance(this.myInterfaceClass.getClassLoader(), new Class[]{this.myInterfaceClass}, handler);
        if (object == null) {
            KeyedExtensionFactory.$$$reportNull$$$0(3);
        }
        return (T)object;
    }

    public T getByKey(@NotNull KeyT key) {
        KeyedFactoryEPBean[] epBeans;
        if (key == null) {
            KeyedExtensionFactory.$$$reportNull$$$0(4);
        }
        for (KeyedFactoryEPBean epBean : epBeans = Extensions.getExtensions(this.myEpName)) {
            if (!Comparing.strEqual((String)this.getKey(key), (String)epBean.key)) continue;
            try {
                if (epBean.implementationClass == null) continue;
                return epBean.instantiate(epBean.implementationClass, this.myPicoContainer);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private T getByKey(KeyedFactoryEPBean[] epBeans, String key, Method method, Object[] args) {
        Object result = null;
        for (KeyedFactoryEPBean epBean : epBeans) {
            if (!Comparing.strEqual((String)epBean.key, (String)key, (boolean)true)) continue;
            try {
                if (epBean.implementationClass != null) {
                    result = epBean.instantiate(epBean.implementationClass, this.myPicoContainer);
                } else {
                    Object factory = epBean.instantiate(epBean.factoryClass, this.myPicoContainer);
                    result = method.invoke(factory, args);
                }
                if (result == null) continue;
                break;
            }
            catch (InvocationTargetException e) {
                ExceptionUtil.rethrowUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return (T)result;
    }

    public abstract String getKey(@NotNull KeyT var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "epName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "picoContainer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/KeyedExtensionFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/KeyedExtensionFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getByKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

