/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.LineTokenizer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.UIBasedFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryContent
extends DiffContent {
    private final Project myProject;
    private final byte[] myBytes;
    private final Charset myCharset;
    private final FileType myFileType;
    private final String myFilePath;
    private Document myDocument;

    public BinaryContent(@NotNull Project project, byte[] bytes, @Nullable Charset charset, @NotNull FileType fileType, @Nullable String filePath2) {
        if (project == null) {
            BinaryContent.$$$reportNull$$$0(0);
        }
        if (fileType == null) {
            BinaryContent.$$$reportNull$$$0(1);
        }
        this.myDocument = null;
        this.myProject = project;
        this.myBytes = bytes;
        this.myCharset = fileType.isBinary() ? null : charset;
        this.myFileType = fileType;
        this.myFilePath = filePath2;
    }

    @Override
    @Nullable
    public Document getDocument() {
        if (this.myDocument == null) {
            if (this.isBinary()) {
                return null;
            }
            String text = null;
            try {
                Charset charset = (Charset)ObjectUtils.notNull((Object)this.myCharset, (Object)EncodingProjectManager.getInstance(this.myProject).getDefaultCharset());
                text = CharsetToolkit.bytesToString((byte[])this.myBytes, (Charset)charset);
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                // empty catch block
            }
            if (text == null) {
                text = new String(this.myBytes);
            }
            text = LineTokenizer.correctLineSeparators(text);
            this.myDocument = EditorFactory.getInstance().createDocument(text);
            this.myDocument.setReadOnly(true);
        }
        return this.myDocument;
    }

    @Override
    public OpenFileDescriptor getOpenFileDescriptor(int offset) {
        VirtualFile file = this.findVirtualFile();
        return file == null ? null : new OpenFileDescriptor(this.myProject, file, offset);
    }

    @Nullable
    private VirtualFile findVirtualFile() {
        return this.myFilePath != null ? LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)this.myFilePath)) : null;
    }

    @Override
    @Nullable
    public VirtualFile getFile() {
        VirtualFile file;
        if (this.myFileType instanceof UIBasedFileType && (file = this.findVirtualFile()) != null) {
            LightVirtualFile lightFile = new LightVirtualFile(file, new String(this.myBytes), 1L);
            lightFile.setOriginalFile(file);
            return lightFile;
        }
        return null;
    }

    @Override
    @NotNull
    public FileType getContentType() {
        FileType fileType = this.myFileType;
        if (fileType == null) {
            BinaryContent.$$$reportNull$$$0(2);
        }
        return fileType;
    }

    @Override
    public byte[] getBytes() throws IOException {
        return this.myBytes;
    }

    @Override
    public boolean isBinary() {
        return this.myCharset == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/BinaryContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/BinaryContent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

