/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.impl.config.PlainTextDescriptor;
import com.intellij.codeInsight.intention.impl.config.ResourceTextDescriptor;
import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class BeforeAfterActionMetaData {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.config.BeforeAfterActionMetaData");
    protected static final TextDescriptor[] EMPTY_EXAMPLE = new TextDescriptor[0];
    protected static final TextDescriptor EMPTY_DESCRIPTION = new PlainTextDescriptor("", "");
    @NonNls
    protected static final String DESCRIPTION_FILE_NAME = "description.html";
    @NonNls
    static final String EXAMPLE_USAGE_URL_SUFFIX = ".template";
    @NonNls
    private static final String BEFORE_TEMPLATE_PREFIX = "before";
    @NonNls
    private static final String AFTER_TEMPLATE_PREFIX = "after";
    protected final ClassLoader myLoader;
    protected final String myDescriptionDirectoryName;
    protected TextDescriptor[] myExampleUsagesBefore = null;
    protected TextDescriptor[] myExampleUsagesAfter = null;
    protected TextDescriptor myDescription = null;

    public BeforeAfterActionMetaData(ClassLoader loader, String descriptionDirectoryName) {
        this.myLoader = loader;
        this.myDescriptionDirectoryName = descriptionDirectoryName;
    }

    public BeforeAfterActionMetaData(TextDescriptor description, TextDescriptor[] exampleUsagesBefore, TextDescriptor[] exampleUsagesAfter) {
        this.myLoader = null;
        this.myDescriptionDirectoryName = null;
        this.myExampleUsagesBefore = exampleUsagesBefore;
        this.myExampleUsagesAfter = exampleUsagesAfter;
        this.myDescription = description;
    }

    @NotNull
    private static TextDescriptor[] retrieveURLs(@NotNull URL descriptionDirectory, @NotNull String prefix, @NotNull String suffix) throws MalformedURLException {
        FileType[] fileTypes;
        if (descriptionDirectory == null) {
            BeforeAfterActionMetaData.$$$reportNull$$$0(0);
        }
        if (prefix == null) {
            BeforeAfterActionMetaData.$$$reportNull$$$0(1);
        }
        if (suffix == null) {
            BeforeAfterActionMetaData.$$$reportNull$$$0(2);
        }
        ArrayList<ResourceTextDescriptor> urls = new ArrayList<ResourceTextDescriptor>();
        for (FileType fileType : fileTypes = FileTypeManager.getInstance().getRegisteredFileTypes()) {
            String[] extensions;
            block5: for (String extension : extensions = FileTypeManager.getInstance().getAssociatedExtensions(fileType)) {
                int i = 0;
                while (true) {
                    URL url = new URL(descriptionDirectory.toExternalForm() + "/" + prefix + "." + extension + (i == 0 ? "" : Integer.toString(i)) + suffix);
                    try {
                        InputStream inputStream = url.openStream();
                        inputStream.close();
                        urls.add(new ResourceTextDescriptor(url));
                    }
                    catch (IOException ioe) {
                        continue block5;
                    }
                    ++i;
                }
            }
        }
        if (urls.isEmpty()) {
            String[] children2;
            Exception cause = null;
            try {
                URI uri = descriptionDirectory.toURI();
                children2 = uri.isOpaque() ? null : (String[])ObjectUtils.notNull((Object)new File(uri).list(), (Object)ArrayUtil.EMPTY_STRING_ARRAY);
            }
            catch (IllegalArgumentException | URISyntaxException e) {
                cause = e;
                children2 = null;
            }
            LOG.error("URLs not found for available file types and prefix: '" + prefix + "', suffix: '" + suffix + "'; in directory: '" + descriptionDirectory + "'" + (children2 == null ? "" : "; directory contents: " + Arrays.asList(children2)), (Throwable)cause);
            if (EMPTY_EXAMPLE == null) {
                BeforeAfterActionMetaData.$$$reportNull$$$0(3);
            }
            return EMPTY_EXAMPLE;
        }
        TextDescriptor[] textDescriptorArray = urls.toArray(new TextDescriptor[urls.size()]);
        if (textDescriptorArray == null) {
            BeforeAfterActionMetaData.$$$reportNull$$$0(4);
        }
        return textDescriptorArray;
    }

    @NotNull
    public TextDescriptor[] getExampleUsagesBefore() {
        if (this.myExampleUsagesBefore == null) {
            try {
                this.myExampleUsagesBefore = BeforeAfterActionMetaData.retrieveURLs(this.getDirURL(), BEFORE_TEMPLATE_PREFIX, EXAMPLE_USAGE_URL_SUFFIX);
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
                if (EMPTY_EXAMPLE == null) {
                    BeforeAfterActionMetaData.$$$reportNull$$$0(5);
                }
                return EMPTY_EXAMPLE;
            }
        }
        if (this.myExampleUsagesBefore == null) {
            BeforeAfterActionMetaData.$$$reportNull$$$0(6);
        }
        return this.myExampleUsagesBefore;
    }

    @NotNull
    public TextDescriptor[] getExampleUsagesAfter() {
        if (this.myExampleUsagesAfter == null) {
            try {
                this.myExampleUsagesAfter = BeforeAfterActionMetaData.retrieveURLs(this.getDirURL(), AFTER_TEMPLATE_PREFIX, EXAMPLE_USAGE_URL_SUFFIX);
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
                if (EMPTY_EXAMPLE == null) {
                    BeforeAfterActionMetaData.$$$reportNull$$$0(7);
                }
                return EMPTY_EXAMPLE;
            }
        }
        if (this.myExampleUsagesAfter == null) {
            BeforeAfterActionMetaData.$$$reportNull$$$0(8);
        }
        return this.myExampleUsagesAfter;
    }

    @NotNull
    public TextDescriptor getDescription() {
        if (this.myDescription == null) {
            try {
                URL dirURL = this.getDirURL();
                URL descriptionURL = new URL(dirURL.toExternalForm() + "/" + DESCRIPTION_FILE_NAME);
                this.myDescription = new ResourceTextDescriptor(descriptionURL);
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
                TextDescriptor textDescriptor = EMPTY_DESCRIPTION;
                if (textDescriptor == null) {
                    BeforeAfterActionMetaData.$$$reportNull$$$0(9);
                }
                return textDescriptor;
            }
        }
        TextDescriptor textDescriptor = this.myDescription;
        if (textDescriptor == null) {
            BeforeAfterActionMetaData.$$$reportNull$$$0(10);
        }
        return textDescriptor;
    }

    @NotNull
    protected abstract URL getDirURL();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionDirectory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/config/BeforeAfterActionMetaData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/config/BeforeAfterActionMetaData";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveURLs";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExampleUsagesBefore";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExampleUsagesAfter";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "retrieveURLs";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

