/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.RunManagerSettings;
import com.intellij.conversion.impl.ConversionContextImpl;
import com.intellij.conversion.impl.SettingsXmlFile;
import com.intellij.openapi.util.JDOMUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunManagerSettingsImpl
implements RunManagerSettings {
    @NonNls
    public static final String RUN_MANAGER_COMPONENT_NAME = "RunManager";
    @NonNls
    private static final String PROJECT_RUN_MANAGER = "ProjectRunConfigurationManager";
    @NonNls
    public static final String CONFIGURATION_ELEMENT = "configuration";
    private SettingsXmlFile myWorkspaceFile;
    private SettingsXmlFile myProjectFile;
    private final List<SettingsXmlFile> mySharedConfigurationFiles;

    public RunManagerSettingsImpl(@NotNull File workspaceFile, @Nullable File projectFile, @Nullable File[] sharedConfigurationFiles, ConversionContextImpl context) throws CannotConvertException {
        if (workspaceFile == null) {
            RunManagerSettingsImpl.$$$reportNull$$$0(0);
        }
        if (workspaceFile.exists()) {
            this.myWorkspaceFile = context.getOrCreateFile(workspaceFile);
        }
        if (projectFile != null && projectFile.exists()) {
            this.myProjectFile = context.getOrCreateFile(projectFile);
        }
        this.mySharedConfigurationFiles = new ArrayList<SettingsXmlFile>();
        if (sharedConfigurationFiles != null) {
            for (File file2 : sharedConfigurationFiles) {
                this.mySharedConfigurationFiles.add(context.getOrCreateFile(file2));
            }
        }
    }

    @Override
    @NotNull
    public Collection<? extends Element> getRunConfigurations() {
        ArrayList result2 = new ArrayList();
        if (this.myWorkspaceFile != null) {
            result2.addAll(JDOMUtil.getChildren((Element)this.myWorkspaceFile.findComponent(RUN_MANAGER_COMPONENT_NAME), (String)CONFIGURATION_ELEMENT));
        }
        if (this.myProjectFile != null) {
            result2.addAll(JDOMUtil.getChildren((Element)this.myProjectFile.findComponent(PROJECT_RUN_MANAGER), (String)CONFIGURATION_ELEMENT));
        }
        for (SettingsXmlFile file2 : this.mySharedConfigurationFiles) {
            result2.addAll(JDOMUtil.getChildren((Element)file2.getRootElement(), (String)CONFIGURATION_ELEMENT));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            RunManagerSettingsImpl.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public Collection<File> getAffectedFiles() {
        ArrayList<File> files = new ArrayList<File>();
        if (this.myWorkspaceFile != null) {
            files.add(this.myWorkspaceFile.getFile());
        }
        if (this.myProjectFile != null) {
            files.add(this.myProjectFile.getFile());
        }
        for (SettingsXmlFile file2 : this.mySharedConfigurationFiles) {
            files.add(file2.getFile());
        }
        return files;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspaceFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/conversion/impl/RunManagerSettingsImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/conversion/impl/RunManagerSettingsImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

