/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.text;

import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.text.TextDiffProviderBase;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class TwosideTextDiffProviderBase
extends TextDiffProviderBase
implements TwosideTextDiffProvider {
    protected TwosideTextDiffProviderBase(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable, @NotNull IgnorePolicy[] ignorePolicies, @NotNull HighlightPolicy[] highlightPolicies) {
        if (settings == null) {
            TwosideTextDiffProviderBase.$$$reportNull$$$0(0);
        }
        if (rediff == null) {
            TwosideTextDiffProviderBase.$$$reportNull$$$0(1);
        }
        if (disposable == null) {
            TwosideTextDiffProviderBase.$$$reportNull$$$0(2);
        }
        if (ignorePolicies == null) {
            TwosideTextDiffProviderBase.$$$reportNull$$$0(3);
        }
        if (highlightPolicies == null) {
            TwosideTextDiffProviderBase.$$$reportNull$$$0(4);
        }
        super(settings, rediff, disposable, ignorePolicies, highlightPolicies);
    }

    @Override
    @Nullable
    public List<LineFragment> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            TwosideTextDiffProviderBase.$$$reportNull$$$0(5);
        }
        if (text2 == null) {
            TwosideTextDiffProviderBase.$$$reportNull$$$0(6);
        }
        if (indicator == null) {
            TwosideTextDiffProviderBase.$$$reportNull$$$0(7);
        }
        IgnorePolicy ignorePolicy = this.getIgnorePolicy();
        HighlightPolicy highlightPolicy = this.getHighlightPolicy();
        if (!highlightPolicy.isShouldCompare()) {
            return null;
        }
        ComparisonPolicy policy = ignorePolicy.getComparisonPolicy();
        boolean innerFragments = highlightPolicy.isFineFragments();
        boolean squashFragments = highlightPolicy.isShouldSquash();
        boolean trimFragments = ignorePolicy.isShouldTrimChunks();
        indicator.checkCanceled();
        List<LineFragment> fragments = this.doCompare(text1, text2, ignorePolicy, innerFragments, indicator);
        indicator.checkCanceled();
        return ComparisonManager.getInstance().processBlocks(fragments, text1, text2, policy, squashFragments, trimFragments);
    }

    @NotNull
    protected abstract List<LineFragment> doCompare(@NotNull CharSequence var1, @NotNull CharSequence var2, @NotNull IgnorePolicy var3, boolean var4, @NotNull ProgressIndicator var5);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rediff";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignorePolicies";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightPolicies";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text1";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text2";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diff/tools/util/text/TwosideTextDiffProviderBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "compare";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

