/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters.impl;

import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoBase;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MultipleFilesHyperlinkInfo
extends HyperlinkInfoBase
implements FileHyperlinkInfo {
    private final List<VirtualFile> myVirtualFiles;
    private final int myLineNumber;
    private final Project myProject;

    public MultipleFilesHyperlinkInfo(@NotNull List<VirtualFile> virtualFiles, int lineNumber, @NotNull Project project) {
        if (virtualFiles == null) {
            MultipleFilesHyperlinkInfo.$$$reportNull$$$0(0);
        }
        if (project == null) {
            MultipleFilesHyperlinkInfo.$$$reportNull$$$0(1);
        }
        this.myVirtualFiles = virtualFiles;
        this.myLineNumber = lineNumber;
        this.myProject = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void navigate(@NotNull Project project, @Nullable RelativePoint hyperlinkLocationPoint) {
        if (project == null) {
            MultipleFilesHyperlinkInfo.$$$reportNull$$$0(2);
        }
        ArrayList<PsiFile> currentFiles = new ArrayList<PsiFile>();
        AccessToken accessToken = ReadAction.start();
        try {
            for (VirtualFile file2 : this.myVirtualFiles) {
                PsiFile psiFile;
                if (!file2.isValid() || (psiFile = PsiManager.getInstance((Project)project).findFile(file2)) == null) continue;
                PsiElement navigationElement = psiFile.getNavigationElement();
                if (navigationElement instanceof PsiFile) {
                    currentFiles.add((PsiFile)navigationElement);
                    continue;
                }
                currentFiles.add(psiFile);
            }
        }
        finally {
            accessToken.finish();
        }
        if (currentFiles.isEmpty()) {
            return;
        }
        if (currentFiles.size() == 1) {
            new OpenFileHyperlinkInfo(this.myProject, ((PsiFile)currentFiles.get(0)).getVirtualFile(), this.myLineNumber).navigate(project);
        } else {
            JBList list2 = new JBList(currentFiles);
            int width = WindowManager.getInstance().getFrame((Project)project).getSize().width;
            list2.setCellRenderer((ListCellRenderer)new GotoFileCellRenderer(width));
            JBPopup popup2 = JBPopupFactory.getInstance().createListPopupBuilder((JList)list2).setTitle("Choose Target File").setItemChoosenCallback(() -> {
                if (project == null) {
                    MultipleFilesHyperlinkInfo.$$$reportNull$$$0(3);
                }
                VirtualFile file2 = ((PsiFile)list2.getSelectedValue()).getVirtualFile();
                new OpenFileHyperlinkInfo(this.myProject, file2, this.myLineNumber).navigate(project);
            }).createPopup();
            if (hyperlinkLocationPoint != null) {
                popup2.show(hyperlinkLocationPoint);
            } else {
                popup2.showInFocusCenter();
            }
        }
    }

    @Nullable
    public OpenFileDescriptor getDescriptor() {
        VirtualFile file2 = this.getPreferredFile();
        return file2 != null ? new OpenFileDescriptor(this.myProject, file2, this.myLineNumber, 0) : null;
    }

    @Nullable
    private VirtualFile getPreferredFile() {
        return (VirtualFile)ContainerUtil.getFirstItem(this.myVirtualFiles);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/filters/impl/MultipleFilesHyperlinkInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "navigate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$navigate$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

