/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.execution.ui.layout.CellTransform;
import com.intellij.execution.ui.layout.GridCell;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.Tab;
import com.intellij.execution.ui.layout.View;
import com.intellij.execution.ui.layout.ViewContext;
import com.intellij.execution.ui.layout.actions.CloseViewAction;
import com.intellij.execution.ui.layout.actions.MinimizeViewAction;
import com.intellij.execution.ui.layout.impl.GridImpl;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.execution.ui.layout.impl.TabImpl;
import com.intellij.execution.ui.layout.impl.ViewContextEx;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.MutualMap;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.UiDecorator;
import com.intellij.ui.tabs.impl.JBEditorTabs;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.singleRow.ScrollableSingleRowLayout;
import com.intellij.ui.tabs.impl.singleRow.SingleRowLayout;
import com.intellij.util.SmartList;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridCellImpl
implements GridCell {
    private final GridImpl myContainer;
    private final MutualMap<Content, TabInfo> myContents;
    private final Set<Content> myMinimizedContents;
    private final JBTabs myTabs;
    private final GridImpl.Placeholder myPlaceholder;
    private final PlaceInGrid myPlaceInGrid;
    private final ViewContextEx myContext;
    private JBPopup myPopup;

    public GridCellImpl(ViewContextEx context, @NotNull GridImpl container, GridImpl.Placeholder placeholder, PlaceInGrid placeInGrid) {
        if (container == null) {
            GridCellImpl.$$$reportNull$$$0(0);
        }
        this.myContents = new MutualMap(true);
        this.myMinimizedContents = new HashSet();
        this.myContext = context;
        this.myContainer = container;
        this.myPlaceInGrid = placeInGrid;
        this.myPlaceholder = placeholder;
        this.myTabs = new JBEditorTabs(this.myContext.getProject(), this.myContext.getActionManager(), this.myContext.getFocusManager(), container){
            {
                this.myDefaultPainter.setDefaultTabColor(new Color(13029343));
                this.myDarkPainter.setDefaultTabColor(new Color(4345183));
            }

            public boolean useSmallLabels() {
                return true;
            }

            protected SingleRowLayout createSingleRowLayout() {
                return new ScrollableSingleRowLayout((JBTabsImpl)this);
            }

            public int tabMSize() {
                return 12;
            }

            protected void paintBorder(Graphics2D g2d, JBTabsImpl.ShapeInfo shape, Color borderColor) {
                if (UIUtil.isUnderDarcula()) {
                    return;
                }
                super.paintBorder(g2d, shape, borderColor);
            }

            public void processDropOver(TabInfo over, RelativePoint point) {
                ((RunnerContentUi)((GridCellImpl)GridCellImpl.this).myContext).myTabs.processDropOver(over, point);
            }

            public Image startDropOver(TabInfo tabInfo, RelativePoint point) {
                return ((RunnerContentUi)((GridCellImpl)GridCellImpl.this).myContext).myTabs.startDropOver(tabInfo, point);
            }

            public void resetDropOver(TabInfo tabInfo) {
                ((RunnerContentUi)((GridCellImpl)GridCellImpl.this).myContext).myTabs.resetDropOver(tabInfo);
            }

            protected TabLabel createTabLabel(TabInfo info) {
                return new TabLabel((JBTabsImpl)this, info){

                    public void setAlignmentToCenter(boolean toCenter) {
                        super.setAlignmentToCenter(false);
                    }
                };
            }
        }.setDataProvider(new DataProvider(){

            @Nullable
            public Object getData(@NonNls String dataId) {
                if (ViewContext.CONTENT_KEY.is(dataId)) {
                    TabInfo target2 = GridCellImpl.this.myTabs.getTargetInfo();
                    if (target2 != null) {
                        return new Content[]{GridCellImpl.this.getContentFor(target2)};
                    }
                } else if (ViewContext.CONTEXT_KEY.is(dataId)) {
                    return GridCellImpl.this.myContext;
                }
                return null;
            }
        });
        this.myTabs.getPresentation().setUiDecorator(new UiDecorator(){

            @NotNull
            public UiDecorator.UiDecoration getDecoration() {
                UiDecorator.UiDecoration uiDecoration = new UiDecorator.UiDecoration(null, new Insets(1, -1, 1, -1));
                if (uiDecoration == null) {
                    3.$$$reportNull$$$0(0);
                }
                return uiDecoration;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/GridCellImpl$3", "getDecoration"));
            }
        }).setSideComponentVertical(!context.getLayoutSettings().isToolbarHorizontal()).setStealthTabMode(true).setFocusCycle(false).setPaintFocus(true).setTabDraggingEnabled(true).setSideComponentOnTabs(false);
        this.myTabs.addTabMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (UIUtil.isCloseClick((MouseEvent)e)) {
                    GridCellImpl.this.closeOrMinimize(e);
                }
            }
        });
        this.rebuildPopupGroup();
        this.myTabs.addListener((TabsListener)new TabsListener.Adapter(){

            public void beforeSelectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                if (oldSelection != null && GridCellImpl.this.myContext.isStateBeingRestored()) {
                    GridCellImpl.this.saveUiState();
                }
            }

            public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                GridCellImpl.this.updateSelection(GridCellImpl.this.myTabs.getComponent().isShowing());
                if (!GridCellImpl.this.myTabs.getComponent().isShowing()) {
                    return;
                }
                if (newSelection != null) {
                    newSelection.stopAlerting();
                }
            }
        });
    }

    public void rebuildPopupGroup() {
        this.myTabs.setPopupGroup(this.myContext.getCellPopupGroup("debuggerCellPopup"), "debuggerCellPopup", true);
    }

    public PlaceInGrid getPlaceInGrid() {
        return this.myPlaceInGrid;
    }

    void add(Content content) {
        if (this.myContents.containsKey((Object)content)) {
            return;
        }
        this.myContents.put((Object)content, null);
        this.revalidateCell(() -> this.myTabs.addTab(this.createTabInfoFor(content)));
        this.updateSelection(this.myTabs.getComponent().getRootPane() != null);
    }

    void remove(Content content) {
        if (!this.myContents.containsKey((Object)content)) {
            return;
        }
        TabInfo info = this.getTabFor(content);
        this.myContents.remove((Object)content);
        this.revalidateCell(() -> this.myTabs.removeTab(info));
        this.updateSelection(this.myTabs.getComponent().getRootPane() != null);
    }

    private void revalidateCell(Runnable contentAction) {
        if (this.myContents.size() == 0) {
            this.myPlaceholder.removeAll();
            this.myTabs.removeAllTabs();
            if (this.myPopup != null) {
                this.myPopup.cancel();
                this.myPopup = null;
            }
        } else {
            if (this.myPlaceholder.isNull()) {
                this.myPlaceholder.setContent(this.myTabs.getComponent());
            }
            contentAction.run();
        }
        this.restoreProportions();
        this.myTabs.getComponent().revalidate();
        this.myTabs.getComponent().repaint();
    }

    void setHideTabs(boolean hide) {
        this.myTabs.getPresentation().setHideTabs(hide);
    }

    private TabInfo createTabInfoFor(Content content) {
        TabInfo tabInfo = GridCellImpl.updatePresentation(new TabInfo((JComponent)((Object)new ProviderWrapper(content, this.myContext))), content).setObject((Object)content).setPreferredFocusableComponent(content.getPreferredFocusableComponent()).setActionsContextComponent(content.getActionsContextComponent());
        this.myContents.remove((Object)content);
        this.myContents.put((Object)content, (Object)tabInfo);
        ActionGroup group = (ActionGroup)this.myContext.getActionManager().getAction("Runner.View.Toolbar");
        tabInfo.setTabLabelActions(group, "debuggerCellToolbar");
        tabInfo.setDragOutDelegate((TabInfo.DragOutDelegate)((RunnerContentUi)this.myContext).myDragOutDelegate);
        return tabInfo;
    }

    @Nullable
    private static TabInfo updatePresentation(TabInfo info, Content content) {
        if (info == null) {
            return null;
        }
        return info.setIcon(content.getIcon()).setText(content.getDisplayName()).setTooltipText(content.getDescription()).setActionsContextComponent(content.getActionsContextComponent()).setActions(content.getActions(), content.getPlace());
    }

    public ActionCallback select(Content content, boolean requestFocus) {
        TabInfo tabInfo = (TabInfo)this.myContents.getValue((Object)content);
        return tabInfo != null ? this.myTabs.select(tabInfo, requestFocus) : ActionCallback.DONE;
    }

    public void processAlert(Content content, boolean activate) {
        TabInfo tab;
        if (this.myMinimizedContents.contains(content)) {
            content.fireAlert();
        }
        if ((tab = this.getTabFor(content)) == null) {
            return;
        }
        if (this.myTabs.getSelectedInfo() != tab) {
            if (activate) {
                tab.fireAlert();
            } else {
                tab.stopAlerting();
            }
        }
    }

    public void updateTabPresentation(Content content) {
        GridCellImpl.updatePresentation(this.myTabs.findInfo((Object)content), content);
    }

    public boolean isMinimized(Content content) {
        return this.myMinimizedContents.contains(content);
    }

    public boolean contains(Component c) {
        return this.myTabs.getComponent().isAncestorOf(c);
    }

    @Nullable
    TabInfo getTabFor(Content content) {
        return (TabInfo)this.myContents.getValue((Object)content);
    }

    @NotNull
    private Content getContentFor(TabInfo tab) {
        Content content = (Content)this.myContents.getKey((Object)tab);
        if (content == null) {
            GridCellImpl.$$$reportNull$$$0(1);
        }
        return content;
    }

    public void setToolbarHorizontal(boolean horizontal) {
        this.myTabs.getPresentation().setSideComponentVertical(!horizontal);
    }

    public void setToolbarBefore(boolean before) {
        this.myTabs.getPresentation().setSideComponentBefore(before);
    }

    public ActionCallback restoreLastUiState() {
        boolean detached;
        ActionCallback result2 = new ActionCallback();
        this.restoreProportions();
        Content[] contents = this.getContents();
        SmartList toMinimize = new SmartList();
        int window = 0;
        for (Content each : contents) {
            View view = this.myContainer.getStateFor(each);
            if (view.isMinimizedInGrid()) {
                toMinimize.add(each);
            }
            window = view.getWindow();
        }
        this.minimize(toMinimize.toArray(new Content[toMinimize.size()]));
        Tab tab = this.myContainer.getTab();
        boolean bl = detached = tab != null && tab.isDetached(this.myPlaceInGrid) || window != this.myContext.getWindow();
        if (detached && contents.length > 0) {
            if (tab != null) {
                tab.setDetached(this.myPlaceInGrid, false);
            }
            this.myContext.detachTo(window, this).notifyWhenDone(result2);
        } else {
            result2.setDone();
        }
        return result2;
    }

    Content[] getContents() {
        return this.myContents.getKeys().toArray(new Content[this.myContents.size()]);
    }

    public int getContentCount() {
        return this.myContents.size();
    }

    public void saveUiState() {
        Window frame;
        this.saveProportions();
        for (Content each : this.myContents.getKeys()) {
            this.saveState(each, false);
        }
        for (Content each : this.myMinimizedContents) {
            this.saveState(each, true);
        }
        DimensionService service = DimensionService.getInstance();
        Dimension size = this.myContext.getContentManager().getComponent().getSize();
        service.setSize(this.getDimensionKey(), size, this.myContext.getProject());
        if (this.myContext.getWindow() != 0 && (frame = SwingUtilities.getWindowAncestor((Component)((Object)this.myPlaceholder))) != null) {
            service.setLocation(this.getDimensionKey(), frame.getLocationOnScreen());
        }
    }

    public void saveProportions() {
        this.myContainer.saveSplitterProportions(this.myPlaceInGrid);
    }

    private void saveState(Content content, boolean minimized) {
        View state2 = this.myContext.getStateFor(content);
        state2.setMinimizedInGrid(minimized);
        state2.setPlaceInGrid(this.myPlaceInGrid);
        List<Content> contents = this.myContainer.getContents();
        Tab tab = this.myContainer.getTabIndex();
        if (minimized && contents.size() == 1 && contents.get(0).equals(content)) {
            state2.setTabIndex(-1);
            if (tab instanceof TabImpl) {
                ((TabImpl)tab).setIndex(-1);
            }
        }
        state2.assignTab(tab);
        state2.setWindow(this.myContext.getWindow());
    }

    public void restoreProportions() {
        this.myContainer.restoreLastSplitterProportions(this.myPlaceInGrid);
    }

    public void updateSelection(boolean isShowing) {
        ContentManager contentManager = this.myContext.getContentManager();
        if (contentManager.isDisposed()) {
            return;
        }
        for (Content each : this.myContents.getKeys()) {
            boolean isSelected;
            TabInfo eachTab = this.getTabFor(each);
            boolean bl = isSelected = eachTab != null && this.myTabs.getSelectedInfo() == eachTab;
            if (isSelected && isShowing) {
                contentManager.addSelectedContent(each);
                continue;
            }
            contentManager.removeFromSelection(each);
        }
        for (Content each : this.myMinimizedContents) {
            contentManager.removeFromSelection(each);
        }
    }

    public void minimize(Content[] contents) {
        if (contents.length == 0) {
            return;
        }
        this.myContext.saveUiState();
        for (final Content each : contents) {
            this.myMinimizedContents.add(each);
            this.remove(each);
            this.saveState(each, true);
            boolean isShowing = this.myTabs.getComponent().getRootPane() != null;
            this.myContainer.minimize(each, new CellTransform.Restore(){

                public ActionCallback restoreInGrid() {
                    return GridCellImpl.this.restore(each);
                }
            });
            this.updateSelection(isShowing);
        }
    }

    @Nullable
    public Point getLocation() {
        return DimensionService.getInstance().getLocation(this.getDimensionKey(), this.myContext.getProject());
    }

    @Nullable
    public Dimension getSize() {
        return DimensionService.getInstance().getSize(this.getDimensionKey(), this.myContext.getProject());
    }

    private String getDimensionKey() {
        return "GridCell.Tab." + this.myContainer.getTab().getIndex() + "." + this.myPlaceInGrid.name();
    }

    public boolean isValidForCalculateProportions() {
        return this.getContentCount() > 0;
    }

    public void minimize(Content content) {
        this.minimize(new Content[]{content});
    }

    public void closeOrMinimize(MouseEvent e) {
        TabInfo tabInfo = this.myTabs.findInfo(e);
        if (tabInfo == null) {
            return;
        }
        Content content = this.getContentFor(tabInfo);
        if (CloseViewAction.isEnabled(new Content[]{content})) {
            CloseViewAction.perform(this.myContext, content);
        } else if (MinimizeViewAction.isEnabled(this.myContext, this.getContents(), "debuggerCellToolbar")) {
            this.minimize(content);
        }
    }

    ActionCallback restore(Content content) {
        this.myMinimizedContents.remove(content);
        return ActionCallback.DONE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/layout/impl/GridCellImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/layout/impl/GridCellImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ProviderWrapper
    extends NonOpaquePanel
    implements DataProvider {
        Content myContent;
        ViewContext myContext;

        private ProviderWrapper(Content content, ViewContext context) {
            this.myContent = content;
            this.myContext = context;
            this.setLayout(new BorderLayout());
            this.add(content.getComponent(), "Center");
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (ViewContext.CONTENT_KEY.is(dataId)) {
                return new Content[]{this.myContent};
            }
            if (ViewContext.CONTEXT_KEY.is(dataId)) {
                return this.myContext;
            }
            return null;
        }
    }
}

