/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.html.impl;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptorsProvider;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.Nullable;

public class RelaxedHtmlFromSchemaElementDescriptor
extends XmlElementDescriptorImpl {
    RelaxedHtmlFromSchemaElementDescriptor(XmlTag tag) {
        super(tag);
    }

    @Override
    public XmlElementDescriptor getElementDescriptor(XmlTag childTag, XmlTag contextTag) {
        XmlElementDescriptor elementDescriptor = super.getElementDescriptor(childTag, contextTag);
        if (elementDescriptor == null) {
            return RelaxedHtmlFromSchemaElementDescriptor.getRelaxedDescriptor(this, childTag);
        }
        return elementDescriptor;
    }

    @Override
    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context) {
        return (XmlElementDescriptor[])ArrayUtil.mergeArrays((Object[])super.getElementsDescriptors(context), (Object[])HtmlUtil.getCustomTagDescriptors((PsiElement)context));
    }

    public static XmlElementDescriptor getRelaxedDescriptor(XmlElementDescriptor base, XmlTag childTag) {
        String namespace = childTag.getNamespace();
        XmlExtension extension = XmlExtension.getExtensionByElement((PsiElement)childTag);
        if (!"http://www.w3.org/1999/xhtml".equals(namespace) && (base.getContentType() != 0 || extension != null && extension.isCustomTagAllowed(childTag))) {
            return new AnyXmlElementDescriptor(base, childTag.getNSDescriptor(namespace, true));
        }
        return null;
    }

    @Override
    public XmlAttributeDescriptor[] getAttributesDescriptors(XmlTag context) {
        return RelaxedHtmlFromSchemaElementDescriptor.addAttrDescriptorsForFacelets(context, super.getAttributesDescriptors(context));
    }

    public static XmlAttributeDescriptor[] addAttrDescriptorsForFacelets(XmlTag context, XmlAttributeDescriptor[] descriptors) {
        if (context == null) {
            return descriptors;
        }
        for (XmlAttributeDescriptorsProvider provider : (XmlAttributeDescriptorsProvider[])Extensions.getExtensions(XmlAttributeDescriptorsProvider.EP_NAME)) {
            descriptors = (XmlAttributeDescriptor[])ArrayUtil.mergeArrays((Object[])descriptors, (Object[])provider.getAttributeDescriptors(context), (ArrayFactory)XmlAttributeDescriptor.ARRAY_FACTORY);
        }
        return descriptors;
    }

    @Override
    public XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        return this.getAttributeDescriptor(attribute.getName(), attribute.getParent());
    }

    @Override
    public XmlAttributeDescriptor getAttributeDescriptor(String attributeName, XmlTag context) {
        XmlAttributeDescriptor descriptor2 = super.getAttributeDescriptor(attributeName.toLowerCase(), context);
        if (descriptor2 != null) {
            return descriptor2;
        }
        return RelaxedHtmlFromSchemaElementDescriptor.getAttributeDescriptorFromFacelets(attributeName, context);
    }

    @Nullable
    public static XmlAttributeDescriptor getAttributeDescriptorFromFacelets(String attributeName, XmlTag context) {
        if (context == null) {
            return null;
        }
        for (XmlAttributeDescriptorsProvider provider : (XmlAttributeDescriptorsProvider[])Extensions.getExtensions(XmlAttributeDescriptorsProvider.EP_NAME)) {
            XmlAttributeDescriptor descriptor2 = provider.getAttributeDescriptor(attributeName, context);
            if (descriptor2 == null) continue;
            return descriptor2;
        }
        return null;
    }

    @Override
    public boolean allowElementsFromNamespace(String namespace, XmlTag context) {
        return true;
    }
}

