/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json;

import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JsonSpellcheckerStrategy
extends SpellcheckingStrategy {
    private final Tokenizer<JsonStringLiteral> ourStringLiteralTokenizer = new Tokenizer<JsonStringLiteral>(){

        @Override
        public void tokenize(@NotNull JsonStringLiteral element, TokenConsumer consumer) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            PlainTextSplitter textSplitter = PlainTextSplitter.getInstance();
            if (element.getText().contains("\\")) {
                List<Pair<TextRange, String>> fragments = element.getTextFragments();
                for (Pair<TextRange, String> fragment : fragments) {
                    String fragmentText = (String)fragment.getSecond();
                    TextRange fragmentRange = (TextRange)fragment.getFirst();
                    if (fragmentText.startsWith("\\")) continue;
                    consumer.consumeToken(element, fragmentText, false, fragmentRange.getStartOffset(), TextRange.allOf((String)fragmentText), textSplitter);
                }
            } else {
                consumer.consumeToken(element, textSplitter);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/json/JsonSpellcheckerStrategy$1", "tokenize"));
        }
    };

    @Override
    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        if (element instanceof JsonStringLiteral) {
            Tokenizer<JsonStringLiteral> tokenizer = this.ourStringLiteralTokenizer;
            if (tokenizer == null) {
                JsonSpellcheckerStrategy.$$$reportNull$$$0(0);
            }
            return tokenizer;
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            JsonSpellcheckerStrategy.$$$reportNull$$$0(1);
        }
        return tokenizer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/JsonSpellcheckerStrategy", "getTokenizer"));
    }
}

