/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextStartWithSelectionAction
extends TextComponentEditorAction {
    public TextStartWithSelectionAction() {
        super(new Handler());
    }

    private static class Handler
    extends EditorActionHandler {
        private Handler() {
        }

        public void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            if (editor == null) {
                Handler.$$$reportNull$$$0(0);
            }
            List carets = editor.getCaretModel().getAllCarets();
            if (editor.isColumnMode() && editor.getCaretModel().supportsMultipleCarets()) {
                if (caret == null) {
                    caret = carets.get(0) == editor.getCaretModel().getPrimaryCaret() ? (Caret)carets.get(carets.size() - 1) : (Caret)carets.get(0);
                }
                LogicalPosition leadSelectionPosition = editor.visualToLogicalPosition(caret.getLeadSelectionPosition());
                LogicalPosition targetPosition = new LogicalPosition(0, 0);
                editor.getSelectionModel().setBlockSelection(leadSelectionPosition, targetPosition);
            } else {
                if (caret == null) {
                    caret = (Caret)carets.get(carets.size() - 1);
                }
                int selectionStart = caret.getLeadSelectionOffset();
                caret.moveToOffset(0);
                caret.setSelection(selectionStart, 0);
            }
            ScrollingModel scrollingModel = editor.getScrollingModel();
            scrollingModel.disableAnimation();
            scrollingModel.scrollToCaret(ScrollType.RELATIVE);
            scrollingModel.enableAnimation();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/TextStartWithSelectionAction$Handler", "doExecute"));
        }
    }
}

