/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnversionedDiffRequestProducer
implements ChangeDiffRequestChain.Producer {
    @Nullable
    private final Project myProject;
    @NotNull
    private final VirtualFile myFile;

    private UnversionedDiffRequestProducer(@Nullable Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myFile = file2;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(1);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public FilePath getFilePath() {
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)this.myFile);
        if (filePath == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(2);
        }
        return filePath;
    }

    @Override
    @NotNull
    public FileStatus getFileStatus() {
        FileStatus fileStatus = FileStatus.UNKNOWN;
        if (fileStatus == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(3);
        }
        return fileStatus;
    }

    @Override
    @Nullable
    public Object getPopupTag() {
        return ChangesBrowserNode.UNVERSIONED_FILES_TAG;
    }

    @NotNull
    public String getName() {
        String string = this.myFile.getPresentableUrl();
        if (string == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
        if (context == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(5);
        }
        if (indicator == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(6);
        }
        if (!this.myFile.isValid()) {
            throw new DiffRequestProducerException("Can't show diff - file not found");
        }
        DiffRequest diffRequest = UnversionedDiffRequestProducer.createRequest(this.myProject, this.myFile);
        if (diffRequest == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(7);
        }
        return diffRequest;
    }

    @NotNull
    public static UnversionedDiffRequestProducer create(@Nullable Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(8);
        }
        UnversionedDiffRequestProducer unversionedDiffRequestProducer = new UnversionedDiffRequestProducer(project, file2);
        if (unversionedDiffRequestProducer == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(9);
        }
        return unversionedDiffRequestProducer;
    }

    @NotNull
    private static DiffRequest createRequest(@Nullable Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(10);
        }
        DiffContentFactory contentFactory = DiffContentFactory.getInstance();
        EmptyContent content1 = contentFactory.createEmpty();
        DiffContent content2 = contentFactory.create(project, file2);
        SimpleDiffRequest request = new SimpleDiffRequest(DiffRequestFactory.getInstance().getTitle(file2), (DiffContent)content1, content2, null, "Your version");
        DiffUtil.putDataKey((UserDataHolder)request, VcsDataKeys.CURRENT_UNVERSIONED, file2);
        SimpleDiffRequest simpleDiffRequest = request;
        if (simpleDiffRequest == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(11);
        }
        return simpleDiffRequest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnversionedDiffRequestProducer producer = (UnversionedDiffRequestProducer)o;
        return Objects.equals(this.myFile, producer.myFile);
    }

    public int hashCode() {
        return this.myFile.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/UnversionedDiffRequestProducer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/UnversionedDiffRequestProducer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileStatus";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createRequest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

