/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.VcsRootError;
import com.intellij.openapi.vcs.configurable.ModuleVcsListener;
import com.intellij.openapi.vcs.configurable.VcsContentAnnotationConfigurable;
import com.intellij.openapi.vcs.configurable.VcsLimitHistoryConfigurable;
import com.intellij.openapi.vcs.configurable.VcsMappingConfigurationDialog;
import com.intellij.openapi.vcs.configurable.VcsUpdateInfoScopeFilterConfigurable;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vcs.roots.VcsRootErrorsFinder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.TableView;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsDirectoryConfigurationPanel
extends JPanel
implements Configurable {
    private final Project myProject;
    private final String myProjectMessage;
    private final ProjectLevelVcsManager myVcsManager;
    private final TableView<MapInfo> myDirectoryMappingTable;
    private final ComboBox<VcsDescriptor> myVcsComboBox = new ComboBox();
    private final List<ModuleVcsListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final MyDirectoryRenderer myDirectoryRenderer;
    private final ColumnInfo<MapInfo, MapInfo> DIRECTORY;
    private ListTableModel<MapInfo> myModel;
    private final Map<String, VcsDescriptor> myAllVcss;
    private VcsContentAnnotationConfigurable myRecentlyChangedConfigurable;
    private final boolean myIsDisabled;
    private final VcsConfiguration myVcsConfiguration;
    @NotNull
    private final Map<String, VcsRootChecker> myCheckers;
    private JCheckBox myShowChangedRecursively;
    private final VcsLimitHistoryConfigurable myLimitHistory;
    private final VcsUpdateInfoScopeFilterConfigurable myScopeFilterConfig;
    private final ColumnInfo<MapInfo, String> VCS_SETTING = new ColumnInfo<MapInfo, String>(VcsBundle.message((String)"column.name.configure.vcses.vcs", (Object[])new Object[0])){

        public String valueOf(MapInfo object) {
            return object.mapping.getVcs();
        }

        public boolean isCellEditable(MapInfo info) {
            return info != MapInfo.SEPARATOR && info.type != MapInfo.Type.UNREGISTERED;
        }

        public void setValue(MapInfo o, String aValue) {
            Collection<AbstractVcs> activeVcses = VcsDirectoryConfigurationPanel.this.getActiveVcses();
            o.mapping.setVcs(aValue);
            VcsDirectoryConfigurationPanel.this.checkNotifyListeners(activeVcses);
        }

        public TableCellRenderer getRenderer(final MapInfo info) {
            return new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    VcsDescriptor vcs;
                    String vcsName;
                    if (info == MapInfo.SEPARATOR) {
                        if (!selected) {
                            this.setBackground(VcsDirectoryConfigurationPanel.getUnregisteredRootBackground());
                        }
                        return;
                    }
                    if (info.type == MapInfo.Type.UNREGISTERED && !selected) {
                        this.setBackground(VcsDirectoryConfigurationPanel.getUnregisteredRootBackground());
                    }
                    String text = (vcsName = info.mapping.getVcs()).length() == 0 ? VcsBundle.message((String)"none.vcs.presentation", (Object[])new Object[0]) : ((vcs = (VcsDescriptor)VcsDirectoryConfigurationPanel.this.myAllVcss.get(vcsName)) != null ? vcs.getDisplayName() : VcsBundle.message((String)"unknown.vcs.presentation", (Object[])new Object[]{vcsName}));
                    this.append(text, VcsDirectoryConfigurationPanel.getAttributes(info));
                }
            };
        }

        public TableCellEditor getEditor(MapInfo o) {
            return new AbstractTableCellEditor(){

                public Object getCellEditorValue() {
                    VcsDescriptor selectedVcs = (VcsDescriptor)VcsDirectoryConfigurationPanel.this.myVcsComboBox.getSelectedItem();
                    return selectedVcs == null || selectedVcs.isNone() ? "" : selectedVcs.getName();
                }

                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    String vcsName = (String)value;
                    VcsDirectoryConfigurationPanel.this.myVcsComboBox.setSelectedItem(VcsDirectoryConfigurationPanel.this.myAllVcss.get(vcsName));
                    return VcsDirectoryConfigurationPanel.this.myVcsComboBox;
                }
            };
        }

        @Nullable
        public String getMaxStringValue() {
            String maxString = null;
            for (String name : VcsDirectoryConfigurationPanel.this.myAllVcss.keySet()) {
                if (maxString != null && maxString.length() >= name.length()) continue;
                maxString = name;
            }
            return maxString;
        }

        public int getAdditionalWidth() {
            return 10;
        }
    };

    @NotNull
    private static Color getUnregisteredRootBackground() {
        JBColor jBColor = new JBColor(UIUtil.getLabelBackground(), new Color(4540746));
        if (jBColor == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(0);
        }
        return jBColor;
    }

    @NotNull
    private static SimpleTextAttributes getAttributes(@NotNull MapInfo info) {
        if (info == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(1);
        }
        if (info == MapInfo.SEPARATOR) {
            SimpleTextAttributes simpleTextAttributes = new SimpleTextAttributes(129, null);
            if (simpleTextAttributes == null) {
                VcsDirectoryConfigurationPanel.$$$reportNull$$$0(2);
            }
            return simpleTextAttributes;
        }
        if (info.type == MapInfo.Type.INVALID) {
            SimpleTextAttributes simpleTextAttributes = new SimpleTextAttributes(0, (Color)JBColor.RED);
            if (simpleTextAttributes == null) {
                VcsDirectoryConfigurationPanel.$$$reportNull$$$0(3);
            }
            return simpleTextAttributes;
        }
        if (info.type == MapInfo.Type.UNREGISTERED) {
            SimpleTextAttributes simpleTextAttributes = new SimpleTextAttributes(1, (Color)JBColor.GRAY);
            if (simpleTextAttributes == null) {
                VcsDirectoryConfigurationPanel.$$$reportNull$$$0(4);
            }
            return simpleTextAttributes;
        }
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        if (simpleTextAttributes == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(5);
        }
        return simpleTextAttributes;
    }

    public VcsDirectoryConfigurationPanel(Project project) {
        this.myProject = project;
        this.myVcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        this.myProjectMessage = XmlStringUtil.wrapInHtml((CharSequence)(StringUtil.escapeXml((String)"<Project>") + " - " + DefaultVcsRootPolicy.getInstance(this.myProject).getProjectConfigurationMessage(this.myProject).replace('\n', ' ')));
        this.myIsDisabled = this.myProject.isDefault();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        VcsDescriptor[] vcsDescriptors = this.myVcsManager.getAllVcss();
        this.myAllVcss = new HashMap<String, VcsDescriptor>();
        for (VcsDescriptor vcsDescriptor : vcsDescriptors) {
            this.myAllVcss.put(vcsDescriptor.getName(), vcsDescriptor);
        }
        this.myDirectoryMappingTable = new TableView();
        this.myDirectoryMappingTable.setIntercellSpacing((Dimension)JBUI.emptySize());
        this.myLimitHistory = new VcsLimitHistoryConfigurable(this.myProject);
        this.myScopeFilterConfig = new VcsUpdateInfoScopeFilterConfigurable(this.myProject, this.myVcsConfiguration);
        this.myCheckers = new HashMap<String, VcsRootChecker>();
        this.updateRootCheckers();
        this.setLayout(new BorderLayout());
        this.add(this.createMainComponent());
        this.myDirectoryRenderer = new MyDirectoryRenderer(this.myProject);
        this.DIRECTORY = new ColumnInfo<MapInfo, MapInfo>(VcsBundle.message((String)"column.info.configure.vcses.directory", (Object[])new Object[0])){

            public MapInfo valueOf(MapInfo mapping) {
                return mapping;
            }

            public TableCellRenderer getRenderer(MapInfo vcsDirectoryMapping) {
                return VcsDirectoryConfigurationPanel.this.myDirectoryRenderer;
            }
        };
        this.initializeModel();
        this.myVcsComboBox.setModel(VcsDirectoryConfigurationPanel.buildVcsWrappersModel(this.myProject));
        this.myVcsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (VcsDirectoryConfigurationPanel.this.myDirectoryMappingTable.isEditing()) {
                    VcsDirectoryConfigurationPanel.this.myDirectoryMappingTable.stopEditing();
                }
            }
        });
        this.myDirectoryMappingTable.setRowHeight(this.myVcsComboBox.getPreferredSize().height);
        if (this.myIsDisabled) {
            this.myDirectoryMappingTable.setEnabled(false);
        }
    }

    private void updateRootCheckers() {
        VcsRootChecker[] checkers;
        this.myCheckers.clear();
        for (VcsRootChecker checker : checkers = (VcsRootChecker[])Extensions.getExtensions((ExtensionPointName)VcsRootChecker.EXTENSION_POINT_NAME)) {
            VcsKey key = checker.getSupportedVcs();
            AbstractVcs vcs = this.myVcsManager.findVcsByName(key.getName());
            if (vcs == null) continue;
            this.myCheckers.put(key.getName(), checker);
        }
    }

    private void initializeModel() {
        ArrayList<MapInfo> mappings = new ArrayList<MapInfo>();
        for (VcsDirectoryMapping mapping : ProjectLevelVcsManager.getInstance((Project)this.myProject).getDirectoryMappings()) {
            mappings.add(MapInfo.registered(new VcsDirectoryMapping(mapping.getDirectory(), mapping.getVcs(), mapping.getRootSettings()), this.isMappingValid(mapping)));
        }
        Collection<VcsRootError> errors = this.findUnregisteredRoots();
        if (!errors.isEmpty()) {
            mappings.add(MapInfo.SEPARATOR);
            for (VcsRootError error : errors) {
                mappings.add(MapInfo.unregistered(error.getMapping(), error.getVcsKey().getName()));
            }
        }
        this.myModel = new ListTableModel(new ColumnInfo[]{this.DIRECTORY, this.VCS_SETTING}, mappings, 0);
        this.myDirectoryMappingTable.setModelAndUpdateColumns(this.myModel);
        this.myRecentlyChangedConfigurable.reset();
        this.myLimitHistory.reset();
        this.myScopeFilterConfig.reset();
        this.myShowChangedRecursively.setSelected(this.myVcsConfiguration.SHOW_DIRTY_RECURSIVELY);
    }

    @NotNull
    private Collection<VcsRootError> findUnregisteredRoots() {
        List list2 = ContainerUtil.filter(VcsRootErrorsFinder.getInstance(this.myProject).find(), error -> error.getType() == VcsRootError.Type.UNREGISTERED_ROOT);
        if (list2 == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(6);
        }
        return list2;
    }

    private boolean isMappingValid(@NotNull VcsDirectoryMapping mapping) {
        String vcs;
        VcsRootChecker checker;
        if (mapping == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(7);
        }
        return (checker = this.myCheckers.get(vcs = mapping.getVcs())) == null || (mapping.isDefaultMapping() ? checker.isRoot(this.myProject.getBasePath()) : checker.isRoot(mapping.getDirectory()));
    }

    @NotNull
    public static DefaultComboBoxModel<VcsDescriptor> buildVcsWrappersModel(@NotNull Project project) {
        if (project == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(8);
        }
        VcsDescriptor[] vcsDescriptors = ProjectLevelVcsManager.getInstance((Project)project).getAllVcss();
        VcsDescriptor[] result2 = new VcsDescriptor[vcsDescriptors.length + 1];
        result2[0] = VcsDescriptor.createFictive();
        System.arraycopy(vcsDescriptors, 0, result2, 1, vcsDescriptors.length);
        DefaultComboBoxModel<VcsDescriptor> defaultComboBoxModel = new DefaultComboBoxModel<VcsDescriptor>(result2);
        if (defaultComboBoxModel == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(9);
        }
        return defaultComboBoxModel;
    }

    private void addMapping() {
        VcsMappingConfigurationDialog dlg = new VcsMappingConfigurationDialog(this.myProject, VcsBundle.message((String)"directory.mapping.add.title", (Object[])new Object[0]));
        dlg.initProjectMessage();
        if (dlg.showAndGet()) {
            this.addMapping(dlg.getMapping());
        }
    }

    private void addMapping(VcsDirectoryMapping mapping) {
        ArrayList<MapInfo> items = new ArrayList<MapInfo>(this.myModel.getItems());
        items.add(MapInfo.registered(new VcsDirectoryMapping(mapping.getDirectory(), mapping.getVcs(), mapping.getRootSettings()), this.isMappingValid(mapping)));
        Collections.sort(items, MapInfo.COMPARATOR);
        this.myModel.setItems(items);
        this.checkNotifyListeners(this.getActiveVcses());
    }

    private void addSelectedUnregisteredMappings(List<MapInfo> infos) {
        ArrayList<MapInfo> items = new ArrayList<MapInfo>(this.myModel.getItems());
        for (MapInfo info : infos) {
            items.remove(info);
            items.add(MapInfo.registered(info.mapping, this.isMappingValid(info.mapping)));
        }
        VcsDirectoryConfigurationPanel.sortAndAddSeparatorIfNeeded(items);
        this.myModel.setItems(items);
        this.checkNotifyListeners(this.getActiveVcses());
    }

    @Contract(pure=false)
    private static void sortAndAddSeparatorIfNeeded(@NotNull List<MapInfo> items) {
        if (items == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(10);
        }
        boolean hasUnregistered = false;
        boolean hasSeparator = false;
        for (MapInfo item : items) {
            if (item.type == MapInfo.Type.UNREGISTERED) {
                hasUnregistered = true;
                continue;
            }
            if (item.type != MapInfo.Type.SEPARATOR) continue;
            hasSeparator = true;
        }
        if (!hasUnregistered && hasSeparator) {
            items.remove(MapInfo.SEPARATOR);
        } else if (hasUnregistered && !hasSeparator) {
            items.add(MapInfo.SEPARATOR);
        }
        Collections.sort(items, MapInfo.COMPARATOR);
    }

    private void editMapping() {
        VcsMappingConfigurationDialog dlg = new VcsMappingConfigurationDialog(this.myProject, VcsBundle.message((String)"directory.mapping.remove.title", (Object[])new Object[0]));
        int row = this.myDirectoryMappingTable.getSelectedRow();
        VcsDirectoryMapping mapping = ((MapInfo)this.myDirectoryMappingTable.getRow(row)).mapping;
        dlg.setMapping(mapping);
        if (dlg.showAndGet()) {
            this.setMapping(row, dlg.getMapping());
        }
    }

    private void setMapping(int row, @NotNull VcsDirectoryMapping mapping) {
        if (mapping == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(11);
        }
        ArrayList<MapInfo> items = new ArrayList<MapInfo>(this.myModel.getItems());
        items.set(row, MapInfo.registered(mapping, this.isMappingValid(mapping)));
        Collections.sort(items, MapInfo.COMPARATOR);
        this.myModel.setItems(items);
        this.checkNotifyListeners(this.getActiveVcses());
    }

    private void removeMapping() {
        Collection<AbstractVcs> activeVcses = this.getActiveVcses();
        ArrayList<MapInfo> mappings = new ArrayList<MapInfo>(this.myModel.getItems());
        int index = this.myDirectoryMappingTable.getSelectionModel().getMinSelectionIndex();
        Collection selection = this.myDirectoryMappingTable.getSelection();
        mappings.removeAll(selection);
        List removedValidRoots = ContainerUtil.mapNotNull((Collection)selection, info -> ((MapInfo)info).type == MapInfo.Type.NORMAL && this.myCheckers.get(((MapInfo)info).mapping.getVcs()) != null ? MapInfo.unregistered(((MapInfo)info).mapping.getDirectory(), ((MapInfo)info).mapping.getVcs()) : null);
        mappings.addAll(removedValidRoots);
        VcsDirectoryConfigurationPanel.sortAndAddSeparatorIfNeeded(mappings);
        this.myModel.setItems(mappings);
        if (mappings.size() > 0) {
            if (index >= mappings.size()) {
                index = mappings.size() - 1;
            }
            this.myDirectoryMappingTable.getSelectionModel().setSelectionInterval(index, index);
        }
        this.checkNotifyListeners(activeVcses);
    }

    protected JComponent createMainComponent() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBag gb = new GridBag().setDefaultInsets(new Insets(0, 0, 4, 10)).setDefaultWeightX(1.0).setDefaultFill(2);
        panel2.add((Component)this.createMappingsTable(), gb.nextLine().next().fillCell().weighty(1.0));
        panel2.add((Component)this.createProjectMappingDescription(), gb.nextLine().next());
        panel2.add((Component)this.myLimitHistory.createComponent(), gb.nextLine().next());
        panel2.add((Component)this.createShowRecursivelyDirtyOption(), gb.nextLine().next());
        panel2.add((Component)this.createShowChangedOption(), gb.nextLine().next());
        panel2.add((Component)this.myScopeFilterConfig.createComponent(), gb.nextLine().next());
        return panel2;
    }

    private JComponent createMappingsTable() {
        JPanel panelForTable = ToolbarDecorator.createDecorator(this.myDirectoryMappingTable, null).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                if (VcsDirectoryConfigurationPanel.this.onlyRegisteredRootsInSelection()) {
                    VcsDirectoryConfigurationPanel.this.addMapping();
                } else {
                    VcsDirectoryConfigurationPanel.this.addSelectedUnregisteredMappings(VcsDirectoryConfigurationPanel.this.getSelectedUnregisteredRoots());
                }
                VcsDirectoryConfigurationPanel.this.updateRootCheckers();
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                VcsDirectoryConfigurationPanel.this.editMapping();
                VcsDirectoryConfigurationPanel.this.updateRootCheckers();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                VcsDirectoryConfigurationPanel.this.removeMapping();
                VcsDirectoryConfigurationPanel.this.updateRootCheckers();
            }
        }).setAddActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                return !VcsDirectoryConfigurationPanel.this.myIsDisabled && VcsDirectoryConfigurationPanel.this.rootsOfOneKindInSelection();
            }
        }).setEditActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                return !VcsDirectoryConfigurationPanel.this.myIsDisabled && VcsDirectoryConfigurationPanel.this.onlyRegisteredRootsInSelection();
            }
        }).setRemoveActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                return !VcsDirectoryConfigurationPanel.this.myIsDisabled && VcsDirectoryConfigurationPanel.this.onlyRegisteredRootsInSelection();
            }
        }).disableUpDownActions().createPanel();
        panelForTable.setPreferredSize((Dimension)new JBDimension(-1, 200));
        return panelForTable;
    }

    @NotNull
    private List<MapInfo> getSelectedUnregisteredRoots() {
        List list2 = ContainerUtil.filter((Collection)this.myDirectoryMappingTable.getSelection(), info -> ((MapInfo)info).type == MapInfo.Type.UNREGISTERED);
        if (list2 == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(12);
        }
        return list2;
    }

    private boolean rootsOfOneKindInSelection() {
        Collection selection = this.myDirectoryMappingTable.getSelection();
        if (selection.isEmpty()) {
            return true;
        }
        if (selection.size() == 1 && ((MapInfo)selection.iterator().next()).type == MapInfo.Type.SEPARATOR) {
            return false;
        }
        List<MapInfo> selectedRegisteredRoots = this.getSelectedRegisteredRoots();
        return selectedRegisteredRoots.size() == selection.size() || selectedRegisteredRoots.size() == 0;
    }

    @NotNull
    private List<MapInfo> getSelectedRegisteredRoots() {
        Collection selection = this.myDirectoryMappingTable.getSelection();
        List list2 = ContainerUtil.filter((Collection)selection, info -> ((MapInfo)info).type == MapInfo.Type.NORMAL || ((MapInfo)info).type == MapInfo.Type.INVALID);
        if (list2 == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(13);
        }
        return list2;
    }

    private boolean onlyRegisteredRootsInSelection() {
        return this.getSelectedRegisteredRoots().size() == this.myDirectoryMappingTable.getSelection().size();
    }

    private JComponent createProjectMappingDescription() {
        JBLabel label = new JBLabel(this.myProjectMessage);
        label.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        label.setFontColor(UIUtil.FontColor.BRIGHTER);
        label.setBorder((Border)JBUI.Borders.empty((int)2, (int)5, (int)2, (int)0));
        return label;
    }

    private JComponent createShowChangedOption() {
        this.myRecentlyChangedConfigurable = new VcsContentAnnotationConfigurable(this.myProject);
        JComponent component = this.myRecentlyChangedConfigurable.createComponent();
        assert (component != null);
        return component;
    }

    private JComponent createShowRecursivelyDirtyOption() {
        this.myShowChangedRecursively = new JCheckBox("Show directories with changed descendants", this.myVcsConfiguration.SHOW_DIRTY_RECURSIVELY);
        return this.myShowChangedRecursively;
    }

    public void reset() {
        this.initializeModel();
    }

    public void apply() throws ConfigurationException {
        this.adjustIgnoredRootsSettings();
        this.myVcsManager.setDirectoryMappings(this.getModelMappings());
        this.myRecentlyChangedConfigurable.apply();
        this.myLimitHistory.apply();
        this.myScopeFilterConfig.apply();
        this.myVcsConfiguration.SHOW_DIRTY_RECURSIVELY = this.myShowChangedRecursively.isSelected();
        this.initializeModel();
    }

    private void adjustIgnoredRootsSettings() {
        List<VcsDirectoryMapping> newMappings = this.getModelMappings();
        List previousMappings = this.myVcsManager.getDirectoryMappings();
        this.myVcsConfiguration.addIgnoredUnregisteredRoots((Collection)previousMappings.stream().filter(mapping -> !newMappings.contains(mapping)).map(mapping -> mapping.isDefaultMapping() ? ProjectUtil.guessProjectDir((Project)this.myProject).getPath() : mapping.getDirectory()).collect(Collectors.toList()));
        this.myVcsConfiguration.removeFromIgnoredUnregisteredRoots((Collection)ContainerUtil.map(newMappings, VcsDirectoryMapping::getDirectory));
    }

    public boolean isModified() {
        if (this.myRecentlyChangedConfigurable.isModified()) {
            return true;
        }
        if (this.myLimitHistory.isModified()) {
            return true;
        }
        if (this.myScopeFilterConfig.isModified()) {
            return true;
        }
        if (this.myVcsConfiguration.SHOW_DIRTY_RECURSIVELY != this.myShowChangedRecursively.isSelected()) {
            return true;
        }
        return !this.getModelMappings().equals(this.myVcsManager.getDirectoryMappings());
    }

    @NotNull
    private List<VcsDirectoryMapping> getModelMappings() {
        List list2 = ContainerUtil.mapNotNull((Collection)this.myModel.getItems(), info -> info == MapInfo.SEPARATOR || ((MapInfo)info).type == MapInfo.Type.UNREGISTERED ? null : ((MapInfo)info).mapping);
        if (list2 == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(14);
        }
        return list2;
    }

    public void addVcsListener(ModuleVcsListener moduleVcsListener) {
        this.myListeners.add(moduleVcsListener);
    }

    public void removeVcsListener(ModuleVcsListener moduleVcsListener) {
        this.myListeners.remove(moduleVcsListener);
    }

    private void checkNotifyListeners(Collection<AbstractVcs> oldVcses) {
        Collection<AbstractVcs> vcses = this.getActiveVcses();
        if (!vcses.equals(oldVcses)) {
            for (ModuleVcsListener listener2 : this.myListeners) {
                listener2.activeVcsSetChanged(vcses);
            }
        }
    }

    public Collection<AbstractVcs> getActiveVcses() {
        HashSet<AbstractVcs> vcses = new HashSet<AbstractVcs>();
        for (VcsDirectoryMapping mapping : this.getModelMappings()) {
            if (mapping.getVcs().length() <= 0) continue;
            vcses.add(this.myVcsManager.findVcsByName(mapping.getVcs()));
        }
        return vcses;
    }

    @Nls
    public String getDisplayName() {
        return "Mappings";
    }

    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        return this;
    }

    public void disposeUIResources() {
        this.myLimitHistory.disposeUIResources();
        this.myScopeFilterConfig.disposeUIResources();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnregisteredRootBackground";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findUnregisteredRoots";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVcsWrappersModel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedUnregisteredRoots";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRegisteredRoots";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelMappings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isMappingValid";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildVcsWrappersModel";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "sortAndAddSeparatorIfNeeded";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setMapping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyDirectoryRenderer
    extends ColoredTableCellRenderer {
        private final Project myProject;

        public MyDirectoryRenderer(Project project) {
            this.myProject = project;
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            if (value instanceof MapInfo) {
                MapInfo info = (MapInfo)value;
                if (!(selected || info != MapInfo.SEPARATOR && info.type != MapInfo.Type.UNREGISTERED)) {
                    this.setBackground(VcsDirectoryConfigurationPanel.getUnregisteredRootBackground());
                }
                if (info == MapInfo.SEPARATOR) {
                    this.append("Unregistered roots:", VcsDirectoryConfigurationPanel.getAttributes(info));
                    return;
                }
                if (info.mapping.isDefaultMapping()) {
                    this.append("<Project>", VcsDirectoryConfigurationPanel.getAttributes(info));
                    return;
                }
                String directory2 = info.mapping.getDirectory();
                VirtualFile baseDir = this.myProject.getBaseDir();
                if (baseDir != null) {
                    File directoryFile = new File(StringUtil.trimEnd((String)UriUtil.trimTrailingSlashes(directory2), (String)"\\") + "/");
                    File ioBase = new File(baseDir.getPath());
                    if (directoryFile.isAbsolute() && !FileUtil.isAncestor((File)ioBase, (File)directoryFile, (boolean)false)) {
                        this.append(new File(directory2).getPath(), VcsDirectoryConfigurationPanel.getAttributes(info));
                        return;
                    }
                    String relativePath = FileUtil.getRelativePath((File)ioBase, (File)directoryFile);
                    if (".".equals(relativePath) || relativePath == null) {
                        this.append(ioBase.getPath(), VcsDirectoryConfigurationPanel.getAttributes(info));
                    } else {
                        this.append(relativePath, VcsDirectoryConfigurationPanel.getAttributes(info));
                        this.append(" (" + ioBase + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                }
            }
        }
    }

    private static class MapInfo {
        static final MapInfo SEPARATOR = new MapInfo(new VcsDirectoryMapping("SEPARATOR", "SEP"), Type.SEPARATOR);
        static final Comparator<MapInfo> COMPARATOR = (o1, o2) -> {
            if (o1.type.isRegistered() && o2.type.isRegistered() || o1.type == Type.UNREGISTERED && o2.type == Type.UNREGISTERED) {
                return NewMappings.MAPPINGS_COMPARATOR.compare(o1.mapping, o2.mapping);
            }
            return o1.type.ordinal() - o2.type.ordinal();
        };
        private final Type type;
        private final VcsDirectoryMapping mapping;

        static MapInfo unregistered(@NotNull String path, @NotNull String vcs) {
            if (path == null) {
                MapInfo.$$$reportNull$$$0(0);
            }
            if (vcs == null) {
                MapInfo.$$$reportNull$$$0(1);
            }
            return new MapInfo(new VcsDirectoryMapping(path, vcs), Type.UNREGISTERED);
        }

        static MapInfo registered(@NotNull VcsDirectoryMapping mapping, boolean valid) {
            if (mapping == null) {
                MapInfo.$$$reportNull$$$0(2);
            }
            return new MapInfo(mapping, valid ? Type.NORMAL : Type.INVALID);
        }

        private MapInfo(@NotNull VcsDirectoryMapping mapping, @NotNull Type type) {
            if (mapping == null) {
                MapInfo.$$$reportNull$$$0(3);
            }
            if (type == null) {
                MapInfo.$$$reportNull$$$0(4);
            }
            this.mapping = mapping;
            this.type = type;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vcs";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapping";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$MapInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "unregistered";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registered";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        static enum Type {
            NORMAL,
            INVALID,
            SEPARATOR,
            UNREGISTERED;


            boolean isRegistered() {
                return this == NORMAL || this == INVALID;
            }
        }
    }
}

