/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.UiActivity;
import com.intellij.ide.UiActivityMonitor;
import com.intellij.internal.focus.FocusTracesAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.impl.ServiceManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EdtRunnable;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.util.TimedOutCallback;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.FocusRequestor;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.KeyEventProcessor;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.openapi.wm.ex.LayoutFocusTraversalPolicyExt;
import com.intellij.openapi.wm.impl.FocusRequestInfo;
import com.intellij.reference.SoftReference;
import com.intellij.ui.FocusTrackback;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntIntProcedure;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FocusManagerImpl
extends IdeFocusManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(FocusManagerImpl.class);
    private static final UiActivity FOCUS = new UiActivity.Focus(new String[]{"awtFocusRequest"});
    private static final UiActivity TYPEAHEAD = new UiActivity.Focus(new String[]{"typeahead"});
    private final Application myApp;
    private FocusCommand myRequestFocusCmd;
    private final List<FocusCommand> myFocusRequests = new ArrayList<FocusCommand>();
    private final List<KeyEvent> myToDispatchOnDone = new ArrayList<KeyEvent>();
    private Reference<FocusCommand> myLastForcedRequest;
    private FocusCommand myFocusCommandOnAppActivation;
    private ActionCallback myCallbackOnActivation;
    private final boolean isInternalMode = ApplicationManagerEx.getApplicationEx().isInternal();
    private final LinkedList<FocusRequestInfo> myRequests = new LinkedList();
    private final IdeEventQueue myQueue;
    private final KeyProcessorContext myKeyProcessorContext = new KeyProcessorContext();
    private long myCmdTimestamp;
    private long myForcedCmdTimestamp;
    private final EdtAlarm myFocusedComponentAlarm;
    private final EdtAlarm myForcedFocusRequestsAlarm;
    private final EdtAlarm myIdleAlarm;
    private final Set<Runnable> myIdleRequests = new LinkedHashSet<Runnable>();
    private boolean myFlushWasDelayedToFixFocus;
    private ExpirableRunnable myFocusRevalidator;
    private final Set<FurtherRequestor> myValidFurtherRequestors = new HashSet<FurtherRequestor>();
    private final Set<ActionCallback> myTypeAheadRequestors = new HashSet<ActionCallback>();
    private final UiActivityMonitor myActivityMonitor;
    private boolean myTypeaheadEnabled = true;
    private int myModalityStateForLastForcedRequest;
    private final Map<IdeFrame, Component> myLastFocused = ContainerUtil.createWeakValueMap();
    private final Map<IdeFrame, Component> myLastFocusedAtDeactivation = ContainerUtil.createWeakValueMap();
    private DataContext myRunContext;
    private final TIntIntHashMap myModalityCount2FlushCount = new TIntIntHashMap();
    private IdeFrame myLastFocusedFrame;

    private boolean canFlushIdleRequests() {
        Component focusOwner = this.getFocusOwner();
        return this.isFocusTransferReady() && !this.isIdleQueueEmpty() && !IdeEventQueue.getInstance().isDispatchingFocusEvent() && (focusOwner != null || this.myValidFurtherRequestors.isEmpty() && (this.myFocusRevalidator == null || this.myFocusRevalidator.isExpired()));
    }

    public FocusManagerImpl(ServiceManagerImpl serviceManager, WindowManager wm, UiActivityMonitor monitor) {
        this.myApp = ApplicationManager.getApplication();
        this.myQueue = IdeEventQueue.getInstance();
        this.myActivityMonitor = monitor;
        this.myFocusedComponentAlarm = new EdtAlarm();
        this.myForcedFocusRequestsAlarm = new EdtAlarm();
        this.myIdleAlarm = new EdtAlarm();
        AppListener myAppListener = new AppListener();
        this.myApp.getMessageBus().connect().subscribe(ApplicationActivationListener.TOPIC, (Object)myAppListener);
        IdeEventQueue.getInstance().addDispatcher(e -> {
            if (e instanceof FocusEvent) {
                FocusEvent fe = (FocusEvent)e;
                Component c = fe.getComponent();
                if (c instanceof Window || c == null) {
                    return false;
                }
                Component parent = UIUtil.findUltimateParent((Component)c);
                if (parent instanceof IdeFrame) {
                    this.myLastFocused.put((IdeFrame)parent, c);
                }
            } else if (e instanceof WindowEvent) {
                Window wnd = ((WindowEvent)e).getWindow();
                if (e.getID() == 202 && wnd instanceof IdeFrame) {
                    this.myLastFocused.remove(wnd);
                    this.myLastFocusedAtDeactivation.remove(wnd);
                }
            }
            return false;
        }, this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusedWindow", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() instanceof IdeFrame) {
                    FocusManagerImpl.this.myLastFocusedFrame = (IdeFrame)evt.getNewValue();
                }
            }
        });
    }

    public IdeFrame getLastFocusedFrame() {
        return this.myLastFocusedFrame;
    }

    public ActionCallback requestFocusInProject(@NotNull Component c, @Nullable Project project) {
        if (c == null) {
            FocusManagerImpl.$$$reportNull$$$0(0);
        }
        return this.requestFocus((FocusCommand)new FocusCommand.ByComponent(c, c, project, (Throwable)new Exception()), false);
    }

    @NotNull
    public ActionCallback requestFocus(@NotNull Component c, boolean forced) {
        if (c == null) {
            FocusManagerImpl.$$$reportNull$$$0(1);
        }
        ActionCallback actionCallback = this.requestFocus((FocusCommand)new FocusCommand.ByComponent(c, (Throwable)new Exception()), forced);
        if (actionCallback == null) {
            FocusManagerImpl.$$$reportNull$$$0(2);
        }
        return actionCallback;
    }

    @NotNull
    public ActionCallback requestFocus(@NotNull FocusCommand command, boolean forced) {
        if (command == null) {
            FocusManagerImpl.$$$reportNull$$$0(3);
        }
        FocusManagerImpl.assertDispatchThread();
        if (this.isInternalMode) {
            this.recordCommand(command, new Throwable(), forced);
        }
        ActionCallback result2 = new ActionCallback();
        this.myActivityMonitor.addActivity(FOCUS, ModalityState.any());
        if (!forced) {
            UIUtil.invokeAndWaitIfNeeded(() -> {
                if (command == null) {
                    FocusManagerImpl.$$$reportNull$$$0(57);
                }
                if (!this.myFocusRequests.contains(command)) {
                    this.myFocusRequests.add(command);
                }
            });
            SwingUtilities.invokeLater(() -> {
                if (command == null) {
                    FocusManagerImpl.$$$reportNull$$$0(56);
                }
                this.resetUnforcedCommand(command);
                this._requestFocus(command, forced, result2);
            });
        } else {
            this._requestFocus(command, forced, result2);
        }
        result2.doWhenProcessed(() -> this.restartIdleAlarm());
        ActionCallback actionCallback = result2;
        if (actionCallback == null) {
            FocusManagerImpl.$$$reportNull$$$0(4);
        }
        return actionCallback;
    }

    @NotNull
    public List<FocusRequestInfo> getRequests() {
        LinkedList<FocusRequestInfo> linkedList = this.myRequests;
        if (linkedList == null) {
            FocusManagerImpl.$$$reportNull$$$0(5);
        }
        return linkedList;
    }

    public void recordFocusRequest(Component c, boolean forced) {
        this.myRequests.add(new FocusRequestInfo(c, new Throwable(), forced));
        if (this.myRequests.size() > 200) {
            this.myRequests.removeFirst();
        }
    }

    private void recordCommand(@NotNull FocusCommand command, @NotNull Throwable trace, boolean forced) {
        if (command == null) {
            FocusManagerImpl.$$$reportNull$$$0(6);
        }
        if (trace == null) {
            FocusManagerImpl.$$$reportNull$$$0(7);
        }
        if (FocusTracesAction.isActive()) {
            this.recordFocusRequest(command.getDominationComponent(), forced);
        }
    }

    private void _requestFocus(final @NotNull FocusCommand command, boolean forced, final @NotNull ActionCallback result2) {
        if (command == null) {
            FocusManagerImpl.$$$reportNull$$$0(8);
        }
        if (result2 == null) {
            FocusManagerImpl.$$$reportNull$$$0(9);
        }
        result2.doWhenProcessed(() -> this.maybeRemoveFocusActivity());
        if (this.checkForRejectOrByPass(command, forced, result2)) {
            return;
        }
        this.setCommand(command);
        command.setCallback(result2);
        if (forced) {
            this.myForcedFocusRequestsAlarm.cancelAllRequests();
            this.setLastEffectiveForcedRequest(command);
        }
        SwingUtilities.invokeLater(() -> {
            if (command == null) {
                FocusManagerImpl.$$$reportNull$$$0(48);
            }
            if (result2 == null) {
                FocusManagerImpl.$$$reportNull$$$0(49);
            }
            if (this.checkForRejectOrByPass(command, forced, result2)) {
                return;
            }
            if (this.myRequestFocusCmd == command) {
                TimedOutCallback focusTimeout = new TimedOutCallback(Registry.intValue((String)"actionSystem.commandProcessingTimeout"), "Focus command timed out, cmd=" + command, command.getAllocation(), true){

                    protected void onTimeout() {
                        FocusManagerImpl.this.forceFinishFocusSettleDown(command, result2);
                    }
                };
                if (command.invalidatesRequestors()) {
                    ++this.myCmdTimestamp;
                }
                this.revalidateFurtherRequestors();
                if (forced) {
                    if (command.invalidatesRequestors()) {
                        ++this.myForcedCmdTimestamp;
                    }
                    this.revalidateFurtherRequestors();
                }
                command.setForced(forced);
                command.run().doWhenDone(() -> {
                    if (command == null) {
                        FocusManagerImpl.$$$reportNull$$$0(52);
                    }
                    if (result2 == null) {
                        FocusManagerImpl.$$$reportNull$$$0(53);
                    }
                    UIUtil.invokeLaterIfNeeded(() -> {
                        if (command == null) {
                            FocusManagerImpl.$$$reportNull$$$0(54);
                        }
                        if (result2 == null) {
                            FocusManagerImpl.$$$reportNull$$$0(55);
                        }
                        this.resetCommand(command, false);
                        result2.setDone();
                    });
                }).doWhenRejected(() -> {
                    if (result2 == null) {
                        FocusManagerImpl.$$$reportNull$$$0(50);
                    }
                    if (command == null) {
                        FocusManagerImpl.$$$reportNull$$$0(51);
                    }
                    result2.setRejected();
                    this.resetCommand(command, true);
                }).doWhenProcessed(() -> {
                    if (forced) {
                        this.myForcedFocusRequestsAlarm.addRequest(new SetLastEffectiveRunnable(), 250);
                    }
                }).notify((ActionCallback)focusTimeout);
            } else {
                this.rejectCommand(command, result2);
            }
        });
    }

    private void maybeRemoveFocusActivity() {
        if (this.isFocusTransferReady()) {
            this.myActivityMonitor.removeActivity(FOCUS);
        }
    }

    private boolean checkForRejectOrByPass(@NotNull FocusCommand cmd, boolean forced, @NotNull ActionCallback result2) {
        if (cmd == null) {
            FocusManagerImpl.$$$reportNull$$$0(10);
        }
        if (result2 == null) {
            FocusManagerImpl.$$$reportNull$$$0(11);
        }
        if (cmd.isExpired()) {
            this.rejectCommand(cmd, result2);
            return true;
        }
        FocusCommand lastRequest = this.getLastEffectiveForcedRequest();
        if (!forced && !this.isUnforcedRequestAllowed()) {
            if (cmd.equals((Object)lastRequest)) {
                this.resetCommand(cmd, false);
                result2.setDone();
            } else {
                this.rejectCommand(cmd, result2);
            }
            return true;
        }
        if (lastRequest != null && lastRequest.dominatesOver(cmd)) {
            this.rejectCommand(cmd, result2);
            return true;
        }
        if (!Registry.is((String)"focus.fix.lost.cursor")) {
            boolean doNotExecuteBecauseAppIsInactive;
            boolean bl = doNotExecuteBecauseAppIsInactive = !this.myApp.isActive() && !FocusManagerImpl.canExecuteOnInactiveApplication(cmd) && Registry.is((String)"actionSystem.suspendFocusTransferIfApplicationInactive");
            if (doNotExecuteBecauseAppIsInactive) {
                if (this.myCallbackOnActivation != null) {
                    this.myCallbackOnActivation.setRejected();
                    if (this.myFocusCommandOnAppActivation != null) {
                        this.resetCommand(this.myFocusCommandOnAppActivation, true);
                    }
                }
                this.myFocusCommandOnAppActivation = cmd;
                this.myCallbackOnActivation = result2;
                return true;
            }
        }
        return false;
    }

    private void setCommand(@NotNull FocusCommand command) {
        if (command == null) {
            FocusManagerImpl.$$$reportNull$$$0(12);
        }
        this.myRequestFocusCmd = command;
        UIUtil.invokeAndWaitIfNeeded(() -> {
            if (command == null) {
                FocusManagerImpl.$$$reportNull$$$0(47);
            }
            if (!this.myFocusRequests.contains(command)) {
                this.myFocusRequests.add(command);
            }
        });
    }

    private void resetCommand(@NotNull FocusCommand cmd, boolean reject) {
        ActionCallback cb;
        KeyEventProcessor processor2;
        if (cmd == null) {
            FocusManagerImpl.$$$reportNull$$$0(13);
        }
        FocusManagerImpl.assertDispatchThread();
        if (cmd == this.myRequestFocusCmd) {
            this.myRequestFocusCmd = null;
        }
        if ((processor2 = cmd.getProcessor()) != null) {
            processor2.finish((KeyEventProcessor.Context)this.myKeyProcessorContext);
        }
        UIUtil.invokeAndWaitIfNeeded(() -> {
            if (cmd == null) {
                FocusManagerImpl.$$$reportNull$$$0(46);
            }
            this.myFocusRequests.remove(cmd);
        });
        if (reject && (cb = cmd.getCallback()) != null && !cb.isProcessed()) {
            cmd.getCallback().setRejected();
        }
    }

    private void resetUnforcedCommand(@NotNull FocusCommand cmd) {
        if (cmd == null) {
            FocusManagerImpl.$$$reportNull$$$0(14);
        }
        UIUtil.invokeAndWaitIfNeeded(() -> {
            if (cmd == null) {
                FocusManagerImpl.$$$reportNull$$$0(45);
            }
            this.myFocusRequests.remove(cmd);
        });
    }

    private static boolean canExecuteOnInactiveApplication(@NotNull FocusCommand cmd) {
        if (cmd == null) {
            FocusManagerImpl.$$$reportNull$$$0(15);
        }
        return cmd.canExecuteOnInactiveApp();
    }

    private void setLastEffectiveForcedRequest(@Nullable FocusCommand command) {
        this.myLastForcedRequest = command == null ? null : new WeakReference<FocusCommand>(command);
        this.myModalityStateForLastForcedRequest = this.getCurrentModalityCount();
    }

    @Nullable
    private FocusCommand getLastEffectiveForcedRequest() {
        FocusCommand request = (FocusCommand)SoftReference.dereference(this.myLastForcedRequest);
        return request != null && !request.isExpired() ? request : null;
    }

    boolean isUnforcedRequestAllowed() {
        if (this.getLastEffectiveForcedRequest() == null) {
            return true;
        }
        return this.myModalityStateForLastForcedRequest != this.getCurrentModalityCount();
    }

    public static FocusManagerImpl getInstance() {
        return (FocusManagerImpl)((Object)ApplicationManager.getApplication().getComponent(IdeFocusManager.class));
    }

    public void dispose() {
        this.myForcedFocusRequestsAlarm.cancelAllRequests();
        this.myFocusedComponentAlarm.cancelAllRequests();
        for (FurtherRequestor requestor : this.myValidFurtherRequestors) {
            Disposer.dispose((Disposable)requestor);
        }
        this.myValidFurtherRequestors.clear();
    }

    public void doWhenFocusSettlesDown(@NotNull ExpirableRunnable runnable2) {
        if (runnable2 == null) {
            FocusManagerImpl.$$$reportNull$$$0(16);
        }
        this.doWhenFocusSettlesDown((Runnable)runnable2);
    }

    public void doWhenFocusSettlesDown(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            FocusManagerImpl.$$$reportNull$$$0(17);
        }
        boolean invokedOnEdt = ApplicationManager.getApplication().isDispatchThread();
        UIUtil.invokeLaterIfNeeded(() -> {
            if (runnable2 == null) {
                FocusManagerImpl.$$$reportNull$$$0(44);
            }
            if (this.isFlushingIdleRequests()) {
                this.myIdleRequests.add(runnable2);
                return;
            }
            if (this.myRunContext != null || invokedOnEdt && this.canFlushIdleRequests()) {
                FocusManagerImpl.flushRequest(runnable2);
                return;
            }
            boolean needsRestart = this.isIdleQueueEmpty();
            if (this.myIdleRequests.contains(runnable2)) {
                this.myIdleRequests.remove(runnable2);
                this.myIdleRequests.add(runnable2);
            } else {
                this.myIdleRequests.add(runnable2);
            }
            if (this.canFlushIdleRequests()) {
                this.flushIdleRequests();
            } else if (needsRestart) {
                this.restartIdleAlarm();
            }
        });
    }

    public void doWhenFocusSettlesDown(@NotNull Runnable runnable2, @NotNull ModalityState modality) {
        if (runnable2 == null) {
            FocusManagerImpl.$$$reportNull$$$0(18);
        }
        if (modality == null) {
            FocusManagerImpl.$$$reportNull$$$0(19);
        }
        AtomicBoolean immediate = new AtomicBoolean(true);
        this.doWhenFocusSettlesDown(() -> {
            if (runnable2 == null) {
                FocusManagerImpl.$$$reportNull$$$0(40);
            }
            if (modality == null) {
                FocusManagerImpl.$$$reportNull$$$0(41);
            }
            if (immediate.get()) {
                FocusManagerImpl.flushRequest(runnable2);
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (runnable2 == null) {
                    FocusManagerImpl.$$$reportNull$$$0(42);
                }
                if (modality == null) {
                    FocusManagerImpl.$$$reportNull$$$0(43);
                }
                this.doWhenFocusSettlesDown(runnable2, modality);
            }, modality);
        });
        immediate.set(false);
    }

    private void restartIdleAlarm() {
        if (!ApplicationManager.getApplication().isActive()) {
            return;
        }
        this.myIdleAlarm.cancelAllRequests();
        this.myIdleAlarm.addRequest(new IdleRunnable(), Registry.intValue((String)"actionSystem.focusIdleTimeout"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushIdleRequests() {
        int currentModalityCount = this.getCurrentModalityCount();
        try {
            this.incFlushingRequests(1, currentModalityCount);
            if (!this.isTypeaheadEnabled()) {
                this.myToDispatchOnDone.clear();
                this.myTypeAheadRequestors.clear();
            }
            if (!this.myToDispatchOnDone.isEmpty() && this.myTypeAheadRequestors.isEmpty()) {
                KeyEvent[] events = this.myToDispatchOnDone.toArray(new KeyEvent[this.myToDispatchOnDone.size()]);
                IdeEventQueue.getInstance().getKeyEventDispatcher().resetState();
                for (int eachIndex = 0; eachIndex < events.length && this.isFocusTransferReady(); ++eachIndex) {
                    KeyEvent each = events[eachIndex];
                    Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                    if (owner == null) {
                        owner = JOptionPane.getRootFrame();
                    }
                    boolean metaKey = each.getKeyCode() == 18 || each.getKeyCode() == 17 || each.getKeyCode() == 16 || each.getKeyCode() == 157;
                    boolean toDispatch = false;
                    if (!(metaKey || each.getID() != 402 && each.getID() != 400)) {
                        for (int i = 0; i < eachIndex; ++i) {
                            KeyEvent prev = events[i];
                            if (prev == null || prev.getID() != 401 || prev.getKeyCode() != each.getKeyCode() && prev.getKeyChar() != each.getKeyChar()) continue;
                            toDispatch = true;
                            events[i] = null;
                            break;
                        }
                    } else {
                        toDispatch = true;
                    }
                    this.myToDispatchOnDone.remove(each);
                    if (!toDispatch) continue;
                    KeyEvent keyEvent = new KeyEvent(owner, each.getID(), each.getWhen(), each.getModifiersEx(), each.getKeyCode(), each.getKeyChar(), each.getKeyLocation());
                    if (SwingUtilities.getWindowAncestor(owner) != null) {
                        IdeEventQueue.getInstance().dispatchEvent(keyEvent);
                        continue;
                    }
                    ((TransactionGuardImpl)TransactionGuard.getInstance()).performUserActivity(() -> this.myQueue._dispatchEvent(keyEvent, true));
                }
                if (this.myToDispatchOnDone.isEmpty() && this.myTypeAheadRequestors.isEmpty()) {
                    this.myActivityMonitor.removeActivity(TYPEAHEAD);
                }
            }
            if (!this.isFocusBeingTransferred()) {
                boolean focusOk;
                boolean bl = focusOk = this.getFocusOwner() != null;
                if (!focusOk && !this.myFlushWasDelayedToFixFocus) {
                    IdeEventQueue.getInstance().fixStickyFocusedComponents(null);
                    this.myFlushWasDelayedToFixFocus = true;
                } else if (!focusOk) {
                    this.myFlushWasDelayedToFixFocus = false;
                }
                if (this.canFlushIdleRequests() && this.getFlushingIdleRequests() <= 1 && (focusOk || !this.myFlushWasDelayedToFixFocus)) {
                    this.myFlushWasDelayedToFixFocus = false;
                    this.flushNow();
                }
            }
        }
        finally {
            this.incFlushingRequests(-1, currentModalityCount);
            if (!this.isIdleQueueEmpty()) {
                this.restartIdleAlarm();
            }
            this.maybeRemoveFocusActivity();
        }
    }

    private boolean processFocusRevalidation() {
        ExpirableRunnable revalidator = this.myFocusRevalidator;
        this.myFocusRevalidator = null;
        if (revalidator != null && !revalidator.isExpired()) {
            revalidator.run();
            return true;
        }
        return false;
    }

    private void flushNow() {
        Runnable[] all = this.myIdleRequests.toArray(new Runnable[this.myIdleRequests.size()]);
        this.myIdleRequests.clear();
        for (int i = 0; i < all.length; ++i) {
            FocusManagerImpl.flushRequest(all[i]);
            if (!this.isFocusBeingTransferred()) continue;
            for (int j = i + 1; j < all.length; ++j) {
                this.myIdleRequests.add(all[j]);
            }
            break;
        }
        this.maybeRemoveFocusActivity();
    }

    private static void flushRequest(Runnable each) {
        if (each == null) {
            return;
        }
        if (each instanceof Expirable) {
            if (!((Expirable)each).isExpired()) {
                each.run();
            }
        } else {
            each.run();
        }
    }

    public boolean isFocusTransferReady() {
        FocusManagerImpl.assertDispatchThread();
        if (this.myRunContext != null) {
            return true;
        }
        this.invalidateFocusRequestsQueue();
        if (!this.myFocusRequests.isEmpty()) {
            return false;
        }
        if (this.myQueue == null) {
            return true;
        }
        return !this.myQueue.isSuspendMode() && !this.myQueue.hasFocusEventsPending();
    }

    private void invalidateFocusRequestsQueue() {
        FocusManagerImpl.assertDispatchThread();
        UIUtil.invokeAndWaitIfNeeded(() -> {
            if (this.myFocusRequests.isEmpty()) {
                return;
            }
            FocusCommand[] requests = this.myFocusRequests.toArray(new FocusCommand[this.myFocusRequests.size()]);
            boolean wasChanged = false;
            for (FocusCommand each : requests) {
                if (!each.isExpired()) continue;
                this.resetCommand(each, true);
                wasChanged = true;
            }
            if (wasChanged && this.myFocusRequests.isEmpty()) {
                this.restartIdleAlarm();
            }
        });
    }

    private boolean isIdleQueueEmpty() {
        return this.isPendingKeyEventsRedispatched() && this.myIdleRequests.isEmpty();
    }

    private boolean isPendingKeyEventsRedispatched() {
        return this.myToDispatchOnDone.isEmpty();
    }

    public boolean dispatch(@NotNull KeyEvent e) {
        if (e == null) {
            FocusManagerImpl.$$$reportNull$$$0(20);
        }
        if (!this.isTypeaheadEnabled()) {
            return false;
        }
        if (this.isFlushingIdleRequests()) {
            return false;
        }
        FocusManagerImpl.assertDispatchThread();
        if (!(this.isFocusTransferReady() && this.isPendingKeyEventsRedispatched() && this.myTypeAheadRequestors.isEmpty())) {
            for (FocusCommand each : this.myFocusRequests) {
                Boolean result2;
                KeyEventProcessor processor2 = each.getProcessor();
                if (processor2 == null || (result2 = processor2.dispatch(e, (KeyEventProcessor.Context)this.myKeyProcessorContext)) == null) continue;
                if (result2.booleanValue()) {
                    this.myActivityMonitor.addActivity(TYPEAHEAD, ModalityState.any());
                    return true;
                }
                return false;
            }
            this.myToDispatchOnDone.add(e);
            this.myActivityMonitor.addActivity(TYPEAHEAD, ModalityState.any());
            this.restartIdleAlarm();
            return true;
        }
        return false;
    }

    public void setTypeaheadEnabled(boolean enabled) {
        this.myTypeaheadEnabled = enabled;
    }

    private boolean isTypeaheadEnabled() {
        return Registry.is((String)"actionSystem.fixLostTyping") && this.myTypeaheadEnabled;
    }

    public void typeAheadUntil(@NotNull ActionCallback callback, final @NotNull String cause) {
        ActionCallback done2;
        if (callback == null) {
            FocusManagerImpl.$$$reportNull$$$0(21);
        }
        if (cause == null) {
            FocusManagerImpl.$$$reportNull$$$0(22);
        }
        if (!this.isTypeaheadEnabled()) {
            return;
        }
        final long currentTime = System.currentTimeMillis();
        if (!Registry.is((String)"type.ahead.logging.enabled")) {
            done2 = callback;
        } else {
            String id = new Exception().getStackTrace()[2].getClassName();
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM yyyy HH:ss:SSS", Locale.US);
            LOG.info(dateFormat.format(System.currentTimeMillis()) + "\tStarted:  " + id);
            done2 = new ActionCallback();
            callback.doWhenDone(() -> {
                done2.setDone();
                LOG.info(dateFormat.format(System.currentTimeMillis()) + "\tDone:     " + id);
            });
            callback.doWhenRejected(() -> {
                done2.setRejected();
                LOG.info(dateFormat.format(System.currentTimeMillis()) + "\tRejected: " + id);
            });
        }
        FocusManagerImpl.assertDispatchThread();
        this.myTypeAheadRequestors.add(done2);
        done2.notify(new TimedOutCallback((long)Registry.intValue((String)"actionSystem.commandProcessingTimeout"), "Typeahead request blocked", (Throwable)new Exception(){

            @Override
            public String getMessage() {
                return "Time: " + (System.currentTimeMillis() - currentTime) + "; cause: " + cause;
            }
        }, true).doWhenProcessed(() -> {
            if (this.myTypeAheadRequestors.remove(done2)) {
                this.restartIdleAlarm();
            }
        }));
    }

    private boolean isFlushingIdleRequests() {
        return this.getFlushingIdleRequests() > 0;
    }

    private int getFlushingIdleRequests() {
        int currentModalityCount = this.getCurrentModalityCount();
        return this.myModalityCount2FlushCount.get(currentModalityCount);
    }

    private void incFlushingRequests(int delta, int currentModalityCount) {
        if (this.myModalityCount2FlushCount.containsKey(currentModalityCount)) {
            this.myModalityCount2FlushCount.adjustValue(currentModalityCount, delta);
        } else {
            this.myModalityCount2FlushCount.put(currentModalityCount, delta);
        }
    }

    private int getCurrentModalityCount() {
        Window[] windows;
        int modalityCount = 0;
        for (Window each : windows = Window.getWindows()) {
            JRootPane rootPane;
            if (!each.isShowing()) continue;
            if (each instanceof Dialog) {
                Dialog eachDialog = (Dialog)each;
                if (eachDialog.isModal()) {
                    ++modalityCount;
                    continue;
                }
                if (!(each instanceof JDialog) || !FocusManagerImpl.isModalContextPopup(((JDialog)each).getRootPane())) continue;
                ++modalityCount;
                continue;
            }
            if (!(each instanceof JWindow) || !FocusManagerImpl.isModalContextPopup(rootPane = ((JWindow)each).getRootPane())) continue;
            ++modalityCount;
        }
        final int finalModalityCount = modalityCount;
        this.myModalityCount2FlushCount.retainEntries(new TIntIntProcedure(){

            public boolean execute(int eachModalityCount, int flushCount) {
                return eachModalityCount <= finalModalityCount;
            }
        });
        return modalityCount;
    }

    private static boolean isModalContextPopup(@NotNull JRootPane rootPane) {
        JBPopup popup2;
        if (rootPane == null) {
            FocusManagerImpl.$$$reportNull$$$0(23);
        }
        return (popup2 = (JBPopup)rootPane.getClientProperty("JBPopup")) != null && popup2.isModalContext();
    }

    @NotNull
    public Expirable getTimestamp(final boolean trackOnlyForcedCommands) {
        FocusManagerImpl.assertDispatchThread();
        Expirable expirable = new Expirable(){
            long myOwnStamp;
            {
                this.myOwnStamp = trackOnlyForcedCommands ? FocusManagerImpl.this.myForcedCmdTimestamp : FocusManagerImpl.this.myCmdTimestamp;
            }

            public boolean isExpired() {
                return this.myOwnStamp < (trackOnlyForcedCommands ? FocusManagerImpl.this.myForcedCmdTimestamp : FocusManagerImpl.this.myCmdTimestamp);
            }
        };
        if (expirable == null) {
            FocusManagerImpl.$$$reportNull$$$0(24);
        }
        return expirable;
    }

    @NotNull
    public FocusRequestor getFurtherRequestor() {
        FocusManagerImpl.assertDispatchThread();
        FurtherRequestor requestor = new FurtherRequestor(this, this.getTimestamp(true));
        this.myValidFurtherRequestors.add(requestor);
        this.revalidateFurtherRequestors();
        FurtherRequestor furtherRequestor = requestor;
        if (furtherRequestor == null) {
            FocusManagerImpl.$$$reportNull$$$0(25);
        }
        return furtherRequestor;
    }

    private void revalidateFurtherRequestors() {
        Iterator<FurtherRequestor> requestorIterator = this.myValidFurtherRequestors.iterator();
        while (requestorIterator.hasNext()) {
            FurtherRequestor each = requestorIterator.next();
            if (!each.isExpired()) continue;
            requestorIterator.remove();
            Disposer.dispose((Disposable)each);
        }
    }

    public void revalidateFocus(@NotNull ExpirableRunnable runnable2) {
        if (runnable2 == null) {
            FocusManagerImpl.$$$reportNull$$$0(26);
        }
        SwingUtilities.invokeLater(() -> {
            if (runnable2 == null) {
                FocusManagerImpl.$$$reportNull$$$0(39);
            }
            this.myFocusRevalidator = runnable2;
            this.restartIdleAlarm();
        });
    }

    public Component getFocusOwner() {
        FocusManagerImpl.assertDispatchThread();
        Component result2 = null;
        if (!ApplicationManager.getApplication().isActive()) {
            result2 = this.myLastFocusedAtDeactivation.get(this.getLastFocusedFrame());
        } else if (this.myRunContext != null) {
            result2 = (Component)this.myRunContext.getData(PlatformDataKeys.CONTEXT_COMPONENT.getName());
        }
        if (result2 == null) {
            result2 = this.isFocusBeingTransferred() ? null : KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        }
        boolean meaninglessOwner = UIUtil.isMeaninglessFocusOwner((Component)result2);
        if (result2 == null && !this.isFocusBeingTransferred() || meaninglessOwner) {
            Component permOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
            if (permOwner != null) {
                result2 = permOwner;
            }
            if (UIUtil.isMeaninglessFocusOwner((Component)result2)) {
                result2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            }
        }
        return result2;
    }

    public void runOnOwnContext(@NotNull DataContext context, @NotNull Runnable runnable2) {
        if (context == null) {
            FocusManagerImpl.$$$reportNull$$$0(27);
        }
        if (runnable2 == null) {
            FocusManagerImpl.$$$reportNull$$$0(28);
        }
        FocusManagerImpl.assertDispatchThread();
        this.myRunContext = context;
        try {
            runnable2.run();
        }
        finally {
            this.myRunContext = null;
        }
    }

    public Component getLastFocusedFor(IdeFrame frame) {
        FocusManagerImpl.assertDispatchThread();
        return this.myLastFocused.get(frame);
    }

    public void setLastFocusedAtDeactivation(@NotNull IdeFrame frame, @NotNull Component c) {
        if (frame == null) {
            FocusManagerImpl.$$$reportNull$$$0(29);
        }
        if (c == null) {
            FocusManagerImpl.$$$reportNull$$$0(30);
        }
        this.myLastFocusedAtDeactivation.put(frame, c);
    }

    public void toFront(JComponent c) {
        FocusManagerImpl.assertDispatchThread();
        if (c == null) {
            return;
        }
        Window window = (Window)UIUtil.getParentOfType(Window.class, (Component)c);
        if (window != null && window.isShowing()) {
            this.doWhenFocusSettlesDown(() -> {
                if (ApplicationManager.getApplication().isActive()) {
                    if (window instanceof JFrame && ((JFrame)window).getState() == 1) {
                        ((JFrame)window).setState(0);
                    } else {
                        window.toFront();
                    }
                }
            });
        }
    }

    private void forceFinishFocusSettleDown(@NotNull FocusCommand cmd, @NotNull ActionCallback cmdCallback) {
        if (cmd == null) {
            FocusManagerImpl.$$$reportNull$$$0(31);
        }
        if (cmdCallback == null) {
            FocusManagerImpl.$$$reportNull$$$0(32);
        }
        this.rejectCommand(cmd, cmdCallback);
    }

    private void rejectCommand(@NotNull FocusCommand cmd, @NotNull ActionCallback callback) {
        if (cmd == null) {
            FocusManagerImpl.$$$reportNull$$$0(33);
        }
        if (callback == null) {
            FocusManagerImpl.$$$reportNull$$$0(34);
        }
        this.resetCommand(cmd, true);
        this.resetUnforcedCommand(cmd);
        callback.setRejected();
    }

    @Nullable
    private static Component getComponent(@NotNull Map<IdeFrame, Component> map2, IdeFrame frame) {
        if (map2 == null) {
            FocusManagerImpl.$$$reportNull$$$0(35);
        }
        return map2.get(frame);
    }

    public JComponent getFocusTargetFor(@NotNull JComponent comp) {
        if (comp == null) {
            FocusManagerImpl.$$$reportNull$$$0(36);
        }
        return IdeFocusTraversalPolicy.getPreferredFocusedComponent(comp);
    }

    public Component getFocusedDescendantFor(Component comp) {
        Component focused = this.getFocusOwner();
        if (focused == null) {
            return null;
        }
        if (focused == comp || SwingUtilities.isDescendingFrom(focused, comp)) {
            return focused;
        }
        List<JBPopup> popups = FocusTrackback.getChildPopups(comp);
        for (JBPopup each : popups) {
            if (!each.isFocused()) continue;
            return focused;
        }
        return null;
    }

    public boolean isFocusBeingTransferred() {
        return !this.isFocusTransferReady();
    }

    @NotNull
    public ActionCallback requestDefaultFocus(boolean forced) {
        Component toFocus;
        block7: {
            Window[] windows;
            block6: {
                toFocus = null;
                if (this.myLastFocusedFrame == null) break block6;
                toFocus = this.myLastFocused.get(this.myLastFocusedFrame);
                if (toFocus != null && toFocus.isShowing()) break block7;
                toFocus = this.getFocusTargetFor(this.myLastFocusedFrame.getComponent());
                break block7;
            }
            for (Window each : windows = Window.getWindows()) {
                if (!each.isActive()) continue;
                if (each instanceof JFrame) {
                    toFocus = this.getFocusTargetFor(((JFrame)each).getRootPane());
                    break;
                }
                if (each instanceof JDialog) {
                    toFocus = this.getFocusTargetFor(((JDialog)each).getRootPane());
                    break;
                }
                if (!(each instanceof JWindow)) continue;
                toFocus = this.getFocusTargetFor(((JWindow)each).getRootPane());
                break;
            }
        }
        if (toFocus != null) {
            ActionCallback actionCallback = this.requestFocus(new FocusCommand.ByComponent(toFocus, (Throwable)new Exception()).setToInvalidateRequestors(false), forced);
            if (actionCallback == null) {
                FocusManagerImpl.$$$reportNull$$$0(37);
            }
            return actionCallback;
        }
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            FocusManagerImpl.$$$reportNull$$$0(38);
        }
        return actionCallback;
    }

    public boolean isFocusTransferEnabled() {
        if (Registry.is((String)"focus.fix.lost.cursor")) {
            return true;
        }
        return this.myApp.isActive() || !Registry.is((String)"actionSystem.suspendFocusTransferIfApplicationInactive");
    }

    private static void assertDispatchThread() {
        if (Registry.is((String)"actionSystem.assertFocusAccessFromEdt")) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 24: 
            case 25: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 24: 
            case 25: 
            case 37: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 24: 
            case 25: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/FocusManagerImpl";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 12: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 9: 
            case 11: 
            case 49: 
            case 50: 
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 31: 
            case 33: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 26: 
            case 28: 
            case 39: 
            case 40: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 19: 
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 21: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPane";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdCallback";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/FocusManagerImpl";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "requestFocus";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequests";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimestamp";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getFurtherRequestor";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "requestDefaultFocus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "requestFocusInProject";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "requestFocus";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 24: 
            case 25: 
            case 37: 
            case 38: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "recordCommand";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "_requestFocus";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkForRejectOrByPass";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setCommand";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resetCommand";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resetUnforcedCommand";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "canExecuteOnInactiveApplication";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doWhenFocusSettlesDown";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "dispatch";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "typeAheadUntil";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isModalContextPopup";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "revalidateFocus";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "runOnOwnContext";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setLastFocusedAtDeactivation";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "forceFinishFocusSettleDown";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "rejectCommand";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getComponent";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getFocusTargetFor";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$revalidateFocus$21";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doWhenFocusSettlesDown$15";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$14";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doWhenFocusSettlesDown$13";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resetUnforcedCommand$12";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resetCommand$11";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setCommand$10";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "lambda$_requestFocus$9";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$7";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$6";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$5";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "lambda$requestFocus$2";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "lambda$requestFocus$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 24: 
            case 25: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SetLastEffectiveRunnable
    extends EdtRunnable {
        private SetLastEffectiveRunnable() {
        }

        public void runEdt() {
            FocusManagerImpl.this.setLastEffectiveForcedRequest(null);
        }
    }

    private class AppListener
    implements ApplicationActivationListener {
        private AppListener() {
        }

        public void applicationActivated(IdeFrame ideFrame) {
            FocusCommand cmd = FocusManagerImpl.this.myFocusCommandOnAppActivation;
            ActionCallback callback = FocusManagerImpl.this.myCallbackOnActivation;
            FocusManagerImpl.this.myFocusCommandOnAppActivation = null;
            FocusManagerImpl.this.myCallbackOnActivation = null;
            if (cmd != null) {
                FocusManagerImpl.this.requestFocus(cmd, true).notify(callback);
            } else {
                this.focusLastFocusedComponent(ideFrame);
            }
        }

        public void delayedApplicationDeactivated(IdeFrame ideFrame) {
            Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            Component parent = UIUtil.findUltimateParent((Component)owner);
            if (parent == ideFrame) {
                FocusManagerImpl.this.myLastFocusedAtDeactivation.put(ideFrame, owner);
            }
        }

        private void focusLastFocusedComponent(IdeFrame ideFrame) {
            KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            if (mgr.getFocusOwner() == null) {
                Component c = FocusManagerImpl.getComponent(FocusManagerImpl.this.myLastFocusedAtDeactivation, ideFrame);
                if (c == null || !c.isShowing()) {
                    c = FocusManagerImpl.getComponent(FocusManagerImpl.this.myLastFocusedAtDeactivation, ideFrame);
                }
                boolean mouseEventAhead = IdeEventQueue.isMouseEventAhead(null);
                if (c != null && c.isShowing() && !mouseEventAhead) {
                    LayoutFocusTraversalPolicyExt policy = LayoutFocusTraversalPolicyExt.findWindowPolicy(c);
                    if (policy != null) {
                        policy.setNoDefaultComponent(true, (Object)FocusManagerImpl.this);
                    }
                    FocusManagerImpl.this.requestFocus(c, false).doWhenProcessed(() -> {
                        if (policy != null) {
                            policy.setNoDefaultComponent(false, (Object)FocusManagerImpl.this);
                        }
                    });
                }
            }
            FocusManagerImpl.this.myLastFocusedAtDeactivation.remove(ideFrame);
        }
    }

    static class EdtAlarm {
        private final Set<EdtRunnable> myRequests = new HashSet<EdtRunnable>();

        EdtAlarm() {
        }

        public void cancelAllRequests() {
            for (EdtRunnable each : this.myRequests) {
                each.expire();
            }
            this.myRequests.clear();
        }

        public void addRequest(@NotNull EdtRunnable runnable2, int delay) {
            if (runnable2 == null) {
                EdtAlarm.$$$reportNull$$$0(0);
            }
            this.myRequests.add(runnable2);
            EdtExecutorService.getScheduledExecutorInstance().schedule((Runnable)runnable2, (long)delay, TimeUnit.MILLISECONDS);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/wm/impl/FocusManagerImpl$EdtAlarm", "addRequest"));
        }
    }

    private static class FurtherRequestor
    implements FocusRequestor {
        private final IdeFocusManager myManager;
        private final Expirable myExpirable;
        private Throwable myAllocation;
        private boolean myDisposed;

        private FurtherRequestor(@NotNull IdeFocusManager manager, @NotNull Expirable expirable) {
            if (manager == null) {
                FurtherRequestor.$$$reportNull$$$0(0);
            }
            if (expirable == null) {
                FurtherRequestor.$$$reportNull$$$0(1);
            }
            this.myManager = manager;
            this.myExpirable = expirable;
            if (Registry.is((String)"ide.debugMode")) {
                this.myAllocation = new Exception();
            }
        }

        @NotNull
        public ActionCallback requestFocus(@NotNull Component c, boolean forced) {
            if (c == null) {
                FurtherRequestor.$$$reportNull$$$0(2);
            }
            ActionCallback result2 = this.isExpired() ? ActionCallback.REJECTED : this.myManager.requestFocus(c, forced);
            result2.doWhenProcessed(() -> Disposer.dispose((Disposable)this));
            ActionCallback actionCallback = result2;
            if (actionCallback == null) {
                FurtherRequestor.$$$reportNull$$$0(3);
            }
            return actionCallback;
        }

        private boolean isExpired() {
            return this.myExpirable.isExpired() || this.myDisposed;
        }

        @NotNull
        public ActionCallback requestFocus(@NotNull FocusCommand command, boolean forced) {
            if (command == null) {
                FurtherRequestor.$$$reportNull$$$0(4);
            }
            ActionCallback actionCallback = this.isExpired() ? ActionCallback.REJECTED : this.myManager.requestFocus(command, forced);
            if (actionCallback == null) {
                FurtherRequestor.$$$reportNull$$$0(5);
            }
            return actionCallback;
        }

        public void dispose() {
            this.myDisposed = true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expirable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/wm/impl/FocusManagerImpl$FurtherRequestor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/wm/impl/FocusManagerImpl$FurtherRequestor";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "requestFocus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "requestFocus";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class KeyProcessorContext
    implements KeyEventProcessor.Context {
        private KeyProcessorContext() {
        }

        @NotNull
        public List<KeyEvent> getQueue() {
            List list2 = FocusManagerImpl.this.myToDispatchOnDone;
            if (list2 == null) {
                KeyProcessorContext.$$$reportNull$$$0(0);
            }
            return list2;
        }

        public void dispatch(@NotNull List<KeyEvent> events) {
            if (events == null) {
                KeyProcessorContext.$$$reportNull$$$0(1);
            }
            FocusManagerImpl.this.doWhenFocusSettlesDown(() -> {
                if (events == null) {
                    KeyProcessorContext.$$$reportNull$$$0(2);
                }
                FocusManagerImpl.this.myToDispatchOnDone.addAll(events);
                FocusManagerImpl.this.restartIdleAlarm();
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/wm/impl/FocusManagerImpl$KeyProcessorContext";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "events";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQueue";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/wm/impl/FocusManagerImpl$KeyProcessorContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "dispatch";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$dispatch$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class IdleRunnable
    extends EdtRunnable {
        private IdleRunnable() {
        }

        public void runEdt() {
            if (FocusManagerImpl.this.canFlushIdleRequests()) {
                FocusManagerImpl.this.flushIdleRequests();
            } else {
                if (FocusManagerImpl.this.processFocusRevalidation() && FocusManagerImpl.this.isFocusTransferReady()) {
                    FocusManagerImpl.this.flushIdleRequests();
                }
                FocusManagerImpl.this.restartIdleAlarm();
            }
        }
    }
}

