/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.TabContentLayout;
import com.intellij.ui.EngravedTextGraphics;
import com.intellij.ui.Gray;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ui.BaseButtonBehavior;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TimedDeadzone;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

class ContentTabLabel
extends BaseLabel {
    private final Content myContent;
    private final TabContentLayout myLayout;

    public ContentTabLabel(@NotNull Content content, @NotNull TabContentLayout layout) {
        if (content == null) {
            ContentTabLabel.$$$reportNull$$$0(0);
        }
        if (layout == null) {
            ContentTabLabel.$$$reportNull$$$0(1);
        }
        super(layout.myUi, true);
        this.myLayout = layout;
        this.myContent = content;
        BaseButtonBehavior behavior = new BaseButtonBehavior(this){

            protected void execute(MouseEvent e) {
                ContentTabLabel.this.selectContent();
            }
        };
        behavior.setActionTrigger(501);
        behavior.setMouseDeadzone(TimedDeadzone.NULL);
    }

    protected void selectContent() {
        ContentManager mgr = this.contentManager();
        if (mgr.getIndexOfContent(this.myContent) >= 0) {
            mgr.setSelectedContent(this.myContent, true);
        }
    }

    public void update() {
        if (!this.myLayout.isToDrawTabs()) {
            this.setHorizontalAlignment(2);
            this.setBorder(null);
        } else {
            this.setHorizontalAlignment(0);
            this.setBorder((Border)JBUI.Borders.empty((int)0, (int)8));
        }
        this.updateTextAndIcon(this.myContent, this.isSelected());
    }

    @Override
    protected boolean allowEngravement() {
        return this.isSelected() || this.myUi != null && this.myUi.myWindow.isActive();
    }

    @Override
    protected Color getActiveFg(boolean selected) {
        if (this.contentManager().getContentCount() > 1) {
            return selected ? Color.white : (UIUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : Color.black);
        }
        return super.getActiveFg(selected);
    }

    @Override
    protected Color getPassiveFg(boolean selected) {
        if (this.contentManager().getContentCount() > 1) {
            return selected && !UIUtil.isUnderDarcula() ? Gray._255 : (UIUtil.isUnderDarcula() ? UIUtil.getLabelDisabledForeground() : Gray._75);
        }
        return super.getPassiveFg(selected);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public boolean isSelected() {
        return this.contentManager().isSelected(this.myContent);
    }

    @Override
    protected Graphics _getGraphics(Graphics2D g) {
        if (this.isSelected() && this.contentManager().getContentCount() > 1) {
            return new EngravedTextGraphics(g, 1, 1, Gray._0.withAlpha(this.myUi.myWindow.isActive() ? 120 : 130));
        }
        return super._getGraphics(g);
    }

    private ContentManager contentManager() {
        return this.myUi.myWindow.getContentManager();
    }

    @Override
    @NotNull
    public Content getContent() {
        Content content = this.myContent;
        if (content == null) {
            ContentTabLabel.$$$reportNull$$$0(2);
        }
        return content;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/content/ContentTabLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/content/ContentTabLabel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

