/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorBasedWidget
implements StatusBarWidget,
FileEditorManagerListener {
    public static final String SWING_FOCUS_OWNER_PROPERTY = "focusOwner";
    protected StatusBar myStatusBar;
    protected Project myProject;
    protected MessageBusConnection myConnection;
    private volatile boolean myDisposed;

    protected EditorBasedWidget(@NotNull Project project) {
        if (project == null) {
            EditorBasedWidget.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myConnection = this.myProject.getMessageBus().connect((Disposable)this);
        this.myConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)this);
        Disposer.register((Disposable)project, (Disposable)this);
    }

    @Nullable
    protected final Editor getEditor() {
        FileEditorManager manager;
        Editor editor;
        Project project = this.getProject();
        if (project == null || project.isDisposed()) {
            return null;
        }
        FileEditor fileEditor = StatusBarUtil.getCurrentFileEditor(project, this.myStatusBar);
        Editor result2 = null;
        if (fileEditor instanceof TextEditor) {
            result2 = ((TextEditor)fileEditor).getEditor();
        }
        if (result2 == null && (editor = (manager = FileEditorManager.getInstance((Project)project)).getSelectedTextEditor()) != null && WindowManager.getInstance().getStatusBar((Component)editor.getComponent(), project) == this.myStatusBar) {
            result2 = editor;
        }
        return result2;
    }

    boolean isOurEditor(Editor editor) {
        return editor != null && editor.getComponent().isShowing() && !Boolean.TRUE.equals(editor.getUserData(EditorTextField.SUPPLEMENTARY_KEY)) && WindowManager.getInstance().getStatusBar((Component)editor.getComponent(), editor.getProject()) == this.myStatusBar;
    }

    Component getFocusedComponent() {
        IdeFocusManager focusManager;
        IdeFrame frame;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner == null && (frame = (focusManager = IdeFocusManager.getInstance((Project)this.myProject)).getLastFocusedFrame()) != null) {
            focusOwner = focusManager.getLastFocusedFor(frame);
        }
        return focusOwner;
    }

    Editor getFocusedEditor() {
        Component component = this.getFocusedComponent();
        return component instanceof EditorComponentImpl ? ((EditorComponentImpl)component).getEditor() : this.getEditor();
    }

    @Nullable
    protected VirtualFile getSelectedFile() {
        Editor editor = this.getEditor();
        if (editor == null) {
            return null;
        }
        Document document = editor.getDocument();
        return FileDocumentManager.getInstance().getFile(document);
    }

    @Nullable
    protected final Project getProject() {
        return this.myProject;
    }

    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            EditorBasedWidget.$$$reportNull$$$0(1);
        }
        this.myStatusBar = statusBar;
    }

    public void dispose() {
        this.myDisposed = true;
        this.myStatusBar = null;
        this.myConnection.disconnect();
        this.myConnection = null;
        this.myProject = null;
    }

    protected final boolean isDisposed() {
        return this.myDisposed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/wm/impl/status/EditorBasedWidget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

