/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.util.Alarm;
import com.intellij.util.ui.BaseButtonBehavior;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TimedDeadzone;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

class ToolWindowsWidget
extends JLabel
implements CustomStatusBarWidget,
StatusBarWidget,
Disposable,
UISettingsListener,
PropertyChangeListener {
    private final Alarm myAlarm;
    private StatusBar myStatusBar;
    private JBPopup popup;
    private boolean wasExited;

    ToolWindowsWidget(@NotNull Disposable parent) {
        if (parent == null) {
            ToolWindowsWidget.$$$reportNull$$$0(0);
        }
        this.wasExited = false;
        new BaseButtonBehavior(this, TimedDeadzone.NULL){

            protected void execute(MouseEvent e) {
                ToolWindowsWidget.this.performAction();
            }
        }.setActionTrigger(501);
        IdeEventQueue.getInstance().addDispatcher(e -> {
            if (e instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)e;
                if (mouseEvent.getComponent() == null || !SwingUtilities.isDescendingFrom(mouseEvent.getComponent(), SwingUtilities.getWindowAncestor(this))) {
                    return false;
                }
                if (e.getID() == 503 && this.isShowing()) {
                    Point p = mouseEvent.getLocationOnScreen();
                    Point screen = this.getLocationOnScreen();
                    if (new Rectangle(screen.x - 4, screen.y - 2, this.getWidth() + 4, this.getHeight() + 4).contains(p)) {
                        this.mouseEntered();
                        this.wasExited = false;
                    } else if (!this.wasExited) {
                        this.wasExited = this.mouseExited(p);
                    }
                } else if (e.getID() == 505) {
                    this.mouseExited(mouseEvent.getLocationOnScreen());
                }
            }
            return false;
        }, parent);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(UISettingsListener.TOPIC, (Object)this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this);
        this.myAlarm = new Alarm(parent);
    }

    public boolean mouseExited(Point currentLocationOnScreen) {
        this.myAlarm.cancelAllRequests();
        if (this.popup != null && this.popup.isVisible()) {
            Point screen = this.popup.getLocationOnScreen();
            Rectangle popupScreenRect = new Rectangle(screen.x, screen.y, this.popup.getSize().width, this.popup.getSize().height);
            if (!popupScreenRect.contains(currentLocationOnScreen)) {
                this.myAlarm.cancelAllRequests();
                this.myAlarm.addRequest(() -> {
                    if (this.popup != null && this.popup.isVisible()) {
                        this.popup.cancel();
                    }
                }, 300);
                return true;
            }
        }
        return false;
    }

    public void mouseEntered() {
        boolean active = ApplicationManager.getApplication().isActive();
        if (!active) {
            return;
        }
        if (this.myAlarm.getActiveRequestCount() == 0) {
            this.myAlarm.addRequest(() -> {
                IdeFrameImpl frame = (IdeFrameImpl)UIUtil.getParentOfType(IdeFrameImpl.class, (Component)this);
                if (frame == null) {
                    return;
                }
                ArrayList<ToolWindow> toolWindows = new ArrayList<ToolWindow>();
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)frame.getProject());
                for (String id : toolWindowManager.getToolWindowIds()) {
                    ToolWindow tw = toolWindowManager.getToolWindow(id);
                    if (!tw.isAvailable() || !tw.isShowStripeButton()) continue;
                    toolWindows.add(tw);
                }
                Collections.sort(toolWindows, (o1, o2) -> StringUtil.naturalCompare((String)o1.getStripeTitle(), (String)o2.getStripeTitle()));
                JBList list2 = new JBList(toolWindows);
                list2.setCellRenderer(new ListCellRenderer(){
                    final JBLabel label = new JBLabel();

                    public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        ToolWindow toolWindow = (ToolWindow)value;
                        this.label.setText(toolWindow.getStripeTitle());
                        this.label.setIcon(toolWindow.getIcon());
                        this.label.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
                        this.label.setForeground(UIUtil.getListForeground((boolean)isSelected));
                        this.label.setBackground(UIUtil.getListBackground((boolean)isSelected));
                        JPanel panel2 = new JPanel(new BorderLayout());
                        panel2.add((Component)this.label, "Center");
                        panel2.setBackground(UIUtil.getListBackground((boolean)isSelected));
                        return panel2;
                    }
                });
                Dimension size = list2.getPreferredSize();
                ToolWindowsWidget c = this;
                Insets padding = UIUtil.getListViewportPadding();
                RelativePoint point = new RelativePoint((Component)c, new Point(-4, -padding.top - padding.bottom - 4 - size.height + (SystemInfo.isMac ? 2 : 0)));
                if (this.popup != null && this.popup.isVisible()) {
                    return;
                }
                list2.setSelectedIndex(list2.getItemsCount() - 1);
                PopupChooserBuilder builder = JBPopupFactory.getInstance().createListPopupBuilder((JList)list2);
                this.popup = builder.setAutoselectOnMouseMove(true).setRequestFocus(false).setItemChoosenCallback(() -> {
                    Object value;
                    if (this.popup != null) {
                        this.popup.closeOk(null);
                    }
                    if ((value = list2.getSelectedValue()) instanceof ToolWindow) {
                        ((ToolWindow)value).activate(null, true, true);
                    }
                }).createPopup();
                list2.setVisibleRowCount(30);
                this.popup.show(point);
            }, 300);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateIcon();
    }

    public void uiSettingsChanged(UISettings uiSettings) {
        this.updateIcon();
    }

    private void performAction() {
        if (this.isActive()) {
            UISettings.getInstance().setHideToolStripes(!UISettings.getInstance().getHideToolStripes());
            UISettings.getInstance().fireUISettingsChanged();
        }
    }

    private void updateIcon() {
        this.setToolTipText(null);
        if (this.isActive()) {
            Icon icon;
            boolean changes = false;
            if (!this.isVisible()) {
                this.setVisible(true);
                changes = true;
            }
            Icon icon2 = icon = UISettings.getInstance().getHideToolStripes() ? AllIcons.General.TbShown : AllIcons.General.TbHidden;
            if (icon != this.getIcon()) {
                this.setIcon(icon);
                changes = true;
            }
            if (changes) {
                this.revalidate();
                this.repaint();
            }
        } else {
            this.setVisible(false);
            this.setToolTipText(null);
        }
    }

    private boolean isActive() {
        return this.myStatusBar != null && this.myStatusBar.getFrame() != null && this.myStatusBar.getFrame().getProject() != null && Registry.is((String)"ide.windowSystem.showTooWindowButtonsSwitcher");
    }

    public JComponent getComponent() {
        return this;
    }

    @NotNull
    public String ID() {
        if ("ToolWindows Widget" == null) {
            ToolWindowsWidget.$$$reportNull$$$0(1);
        }
        return "ToolWindows Widget";
    }

    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            ToolWindowsWidget.$$$reportNull$$$0(2);
        }
        return null;
    }

    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            ToolWindowsWidget.$$$reportNull$$$0(3);
        }
        this.myStatusBar = statusBar;
        this.updateIcon();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this);
        this.myStatusBar = null;
        this.popup = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/status/ToolWindowsWidget";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/status/ToolWindowsWidget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "ID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

