/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.impl.runtime.ServerConnectionEventDispatcher;
import com.intellij.remoteServer.impl.runtime.ServerConnectionManagerImpl;
import com.intellij.remoteServer.impl.runtime.deployment.DeploymentImpl;
import com.intellij.remoteServer.impl.runtime.deployment.DeploymentTaskImpl;
import com.intellij.remoteServer.impl.runtime.deployment.LocalDeploymentImpl;
import com.intellij.remoteServer.impl.runtime.log.DeploymentLogManagerImpl;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerImpl;
import com.intellij.remoteServer.runtime.ConnectionStatus;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.runtime.deployment.debug.DebugConnectionData;
import com.intellij.remoteServer.runtime.deployment.debug.DebugConnectionDataNotAvailableException;
import com.intellij.remoteServer.runtime.deployment.debug.DebugConnector;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerConnectionImpl<D extends DeploymentConfiguration>
implements ServerConnection<D> {
    private static final Logger LOG = Logger.getInstance(ServerConnectionImpl.class);
    private final RemoteServer<?> myServer;
    private final ServerConnector<D> myConnector;
    private final ServerConnectionEventDispatcher myEventDispatcher;
    private final ServerConnectionManagerImpl myConnectionManager;
    private volatile ConnectionStatus myStatus = ConnectionStatus.DISCONNECTED;
    private volatile String myStatusText;
    private volatile ServerRuntimeInstance<D> myRuntimeInstance;
    private final Map<String, DeploymentLogManagerImpl> myLogManagers = ContainerUtil.newConcurrentMap();
    private final MyDeployments myAllDeployments;

    public ServerConnectionImpl(RemoteServer<?> server, ServerConnector<D> connector, @Nullable ServerConnectionManagerImpl connectionManager, ServerConnectionEventDispatcher eventDispatcher) {
        this.myServer = server;
        this.myConnector = connector;
        this.myConnectionManager = connectionManager;
        this.myEventDispatcher = eventDispatcher;
        this.myAllDeployments = new MyDeployments(server.getType().getDeploymentComparator());
    }

    @NotNull
    public RemoteServer<?> getServer() {
        RemoteServer<?> remoteServer = this.myServer;
        if (remoteServer == null) {
            ServerConnectionImpl.$$$reportNull$$$0(0);
        }
        return remoteServer;
    }

    @NotNull
    public ConnectionStatus getStatus() {
        ConnectionStatus connectionStatus = this.myStatus;
        if (connectionStatus == null) {
            ServerConnectionImpl.$$$reportNull$$$0(1);
        }
        return connectionStatus;
    }

    @NotNull
    public String getStatusText() {
        String string = this.myStatusText != null ? this.myStatusText : this.myStatus.getPresentableText();
        if (string == null) {
            ServerConnectionImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void connect(final @NotNull Runnable onFinished) {
        if (onFinished == null) {
            ServerConnectionImpl.$$$reportNull$$$0(3);
        }
        this.doDisconnect();
        this.connectIfNeeded(new ServerConnector.ConnectionCallback<D>(){

            public void connected(@NotNull ServerRuntimeInstance<D> serverRuntimeInstance) {
                if (serverRuntimeInstance == null) {
                    1.$$$reportNull$$$0(0);
                }
                onFinished.run();
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(1);
                }
                onFinished.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "serverRuntimeInstance";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "connected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorOccurred";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void disconnect() {
        if (this.myConnectionManager != null) {
            this.myConnectionManager.removeConnection(this.myServer);
        }
        this.doDisconnect();
    }

    private void doDisconnect() {
        if (this.myStatus == ConnectionStatus.CONNECTED) {
            if (this.myRuntimeInstance != null) {
                this.myRuntimeInstance.disconnect();
                this.myRuntimeInstance = null;
            }
            this.setStatus(ConnectionStatus.DISCONNECTED);
            for (DeploymentLogManagerImpl logManager : this.myLogManagers.values()) {
                logManager.disposeLogs();
            }
        }
    }

    public void deploy(final @NotNull DeploymentTask<D> task2, final @NotNull java.util.function.Consumer<String> onDeploymentStarted) {
        if (task2 == null) {
            ServerConnectionImpl.$$$reportNull$$$0(4);
        }
        if (onDeploymentStarted == null) {
            ServerConnectionImpl.$$$reportNull$$$0(5);
        }
        this.connectIfNeeded(new ConnectionCallbackBase<D>(){

            public void connected(@NotNull ServerRuntimeInstance<D> instance) {
                if (instance == null) {
                    2.$$$reportNull$$$0(0);
                }
                LocalDeploymentImpl deployment = new LocalDeploymentImpl(instance, ServerConnectionImpl.this, DeploymentStatus.DEPLOYING, null, null, task2);
                String deploymentName = deployment.getName();
                ServerConnectionImpl.this.myAllDeployments.addLocal(deployment);
                DeploymentLogManagerImpl logManager = new DeploymentLogManagerImpl(task2.getProject(), new ChangeListener()).withMainHandlerVisible(true);
                LoggingHandlerImpl handler2 = logManager.getMainLoggingHandler();
                ServerConnectionImpl.this.myLogManagers.put(deploymentName, logManager);
                handler2.printlnSystemMessage("Deploying '" + deploymentName + "'...");
                onDeploymentStarted.accept(deploymentName);
                instance.deploy(task2, (DeploymentLogManager)logManager, (ServerRuntimeInstance.DeploymentOperationCallback)new DeploymentOperationCallbackImpl(deploymentName, (DeploymentTaskImpl)task2, handler2, deployment));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$2", "connected"));
            }
        });
    }

    @Nullable
    public DeploymentLogManager getLogManager(@NotNull Deployment deployment) {
        if (deployment == null) {
            ServerConnectionImpl.$$$reportNull$$$0(6);
        }
        return this.myLogManagers.get(deployment.getName());
    }

    @NotNull
    public DeploymentLogManager getOrCreateLogManager(@NotNull Project project, @NotNull Deployment deployment) {
        DeploymentLogManagerImpl result2;
        if (project == null) {
            ServerConnectionImpl.$$$reportNull$$$0(7);
        }
        if (deployment == null) {
            ServerConnectionImpl.$$$reportNull$$$0(8);
        }
        if ((result2 = (DeploymentLogManagerImpl)this.getLogManager(deployment)) == null) {
            result2 = new DeploymentLogManagerImpl(project, new ChangeListener());
            this.myLogManagers.put(deployment.getName(), result2);
        }
        DeploymentLogManagerImpl deploymentLogManagerImpl = result2;
        if (deploymentLogManagerImpl == null) {
            ServerConnectionImpl.$$$reportNull$$$0(9);
        }
        return deploymentLogManagerImpl;
    }

    public void computeDeployments(final @NotNull Runnable onFinished) {
        if (onFinished == null) {
            ServerConnectionImpl.$$$reportNull$$$0(10);
        }
        this.connectIfNeeded(new ConnectionCallbackBase<D>(){

            public void connected(@NotNull ServerRuntimeInstance<D> instance) {
                if (instance == null) {
                    3.$$$reportNull$$$0(0);
                }
                ServerConnectionImpl.this.computeDeployments(instance, onFinished);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$3", "connected"));
            }
        });
    }

    private void computeDeployments(ServerRuntimeInstance<D> instance, final Runnable onFinished) {
        instance.computeDeployments(new ServerRuntimeInstance.ComputeDeploymentsCallback(){
            private final List<DeploymentImpl> myCollectedDeployments = Collections.synchronizedList(new ArrayList());

            public void addDeployment(@NotNull String deploymentName) {
                if (deploymentName == null) {
                    4.$$$reportNull$$$0(0);
                }
                this.addDeployment(deploymentName, null);
            }

            public void addDeployment(@NotNull String deploymentName, @Nullable DeploymentRuntime deploymentRuntime) {
                if (deploymentName == null) {
                    4.$$$reportNull$$$0(1);
                }
                this.addDeployment(deploymentName, deploymentRuntime, null, null);
            }

            public Deployment addDeployment(@NotNull String name, @Nullable DeploymentRuntime runtime, @Nullable DeploymentStatus status, @Nullable String statusText) {
                DeploymentImpl result2;
                if (name == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (status == null) {
                    status = DeploymentStatus.DEPLOYED;
                }
                if ((result2 = ServerConnectionImpl.this.myAllDeployments.updateRemoteState(name, runtime, status, statusText)) == null) {
                    result2 = new DeploymentImpl(ServerConnectionImpl.this, name, status, statusText, runtime, null);
                }
                this.myCollectedDeployments.add(result2);
                return result2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void succeeded() {
                List<DeploymentImpl> list2 = this.myCollectedDeployments;
                synchronized (list2) {
                    ServerConnectionImpl.this.myAllDeployments.replaceRemotesWith(this.myCollectedDeployments);
                }
                ServerConnectionImpl.this.myEventDispatcher.queueDeploymentsChanged(ServerConnectionImpl.this);
                onFinished.run();
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    4.$$$reportNull$$$0(3);
                }
                ServerConnectionImpl.this.myAllDeployments.replaceRemotesWith(Collections.emptyList());
                ServerConnectionImpl.this.myStatusText = "Cannot obtain deployments: " + errorMessage;
                ServerConnectionImpl.this.myEventDispatcher.queueConnectionStatusChanged(ServerConnectionImpl.this);
                ServerConnectionImpl.this.myEventDispatcher.queueDeploymentsChanged(ServerConnectionImpl.this);
                onFinished.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "deploymentName";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addDeployment";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorOccurred";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void undeploy(@NotNull Deployment deployment, @NotNull DeploymentRuntime runtime) {
        if (deployment == null) {
            ServerConnectionImpl.$$$reportNull$$$0(11);
        }
        if (runtime == null) {
            ServerConnectionImpl.$$$reportNull$$$0(12);
        }
        final String deploymentName = deployment.getName();
        final UndeployTransition undeployInProgress = this.myAllDeployments.startUndeploy(deploymentName);
        this.myEventDispatcher.queueDeploymentsChanged(this);
        DeploymentLogManagerImpl logManager = this.myLogManagers.get(deploymentName);
        LoggingHandlerImpl loggingHandler = logManager == null ? null : logManager.getMainLoggingHandler();
        final Consumer logConsumer = message -> {
            if (loggingHandler == null) {
                LOG.info(message);
            } else {
                loggingHandler.printlnSystemMessage((String)message);
            }
        };
        logConsumer.consume((Object)("Undeploying '" + deploymentName + "'..."));
        runtime.undeploy(new DeploymentRuntime.UndeploymentTaskCallback(){

            public void succeeded() {
                DeploymentLogManagerImpl logManager;
                logConsumer.consume((Object)("'" + deploymentName + "' has been undeployed successfully."));
                if (undeployInProgress != null) {
                    undeployInProgress.succeeded();
                }
                if ((logManager = (DeploymentLogManagerImpl)ServerConnectionImpl.this.myLogManagers.remove(deploymentName)) != null) {
                    logManager.disposeLogs();
                }
                ServerConnectionImpl.this.myEventDispatcher.queueDeploymentsChanged(ServerConnectionImpl.this);
                ServerConnectionImpl.this.computeDeployments(ServerConnectionImpl.this.myRuntimeInstance, EmptyRunnable.INSTANCE);
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    5.$$$reportNull$$$0(0);
                }
                logConsumer.consume((Object)("Failed to undeploy '" + deploymentName + "': " + errorMessage));
                if (undeployInProgress != null) {
                    undeployInProgress.failed();
                }
                ServerConnectionImpl.this.myEventDispatcher.queueDeploymentsChanged(ServerConnectionImpl.this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$5", "errorOccurred"));
            }
        });
    }

    @NotNull
    public Collection<Deployment> getDeployments() {
        Collection<Deployment> collection = this.myAllDeployments.listDeployments();
        if (collection == null) {
            ServerConnectionImpl.$$$reportNull$$$0(13);
        }
        return collection;
    }

    public void connectIfNeeded(final ServerConnector.ConnectionCallback<D> callback) {
        ServerRuntimeInstance<D> instance = this.myRuntimeInstance;
        if (instance != null) {
            callback.connected(instance);
            return;
        }
        this.setStatus(ConnectionStatus.CONNECTING);
        this.myConnector.connect(new ServerConnector.ConnectionCallback<D>(){

            public void connected(@NotNull ServerRuntimeInstance<D> instance) {
                if (instance == null) {
                    6.$$$reportNull$$$0(0);
                }
                ServerConnectionImpl.this.setStatus(ConnectionStatus.CONNECTED);
                ServerConnectionImpl.this.myRuntimeInstance = instance;
                callback.connected(instance);
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    6.$$$reportNull$$$0(1);
                }
                ServerConnectionImpl.this.setStatus(ConnectionStatus.DISCONNECTED, errorMessage);
                ServerConnectionImpl.this.myRuntimeInstance = null;
                callback.errorOccurred(errorMessage);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "instance";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "connected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorOccurred";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void setStatus(ConnectionStatus status) {
        this.setStatus(status, null);
    }

    private void setStatus(ConnectionStatus status, String statusText) {
        this.myStatus = status;
        this.myStatusText = statusText;
        this.myEventDispatcher.queueConnectionStatusChanged(this);
    }

    public void changeDeploymentState(@NotNull DeploymentImpl deployment, @Nullable DeploymentRuntime deploymentRuntime, @NotNull DeploymentStatus oldStatus, @NotNull DeploymentStatus newStatus, @Nullable String statusText) {
        if (deployment == null) {
            ServerConnectionImpl.$$$reportNull$$$0(14);
        }
        if (oldStatus == null) {
            ServerConnectionImpl.$$$reportNull$$$0(15);
        }
        if (newStatus == null) {
            ServerConnectionImpl.$$$reportNull$$$0(16);
        }
        if (this.myAllDeployments.updateAnyState(deployment, deploymentRuntime, oldStatus, newStatus, statusText)) {
            this.myEventDispatcher.queueDeploymentsChanged(this);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onFinished";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onDeploymentStarted";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployment";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtime";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldStatus";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getServer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusText";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateLogManager";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeployments";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deploy";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLogManager";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateLogManager";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "computeDeployments";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "undeploy";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "changeDeploymentState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class UndeployTransition {
        private final DeploymentImpl myDeployment;

        public UndeployTransition(@NotNull DeploymentImpl deployment) {
            if (deployment == null) {
                UndeployTransition.$$$reportNull$$$0(0);
            }
            this.myDeployment = deployment;
            this.myDeployment.changeState(DeploymentStatus.DEPLOYED, DeploymentStatus.DEPLOYING, null, null);
        }

        public abstract void succeeded();

        public abstract void failed();

        protected boolean tryChangeToTerminalState(DeploymentStatus terminalState) {
            return this.myDeployment.changeState(DeploymentStatus.DEPLOYING, terminalState, null, null);
        }

        protected DeploymentImpl getDeployment() {
            return this.myDeployment;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployment", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$UndeployTransition", "<init>"));
        }
    }

    private static class MyDeployments {
        private final Object myLocalLock = new Object();
        private final Object myRemoteLock = new Object();
        private final Map<String, DeploymentImpl> myRemoteDeployments = new HashMap<String, DeploymentImpl>();
        private final Map<String, LocalDeploymentImpl> myLocalDeployments = new HashMap<String, LocalDeploymentImpl>();
        private List<Deployment> myCachedAllDeployments;
        private final Comparator<Deployment> myDeploymentComparator;

        public MyDeployments(Comparator<Deployment> deploymentComparator) {
            this.myDeploymentComparator = deploymentComparator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLocal(@NotNull LocalDeploymentImpl<?> deployment) {
            if (deployment == null) {
                MyDeployments.$$$reportNull$$$0(0);
            }
            Object object = this.myLocalLock;
            synchronized (object) {
                this.myLocalDeployments.put(deployment.getName(), deployment);
                this.myCachedAllDeployments = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void replaceRemotesWith(@NotNull Collection<DeploymentImpl> newDeployments) {
            if (newDeployments == null) {
                MyDeployments.$$$reportNull$$$0(1);
            }
            Object object = this.myRemoteLock;
            synchronized (object) {
                this.myRemoteDeployments.clear();
                this.myCachedAllDeployments = null;
                for (DeploymentImpl deployment : newDeployments) {
                    this.myRemoteDeployments.put(deployment.getName(), deployment);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public DeploymentImpl updateRemoteState(@NotNull String deploymentName, @Nullable DeploymentRuntime deploymentRuntime, @NotNull DeploymentStatus deploymentStatus, @Nullable String deploymentStatusText) {
            if (deploymentName == null) {
                MyDeployments.$$$reportNull$$$0(2);
            }
            if (deploymentStatus == null) {
                MyDeployments.$$$reportNull$$$0(3);
            }
            Object object = this.myRemoteLock;
            synchronized (object) {
                DeploymentImpl result2 = this.myRemoteDeployments.get(deploymentName);
                if (result2 != null && !result2.getStatus().isTransition()) {
                    result2.changeState(result2.getStatus(), deploymentStatus, deploymentStatusText, deploymentRuntime);
                }
                return result2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean updateAnyState(@NotNull DeploymentImpl deployment, @Nullable DeploymentRuntime deploymentRuntime, @NotNull DeploymentStatus oldStatus, @NotNull DeploymentStatus newStatus, @Nullable String statusText) {
            if (deployment == null) {
                MyDeployments.$$$reportNull$$$0(4);
            }
            if (oldStatus == null) {
                MyDeployments.$$$reportNull$$$0(5);
            }
            if (newStatus == null) {
                MyDeployments.$$$reportNull$$$0(6);
            }
            Object object = this.myLocalLock;
            synchronized (object) {
                Object object2 = this.myRemoteLock;
                synchronized (object2) {
                    return deployment.changeState(oldStatus, newStatus, statusText, deploymentRuntime);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @NotNull
        public Collection<Deployment> listDeployments() {
            Object object = this.myLocalLock;
            // MONITORENTER : object
            Object object2 = this.myRemoteLock;
            // MONITORENTER : object2
            if (this.myCachedAllDeployments == null) {
                Collection<Deployment> result2 = this.doListDeployments();
                this.myCachedAllDeployments = Collections.unmodifiableList(new ArrayList<Deployment>(result2));
            }
            List<Deployment> list2 = this.myCachedAllDeployments;
            // MONITOREXIT : object2
            // MONITOREXIT : object
            if (list2 != null) return list2;
            MyDeployments.$$$reportNull$$$0(7);
            return list2;
        }

        private Collection<Deployment> doListDeployments() {
            TreeMap<Deployment, DeploymentImpl> orderedDeployments = new TreeMap<Deployment, DeploymentImpl>(this.myDeploymentComparator);
            for (LocalDeploymentImpl localDeployment : this.myLocalDeployments.values()) {
                localDeployment.setRemoteDeployment(null);
                orderedDeployments.put(localDeployment, localDeployment);
            }
            LinkedHashSet<Deployment> result2 = new LinkedHashSet<Deployment>(orderedDeployments.keySet());
            for (DeploymentImpl remoteDeployment : this.myRemoteDeployments.values()) {
                DeploymentImpl deployment = (DeploymentImpl)orderedDeployments.get(remoteDeployment);
                if (deployment != null) {
                    if (!(deployment instanceof LocalDeploymentImpl)) continue;
                    ((LocalDeploymentImpl)deployment).setRemoteDeployment(remoteDeployment);
                    continue;
                }
                orderedDeployments.put(remoteDeployment, remoteDeployment);
            }
            result2.addAll(orderedDeployments.keySet());
            return result2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public UndeployTransition startUndeploy(@NotNull String deploymentName) {
            if (deploymentName == null) {
                MyDeployments.$$$reportNull$$$0(8);
            }
            Object object = this.myLocalLock;
            synchronized (object) {
                Object object2 = this.myRemoteLock;
                synchronized (object2) {
                    DeploymentImpl local = this.myLocalDeployments.get(deploymentName);
                    if (local != null) {
                        return new UndeployTransition(local){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void succeeded() {
                                Object object = myLocalLock;
                                synchronized (object) {
                                    if (this.tryChangeToTerminalState(DeploymentStatus.NOT_DEPLOYED)) {
                                        myLocalDeployments.remove(this.getDeployment().getName());
                                        myCachedAllDeployments = null;
                                    }
                                }
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void failed() {
                                Object object = myLocalLock;
                                synchronized (object) {
                                    this.tryChangeToTerminalState(DeploymentStatus.DEPLOYED);
                                }
                            }
                        };
                    }
                    DeploymentImpl remote = this.myRemoteDeployments.get(deploymentName);
                    if (remote != null) {
                        return new UndeployTransition(remote){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void succeeded() {
                                Object object = myRemoteLock;
                                synchronized (object) {
                                    if (this.tryChangeToTerminalState(DeploymentStatus.NOT_DEPLOYED)) {
                                        myRemoteDeployments.remove(this.getDeployment().getName());
                                        myCachedAllDeployments = null;
                                    }
                                }
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void failed() {
                                Object object = myRemoteLock;
                                synchronized (object) {
                                    this.tryChangeToTerminalState(DeploymentStatus.DEPLOYED);
                                }
                            }
                        };
                    }
                    return null;
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deployment";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newDeployments";
                    break;
                }
                case 2: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deploymentName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deploymentStatus";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldStatus";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newStatus";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$MyDeployments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$MyDeployments";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "listDeployments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addLocal";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceRemotesWith";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "updateRemoteState";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "updateAnyState";
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "startUndeploy";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class ChangeListener
    implements Runnable {
        private ChangeListener() {
        }

        @Override
        public void run() {
            ServerConnectionImpl.this.myEventDispatcher.queueDeploymentsChanged(ServerConnectionImpl.this);
        }
    }

    private class DeploymentOperationCallbackImpl
    implements ServerRuntimeInstance.DeploymentOperationCallback {
        private final String myDeploymentName;
        private final DeploymentTaskImpl<D> myDeploymentTask;
        private final LoggingHandlerImpl myLoggingHandler;
        private final DeploymentImpl myDeployment;

        public DeploymentOperationCallbackImpl(String deploymentName, DeploymentTaskImpl<D> deploymentTask, LoggingHandlerImpl handler2, DeploymentImpl deployment) {
            this.myDeploymentName = deploymentName;
            this.myDeploymentTask = deploymentTask;
            this.myLoggingHandler = handler2;
            this.myDeployment = deployment;
        }

        public Deployment succeeded(@NotNull DeploymentRuntime deploymentRuntime) {
            if (deploymentRuntime == null) {
                DeploymentOperationCallbackImpl.$$$reportNull$$$0(0);
            }
            this.myLoggingHandler.printlnSystemMessage("'" + this.myDeploymentName + "' has been deployed successfully.");
            this.myDeployment.changeState(DeploymentStatus.DEPLOYING, DeploymentStatus.DEPLOYED, null, deploymentRuntime);
            ServerConnectionImpl.this.myEventDispatcher.queueDeploymentsChanged(ServerConnectionImpl.this);
            DebugConnector<?, ?> debugConnector = this.myDeploymentTask.getDebugConnector();
            if (debugConnector != null) {
                this.launchDebugger(debugConnector, deploymentRuntime);
            }
            return this.myDeployment;
        }

        private <D extends DebugConnectionData, R extends DeploymentRuntime> void launchDebugger(@NotNull DebugConnector<D, R> debugConnector, @NotNull DeploymentRuntime runtime) {
            if (debugConnector == null) {
                DeploymentOperationCallbackImpl.$$$reportNull$$$0(1);
            }
            if (runtime == null) {
                DeploymentOperationCallbackImpl.$$$reportNull$$$0(2);
            }
            try {
                DebugConnectionData debugInfo = debugConnector.getConnectionData(runtime);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (debugConnector == null) {
                        DeploymentOperationCallbackImpl.$$$reportNull$$$0(4);
                    }
                    try {
                        debugConnector.getLauncher().startDebugSession(debugInfo, this.myDeploymentTask.getExecutionEnvironment(), ServerConnectionImpl.this.myServer);
                    }
                    catch (ExecutionException e) {
                        this.myLoggingHandler.print("Cannot start debugger: " + e.getMessage() + "\n");
                        LOG.info((Throwable)e);
                    }
                });
            }
            catch (DebugConnectionDataNotAvailableException e) {
                this.myLoggingHandler.print("Cannot retrieve debug connection: " + e.getMessage() + "\n");
                LOG.info((Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void errorOccurred(@NotNull String errorMessage) {
            if (errorMessage == null) {
                DeploymentOperationCallbackImpl.$$$reportNull$$$0(3);
            }
            this.myLoggingHandler.printlnSystemMessage("Failed to deploy '" + this.myDeploymentName + "': " + errorMessage);
            Object object = ServerConnectionImpl.this.myAllDeployments.myLocalLock;
            synchronized (object) {
                this.myDeployment.changeState(DeploymentStatus.DEPLOYING, DeploymentStatus.NOT_DEPLOYED, errorMessage, null);
            }
            ServerConnectionImpl.this.myEventDispatcher.queueDeploymentsChanged(ServerConnectionImpl.this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deploymentRuntime";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debugConnector";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runtime";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$DeploymentOperationCallbackImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "succeeded";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "launchDebugger";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "errorOccurred";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$launchDebugger$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class ConnectionCallbackBase<D extends DeploymentConfiguration>
    implements ServerConnector.ConnectionCallback<D> {
        private ConnectionCallbackBase() {
        }

        public void errorOccurred(@NotNull String errorMessage) {
            if (errorMessage == null) {
                ConnectionCallbackBase.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/remoteServer/impl/runtime/ServerConnectionImpl$ConnectionCallbackBase", "errorOccurred"));
        }
    }
}

