/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Version;
import com.intellij.util.JdkBundle;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkBundleList {
    @NotNull
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.JdkBundleList");
    private ArrayList<JdkBundle> bundleList = new ArrayList();
    private HashMap<String, JdkBundle> bundleMap = new HashMap();
    private HashMap<String, JdkBundle> nameVersionMap = new HashMap();

    public void addBundle(@NotNull JdkBundle bundle, boolean forceOldVersion) {
        JdkBundle bundleDescr;
        if (bundle == null) {
            JdkBundleList.$$$reportNull$$$0(0);
        }
        if ((bundleDescr = this.bundleMap.get(bundle.getLocation().getAbsolutePath())) == null) {
            this.addMostRecent(bundle, forceOldVersion);
        } else {
            if (bundle.isBundled()) {
                bundleDescr.setBundled(true);
            }
            if (bundle.isBoot()) {
                bundleDescr.setBoot(true);
            }
        }
    }

    public JdkBundle getBundle(@NotNull String path) {
        if (path == null) {
            JdkBundleList.$$$reportNull$$$0(1);
        }
        return this.bundleMap.get(path);
    }

    private void addMostRecent(@NotNull JdkBundle bundleDescriptor, boolean forceOldVersion) {
        Pair<Version, Integer> latestVersionUpdate;
        JdkBundle latestJdk;
        Pair<Version, Integer> versionUpdate;
        boolean updateVersionMap;
        if (bundleDescriptor == null) {
            JdkBundleList.$$$reportNull$$$0(2);
        }
        boolean bl = updateVersionMap = (versionUpdate = bundleDescriptor.getVersionUpdate()) != null;
        if (!this.bundleList.isEmpty() && updateVersionMap && (latestJdk = this.nameVersionMap.get(bundleDescriptor.getNameVersion().replaceFirst("\\(.*\\)", ""))) != null && (latestVersionUpdate = latestJdk.getVersionUpdate()) != null) {
            if ((Integer)latestVersionUpdate.second >= (Integer)versionUpdate.second) {
                if (!forceOldVersion) {
                    return;
                }
                updateVersionMap = false;
            } else if (!latestJdk.isBoot() && !latestJdk.isBundled()) {
                this.bundleList.remove(latestJdk);
                this.nameVersionMap.remove(latestJdk.getNameVersion());
                this.bundleMap.remove(latestJdk.getLocation().getAbsolutePath());
            }
        }
        this.bundleList.add(bundleDescriptor);
        this.bundleMap.put(bundleDescriptor.getLocation().getAbsolutePath(), bundleDescriptor);
        if (updateVersionMap) {
            this.nameVersionMap.put(bundleDescriptor.getNameVersion(), bundleDescriptor);
        }
    }

    public void addBundlesFromLocation(@NotNull String location, @Nullable Version minVer, @Nullable Version maxVer) {
        File jvmLocation;
        if (location == null) {
            JdkBundleList.$$$reportNull$$$0(3);
        }
        if (!(jvmLocation = new File(location)).exists()) {
            LOG.debug("Standard jvm location does not exists: " + jvmLocation);
            return;
        }
        File[] jvms = jvmLocation.listFiles();
        if (jvms == null) {
            LOG.debug("Cannot get jvm list from: " + jvmLocation);
            return;
        }
        for (File jvm : jvms) {
            Version jdkVer;
            JdkBundle jvmBundle = JdkBundle.createBundle(jvm, false, false);
            if (jvmBundle == null || jvmBundle.getVersionUpdate() == null || (jdkVer = jvmBundle.getVersion()) == null || minVer != null && jdkVer.lessThan(Integer.valueOf(minVer.major), Integer.valueOf(minVer.minor), Integer.valueOf(minVer.bugfix)) || maxVer != null && maxVer.lessThan(Integer.valueOf(jdkVer.major), Integer.valueOf(jdkVer.minor), Integer.valueOf(jdkVer.bugfix))) continue;
            this.addBundle(jvmBundle, false);
        }
    }

    public ArrayList<JdkBundle> toArrayList() {
        return this.bundleList;
    }

    public boolean contains(@NotNull String path) {
        if (path == null) {
            JdkBundleList.$$$reportNull$$$0(4);
        }
        return this.bundleMap.keySet().contains(path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/JdkBundleList";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addBundle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getBundle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addMostRecent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addBundlesFromLocation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

